/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GeneralSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.RingSystemRecognizer;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class SpiroNamer
extends SimplePart {
    private RingSystemRecognizer.RingTree tree;

    static Part createPart(RingSystemRecognizer.RingTree tree, Molecule m) {
        if (tree.purelyMonocyclic) {
            return new SpiroNamer(tree, m);
        }
        return GeneralSpiroNamer.create(tree, m);
    }

    SpiroNamer(RingSystemRecognizer.RingTree tree, Molecule m) {
        super(m);
        this.tree = tree;
    }

    private int getSpiroCount() {
        return this.tree.size - 1 - this.tree.threeRingSpiroAtoms.size();
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        StringBuffer name = new StringBuffer();
        int spiroCount = descriptor.length / 3;
        if (spiroCount > 1) {
            name.append(Chem.greek(spiroCount));
        }
        name.append("spiro[");
        for (int i = 0; i < descriptor.length; ++i) {
            if (i > 0) {
                name.append('.');
            }
            name.append(descriptor[i]);
            if (i + 1 >= descriptor.length || descriptor[i + 1] >= 0) continue;
            int superScript = descriptor[++i] - Integer.MIN_VALUE;
            if (this.tree.size <= 2) continue;
            if (Options.unicode) {
                name.append(Util.unicodeSuperscriptNumber(superScript));
                continue;
            }
            name.append("^{").append(superScript).append('}');
        }
        name.append(']');
        if (!omitSuffix) {
            name.append(Chem.carbonChainName(this.originalMolecule.getAtomCount()));
        }
        return name.toString();
    }

    @Override
    int[][][] recognize() {
        IntVector smallestTerminals = new IntVector();
        this.findSmallestTerminals(0, this.newVisit(), smallestTerminals, Integer.MAX_VALUE);
        ArrayList results = new ArrayList();
        for (int i = 0; i < smallestTerminals.size(); ++i) {
            this.recognize(smallestTerminals.get(i), results);
        }
        return Util.intArrayArrayArray(results);
    }

    int findSmallestTerminals(int node, boolean[] visited, IntVector res, int bestRingSize) {
        if (visited[node]) {
            return bestRingSize;
        }
        visited[node] = true;
        RingSystem rs = this.tree.ringSystems[node];
        IntVector neighbours = rs.connections;
        int ringSize = rs.getRingSize();
        if (!rs.spiroAtoms.hasSeveralValues() && ringSize <= bestRingSize) {
            if (ringSize < bestRingSize) {
                res.clear();
                bestRingSize = ringSize;
            }
            res.add(node);
        }
        for (int i = 0; i < neighbours.size(); ++i) {
            bestRingSize = this.findSmallestTerminals(neighbours.get(i), visited, res, bestRingSize);
        }
        return bestRingSize;
    }

    private void recognize(int terminal, ArrayList results) {
        IntVector descriptor = new IntVector();
        RingSystem rs = this.tree.ringSystems[terminal];
        int[] numbering = new int[this.originalMolecule.getAtomCount()];
        this.recognize(terminal, rs.spiroAtoms.get(0), this.newEdgeVisit(), descriptor, numbering, 0, results);
    }

    private void recognize(int node, int atom, boolean[] visited, IntVector descriptor, int[] numbering, int number, ArrayList results) {
        int max;
        int min;
        RingSystem rs = this.tree.ringSystems[node];
        IntVector neighbours = rs.connections;
        int[] ring = rs.getRing();
        int len = ring.length;
        int atomIndex = Util.indexOf(atom, ring);
        if (atomIndex == -1) {
            throw new IUPACNamer.Failure("Unexpected situation");
        }
        int direction = this.findDirection(ring, rs.spiroAtoms, visited, atomIndex);
        if (direction == -2) {
            this.addResult(new int[][]{descriptor.toArray(), numbering}, results);
            return;
        }
        if (direction == 0) {
            min = -1;
            max = 1;
        } else {
            min = max = direction;
        }
        class Backup {
            boolean[] visited;
            IntVector descriptor;
            int[] numbering;
            int number;

            Backup() {
            }
        }
        Backup bk = null;
        block0: for (int dir = min; dir <= max; dir += 2) {
            if (min < max) {
                if (dir == -1) {
                    bk = new Backup();
                    bk.visited = (boolean[])visited.clone();
                    bk.descriptor = (IntVector)descriptor.clone();
                    bk.numbering = (int[])numbering.clone();
                    bk.number = number;
                } else {
                    visited = bk.visited;
                    descriptor = bk.descriptor;
                    numbering = bk.numbering;
                    number = bk.number;
                }
            }
            int curAtom = atom;
            int i = 1;
            while (true) {
                int spiro;
                int prevAtom = curAtom;
                curAtom = ring[(atomIndex + 2 * len + i * dir) % len];
                int curBond = Util.getBondIndex(this.originalMolecule, prevAtom, curAtom);
                visited[curBond] = true;
                if (numbering[curAtom] == 0) {
                    numbering[curAtom] = ++number;
                }
                if ((spiro = rs.spiroAtoms.indexOf(curAtom)) != -1) {
                    descriptor.add(i - 1);
                    if (numbering[curAtom] != number) {
                        descriptor.add(numbering[curAtom] + Integer.MIN_VALUE);
                    }
                    if (rs.spiroAtoms.indexOf(curAtom, spiro + 1) == -1) {
                        this.recognize(neighbours.get(spiro), curAtom, visited, descriptor, numbering, number, results);
                        continue block0;
                    }
                    Backup bk2 = new Backup();
                    bk2.visited = (boolean[])visited.clone();
                    bk2.descriptor = (IntVector)descriptor.clone();
                    bk2.numbering = (int[])numbering.clone();
                    bk2.number = number;
                    while (spiro != -1) {
                        this.recognize(neighbours.get(spiro), curAtom, visited, descriptor, numbering, number, results);
                        if ((spiro = rs.spiroAtoms.indexOf(curAtom, spiro + 1)) == -1) continue;
                        visited = bk2.visited;
                        descriptor = bk2.descriptor;
                        numbering = bk2.numbering;
                        number = bk2.number;
                    }
                    continue block0;
                }
                ++i;
            }
        }
    }

    private int findDirection(int[] ring, IntVector spiroAtoms, boolean[] visited, int atomIndex) {
        int lenm1;
        int len1 = this.distanceToNextSpiro(ring, spiroAtoms, atomIndex, visited, 1);
        if (len1 == (lenm1 = this.distanceToNextSpiro(ring, spiroAtoms, atomIndex, visited, -1))) {
            if (len1 == Integer.MAX_VALUE) {
                return -2;
            }
            return 0;
        }
        return len1 < lenm1 ? 1 : -1;
    }

    private int distanceToNextSpiro(int[] ring, IntVector spiroAtoms, int atomIndex, boolean[] visited, int dir) {
        int atom = ring[atomIndex];
        int len = ring.length;
        int curAtom = ring[(atomIndex + len + dir) % len];
        int curBond = Util.getBondIndex(this.originalMolecule, atom, curAtom);
        if (visited[curBond]) {
            return Integer.MAX_VALUE;
        }
        int i = 1;
        int spiro;
        while ((spiro = spiroAtoms.indexOf(curAtom = ring[(atomIndex + 2 * len + i * dir) % len])) == -1) {
            ++i;
        }
        return i;
    }

    boolean[] newVisit() {
        return new boolean[this.tree.ringSystems.length];
    }

    boolean[] newEdgeVisit() {
        return new boolean[this.originalMolecule.getBondCount()];
    }

    int compareResults(int[] r1, int[] r2, int[] numbering1, int[] numbering2) {
        if (r1.length != r2.length) {
            return r1.length < r2.length ? 1 : -1;
        }
        int diff = Util.setComparison(r1, r2);
        if (diff != 0) {
            return diff;
        }
        diff = Util.setComparison(numbering1, numbering2, this.tree.threeRingSpiroAtoms);
        if (diff != 0) {
            return diff;
        }
        diff = Util.pointToPointComparison(r1, r2);
        return diff;
    }

    void addResult(int[][] newResult, ArrayList results) {
        if (results.size() == 0) {
            results.add(newResult);
        } else {
            int[][] best = (int[][])results.get(0);
            int diff = this.compareResults(best[0], newResult[0], best[1], newResult[1]);
            if (diff == 0) {
                results.add(newResult);
            } else if (diff > 0) {
                results.clear();
                results.add(newResult);
            }
        }
    }

    @Override
    int parentSeniority() {
        return 0x10000000 + (0x8000000 - this.getSpiroCount());
    }

    @Override
    boolean cyclic() {
        return true;
    }
}

