/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Substituent {
    Part part;
    int root;
    boolean hasRoot;
    String extraLocant;
    Modifiers parentModifiers;
    boolean toRemove = false;
    static final Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Substituent s1 = (Substituent)o1;
            Substituent s2 = (Substituent)o2;
            if (s1.isDetached() != s2.isDetached()) {
                return s1.isDetached() ? -1 : 1;
            }
            if (s1.hasLocant() != s2.hasLocant()) {
                return s1.hasLocant() ? -1 : 1;
            }
            String name1 = s1.getName();
            String name2 = s2.getName();
            return Util.alphabeticalOrder(name1, name2);
        }
    };

    Substituent(Part part, Modifiers parentModifiers, int root, boolean hasRoot, String extraLocant) {
        this.part = part;
        this.parentModifiers = parentModifiers;
        this.root = root;
        this.hasRoot = hasRoot;
        if (extraLocant != null) {
            this.extraLocant = extraLocant == "" ? null : extraLocant.intern();
        }
    }

    Part parent() {
        return this.parentModifiers.part;
    }

    String getName() {
        String name = this.part.getPrefixName();
        if (!this.part.noBrackets() && (!this.isDetached() || this.root >= 0 && Character.isDigit(name.charAt(0))) && this.needsParen(name) && name.charAt(name.length() - 1) != '-') {
            name = Util.parenthesize(name);
        }
        if (this.isDetached()) {
            name = this.rewriteDetached(name);
        }
        return name;
    }

    private boolean needsParen(String name) {
        if (Options.minimizeBrackets) {
            if (this.part.complex() && (!Options.minimizeBrackets || this.root != -899 || this.parent().isAmine())) {
                return true;
            }
            return (Util.letterLocant(this.root) || this.extraLocant != null || this.parent().needsLocants()) && name.indexOf(45) != -1;
        }
        return this.part.complex() || (this.root < 0 || this.extraLocant != null || this.parent().needsLocants()) && name.indexOf(45) != -1;
    }

    boolean isDetached() {
        return this.extraLocant == " ";
    }

    boolean hasLocant() {
        return this.root != -899;
    }

    String rewriteDetached(String name) {
        if ((name = name.intern()) == "sodio") {
            return "sodium";
        }
        if (name == "potassio") {
            return "potassium";
        }
        return name;
    }

    static void sort(ArrayList substituents) {
        Collections.sort(substituents, comparator);
    }

    static int[] getSortedRoots(ArrayList substituents) {
        if (substituents == null) {
            return null;
        }
        Substituent.sort(substituents);
        int[] res = new int[substituents.size()];
        int i = 0;
        for (Substituent s : substituents) {
            res[i++] = s.root;
        }
        return res;
    }

    static int[] getDirectRoots(ArrayList substituents) {
        if (substituents == null) {
            return null;
        }
        IntVector res = new IntVector(substituents.size());
        for (Substituent s : substituents) {
            if (s.root < 0) continue;
            res.add(s.root);
        }
        return res.toArray();
    }
}

