/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Canonicalizer;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.SubstituablePart;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

class Suffix
extends SubstituablePart {
    String suffix;

    public Suffix(Molecule m, MolAtom radical, String suffix) {
        super(m);
        this.suffix = suffix;
        this.radical = radical;
    }

    @Override
    String computePrefixName() {
        if (this.substituents == null) {
            return this.suffix;
        }
        StringBuffer res = new StringBuffer();
        Modifiers mod = new Modifiers(this);
        int i = this.substituents.length;
        while (--i >= 0) {
            int root;
            Part substituent = this.substituents[i];
            if (SubmoleculeBuilder.originalAtom(substituent.root) == SubmoleculeBuilder.originalAtom(this.radical)) {
                root = 0;
                if (!substituent.needsLocants()) {
                    ((SimplePart)substituent).modifiers.setEnding(-1, null);
                }
            } else {
                root = Util.groupLocant("N");
            }
            if (substituent.root.getAtno() != 7) {
                substituent.glueToSuffix();
            }
            mod.addSubstituent(root, substituent);
        }
        i = this.originalMolecule.getBondCount();
        while (--i >= 0) {
            MolAtom a2;
            MolBond b = this.originalMolecule.getBond(i);
            MolAtom a1 = b.getAtom1();
            if (Canonicalizer.getStereo(a1, a2 = b.getAtom2()) == 0) continue;
            mod.addBond(b.getType(), this.originalMolecule.indexOf(a1), this.originalMolecule.indexOf(a2));
        }
        mod.printStereoDescriptors(null, null, res);
        mod.printSubstituents(null, null, null, res);
        res.append(this.suffix);
        return res.toString();
    }

    @Override
    String getName() {
        String suffix;
        if (Chem.isRadical(this.radical)) {
            return this.getPrefixName();
        }
        if (this.suffix == "carbonyl") {
            suffix = "methanone";
        } else if (this.suffix == "carboximidoyl") {
            suffix = "methanimine";
        } else {
            throw new IUPACNamer.Failure("unhandled case: " + this.suffix);
        }
        return Suffix.printSubstituted(this.substituents, suffix, this);
    }

    static String printSubstituted(Part[] substituents, String suffixName, Part suffix) {
        StringBuffer res = new StringBuffer();
        Modifiers m = new Modifiers(suffix);
        if (substituents != null) {
            int i = substituents.length;
            while (--i >= 0) {
                m.addSubstituent(0, substituents[i]);
            }
        }
        m.printStereoDescriptors(null, null, res);
        m.printSubstituents(null, null, null, res);
        Util.appendRemovingVowel(suffixName, res);
        return res.toString();
    }

    @Override
    Part getRealParent(MolAtom atom) {
        if (atom == SubmoleculeBuilder.originalAtom(this.radical)) {
            return this;
        }
        return super.getRealParent(atom);
    }
}

