/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.GeneralSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.MonoSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.RingSystemRecognizer;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.util.Collections;
import java.util.Iterator;

class UnbranchedSpiroNamer
extends GeneralSpiroNamer {
    private boolean mustTryBothDirections = false;

    UnbranchedSpiroNamer(RingSystemRecognizer.RingTree tree, Molecule m) {
        super(tree, m);
    }

    @Override
    void computePartNames() {
        int terminal = this.findTerminal(0, this.tree.ringSystems, new boolean[this.tree.ringSystems.length]);
        this.getAllNames(terminal, new boolean[this.tree.ringSystems.length], -1);
        this.sortChain();
    }

    private int findTerminal(int node, RingSystem[] ringSystems, boolean[] visited) {
        visited[node] = true;
        RingSystem rs = ringSystems[node];
        IntVector neighbours = rs.connections;
        if (neighbours.size() == 1) {
            return node;
        }
        for (int i = 0; i < neighbours.size(); ++i) {
            if (visited[neighbours.get(i)]) continue;
            return this.findTerminal(neighbours.get(i), ringSystems, visited);
        }
        throw new IUPACNamer.Failure("Impossible, there must be a terminal ring system");
    }

    private void getAllNames(int node, boolean[] visited, int spiroAtom) {
        visited[node] = true;
        RingSystem rs = this.tree.ringSystems[node];
        GeneralSpiroNamer.NameComponent component = this.nameRingSystem(node, rs);
        if (spiroAtom != -1) {
            component.addSpiroAtom(spiroAtom);
        }
        this.components.add(component);
        IntVector neighbours = rs.connections;
        for (int i = 0; i < neighbours.size(); ++i) {
            int n = neighbours.get(i);
            if (visited[n]) continue;
            int outgoingSpiroAtom = rs.spiroAtoms.get(i);
            component.addSpiroAtom(outgoingSpiroAtom);
            this.getAllNames(n, visited, outgoingSpiroAtom);
            break;
        }
    }

    private void sortChain() {
        int diff = this.mustReverse();
        if (diff < 0) {
            return;
        }
        if (diff > 0) {
            this.reverse();
            return;
        }
        this.computeNumbering();
        HeteroAnalyser.HeteroAtom[] initialHA = HeteroAnalyser.findHeteroAtoms(this.originalMolecule, this.numbering, this.primes);
        this.reverse();
        this.computeNumbering();
        HeteroAnalyser.HeteroAtom[] currentHA = HeteroAnalyser.findHeteroAtoms(this.originalMolecule, this.numbering, this.primes);
        diff = HeteroAnalyser.compareHeteroAtoms(currentHA, initialHA);
        if (diff > 0) {
            this.reverse();
        } else if (diff == 0) {
            this.mustTryBothDirections = true;
        }
    }

    private void reverse() {
        Collections.reverse(this.components);
        for (GeneralSpiroNamer.NameComponent component : this.components) {
            component.localSpiroAtoms.reverse();
        }
        for (int i = 0; i < this.primes.length; ++i) {
            if (this.primes[i] == -1) continue;
            this.primes[i] = this.components.size() - this.primes[i] - 1;
        }
    }

    private int mustReverse() {
        GeneralSpiroNamer.NameComponent c2;
        GeneralSpiroNamer.NameComponent c1;
        int i;
        int size = this.components.size();
        for (i = 0; i < size / 2; ++i) {
            c1 = (GeneralSpiroNamer.NameComponent)this.components.get(i);
            int diff = c1.compareTo(c2 = (GeneralSpiroNamer.NameComponent)this.components.get(size - 1 - i));
            if (diff > 0) {
                return 1;
            }
            if (diff >= 0) continue;
            return -1;
        }
        for (i = 0; i < (size + 1) / 2; ++i) {
            int outgoing2;
            int incoming2;
            c1 = (GeneralSpiroNamer.NameComponent)this.components.get(i);
            c2 = (GeneralSpiroNamer.NameComponent)this.components.get(size - 1 - i);
            int incoming1 = this.locant(c1, 0);
            if (incoming1 < (incoming2 = this.locant(c2, c2.localSpiroAtoms.size() - 1))) {
                return -1;
            }
            if (incoming2 < incoming1) {
                return 1;
            }
            int outgoing1 = this.locant(c1, c1.localSpiroAtoms.size() - 1);
            if (outgoing1 < (outgoing2 = this.locant(c2, 0))) {
                return -1;
            }
            if (outgoing2 >= outgoing1) continue;
            return 1;
        }
        return 0;
    }

    int locant(GeneralSpiroNamer.NameComponent component, int spiroIndex) {
        if (spiroIndex >= component.localSpiroAtoms.size()) {
            return -1;
        }
        int spiroAtom = component.localSpiroAtoms.get(spiroIndex);
        int[][][] results = component.results;
        int res = results[0][1][spiroAtom];
        for (int i = 1; i < results.length; ++i) {
            if (results[i][1][spiroAtom] == res) continue;
            return -1;
        }
        return res;
    }

    @Override
    int getFirstSpiroLocant(int rank, IntVector localSpiroAtoms, int[] numbering) {
        return numbering[localSpiroAtoms.get(rank == 0 ? 0 : 1)];
    }

    @Override
    int getSecondSpiroLocant(int rank, IntVector localSpiroAtoms, int[] numbering) {
        return numbering[localSpiroAtoms.get(0)];
    }

    private boolean spiroBiOrTer() {
        int size = this.components.size();
        if (size > 3) {
            return false;
        }
        GeneralSpiroNamer.NameComponent c0 = this.component(0);
        GeneralSpiroNamer.NameComponent c1 = this.component(1);
        GeneralSpiroNamer.NameComponent cN = this.component(size - 1);
        if (c0.compareTo(c1) != 0) {
            return false;
        }
        return c1.compareTo(cN) == 0;
    }

    private void chooseDirection() {
        int[] numberingOrig = (int[])this.numbering.clone();
        int[] primesOrig = (int[])this.primes.clone();
        this.reverse();
        this.computeNumbering();
        int[] numberingNew = this.numbering;
        int[] primesNew = this.primes;
        int diff = this.modifiers.compare(numberingOrig, primesOrig, numberingNew, primesNew);
        if (diff < 0 || diff == 0 && Util.randomBoolean()) {
            this.reverse();
            this.computeNumbering();
        }
    }

    @Override
    protected void computeName(StringBuffer name) {
        if (this.mustTryBothDirections) {
            this.chooseDirection();
        }
        int size = this.components.size();
        if (!this.spiroBiOrTer()) {
            super.computeName(name);
            return;
        }
        this.modifiers.printPrefix(this.numbering, this.primes, name);
        HeteroAnalyser.nameHeteroAtoms(this.originalMolecule, this.numbering, this.primes, false, name);
        if (name.length() > 0) {
            Util.appendDash(name);
        }
        GeneralSpiroNamer.NameComponent component = null;
        int i = 0;
        String primes = "";
        boolean monoSpiro = this instanceof MonoSpiroNamer;
        Iterator it = this.components.iterator();
        while (it.hasNext()) {
            component = (GeneralSpiroNamer.NameComponent)it.next();
            int[] numbering = component.getNumbering();
            if (i > 0) {
                primes = primes + "'";
                name.append(Util.locant(this.getSecondSpiroLocant(i, component.localSpiroAtoms, numbering)));
                name.append(primes);
                name.append((char)(it.hasNext() ? (monoSpiro ? 44 : 58) : 45));
            }
            if (it.hasNext() && (i == 0 || !monoSpiro)) {
                name.append(Util.locant(this.getFirstSpiroLocant(i, component.localSpiroAtoms, numbering)));
                name.append(this.getFirstPrime(i, primes)).append(',');
            }
            ++i;
        }
        if (size == 3) {
            if (this.tree.threeRingSpiroAtoms.size() == 1) {
                name.append("spiroter[");
            } else {
                name.append("dispiroter[");
            }
        } else {
            name.append("spirobi[");
        }
        component.part.namePrefix(component.getDescriptor(), component.getNumbering(), true, false, false, name);
        name.append(this.component((int)0).name);
        name.append(']');
        this.modifiers.printSuffix(this.numbering, this.primes, true, false, name);
    }
}

