/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.formats.name.nameimport.lex.NameLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.naming.NameConverter;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.NamePrefixException;
import chemaxon.naming.n2s.N2S;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class SystematicNameConverter
implements NameConverter {
    private boolean prefixMode;

    @Override
    public Molecule convert(String name) throws NameFormatException {
        Molecule mol;
        if (SystematicNameConverter.blackListed(name)) {
            return null;
        }
        ArrayList<Token> tokens = NameLexer.parse(name, this.prefixMode || N2S.getOptions().ocrCorrection);
        try {
            Structure root = IUPACParserCore.parseTokens(tokens);
            mol = root.getMolecule();
        }
        catch (RuntimeException e) {
            if (N2S.getOptions().dataMining) {
                throw new NamePrefixException(name);
            }
            throw new NameFormatException(e);
        }
        String smi = mol.toFormat("cxsmiles");
        try {
            mol = MolImporter.importMol(smi, "cxsmiles");
        }
        catch (MolFormatException e) {
            return null;
        }
        if (mol.hasValenceError()) {
            throw new NameFormatException("Valence error");
        }
        return mol;
    }

    @Override
    public boolean setPrefixMode(boolean prefixMode) {
        this.prefixMode = prefixMode;
        return true;
    }

    private static boolean blackListed(String name) {
        if ((name = name.toLowerCase()).endsWith(" but")) {
            return true;
        }
        return name.equals("tell") || name.equals("formal") || name.equals("germ") || name.equals("voltage");
    }
}

