/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex;

import chemaxon.marvin.io.formats.name.nameimport.lex.StructureLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StructureToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.naming.NamePrefixException;
import java.util.ArrayList;

public class PostLexer {
    static ArrayList<Token> fix(ArrayList<Token> tokens) {
        Token last;
        Token prev = null;
        Token prevprev = null;
        for (int i = 0; i < tokens.size(); ++i) {
            Token t = tokens.get(i);
            if (t instanceof BracketToken) {
                PostLexer.fix(((BracketToken)t).inside);
            }
            if (t.getValue().equals("[IGNORE]")) {
                tokens.remove(i--);
            }
            if (t instanceof LocantList && ((LocantList)t).getType() == 2 && i + 2 < tokens.size()) {
                Token next1 = tokens.get(i + 1);
                Token next2 = tokens.get(i + 2);
                if (!next1.is("-") && !next1.is(",")) {
                    if (next1.is(" ")) {
                        if (next2 instanceof LocantList && ((LocantList)t).getType() == ((LocantList)next2).getType() && ((LocantList)t).isStereo() == ((LocantList)next2).isStereo()) {
                            LocantList locants1 = (LocantList)t;
                            LocantList locants2 = (LocantList)next2;
                            locants1.tryAddLocant(locants2);
                            tokens.remove(i + 2);
                            tokens.remove(i + 1);
                            --i;
                            continue;
                        }
                        tokens.set(i + 1, new Separator('-'));
                        continue;
                    }
                    if (next1 instanceof StructureToken) {
                        tokens.add(i + 1, new Separator('-'));
                        continue;
                    }
                }
            }
            if (t instanceof BracketToken && prev instanceof LocantList && prev.getType() != 5) {
                tokens.add(i++, new Separator('-'));
            }
            if (t.getValue().equals("[ANNULENE]") && i >= 4 && tokens.get(i - 4).getName().equals("benz")) {
                tokens.set(i - 4, new StructureToken("benzo", (String)StructureLexer.getDict().get("benzo")));
            }
            if (PostLexer.isNumberedAtomLocant(prevprev, prev, t)) {
                int index = ((LocantList)prevprev).getLocant(0).getValue();
                ((AtomLocant)((LocantList)t).getLocant(0)).setLocantIndex(index);
                tokens.remove(prevprev);
                tokens.remove(prev);
                i -= 2;
            }
            if (t instanceof LocantList && prev instanceof LocantList) {
                LocantList l2 = (LocantList)t;
                if (l2.hasLocant() && l2.getLocant(0) instanceof StereoNumber) {
                    tokens.remove(i);
                    tokens.add(i - 1, l2);
                }
                tokens.add(i, new Separator('-'));
                ++i;
            }
            prevprev = prev;
            prev = t;
        }
        Token token = last = tokens.isEmpty() ? null : tokens.get(tokens.size() - 1);
        if (tokens.size() > 1 && PostLexer.isIonNumbering(last)) {
            tokens.add(new Separator(' '));
            tokens.add(new EndingToken("ion", "[ION]"));
        }
        return tokens;
    }

    private static boolean isNumberedAtomLocant(Token first, Token second, Token third) {
        boolean typeCheck;
        boolean bl = typeCheck = first instanceof LocantList && second instanceof Separator && third instanceof LocantList;
        if (!typeCheck) {
            return false;
        }
        if (((LocantList)first).size() != 1 || first.getType() != 2) {
            return false;
        }
        Locant numberLocant = ((LocantList)first).getLocant(0);
        if (numberLocant.getParent() != 0) {
            return false;
        }
        if (((LocantList)first).getLocant(0) instanceof StereoNumber) {
            return false;
        }
        if (second.getType() != 2) {
            return false;
        }
        return ((LocantList)third).size() == 1 && third.getType() == 6;
    }

    static boolean canBeValidName(ArrayList<Token> tokenList, boolean dataMining) throws NamePrefixException {
        if (tokenList.isEmpty()) {
            return false;
        }
        Token lastToken = tokenList.get(tokenList.size() - 1);
        String name = lastToken.getName();
        String value = (String)StructureLexer.getDict().get(name + "a");
        return value == null || !value.endsWith("*");
    }

    private static boolean isIonNumbering(Token token) {
        LocantList numbering = null;
        if (token instanceof LocantList) {
            numbering = (LocantList)token;
        }
        if (token instanceof BracketToken) {
            numbering = ((BracketToken)token).toNumbering();
        }
        return numbering != null && numbering.getType() == 4;
    }
}

