/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class StringLexer<T> {
    private Map<String, T> dictionary;
    private final int shortestKey = 1;
    private final int longestKey;

    public StringLexer(Map<String, T> dictionary) {
        this(dictionary, Integer.MAX_VALUE);
    }

    public StringLexer(Map<String, T> dictionary, int longestKey) {
        this.dictionary = dictionary;
        this.longestKey = longestKey;
    }

    public List<String> lex(String text) throws LexingFailure {
        ArrayList<String> values = new ArrayList<String>();
        try {
            this.lexLongestBackwards(text, values, "", new boolean[text.length() + 1]);
        }
        catch (LexingFailure e) {
            ArrayList<String> startingValues = new ArrayList<String>();
            this.lexLongestForwards(e.unknownToken, startingValues, "", new boolean[text.length() + 1]);
            throw new RuntimeException("If there is no backwards solution, there is also no forwards solution");
        }
        return values;
    }

    void lexLongestForwards(String text, ArrayList<String> to, String prefix, boolean[] fail) throws LexingFailure {
        int end;
        String bestUnknown = text;
        String bestPrefix = prefix;
        for (int i = end = Math.min(text.length(), this.longestKey); i >= 1; --i) {
            String start;
            T value;
            if (fail[prefix.length() + i] || (value = this.dictionary.get(start = text.substring(0, i))) == null || value.equals("[PREFIX]")) continue;
            int pos = to.size();
            if (i < text.length()) {
                String newPrefix = prefix + start;
                try {
                    this.lexLongestForwards(text.substring(i), to, newPrefix, fail);
                }
                catch (LexingFailure e) {
                    fail[newPrefix.length()] = true;
                    if (e.prefix.length() <= bestPrefix.length()) continue;
                    bestUnknown = e.unknownToken;
                    bestPrefix = e.prefix;
                    continue;
                }
            }
            to.add(pos, start);
            return;
        }
        throw new LexingFailure(bestPrefix, bestUnknown);
    }

    void lexLongestBackwards(String text, ArrayList<String> to, String suffix, boolean[] fail) throws LexingFailure {
        int end = text.length();
        int start = Math.max(0, end - this.longestKey);
        String shortestUnknown = text;
        for (int i = start; i <= end - 1; ++i) {
            String candidate;
            T value;
            if (fail[suffix.length() + (end - i)] || (value = this.dictionary.get(candidate = text.substring(i, end))) == null) continue;
            if (i > 0) {
                String newSuffix = candidate + suffix;
                try {
                    this.lexLongestBackwards(text.substring(0, i), to, newSuffix, fail);
                }
                catch (LexingFailure e) {
                    fail[newSuffix.length()] = true;
                    if (e.unknownToken.length() >= shortestUnknown.length()) continue;
                    shortestUnknown = e.unknownToken;
                    continue;
                }
            }
            to.add(candidate);
            return;
        }
        throw new LexingFailure(null, shortestUnknown);
    }

    public static class LexingFailure
    extends Exception {
        final String prefix;
        final String unknownToken;

        LexingFailure(String prefix, String unknownToken) {
            this.prefix = prefix;
            this.unknownToken = unknownToken;
        }

        @Override
        public String toString() {
            return "LexingFailure(prefix='" + this.prefix + "', unknown token='" + this.unknownToken + "')";
        }
    }
}

