/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex;

import chemaxon.marvin.io.formats.name.nameimport.DictionaryTable;
import chemaxon.marvin.io.formats.name.nameimport.UnknownTokenException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.StringLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Number;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SpecialGroup;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StructureToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.naming.NameFormatException;
import chemaxon.naming.NamePrefixException;
import chemaxon.util.DotfileUtil;
import java.util.ArrayList;
import java.util.List;

public class StructureLexer {
    static StringLexer<String> _lexer;
    private static final String path = "/chemaxon/marvin/io/formats/name/nameimport/";
    public static final String functionalgroupPath = "/chemaxon/marvin/templates/functionalgroups";
    private static DictionaryTable _dict;
    private static String PREFIX;

    static void addStructures(String text, ArrayList<Token> to) throws NameFormatException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try {
            List<String> names = StructureLexer.getLexer().lex(text);
            for (String name : names) {
                String value = (String)StructureLexer.getDict().get(name);
                if (name.endsWith(" ") && ((String)StructureLexer.getDict().get(name + "acid")).equals(value) && value.indexOf("C") > -1) {
                    name = name + "acid";
                }
                Token t = StructureLexer.dictFormatToToken(value, name);
                if (!tokens.isEmpty() && StructureLexer.isNonChainEnding(value)) {
                    int last = tokens.size() - 1;
                    tokens.set(last, StructureLexer.fixNotAsChain((Token)tokens.get(last)));
                }
                tokens.add(t);
            }
        }
        catch (StringLexer.LexingFailure e) {
            throw new UnknownTokenException(e.unknownToken, e.prefix);
        }
        int i = tokens.size();
        while (--i >= 0) {
            String name;
            Token t = (Token)tokens.get(i);
            name = t.getName();
            if (!t.getValue().equals(PREFIX)) continue;
            if (i == tokens.size() - 1) {
                throw new NamePrefixException(text, name);
            }
            throw new NameFormatException(name);
        }
        to.addAll(tokens);
    }

    static Token dictFormatToToken(String value, String name) {
        if (value.endsWith(".")) {
            return new EndingToken(name, value);
        }
        if (value.endsWith("*") && value.length() > 1) {
            int type = 1;
            if (name.endsWith("a")) {
                type = 0;
            }
            return new Number(name, value, type);
        }
        if ((value.equalsIgnoreCase("H") || value.equalsIgnoreCase("-H")) && !name.equals("hydrogen")) {
            return new Hydro(name, value);
        }
        if (value.equals(" ")) {
            return new Separator(' ');
        }
        if (name.equalsIgnoreCase("spiro") || name.equalsIgnoreCase("cyclo") || value.startsWith("!")) {
            return new SpecialGroup(name);
        }
        return new StructureToken(name, value);
    }

    private static boolean isNonChainEnding(String struct2) {
        return struct2.endsWith(".") && !Util.isChainEnding(struct2);
    }

    private static Token fixNotAsChain(Token t) {
        String name = t.getName() + "a";
        String struct1 = t.getValue();
        if (Util.isCharbonChain(struct1) && StructureLexer.getDict().containsKey(name)) {
            return StructureLexer.dictFormatToToken((String)StructureLexer.getDict().get(name), t.getName());
        }
        return t;
    }

    private static void loadDictionary() {
        DictionaryTable tmpDict = new DictionaryTable();
        tmpDict.addDictionary("/chemaxon/marvin/io/formats/name/nameimport/fused_dict", false, false);
        tmpDict.addDictionary("/chemaxon/marvin/io/formats/name/nameimport/dictionary", false, false);
        tmpDict.addDictionary("/chemaxon/marvin/io/formats/name/nameimport/nonSmilesDict", false, false);
        tmpDict.addDictionary(functionalgroupPath, true, true);
        try {
            tmpDict.addUserDictionaryFile(DotfileUtil.getDotFile("/name_dictionary_substitutable.smi"));
        }
        catch (SecurityException sex) {
            System.err.println("Cannot access user dir");
        }
        _dict = tmpDict;
    }

    public static void reloadDictionary() {
        _dict = null;
        _lexer = null;
    }

    private static StringLexer<String> getLexer() {
        if (_lexer == null) {
            _lexer = new StringLexer<String>(StructureLexer.getDict(), StructureLexer.getDict().getLongestKey());
        }
        return _lexer;
    }

    public static DictionaryTable getDict() {
        if (_dict == null) {
            StructureLexer.loadDictionary();
        }
        return _dict;
    }

    static {
        PREFIX = "[PREFIX]";
    }
}

