/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;

public class EndingToken
extends Token {
    public static final int NOT_SET = 0;
    public static final int SALT_ENDING = 1;
    public static final int ACID_ENDING = 2;
    public static final int ION_ENDING = 3;
    public static final int AMINE_ENDING = 4;
    public static final int RADICAL_ENDING = 5;
    public static final int BOND_ENDING = 6;
    private static final int MAXTYPE = 6;
    private String ending;
    private int type = 0;
    private boolean structural = true;

    public EndingToken() {
        this.name = "";
        this.ending = "";
        this.type = 0;
        this.structural = false;
    }

    public EndingToken(String name, String ending) {
        this.name = name;
        while (ending.endsWith(".")) {
            ending = ending.substring(0, ending.length() - 1);
        }
        this.ending = ending;
        this.setTypes(ending);
    }

    public EndingToken(String name, String ending, int type) {
        this.name = name;
        if (ending.endsWith(".")) {
            ending = ending.substring(0, ending.length() - 1);
        }
        this.ending = ending;
        this.type = type;
    }

    public String getData() {
        return this.ending;
    }

    public void setData(String ending) {
        this.ending = ending;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type < 0 || type > 6) {
            type = 0;
        }
        this.type = type;
    }

    @Override
    public String getValue() {
        return this.ending;
    }

    @Override
    public void setValue(String value) {
        this.ending = value;
    }

    @Override
    public String getTypeInString() {
        switch (this.type) {
            case 0: {
                return "NOT_SET";
            }
            case 1: {
                return "SALT_ENDING";
            }
            case 2: {
                return "ACID_ENDING";
            }
            case 3: {
                return "ION_ENDING";
            }
            case 4: {
                return "AMINE_ENDING";
            }
            case 5: {
                return "RADICAL_ENDING";
            }
            case 6: {
                return "BOND_ENDING";
            }
        }
        return "ERROR " + this.type;
    }

    private void setTypes(String ending) {
        if (ending.length() < 1) {
            return;
        }
        int n = this.type = ending.startsWith("|") ? 5 : 0;
        while (ending.startsWith("=") || ending.startsWith("#") || ending.startsWith("|")) {
            if (ending.startsWith("|")) {
                this.type = 5;
            }
            ending = ending.substring(1);
        }
        if (ending.length() == 0) {
            this.structural = false;
            if (this.type != 5) {
                this.type = 6;
            }
        }
        if (ending.matches("[+|-]h[+|-]")) {
            this.structural = false;
            this.type = 3;
        }
        if (ending.equals("[SALT]")) {
            this.type = 1;
        }
        if (this.name.endsWith("acid")) {
            this.type = 2;
        }
    }

    public boolean isStructural() {
        return this.structural;
    }

    public boolean equalsName(String name) {
        if (this.name.endsWith("e")) {
            return this.equalsName(this.name, name);
        }
        if (name.endsWith("e")) {
            return this.equalsName(name, this.name);
        }
        return this.name.equalsIgnoreCase(name);
    }

    private boolean equalsName(String n1, String n2) {
        if (n2.endsWith("e")) {
            return n1.equalsIgnoreCase(n2);
        }
        return n1.equalsIgnoreCase(n2 + "e");
    }
}

