/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;

public class StereoNumber
extends Locant {
    public static final StereoNumber cis = new StereoNumber(1, "cis");
    public static final StereoNumber trans = new StereoNumber(1, "trans");
    public static final StereoNumber endo = new StereoNumber(1, "endo");
    public static final StereoNumber exo = new StereoNumber(1, "exo");
    public static final int STEREO_NOT_SET = -1;
    public static final int STEREO_R = 8;
    public static final int STEREO_S = 16;
    public static final int STEREO_r = 32;
    public static final int STEREO_s = 64;
    public static final int STEREO_E = 64;
    public static final int STEREO_Z = 128;
    public static final int ENDO = 1;
    public static final int EXO = 2;
    public static final int STEREO_L = 3;
    public static final int STEREO_D = 4;
    public static final int STEREO_DL = 5;
    private Locant locant;
    private boolean bondstereo = false;
    private boolean cisTrans = false;
    public final boolean relative;
    public final boolean empty;

    public boolean isDLconfiguration() {
        switch (this.getStereoData()) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    public StereoNumber(int stereo) {
        this.locant = new SimpleLocant(1);
        this.value = stereo;
        this.relative = false;
        this.empty = false;
    }

    public StereoNumber(Locant locant, int stereo) {
        this.locant = locant;
        this.value = stereo;
        this.relative = false;
        this.empty = false;
    }

    public StereoNumber(int locant, char stereo, boolean relative, boolean empty) {
        this(new SimpleLocant(locant), stereo, relative, empty);
    }

    public StereoNumber(Locant locant, char stereo, boolean relative) {
        this(locant, stereo, relative, false);
    }

    public StereoNumber(Locant locant, char stereo, boolean relative, boolean empty) {
        this.locant = locant;
        this.relative = relative;
        this.empty = empty;
        switch (stereo) {
            case 'E': {
                this.value = 64;
                this.bondstereo = true;
                break;
            }
            case 'R': {
                this.value = 8;
                break;
            }
            case 'S': {
                this.value = 16;
                break;
            }
            case 'r': {
                this.value = 32;
                break;
            }
            case 's': {
                this.value = 64;
                break;
            }
            case 'Z': {
                this.value = 128;
                this.bondstereo = true;
                break;
            }
            default: {
                throw new NameImportException.Failure("Unknown stereo: " + stereo);
            }
        }
    }

    public StereoNumber(int locant, String qualifier) {
        this.locant = new SimpleLocant(locant);
        this.relative = false;
        this.empty = false;
        if (qualifier == "cis") {
            this.value = 128;
            this.bondstereo = true;
            this.cisTrans = true;
        } else if (qualifier == "trans") {
            this.value = 64;
            this.bondstereo = true;
            this.cisTrans = true;
        } else if (qualifier == "endo") {
            this.value = 1;
        } else if (qualifier == "exo") {
            this.value = 2;
        } else {
            throw new NameImportException.Failure("Unknown stereo qualifier: " + qualifier);
        }
    }

    public Locant getLocant() {
        return this.locant;
    }

    public void setLocant(SimpleLocant locant) {
        this.locant = locant;
    }

    @Override
    public void setParent(int parent) {
        this.locant.setParent(parent);
    }

    public int getStereoData() {
        return this.value;
    }

    public void setStereoData(int stereoData) {
        if (stereoData < 0 || stereoData > 3) {
            stereoData = -1;
        }
        this.value = stereoData;
    }

    @Override
    public int getValue() {
        if (this.locant == null) {
            return -1;
        }
        return this.locant.getValue();
    }

    @Override
    public void setValue(int value) {
        if (this.locant == null) {
            this.locant = new SimpleLocant(value, 0);
        } else {
            this.locant.setValue(value);
        }
    }

    public String toString() {
        String last = null;
        switch (this.value) {
            case 8: {
                last = "R";
                break;
            }
            case 128: {
                last = this.cisTrans ? "cis" : "Z";
                break;
            }
            case 16: {
                last = "S";
                break;
            }
            case 64: {
                if (this.bondstereo) {
                    last = this.cisTrans ? "trans" : "E";
                    break;
                }
                last = "s";
                break;
            }
            case 32: {
                last = "r";
                break;
            }
            case 2: {
                last = "exo";
                break;
            }
            case 1: {
                last = "endo";
                break;
            }
            case 3: {
                last = "L";
                break;
            }
            case 4: {
                last = "D";
                break;
            }
            case 5: {
                last = "DL";
            }
        }
        String loc = this.locant == null ? "" : this.locant.toString();
        return loc.equals("0") ? last : loc + last;
    }

    public boolean isBondStereo() {
        return this.bondstereo;
    }

    public boolean isChiral() {
        return this.value == 8 || this.value == 16 || this.value == 32 || this.value == 64;
    }

    public int getStereoType() {
        if (this.bondstereo) {
            return 1;
        }
        if (this.value == -1) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof StereoNumber)) {
            return false;
        }
        StereoNumber oo = (StereoNumber)o;
        return this.locant.equals(oo.locant) && this.bondstereo == oo.bondstereo && this.value == oo.value;
    }

    protected static boolean isStereoDescriptor(String str) {
        return StereoNumber.isVonBaeyerDescriptor(str) || StereoNumber.isLDconfigDescriptor(str) || str.endsWith("cis") || str.endsWith("trans");
    }

    protected static boolean isVonBaeyerDescriptor(String str) {
        if (")]}".indexOf(str.charAt(str.length() - 1)) > -1) {
            str = str.substring(0, str.length() - 1);
        }
        return str.endsWith("exo") || str.endsWith("endo");
    }

    protected static boolean isLDconfigDescriptor(String str) {
        if (str == null || str.length() != 1) {
            return false;
        }
        return str.equals("L") || str.equals("D");
    }

    @Override
    boolean isCis() {
        return this.cisTrans && this.value == 128;
    }

    @Override
    boolean isTrans() {
        return this.cisTrans && this.value == 64;
    }
}

