/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.lex.data;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.StructureLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.NonStdValenceLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Annulene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.BenzoFusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.FusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HantzschWidmanSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MonoCyclicSpiroSytem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PhenoIneSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyCyclicSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyRingSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.VonBaeyerSystem;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;
import java.util.HashMap;

public class StructureToken
extends Token
implements Cloneable {
    private String value;
    public boolean wrap = false;
    public ArrayList<Suffix> suffixes = null;
    public LocantList locantsBefore = new LocantList();
    public ArrayList<StructureToken> substituents = null;
    public LocantList locantInParent = null;
    public StructureToken cloneOf;
    public Structure structure;
    public LocantList stereos;
    public ArrayList<Hydro> hydros;
    boolean spaceSeparated = false;
    public boolean explicitSingle = false;
    public boolean isRoot = false;
    public int multiplicity = 1;
    private HashMap<Locant, Boolean> locants;

    public StructureToken(String name, String struc) {
        this.name = name;
        this.value = struc;
    }

    public StructureToken(Structure structure) {
        this.structure = structure;
        this.name = structure.toString();
        this.wrap = true;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
        this.locants = null;
    }

    public void addSuffix(Suffix suffix) {
        Suffix sulfonicAcid;
        if (suffix.getName().equals("ane") && !suffix.hasLocant()) {
            return;
        }
        if (suffix.is("hydrazide") && (sulfonicAcid = this.getSuffix("sulfonic acid")) != null) {
            sulfonicAcid.setName("sulfonic acid hydrazide");
            sulfonicAcid.setValue("S(=O)(=O)NN");
            return;
        }
        if (this.is("aceton") && (suffix.is("at") || suffix.is("ato"))) {
            throw new NameImportException.ParseException("acetonate is not supported yet");
        }
        if (suffix.is("at") && !suffix.hasLocant()) {
            String acid = (String)StructureLexer.getDict().get(this.name + "ic acid");
            if (acid == null) {
                acid = (String)StructureLexer.getDict().get(this.name + "oic acid");
            }
            if (acid != null) {
                String ate = StructureToken.removeAllO(acid);
                if (ate == null || acid.equals(ate)) {
                    throw new NameImportException.ParseException("Unhandled acid: " + this.name + "ate");
                }
                this.value = ate;
            }
        }
        if (this.suffixes == null) {
            this.suffixes = new ArrayList();
        }
        if (this.is("isopropyl") && !suffix.hasLocant()) {
            suffix.setLocant(new SimpleLocant(2));
        }
        if (this.is("androst") && !suffix.hasLocant() && suffix.getMultiplicity() == 2) {
            suffix.setLocant(LocantList.simpleList(3, 17));
        }
        this.suffixes.add(suffix);
    }

    public boolean tryAddLocantsBefore(LocantList locants, boolean cautious) {
        if (this.addNumGreekLocants(locants)) {
            return true;
        }
        if (this.useLocantsForSuffixes(locants, cautious)) {
            return true;
        }
        if (this.hasDefaultLocants()) {
            this.locantsBefore = locants;
            return true;
        }
        return false;
    }

    private boolean addNumGreekLocants(LocantList locants) {
        if (!locants.isAllNumGreek()) {
            return false;
        }
        if (this.locantInParent != null) {
            return false;
        }
        this.locantInParent = locants;
        return true;
    }

    private boolean useLocantsForSuffixes(LocantList locants, boolean cautious) {
        if (this.suffixes == null) {
            return false;
        }
        for (Suffix s : this.suffixes) {
            if (s.getName().startsWith("an")) continue;
            if (cautious && s.getName().startsWith("yl")) {
                return false;
            }
            if (s.hasLocant()) continue;
            LocantList ll = locants.expandOMP(s.getMultiplicity());
            if (s.getMultiplicity() != ll.size()) continue;
            if (!this.hasLocants(ll)) {
                return false;
            }
            s.setLocant(ll);
            return true;
        }
        return false;
    }

    public boolean addLocantsBefore(LocantList locants) {
        if (this.is("androst")) {
            return true;
        }
        if (this.tryAddLocantsBefore(locants, false)) {
            return true;
        }
        if (this.substituents != null && this.substituents.size() == 1 && this.substituents.get(0).addLocantsBefore(locants)) {
            return true;
        }
        if (this.locantInParent != null) {
            return false;
        }
        this.locantInParent = locants;
        return true;
    }

    public void setLocantBefore(Locant l) {
        this.locantsBefore.tryAddLocant(l);
    }

    public void addSubstituent(Locant locant, StructureToken substituent) {
        if (this.substituents == null) {
            this.substituents = new ArrayList();
        } else if ((this.is("oxy") || this.is("sulfan") && this.hasSuffix("yl") || this.is("thio")) && this.substituents.size() == 1 && this.hasStandardValence()) {
            this.substituents.get(0).addSubstituent(locant, substituent);
            return;
        }
        if (locant != null) {
            substituent.locantInParent = LocantList.simpleList(locant);
        }
        this.substituents.add(substituent);
    }

    boolean hasStandardValence() {
        if (this.suffixes == null) {
            return true;
        }
        for (Suffix s : this.suffixes) {
            LocantList l = s.getLocant();
            if (!l.hasLocant() || !(l.getLocant(0) instanceof NonStdValenceLocant)) continue;
            return false;
        }
        return true;
    }

    public StructureToken cloneMe() {
        return this.cloneMe(true);
    }

    public StructureToken cloneMe(boolean alwaysDeep) {
        StructureToken res;
        if (this.cloneOf == null) {
            this.cloneOf = this;
            res = this;
            if (!alwaysDeep) {
                return this;
            }
        } else {
            try {
                res = (StructureToken)this.clone();
                if (this.structure != null) {
                    res.structure = res.structure.cloneStructure();
                }
            }
            catch (CloneNotSupportedException e) {
                throw new NameImportException.Failure(e);
            }
        }
        if (this.substituents != null) {
            ArrayList<StructureToken> subs = new ArrayList<StructureToken>(res.substituents.size());
            for (StructureToken sub : res.substituents) {
                subs.add(sub.cloneMe(false));
            }
            res.substituents = subs;
        }
        if (res.suffixes != null) {
            res.suffixes = new ArrayList<Suffix>(res.suffixes);
        }
        return res;
    }

    public StructureToken OLDcloneMe() {
        if (this.cloneOf == null) {
            this.cloneOf = this;
            return this;
        }
        try {
            StructureToken res = (StructureToken)this.clone();
            if (this.structure != null) {
                res.structure = res.structure.cloneStructure();
            }
            if (this.substituents != null) {
                ArrayList<StructureToken> subs = new ArrayList<StructureToken>(res.substituents.size());
                for (StructureToken sub : res.substituents) {
                    subs.add(sub.OLDcloneMe());
                }
                res.substituents = subs;
            }
            if (res.suffixes != null) {
                res.suffixes = new ArrayList<Suffix>(res.suffixes);
            }
            return res;
        }
        catch (CloneNotSupportedException e) {
            throw new NameImportException.Failure(e);
        }
    }

    public void addStereo(LocantList stereos) {
        if (this.stereos == null) {
            this.stereos = stereos;
        } else {
            this.stereos.tryAddLocant(stereos);
        }
    }

    public void addHydro(Hydro hydro) {
        if (this.hydros == null) {
            this.hydros = new ArrayList();
        }
        this.hydros.add(hydro);
    }

    public void addHydros(LocantList ll, Hydro hydro) {
        for (Locant l : ll.getLocantsList()) {
            Hydro h = hydro.cloneToken();
            h.setLocant((SimpleLocant)l);
            this.addHydro(h);
        }
    }

    private String basicSmiles() {
        return Util.basicSmiles(this.value);
    }

    public boolean isAcid() {
        if (this.name.endsWith("ate") || this.name.endsWith("ite")) {
            return true;
        }
        return this.name.endsWith(" acid");
    }

    public boolean isEsterParent() {
        if (this.is("hydrate")) {
            return false;
        }
        if (this.isAcid()) {
            return true;
        }
        if (this.value != null && this.value.indexOf("AminoAcid") != -1 && this.value.indexOf("SpaceAttach:") != -1) {
            return true;
        }
        if (this.suffixes != null) {
            for (Suffix s : this.suffixes) {
                if (s.getType() != 4 && !s.getName().endsWith(" acid")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSalt() {
        return this.suffixes != null && this.suffixes.size() == 1 && this.suffixes.get(0).getName().equals("salt");
    }

    public boolean isCyclic() {
        if (this.basicSmiles().indexOf(49) != -1) {
            return true;
        }
        return this.wrap && (this.structure instanceof HantzschWidmanSystem || this.structure instanceof FusedSystem || this.structure instanceof Annulene || this.structure instanceof BenzoFusedSystem || this.structure instanceof MonoCyclicSpiroSytem || this.structure instanceof MultipliedSpiroSystem || this.structure instanceof PhenoIneSystem || this.structure instanceof PolyCyclicSpiroSystem || this.structure instanceof PolyRingSystem || this.structure instanceof VonBaeyerSystem);
    }

    public boolean isMonoAtomic() {
        String smiles = this.basicSmiles();
        if (smiles.endsWith("|")) {
            smiles = smiles.substring(0, smiles.length() - 1);
        }
        if (smiles.length() == 1) {
            return true;
        }
        if (smiles.equals("Cl") || smiles.equals("Br")) {
            return true;
        }
        return smiles.matches("\\[[A-Z][a-z]?H?\\d?\\]");
    }

    public boolean isChain() {
        if (this.wrap) {
            return this.structure.isChain();
        }
        if (this.value == null) {
            return false;
        }
        if (this.is("carbin")) {
            return false;
        }
        if (this.is("isobut")) {
            return true;
        }
        return Util.isChain(this.value);
    }

    public boolean needsLocant() {
        return this.isCyclic() && (this.hasSuffix("yl") || this.substituents != null || this.suffixes != null);
    }

    public boolean hasDefaultLocants() {
        if (this.value == null) {
            return false;
        }
        return this.value.indexOf("Substituent:") != -1 || this.value.indexOf("RGroups:") != -1 || this.value.indexOf("AtomsToReplace:") != -1 || this.value.indexOf("ConnectionPoint:") != -1;
    }

    boolean hasOneDefaultLocant() {
        if (this.value == null) {
            return false;
        }
        return this.value.indexOf("Substituent:") != -1 || this.value.indexOf("RGroups:") != -1 || this.value.indexOf("AtomsToReplace:") != -1;
    }

    static String smilesAtoms(String smiles) {
        return smiles.replaceAll("[=#\\[\\]\\-H]", "");
    }

    int getNumberOfAtoms() {
        if (this.value == null) {
            return Integer.MAX_VALUE;
        }
        if (this.isMonoAtomic()) {
            return 1;
        }
        return StructureToken.smilesAtoms(this.basicSmiles()).length();
    }

    public boolean getSpaceSeparated() {
        return this.spaceSeparated;
    }

    public void setSpaceSeparated(boolean value) {
        this.spaceSeparated = value;
    }

    Locant reinterpretLocantAsNumber(Locant l) {
        if (l.isGreekLetter() && !this.isCyclic()) {
            int n = Util.greekLetterToNumbering(l.getValue());
            if (this.isAcid()) {
                ++n;
            }
            return new SimpleLocant(n);
        }
        return l;
    }

    @Override
    public boolean hasLocant(Locant l) {
        if (l.isOrthoMetaPara() && !this.isCyclic()) {
            return false;
        }
        if (this.is("sulfonyl")) {
            return false;
        }
        this.computeLocants();
        if (this.locants == null) {
            if ((l = this.reinterpretLocantAsNumber(l)).isGreekLetter()) {
                return false;
            }
            if (l instanceof SimpleLocant || l instanceof StereoNumber) {
                if (this.is("amine")) {
                    return false;
                }
                int value = l.getValue();
                if (value > this.getNumberOfAtoms()) {
                    return false;
                }
                if (value == 1 && !l.isEmpty() && this.isMonoAtomic() && !this.is("meth") && !(l instanceof NonStdValenceLocant)) {
                    return false;
                }
            }
            if (l instanceof AtomLocant) {
                AtomLocant al = (AtomLocant)l;
                return StructureToken.smilesAtoms(this.basicSmiles()).contains(al.getAtomSymbol()) || this.suffixesHave(al);
            }
            return true;
        }
        if (l instanceof AtomLocant) {
            if (this.suffixesHave((AtomLocant)l)) {
                return true;
            }
            return true;
        }
        if (this.locants.containsKey(l)) {
            return true;
        }
        if (l.isGreekLetter()) {
            l = this.reinterpretLocantAsNumber(l);
            return this.locants.containsKey(l);
        }
        return false;
    }

    boolean suffixesHave(AtomLocant locant) {
        if (this.suffixes != null) {
            for (Suffix suffix : this.suffixes) {
                if (!StructureToken.smilesAtoms(suffix.getValue()).contains(locant.getAtomSymbol())) continue;
                return true;
            }
        }
        if (locant.getAtomSymbol() == "N" && this.substituents != null) {
            for (StructureToken structureToken : this.substituents) {
                if (!structureToken.is("amino")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLocants(LocantList locants) {
        if (locants == null) {
            return true;
        }
        for (Locant l : locants.getLocantsList()) {
            if (this.hasLocant(l)) continue;
            return false;
        }
        return true;
    }

    private void computeLocants() {
        if (this.locants != null || this.value == null) {
            return;
        }
        String smiles = this.value;
        if (smiles.indexOf("|$") == -1) {
            return;
        }
        this.locants = new HashMap();
        String map = smiles.substring(smiles.lastIndexOf("|$") + 2, smiles.indexOf("$|"));
        String[] locants = map.split("[;,]");
        for (int i = 0; i < locants.length; ++i) {
            if (locants[i].length() <= 0) continue;
            this.locants.put(this.parseLocant(locants[i]), Boolean.TRUE);
        }
    }

    SimpleLocant parseLocant(String loc) {
        int primes = 0;
        while (loc.endsWith("'")) {
            ++primes;
            loc = loc.substring(0, loc.length() - 1);
        }
        while (loc.endsWith("\"")) {
            primes += 2;
            loc = loc.substring(0, loc.length() - 1);
        }
        return new SimpleLocant(Util.stringToLocant(loc), primes);
    }

    public boolean hasSuffix(String name) {
        if (name == "yl" && this.getName().endsWith("yl")) {
            return true;
        }
        return this.getSuffix(name) != null;
    }

    public Suffix getSuffix(String name) {
        if (this.suffixes == null) {
            return null;
        }
        for (Suffix s : this.suffixes) {
            if (!Util.isName(s.getName(), name)) continue;
            return s;
        }
        return null;
    }

    public boolean removeSuffix(String name) {
        Suffix s = this.getSuffix(name);
        if (s == null) {
            return false;
        }
        this.suffixes.remove(s);
        return true;
    }

    public boolean firstAtomSubstituable() {
        try {
            return MolImporter.importMol(this.value).getAtom(0).getImplicitHcount() > 0;
        }
        catch (MolFormatException e) {
            return true;
        }
    }

    public boolean replaceLastO(String replacement) {
        for (int i = this.value.length() - 4; i >= 1; --i) {
            if (this.value.indexOf("[O-]", i) == -1) continue;
            this.value = this.value.substring(0, i) + replacement + this.value.substring(i + 4);
            return true;
        }
        return false;
    }

    static String removeAllO(String smiles) {
        if (smiles.indexOf("|$") != -1) {
            try {
                Molecule m = MolImporter.importMol(smiles, "cxsmiles");
                boolean foundOne = false;
                int i = m.getAtomCount();
                while (--i >= 0) {
                    MolAtom a = m.getAtom(i);
                    if (a.getAtno() != 8 || a.getBondCount() != 1 || a.getBond(0).getType() != 1) continue;
                    foundOne = true;
                    m.removeAtom(a);
                }
                if (!foundOne) {
                    return null;
                }
                return m.exportToFormat("cxsmiles");
            }
            catch (MolFormatException e) {
                throw new NameImportException.Failure(e);
            }
            catch (MolExportException e) {
                throw new NameImportException.Failure(e);
            }
        }
        return smiles.replaceAll("\\(O\\)", "");
    }

    public boolean nameEndsWith(String string) {
        return this.name != null && this.name.endsWith(string);
    }

    public boolean acceptsAne() {
        if (this.isChain() || this.structure instanceof HeteroChain) {
            return true;
        }
        if (this.isMonoAtomic()) {
            String basicSmiles = this.basicSmiles();
            try {
                int atno = MolImporter.importMol(basicSmiles, "smiles").getAtom(0).getAtno();
                int col = PeriodicSystem.getColumn(atno);
                return col >= 13 && col <= 17;
            }
            catch (MolFormatException e) {
                throw new RuntimeException(e);
            }
        }
        return this.isCyclic();
    }
}

