/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class AmineChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        boolean changed = false;
        changed |= AmineChecker.checkAmine(root);
        changed |= AmineChecker.checkLigands(root);
        for (int i = 0; i < root.substituentCount(); ++i) {
            changed |= this.checkTree(root.getSubstituent(i));
        }
        return changed;
    }

    private static boolean checkAmine(Structure root) {
        if (!(root instanceof Amine) || root.substituentCount() == 0) {
            return false;
        }
        boolean changed = false;
        Structure ligand = root.getSubstituent(0);
        for (int i = 1; i < root.substituentCount(); ++i) {
            Structure s = root.getSubstituent(i);
            LocantList list = s.getLocantInParent();
            if (!s.hasLocant() || root.hasLocant(list.getLocant(0)) || list.getLocant(0) instanceof AzaLocant || s.isCloneOf(ligand)) continue;
            root.removeSubstituent(i);
            --i;
            ligand.addSubstituent(s);
            changed = true;
        }
        return changed;
    }

    private static boolean checkLigands(Structure root) {
        if (root.substituentCount() == 0) {
            return false;
        }
        boolean changed = false;
        int dummies = 0;
        for (int i = 0; i < root.substituentCount(); ++i) {
            SimpleStructure s;
            SimpleStructure simpleStructure = s = root.getSubstituent(i) instanceof SimpleStructure ? (SimpleStructure)root.getSubstituent(i) : null;
            if (s != null && s.getValue() == "") {
                int j;
                Locant l = s.hasLocant() ? s.getLocantInParent().getLocant(0) : new SimpleLocant(1, 0);
                LocantList li = new LocantList();
                li.tryAddLocant(l);
                for (j = 0; j < s.suffixCount(); ++j) {
                    s.getSuffix(j).setLocant(li);
                    root.addSuffix(s.getSuffix(j));
                }
                for (j = 0; j < s.substituentCount(); ++j) {
                    s.getSubstituent(j).setLocantInParent(l);
                    root.addSubstituent(s.getSubstituent(j));
                }
                root.removeSubstituent(s);
                --i;
                ++dummies;
                changed = true;
                continue;
            }
            dummies = 0;
        }
        return changed;
    }
}

