/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HantzschWidmanSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import java.util.ArrayList;

public class HantzschWidmanChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        boolean changed = false;
        if (root.getParent() == null) {
            for (Structure ligand : root.getSubstituentList()) {
                changed |= this.checkTree(ligand);
            }
        }
        if (!(root instanceof HantzschWidmanSystem)) {
            return changed;
        }
        ArrayList<HeteroAtom> hAtoms = new ArrayList<HeteroAtom>();
        Suffix suffix = this.getSuffixWithHeteoAtomCountMultiplicity((HantzschWidmanSystem)root, hAtoms);
        if (suffix == null) {
            return changed;
        }
        return this.replaceNumbering(hAtoms, this.getNumberingOfHeteroAtoms(hAtoms), suffix) || changed;
    }

    protected Suffix getSuffixWithHeteoAtomCountMultiplicity(HantzschWidmanSystem struc, ArrayList<HeteroAtom> hAtoms) {
        int heteroAtomCount = 0;
        for (Structure ligand : struc.getSubstituentList()) {
            if (!(ligand instanceof HeteroAtom)) continue;
            ++heteroAtomCount;
            hAtoms.add((HeteroAtom)ligand);
        }
        for (Suffix suff : struc.getSuffixList()) {
            if (suff.getMultiplicity() != heteroAtomCount || suff.hasLocant()) continue;
            return suff;
        }
        Structure parent = struc.getParent();
        if (parent instanceof Amine && ((Amine)parent).getMultiplicity() == heteroAtomCount) {
            Suffix radical = SuffixFactory.createSuffix("|", "yl", (LocantList)null, heteroAtomCount, 2);
            struc.addSuffix(radical);
            return radical;
        }
        return null;
    }

    protected LocantList getNumberingOfHeteroAtoms(ArrayList<HeteroAtom> hAtoms) {
        LocantList numbering = new LocantList();
        for (HeteroAtom hAtom : hAtoms) {
            numbering.tryAddLocant(hAtom.getLocantInParent());
        }
        return numbering;
    }

    protected boolean replaceNumbering(ArrayList<HeteroAtom> hAtoms, LocantList numbering, Suffix suffix) {
        if (!this.needToChange(numbering)) {
            return false;
        }
        suffix.setLocant(numbering);
        this.setHeteroAtomNumberingToDefault(hAtoms);
        return true;
    }

    protected boolean needToChange(LocantList numbering) {
        return numbering.size() > 1 && numbering.getLocant(0).getValue() != 1;
    }

    protected void setHeteroAtomNumberingToDefault(ArrayList<HeteroAtom> heteroAtoms) {
        if (heteroAtoms.size() == 2) {
            heteroAtoms.get(0).setLocantInParent(1);
            heteroAtoms.get(1).setLocantInParent(3);
        } else {
            for (HeteroAtom hAtom : heteroAtoms) {
                hAtom.setLocantInParent((LocantList)null);
            }
        }
    }
}

