/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BracketToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Number;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RingNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Separator;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SpecialGroup;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StructureToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AcetateGroup;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AcidGenerator;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AminoAcid;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Anhydride;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Annulene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.BenzoFusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Bridge;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Ether;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.FusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HantzschWidmanSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Hydrazone;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.ImplicitPolyAcid;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Molecular;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MonoCyclicSpiroSytem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.NucleoBase;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Oxime;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PhenoIneSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyCane;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyCyclicSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyHelicene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyNaphthylene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyaLene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyaPhene;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SecChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.TertChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.VonBaeyerSystem;
import java.util.ArrayList;
import java.util.List;

public class IUPACParser {
    static boolean isAnthrene(String name) {
        return name.equalsIgnoreCase("anthren") || name.equalsIgnoreCase("anthrene");
    }

    static boolean isIne(String name) {
        return name.equalsIgnoreCase("in") || name.equalsIgnoreCase("ine");
    }

    static boolean isPhenox(String name) {
        return name.equalsIgnoreCase("phenox") || name.equalsIgnoreCase("phenoxa");
    }

    static boolean isPhenArs(String name) {
        return name.equalsIgnoreCase("phenars") || name.equalsIgnoreCase("phenarsa");
    }

    static boolean isBenzo(String name) {
        return name.equalsIgnoreCase("benzo") || name.equalsIgnoreCase("benz") || name.equalsIgnoreCase("benzoyl");
    }

    static boolean isOle(String name) {
        return name.equalsIgnoreCase("ol") || name.equalsIgnoreCase("ole");
    }

    static boolean isHeteroOle(String name) {
        return name.matches("(thiol|selenol|tellurol)e*");
    }

    static boolean isEpine(String name) {
        return name.equalsIgnoreCase("epin") || name.equalsIgnoreCase("epine");
    }

    static boolean isYl(String name) {
        return name.equalsIgnoreCase("yl");
    }

    protected Structure getStructure(List<Token> list, int type) {
        switch (type) {
            case -1: {
                throw new NameImportException("Unknown fused structure.");
            }
            case 0: {
                return this.createSimpleStructure(list);
            }
            case 1: {
                return this.createVonBaeyerSystem(list);
            }
            case 2: {
                return this.createMonoCyclicSpiroSystem(list);
            }
            case 3: {
                return this.createPolyCyclicSpiroSystem2(list);
            }
            case 4: {
                return this.createPolyCyclicSpiroSystem1(list);
            }
            case 5: {
                return this.createHeteroChain(list);
            }
            case 6: {
                return this.createCarbOxyGroup(list);
            }
            case 7: {
                return this.createHeteranthreneSystem(list);
            }
            case 8: {
                return this.createPhenoIneSystem(list);
            }
            case 9: {
                return this.createBenzoFusedSystem(list);
            }
            case 10: {
                return this.createAcetateGroup(list);
            }
            case 11: {
                return this.createHatzschWidmanSystem(list);
            }
            case 12: {
                return this.createPolyCarbonicAcidGroup(list);
            }
            case 13: {
                return this.createAcidGroup(list);
            }
            case 14: {
                return this.createSulfinylGroup(list);
            }
            case 15: {
                return this.createCarbonChainWithMultipiledSuffix(list);
            }
            case 16: {
                return this.createPolyRingSystem(list);
            }
            case 17: {
                return this.createMultipliedStructure(list);
            }
            case 18: {
                return this.createPolyCarbonate(list);
            }
            case 19: {
                return this.createAnnulene(list);
            }
            case 20: {
                return this.createMolecularStructure(list);
            }
            case 21: {
                return this.createDummyStructure(list);
            }
            case 23: {
                return this.createFusedSystem(list);
            }
            case 26: {
                return this.createBridge(list);
            }
            case 28: {
                return this.createMultiMetylene(list);
            }
        }
        return null;
    }

    private Structure createMultiMetylene(List<Token> list) {
        Number numToken = (Number)list.get(0);
        int mul = numToken.getData();
        String smi = "C";
        for (int i = 1; i < mul; ++i) {
            smi = smi + "C";
        }
        return new SimpleStructure(smi, numToken.getName() + "methylene");
    }

    private Structure createBridge(List<Token> list) {
        Token t = list.get(0);
        if (t.getValue().equals("[EPI]")) {
            Structure struc = this.createSimpleStructure(list.subList(1, list.size()));
            return new Bridge(struc, new LocantList());
        }
        t = list.get(list.size() - 1);
        ArrayList<Token> subList = new ArrayList<Token>();
        ArrayList<Suffix> suffixes = new ArrayList<Suffix>();
        for (int i = list.size() - 2; i > -1; --i) {
            if (Util.isNumbering(list.get(i))) {
                LocantList numbering = Util.getNumbering(list.get(i));
                Suffix s = SuffixFactory.createSuffix("|", "yl", numbering, 1, 2);
                suffixes.add(s);
                continue;
            }
            if (!(list.get(i) instanceof StructureToken) && subList.isEmpty()) continue;
            subList.add(list.get(i));
        }
        Structure struc = this.createSimpleStructure(subList);
        Bridge bridge = new Bridge(struc, new LocantList());
        if ("=#".indexOf(t.getValue().charAt(0)) > -1) {
            LocantList ll = new LocantList();
            ll.tryAddLocant(new SimpleLocant(1, 0));
            Suffix s = null;
            if (!suffixes.isEmpty()) {
                s = suffixes.get(0);
                s.setValue(t.getValue().substring(0, 1));
                s.setType(-1);
            } else {
                s = SuffixFactory.createSuffix(t.getValue().substring(0, 1), t.getName(), ll, 1, 0);
                bridge.addSuffix(s);
            }
            s.setRadical(SuffixFactory.getRadical(s.getValue()));
        }
        bridge.addSuffix(suffixes);
        return bridge;
    }

    private Structure createFusedSystem(List<Token> list) {
        Token token;
        ArrayList<Token> tmplist = new ArrayList<Token>();
        tmplist.addAll(list);
        ArrayList<Token> list1 = new ArrayList<Token>();
        ArrayList<Token> list2 = new ArrayList<Token>();
        while (!(tmplist.isEmpty() || (token = (Token)tmplist.get(0)) instanceof LocantList && token.getType() == 5)) {
            list1.add(token);
            tmplist.remove(0);
        }
        Structure leftStructure = IUPACParserCore.parseTokens(list1, false);
        LocantList numbering = (LocantList)tmplist.get(0);
        tmplist.remove(0);
        list2.addAll(tmplist);
        Structure rightStructure = IUPACParserCore.parseTokens(list2);
        return new FusedSystem(leftStructure, rightStructure, numbering);
    }

    static Structure createFusedSystem(List<Token> list, Structure rightstruc) {
        LocantList numbering = (LocantList)list.get(list.size() - 1);
        ArrayList<Token> list1 = new ArrayList<Token>();
        list1.addAll(list.subList(0, list.size() - 1));
        Structure leftStructure = IUPACParserCore.parseTokens(list1, false);
        FusedSystem system = new FusedSystem(leftStructure, rightstruc, numbering);
        IUPACParser.addRadicalsToParent(rightstruc, system);
        return system;
    }

    private static void addRadicalsToParent(Structure struc, Structure parent) {
        parent.addSuffix(struc.getSuffixList());
        struc.clearSuffixList();
    }

    private Structure createDummyStructure(List<Token> list) {
        return new SimpleStructure("", "");
    }

    private Structure createMolecularStructure(List<Token> list) {
        List<Token> l = list.subList(2, 3);
        Structure atom = this.createSimpleStructure(l);
        return new Molecular(atom);
    }

    private Structure createAnnulene(List<Token> list) {
        if (list.size() < 3 || Util.isNumbering(list.get(0)) && !list.get(0).getName().equals("benzo")) {
            throw new NameImportException.Failure("Name is not supported yet.");
        }
        if (list.get(0) instanceof StructureToken) {
            LocantList numbering = Util.getNumbering(list.get(1));
            return new Annulene(numbering.getLocant(0).getValue(), true);
        }
        LocantList numbering = Util.getNumbering(list.get(0));
        return new Annulene(numbering.getLocant(0).getValue(), true);
    }

    private Structure createPolyCarbonate(List<Token> list) {
        int mul = ((Number)list.get(0)).getData();
        int locant = 0;
        String carbonateSmi = "[C:" + ++locant + "](=O)O";
        for (int i = 0; i < mul - 1; ++i) {
            carbonateSmi = carbonateSmi + "[C:" + ++locant + "](=O)O";
        }
        carbonateSmi = carbonateSmi.substring(0, carbonateSmi.length() - 1);
        carbonateSmi = "[O-:" + ++locant + "]" + carbonateSmi + "[O-:" + (locant + 1) + "]";
        carbonateSmi = carbonateSmi + "{SpaceAttach: " + locant + " " + (locant + 1) + "}";
        return new SimpleStructure(carbonateSmi, mul + "carbonate");
    }

    private Structure createMultipliedStructure(List<Token> list) {
        try {
            Structure struc;
            LocantList locants = null;
            boolean bracketed = list.get(list.size() - 1) instanceof BracketToken;
            ArrayList<Token> tokens = new ArrayList<Token>();
            tokens.addAll(list);
            if (tokens.get(0) instanceof LocantList) {
                locants = (LocantList)tokens.get(0);
                tokens.remove(0);
                tokens.remove(0);
            }
            Number mul = (Number)tokens.get(0);
            tokens.remove(0);
            if (bracketed) {
                BracketToken bracket = (BracketToken)tokens.get(0);
                struc = IUPACParserCore.parseTokens(bracket.getInside());
            } else {
                struc = IUPACParserCore.parseTokens(tokens);
            }
            MultipliedSystem s = new MultipliedSystem(mul.getData(), struc, locants);
            return s;
        }
        catch (Exception e) {
            throw new NameImportException("Not Supperted yet.");
        }
    }

    private Structure createPolyRingSystem(List<Token> list) {
        int mul = ((Number)list.get(0)).getData();
        String suf = ((EndingToken)list.get(1)).getData();
        boolean arom = suf.endsWith("=");
        if (suf.startsWith("[POLY_CENE]")) {
            return new PolyCane(mul, arom);
        }
        if (suf.startsWith("[POLY_PHENE]")) {
            return new PolyaPhene(mul, arom);
        }
        if (suf.startsWith("[POLY_LENE]")) {
            return new PolyaLene(mul);
        }
        if (suf.startsWith("[POLY_NAPHTHYLENE]")) {
            return new PolyNaphthylene(mul);
        }
        if (suf.startsWith("[POLY_HELICENE]")) {
            return new PolyHelicene(mul);
        }
        return null;
    }

    private Structure createCarbonChainWithMultipiledSuffix(List<Token> list) {
        String value = list.get(2).getValue();
        String name = list.get(2).getName();
        SimpleStructure s = new SimpleStructure(value, name);
        LocantList l = (LocantList)list.get(0);
        int mul = ((Number)list.get(3)).getData();
        String sx = ((EndingToken)list.get(4)).getValue();
        String sn = ((EndingToken)list.get(4)).getName();
        Suffix suffix = SuffixFactory.createSuffix(sx, sn, l, mul, -1);
        s.addSuffix(suffix);
        return s;
    }

    private Structure createSulfinylGroup(List<Token> list) {
        String carb = list.get(0).getValue();
        String sulf = "S=O";
        String name = list.get(0).getName() + "sulfinyl";
        String value = carb + sulf;
        String numbering = "|$";
        int len = carb.length() + 2;
        for (int i = len - 2; i > 0; --i) {
            numbering = numbering + i + ";";
        }
        numbering = numbering + (len - 1) + ";" + len + "$|";
        value = value.replaceAll("2}", len + "}");
        SimpleStructure struc = new SimpleStructure(value + ' ' + numbering, name, 2);
        Util.addSuffix(struc, "yl", "|", len - 1);
        return struc;
    }

    private Structure createPolyCarbonicAcidGroup(List<Token> list) {
        ArrayList<Token> l = new ArrayList<Token>();
        l.addAll(list);
        String acid = AcidGenerator.createPolyCarbonicAcid(l, l.size() - 1, new ArrayList<Token>());
        return new SimpleStructure(acid, "acid");
    }

    private Structure createAcidGroup(List<Token> list) {
        ArrayList<Token> l = new ArrayList<Token>();
        l.addAll(list);
        String acid = AcidGenerator.createAcid(l, l.size() - 1, new ArrayList<Token>());
        return new SimpleStructure(acid, "acid");
    }

    private Structure createHatzschWidmanSystem(List<Token> list) {
        boolean addDefaultNumbering;
        ArrayList<Structure> atoms = new ArrayList<Structure>();
        int index = 0;
        if (list.size() == 2 && list.get(0).getName().equals("thi") && list.get(1).getName().equals("ol")) {
            return new SimpleStructure("S", "thiol");
        }
        EndingToken t = (EndingToken)list.get(list.size() - 1);
        LocantList l = null;
        int numsize = 0;
        if (list.get(0) instanceof Separator) {
            list.remove(0);
            ++index;
        }
        if (Util.isNumbering(list.get(0))) {
            l = Util.getNumbering(list.get(0));
            numsize = l.size();
            ++index;
        }
        int mul = 1;
        int loc = 0;
        while (index < list.size() - 1) {
            Token token = list.get(index);
            if (token instanceof Number) {
                mul = ((Number)token).getData();
            } else if (token instanceof StructureToken) {
                String val = token.getValue();
                if (val.endsWith("|")) {
                    val = val.substring(0, val.length() - 1);
                }
                for (int i = 0; i < mul; ++i) {
                    SimpleStructure s = new SimpleStructure(val, token.getName());
                    if (l == null || l.size() == 0) {
                        s.addLocant(new SimpleLocant(++loc, 0));
                    } else {
                        s.addLocant(l.removeLocant(0));
                    }
                    atoms.add(s);
                }
                mul = 1;
            }
            ++index;
        }
        boolean bl = addDefaultNumbering = l == null;
        if (atoms.size() > 1 && numsize == 1) {
            SimpleLocant locant;
            boolean canBeOMP = ((Structure)atoms.get(0)).getLocantInParent().getLocant(0) instanceof SimpleLocant;
            SimpleLocant simpleLocant = locant = canBeOMP ? (SimpleLocant)atoms.get(0).getLocantInParent().getLocant(0) : null;
            if (locant != null && !locant.isOrthoMetaPara()) {
                l.tryAddLocant(atoms.get(0).getLocantInParent());
                atoms.get(0).setLocantInParent(1);
                addDefaultNumbering = true;
            }
        }
        int ringSize = HantzschWidmanSystem.getRingSize(t);
        boolean aromatic = HantzschWidmanSystem.isAromatic(t);
        if (addDefaultNumbering && atoms.size() == 2 && ringSize > 3) {
            atoms.get(1).setLocantInParent(3);
        }
        HantzschWidmanSystem newStruc = new HantzschWidmanSystem(ringSize, atoms, aromatic);
        newStruc.addLocant(l);
        return newStruc;
    }

    private Structure createAcetateGroup(List<Token> list) {
        String value = list.get(0).getValue();
        String name = list.get(0).getName();
        if (Util.isImplicitPolyAcid(name)) {
            return new ImplicitPolyAcid(value, name);
        }
        return new AcetateGroup(value, name);
    }

    private Structure createBenzoFusedSystem(List<Token> list) {
        LocantList locants;
        ArrayList<Token> tokenList = new ArrayList<Token>();
        tokenList.addAll(list);
        ArrayList<HeteroAtom> atoms = new ArrayList<HeteroAtom>();
        int type = -1;
        boolean hasLocants = false;
        if (tokenList.get(0) instanceof Separator) {
            tokenList.remove(0);
        }
        if (Util.isNumbering((Token)tokenList.get(0))) {
            locants = Util.getNumbering((Token)tokenList.get(0));
            tokenList.remove(0);
            hasLocants = true;
            if (tokenList.get(0) instanceof Separator) {
                tokenList.remove(0);
            }
        } else {
            locants = LocantList.simpleList(1, 2);
        }
        assert (IUPACParser.isBenzo(((Token)tokenList.get(0)).getName()));
        tokenList.remove(0);
        while (!tokenList.isEmpty() && !(tokenList.get(0) instanceof EndingToken)) {
            Token first = (Token)tokenList.get(0);
            int multiplier = 1;
            if (first instanceof Number) {
                multiplier = ((Number)first).getData();
                tokenList.remove(0);
                if (tokenList.isEmpty()) {
                    throw new NameImportException("Invalid benzo fused name");
                }
                first = (Token)tokenList.get(0);
            }
            if (first instanceof StructureToken) {
                for (int i = 0; i < multiplier; ++i) {
                    atoms.add(new HeteroAtom(((Token)tokenList.get(0)).getValue()));
                }
                tokenList.remove(0);
                continue;
            }
            throw new NameImportException("Invalid benzo fused name");
        }
        if (tokenList.size() != 1) {
            throw new NameImportException("Invalid benzo fused name");
        }
        EndingToken token = (EndingToken)tokenList.get(0);
        if (IUPACParser.isIne(token.getName())) {
            type = 6;
        } else if (IUPACParser.isOle(token.getName()) || IUPACParser.isYl(token.getName())) {
            type = 5;
            if (!hasLocants) {
                locants = LocantList.simpleList(1, 3);
            }
        } else if (IUPACParser.isHeteroOle(token.getName())) {
            type = 5;
            if (!hasLocants) {
                locants = LocantList.simpleList(1, 3);
            }
            atoms.add(new HeteroAtom(((Token)tokenList.get(0)).getValue()));
        } else if (IUPACParser.isEpine(token.getName())) {
            type = 7;
        }
        return new BenzoFusedSystem(type, atoms, locants);
    }

    private Structure createPhenoIneSystem(List<Token> tokenList) {
        String smiles;
        int index = 0;
        HeteroAtom atom1 = null;
        HeteroAtom atom2 = null;
        PhenoIneSystem struc = null;
        if (IUPACParser.isPhenox(smiles = tokenList.get(index++).getName())) {
            atom1 = new HeteroAtom("O");
        } else if (IUPACParser.isPhenArs(smiles)) {
            atom1 = new HeteroAtom("[AsH3]");
        }
        if (index < tokenList.size()) {
            boolean b = false;
            if (tokenList.get(index) instanceof Number) {
                b = true;
                ++index;
            }
            if (tokenList.get(index) instanceof StructureToken) {
                if (atom1 == null) {
                    atom1 = new HeteroAtom(tokenList.get(index++).getValue());
                } else {
                    atom2 = new HeteroAtom(tokenList.get(index++).getValue());
                }
                if (b && atom2 == null) {
                    atom2 = (HeteroAtom)atom1.cloneStructure();
                } else if (atom2 == null && Util.heteroAtom(tokenList.get(index).getValue())) {
                    atom2 = new HeteroAtom(tokenList.get(index++).getValue());
                }
            }
            struc = new PhenoIneSystem(atom1, atom2);
        }
        return struc;
    }

    private Structure createHeteranthreneSystem(List<Token> tokenList) {
        PhenoIneSystem struc = null;
        if (tokenList.size() == 2 && IUPACParser.isAnthrene(tokenList.get(1).getName())) {
            String hetatom = tokenList.get(0).getValue();
            HeteroAtom atom = new HeteroAtom(hetatom);
            struc = new PhenoIneSystem(atom);
        }
        return struc;
    }

    private Structure createCarbOxyGroup(List<Token> tokenList) {
        if (tokenList.get(0).getValue().equals("[TERT]")) {
            String value = tokenList.get(2).getValue();
            String name = tokenList.get(2).getName();
            TertChain tertChain = new TertChain(value, name);
            SimpleStructure oxy = new SimpleStructure("O", "oxy");
            ((Structure)oxy).addSubstituent(tertChain);
            return oxy;
        }
        String value = tokenList.get(0).getValue() + tokenList.get(1).getValue();
        String name = tokenList.get(0).getName() + tokenList.get(1).getName();
        String numbering = "|$";
        int len = value.length();
        for (int i = len - 1; i > 0; --i) {
            numbering = numbering + i + ";";
        }
        numbering = numbering + len + "$|";
        SimpleStructure struc = new SimpleStructure(value + ' ' + numbering, name, 1);
        Util.addSuffix(struc, "yl", "|", len);
        struc.setConnectionPoint(0);
        return struc;
    }

    private Structure createSimpleStructure(List<Token> tokenList) {
        int mul = 1;
        int index = 0;
        LocantList l = null;
        if (Util.isNumbering(tokenList.get(0))) {
            ++index;
            if (tokenList.get(1) instanceof Separator) {
                ++index;
            }
            l = Util.getNumbering(tokenList.get(0));
        } else if (tokenList.get(0) instanceof Number) {
            mul = ((Number)tokenList.get(0)).getData();
            ++index;
        }
        Token t = tokenList.get(0);
        if (t.getName().equals("tert") || t.getName().equals("sec")) {
            index += 2;
        }
        String value = tokenList.get(index).getValue();
        String name = tokenList.get(index).getName();
        if (tokenList.get(0).getName().equals("tert") && Util.isCharbonChain(value)) {
            return new TertChain(value, name);
        }
        if (tokenList.get(0).getName().equals("sec") && Util.isCharbonChain(value)) {
            return new SecChain(value, name);
        }
        if (value.endsWith("|") && value.substring(0, value.length() - 1).indexOf(124) < 0) {
            return new HeteroAtom(value.substring(0, value.length() - 1));
        }
        if (value.indexOf("AminoAcid") > 0) {
            return new AminoAcid(value, name);
        }
        if (value.indexOf("NucleoBase") > 0) {
            return new NucleoBase(value, name, l);
        }
        if (l == null && name.indexOf("amin") > -1 && !name.endsWith("s")) {
            return new Amine(value, mul, name);
        }
        if (name.indexOf("ether") > -1) {
            return new Ether(value, name);
        }
        if (name.indexOf("oxim") > -1 && !name.endsWith("yl")) {
            return new Oxime(value, mul, name);
        }
        if (name.indexOf("hydrazon") > -1) {
            return new Hydrazone(value, name, l);
        }
        if (name.indexOf("anhydrid") > -1) {
            return new Anhydride(value, name);
        }
        return new SimpleStructure(value, name, l);
    }

    private Structure createVonBaeyerSystem(List<Token> tokenList) {
        String atom2;
        VonBaeyerSystem struc = null;
        Token token = tokenList.get(tokenList.size() - 1);
        boolean aromatic = token instanceof EndingToken;
        if (aromatic) {
            tokenList.remove(tokenList.size() - 1);
        }
        String atom = Util.getAtom(tokenList.get(tokenList.size() - 1).getValue(), 0);
        String string = atom2 = tokenList.get(tokenList.size() - 2) instanceof StructureToken ? Util.getAtom(tokenList.get(tokenList.size() - 2).getValue(), 0) : null;
        if (tokenList.get(0) instanceof SpecialGroup) {
            LocantList list = new LocantList();
            if (tokenList.size() == 2) {
                int length = tokenList.get(1).getValue().length();
                list.tryAddLocant(new RingNumber(length));
                struc = new VonBaeyerSystem(list, atom, atom2);
            } else {
                int length = ((Number)tokenList.get(1)).getData();
                list.tryAddLocant(new RingNumber(length));
                struc = new VonBaeyerSystem(list, atom, atom2);
            }
        } else {
            if (tokenList.get(2).getClass() != LocantList.class) {
                return null;
            }
            struc = new VonBaeyerSystem((LocantList)tokenList.get(2), atom, atom2);
        }
        struc.setAromatic(aromatic);
        return struc;
    }

    private Structure createMonoCyclicSpiroSystem(List<Token> tokenList) {
        MonoCyclicSpiroSytem struc = null;
        String atom = Util.getAtom(tokenList.get(tokenList.size() - 1).getValue(), 0);
        String atom2 = tokenList.get(tokenList.size() - 2) instanceof StructureToken ? Util.getAtom(tokenList.get(tokenList.size() - 2).getValue(), 0) : null;
        LocantList numbering = new LocantList();
        numbering = tokenList.get(0).getClass() == SpecialGroup.class ? (LocantList)tokenList.get(1) : (LocantList)tokenList.get(2);
        struc = new MonoCyclicSpiroSytem(numbering, atom, atom2);
        return struc;
    }

    private Structure createPolyCyclicSpiroSystem1(List<Token> tokenList) {
        MultipliedSpiroSystem struc = null;
        LocantList locant = (LocantList)tokenList.get(0);
        BracketToken bracketed = (BracketToken)tokenList.get(tokenList.size() - 1);
        Structure mainstruc = IUPACParserCore.parseTokens(bracketed.getInside());
        struc = new MultipliedSpiroSystem(mainstruc, locant);
        return struc;
    }

    private Structure createPolyCyclicSpiroSystem2(List<Token> tokenList) {
        PolyCyclicSpiroSystem struc = null;
        ArrayList<Structure> baseStructures = new ArrayList<Structure>();
        ArrayList<Token> tokens = new ArrayList<Token>();
        LocantList locants = new LocantList();
        ArrayList<Token> baseStructureTokens = ((BracketToken)tokenList.get(tokenList.size() - 1)).getInside();
        for (int i = 0; i < baseStructureTokens.size(); ++i) {
            Token token = baseStructureTokens.get(i);
            if (!tokens.isEmpty() && token instanceof LocantList && token.getType() == 2) {
                locants.tryAddLocant((LocantList)token);
                baseStructures.add(IUPACParserCore.parseTokens(tokens));
                tokens.clear();
                ++i;
                continue;
            }
            tokens.add(token);
        }
        baseStructures.add(IUPACParserCore.parseTokens(tokens));
        struc = new PolyCyclicSpiroSystem(baseStructures, locants);
        return struc;
    }

    private Structure createHeteroChain(List<Token> tokenList) {
        String atom = tokenList.get(tokenList.size() - 1).getValue();
        String atom2 = tokenList.size() < 3 ? null : tokenList.get(1).getValue();
        int mul = ((Number)tokenList.get(0)).getData();
        if (atom.indexOf("{") > 0) {
            atom = atom.substring(0, atom.indexOf("{"));
        }
        if (atom2 != null && atom2.indexOf("{") > 0) {
            atom2 = atom2.substring(0, atom2.indexOf("{"));
        }
        return new HeteroChain(atom, atom2, mul);
    }
}

