/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class KetoneChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        boolean changed = false;
        for (int i = 0; i < root.substituentCount(); ++i) {
            changed |= this.checkTree(root.getSubstituent(i));
        }
        if (!(root instanceof SimpleStructure) || root.substituentCount() < 3) {
            return changed;
        }
        SimpleStructure ss = (SimpleStructure)root;
        if (!ss.getName().startsWith("keton")) {
            return changed;
        }
        Structure firstLigand = root.getSubstituent(0);
        while (root.substituentCount() > 2 && !root.getSubstituent(1).isSpaceSeparated()) {
            Structure nextLigand = root.getSubstituent(1);
            firstLigand.addSubstituent(nextLigand);
            root.removeSubstituent(nextLigand);
            changed = true;
        }
        return changed;
    }
}

