/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import java.util.ArrayList;

public class MultiParentChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        ArrayList<Suffix> multiParent = this.getMultiParent(root);
        return this.correctSulfonate(multiParent);
    }

    private boolean correctSulfonate(ArrayList<Suffix> multiParent) {
        boolean changed = false;
        for (int i = 0; i < multiParent.size(); ++i) {
            Suffix suffix = multiParent.get(i);
            if (!"sulfon".equals(suffix.getStructure().getName())) continue;
            suffix.setValue("S(=O)(=O)[O-] |$1;;;4$|{SpaceAttach:4}");
            suffix.setName("sulfonate");
            suffix.setStructure(null);
            suffix.setType(4);
            changed = true;
        }
        return changed;
    }

    public boolean checkTrees(Structure root) {
        boolean changed = true;
        ArrayList<Suffix> multiParent = this.getMultiParent(root);
        LocantList locantsOfMultiParent = this.getLocants(multiParent);
        if (locantsOfMultiParent.size() == 0) {
            return false;
        }
        for (int i = 0; i < root.substituentCount(); ++i) {
            Structure struc = root.getSubstituent(i);
            LocantList locant = struc.getLocantInParent();
            if (locant == null || !locantsOfMultiParent.containsAll(locant)) continue;
            changed |= this.addLigandToMultiParent(struc, multiParent);
            --i;
        }
        return changed;
    }

    private ArrayList<Suffix> getMultiParent(Structure struc) {
        ArrayList<Suffix> multiParent = new ArrayList<Suffix>();
        for (int i = 0; i < struc.suffixCount(); ++i) {
            if (struc.getSuffix(i).getStructure() == null) continue;
            multiParent.add(struc.getSuffix(i));
        }
        return multiParent;
    }

    private LocantList getLocants(ArrayList<Suffix> suffixList) {
        LocantList locants = new LocantList();
        for (int i = 0; i < suffixList.size(); ++i) {
            locants.tryAddLocant(suffixList.get(i).getLocant());
        }
        return locants;
    }

    private boolean addLigandToMultiParent(Structure ligand, ArrayList<Suffix> parents) {
        LocantList locant = ligand.getLocantInParent();
        for (int i = 0; i < parents.size(); ++i) {
            if (!parents.get(i).getLocant().containsAll(locant)) continue;
            ligand.removeLastLocant();
            ligand.setSpaceSeparated(true);
            Structure parentStruc = parents.get(i).getStructure();
            ligand.getParent().removeSubstituent(ligand);
            parentStruc.addSubstituent(ligand);
            return true;
        }
        return false;
    }
}

