/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;

public class PeroxyChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        boolean changed = false;
        if (Util.isAcid(root)) {
            int scount = root.substituentCount();
            for (int i = 0; i < scount; ++i) {
                Structure s = root.getSubstituent(i);
                if (s.hasLocant() || !PeroxyChecker.isPeroxy(s)) continue;
                PeroxyChecker.addPeroxyToAcid(root);
                root.addSubstituent(s.getSubstituentList());
                root.removeSubstituent(i);
                changed = true;
                break;
            }
        }
        return changed;
    }

    private static boolean isPeroxy(Structure struc) {
        return "peroxy".equals(struc.getName());
    }

    private static void addPeroxyToAcid(Structure acid) {
        SimpleStructure ss;
        SimpleStructure simpleStructure = ss = acid instanceof SimpleStructure ? (SimpleStructure)acid : null;
        if (ss != null && ss.getName().indexOf("acid") > -1) {
            ss.setValue(PeroxyChecker.addPeroxy(ss.getValue()));
        } else {
            for (int i = 0; i < acid.substituentCount(); ++i) {
                Suffix suff = acid.getSuffix(i);
                if (suff.getType() != 0) continue;
                suff.setValue(PeroxyChecker.addPeroxy(suff.getValue()));
            }
        }
    }

    private static String addPeroxy(String smi) {
        smi = smi.replace("=O", "&&");
        smi = smi.replaceFirst("O", "OO");
        return smi.replace("&&", "=O");
    }
}

