/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SaltEnding;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.Molecule;

public class SaltChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        if (root == null || root.substituentCount() > 0 || root.suffixCount() == 0) {
            return false;
        }
        int saltEnding = this.getSaltEndingIndex(root);
        if (saltEnding < 0) {
            return false;
        }
        if (root instanceof SimpleStructure) {
            if (this.isIon(root)) {
                this.setSaltToParent(root, (SaltEnding)root.removeSuffix(saltEnding));
                return true;
            }
        } else if (root instanceof MultipliedSystem) {
            Molecule mol;
            MultipliedSystem mulRoot = (MultipliedSystem)root;
            Structure basicStruc = mulRoot.getStructure();
            int mul = mulRoot.getMultiplicity();
            String atom = ((SaltEnding)root.getSuffix(saltEnding)).getAtom();
            try {
                mol = MolImporter.importMol(atom, "smiles");
            }
            catch (MolFormatException e) {
                return false;
            }
            if (mol.getAtom(0).getImplicitHcount() < mul) {
                return false;
            }
            mulRoot.setMultpilicity(1);
            mulRoot.setStructure(new SimpleStructure(atom, atom));
            mulRoot.removeSuffix(saltEnding);
            for (int i = 0; i < mul; ++i) {
                mulRoot.addSubstituent(basicStruc.cloneStructure());
            }
            return true;
        }
        return false;
    }

    private int getSaltEndingIndex(Structure struc) {
        if (struc == null) {
            return -1;
        }
        for (int i = 0; i < struc.suffixCount(); ++i) {
            if (!(struc.getSuffix(i) instanceof SaltEnding)) continue;
            return i;
        }
        return -1;
    }

    private boolean isIon(Structure struc) {
        if (!(struc instanceof SimpleStructure)) {
            return false;
        }
        SimpleStructure ss = (SimpleStructure)struc;
        if (ss.getName() == null || !ss.getName().endsWith("ium")) {
            return false;
        }
        return ss.getValue().indexOf("+") > -1 || ss.getValue().indexOf("-") > -1;
    }

    private void setSaltToParent(Structure struc, SaltEnding salt) {
        Structure newStruc = struc.cloneStructure();
        ((SimpleStructure)struc).setName(salt.getName());
        ((SimpleStructure)struc).setValue(salt.getAtom());
        struc.addSubstituent(newStruc);
        newStruc.setSpaceSeparated(true);
        struc.addSuffix(SuffixFactory.createSuffix("-h+", "id", new LocantList(), 1, 3));
    }
}

