/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import java.util.ArrayList;

public class SpaceSeparatedLigandChecker
implements Refactoring<Structure> {
    @Override
    public boolean checkTree(Structure root) {
        if (root == null) {
            return false;
        }
        boolean changed = false;
        int i = 0;
        ArrayList<Structure> substList = new ArrayList<Structure>();
        while (i < root.substituentCount() - 1) {
            Structure struc = root.getSubstituent(i);
            Structure struc2 = root.getSubstituent(i + 1);
            if (struc.isSpaceSeparated() && !struc.isRoot() && !struc2.isSpaceSeparated()) {
                root.removeSubstituent(struc2);
                struc.addSubstituent(struc2);
                if (!substList.contains(struc)) {
                    substList.add(struc);
                }
                changed = true;
                continue;
            }
            ++i;
        }
        if (root.getParent() != null) {
            for (int j = 0; j < substList.size(); ++j) {
                Structure s = (Structure)substList.get(j);
                root.removeSubstituent(s);
                root.getParent().addSubstituent(s);
                changed = true;
            }
        }
        if (root.substituentCount() == 1 && root.getSubstituent(0).isSpaceSeparated()) {
            changed |= this.checkTree(root.getSubstituent(0));
        }
        return changed;
    }
}

