/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.Refactoring;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;

public class SulfonamidoChecker
implements Refactoring<IUPACParserCore.NodeSet> {
    @Override
    public boolean checkTree(IUPACParserCore.NodeSet nodes) {
        int subCount = nodes.getRoot().substituentCount();
        if (!SulfonamidoChecker.isSulfonAmido(nodes.getSecondRoot()) || nodes.getRoot() == nodes.getSecondRoot() || subCount == 0 || nodes.getRoot().hasLocant()) {
            return false;
        }
        boolean needToChange = false;
        for (int i = 0; i < subCount && !needToChange; ++i) {
            Structure s = nodes.getRoot().getSubstituent(i);
            if (s.hasLocant() && s.getLocantInParent().getLocant(0) instanceof AzaLocant) continue;
            needToChange = true;
        }
        if (needToChange) {
            nodes.getRoot().setLocantInParent(new AzaLocant("N"));
        }
        return needToChange;
    }

    private static boolean isSulfonAmido(Structure struc) {
        return struc != null && "sulfonamido".equals(struc.getName());
    }
}

