/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.RingUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class Amine
extends SimpleStructure {
    private int mul = 0;
    private ArrayList<MolAtom> atomList = new ArrayList();
    private LocantList numbering;

    public Amine(String value, int mul, String name) {
        super(value, name);
        this.mul = mul;
    }

    @Override
    public Structure cloneStructure() {
        Amine newStructure = new Amine(this.value, this.mul, this.name);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected void preProcess() {
        if (this.molecule != null) {
            return;
        }
        int count = this.substituentCount();
        for (int i = 0; i < count; ++i) {
            Amine.addChildToAmineGroup((Structure)this.substituentList.get(i), this);
        }
        if (count == 0 && this.mul > 1) {
            Structure.RGroup rg = new Structure.RGroup(1);
            for (int i = 0; i < this.mul; ++i) {
                rg.addNeighbour(i + 1, 1);
            }
            this.rgroups.add(rg);
        }
        if (this.mul > 1 && count > 0 && !this.getSubstituent(0).isSpaceSeparated()) {
            this.molecule = this.getBasicStructure().getMolecule();
        }
    }

    protected Structure getBasicStructure() {
        Structure root = this.getSubstituent(0);
        this.removeSubstituent(0);
        while (this.substituentCount() > 0) {
            root.addSubstituent(this.getSubstituent(0));
            this.removeSubstituent(0);
        }
        while (this.suffixCount() > 0) {
            root.addSuffix(this.getSuffix(0));
            this.removeSuffix(0);
        }
        root.setParent(null);
        LocantList locants = null;
        if (root.hasLocant()) {
            locants = root.getLocantInParent();
        } else {
            for (int i = 0; i < root.suffixCount(); ++i) {
                if (!root.getSuffix(i).getValue().equals("|")) continue;
                locants = root.getSuffix(i).getLocant();
                root.removeSuffix(i);
                break;
            }
        }
        Suffix amine = SuffixFactory.createSuffix(this.getValue(), this.getName(), locants, this.mul, 1);
        root.setLocantInParent((LocantList)null);
        root.addSuffix(amine);
        return root;
    }

    @Override
    protected Molecule getMol() {
        String smiles = RingUtil.dictFormatToSmiles(this.value);
        this.setAtomMap(smiles);
        if (smiles.indexOf(32) > 0) {
            smiles = smiles.substring(0, smiles.indexOf(32));
        }
        String val = smiles;
        for (int i = 1; i < this.mul; ++i) {
            val = val + "." + smiles;
        }
        Molecule molecule = this.readMol(val);
        for (int i = 0; i < this.mul; ++i) {
            this.atomList.add(molecule.getAtom(i));
        }
        return molecule;
    }

    private static boolean addChildToAmineGroup(Structure struc, Amine amine) {
        if (struc instanceof Amine) {
            return false;
        }
        int i = 0;
        while (i < struc.substituentCount()) {
            if (Amine.addChildToAmineGroup(struc.getSubstituent(i), amine)) continue;
            ++i;
        }
        if (!(struc.getLocantInParent() == null || !(struc.getLocantInParent().getLocant(0) instanceof AzaLocant) || struc.parent instanceof SimpleStructure && Amine.hasAzane(((SimpleStructure)struc.parent).getName()))) {
            struc.parent.removeSubstituent(struc);
            amine.addSubstituent(struc);
            return true;
        }
        return false;
    }

    private static boolean hasAzane(String s) {
        return s.indexOf("amin") > 0 || s.indexOf("imin") > 0 || s.indexOf("amid") > 0 || s.indexOf("imid") > 0;
    }

    @Override
    protected void getAtomNumbers(IntVector vec) {
        if (!this.atomMap.isEmpty()) {
            super.getAtomNumbers(vec);
        } else {
            for (int i = 0; i < this.mul; ++i) {
                vec.add(i + 1);
            }
        }
    }

    protected void connectLigands() {
        for (int i = 0; i < this.substituentCount(); ++i) {
            Structure struc = (Structure)this.substituentList.get(i);
            Molecule mol = struc.buildMolecule();
            this.molecule.fuse(mol);
            int index = 1;
            int mul = 1;
            if (!struc.radicals.isEmpty()) {
                index = struc.radicals.get(0).getLocant().getLocant(0).getValue();
                String rad = struc.radicals.get(0).getValue();
                if (rad.endsWith("=")) {
                    mul = 2;
                }
                if (rad.endsWith("#")) {
                    mul = 3;
                }
            }
            if (struc.getLocantInParent() != null && struc.getLocantInParent().getLocant(0) instanceof AzaLocant) {
                AzaLocant locant = (AzaLocant)struc.getLocantInParent().getLocant(0);
                int parent = locant.getParent();
                this.molecule.add(new MolBond(this.atomList.get(parent), mol.getAtom(struc.getAtomIndex(index)), mul));
                continue;
            }
            if (!struc.radicals.isEmpty()) {
                LocantList list = struc.radicals.get(0).getLocant();
                for (int j = 0; j < list.size(); ++j) {
                    index = ((SimpleLocant)list.getLocant(j)).getValue();
                    this.molecule.add(new MolBond(this.atomList.get(j), mol.getAtom(struc.getAtomIndex(index)), mul));
                }
                continue;
            }
            if (struc.spaceSeparated) continue;
            this.molecule.add(new MolBond(this.atomList.get(0), mol.getAtom(struc.getAtomIndex(index)), mul));
        }
    }

    @Override
    protected LocantList storeStereoData() {
        StereoNumber sn = this.stereoLocants.size() > 0 ? (StereoNumber)this.stereoLocants.getLocant(0) : null;
        boolean useSubstituent = (sn == null || !(sn.getLocant() instanceof AzaLocant)) && this.substituentCount() > 0;
        Amine struc = useSubstituent ? this.getSubstituent(0) : this;
        return super.addStereoData2(struc, this.stereoLocants, true);
    }

    public LocantList getNumbering() {
        return this.numbering;
    }

    public void setNumbering(LocantList numbering) {
        this.numbering = numbering;
    }

    @Override
    protected int addBonds(Molecule mol, Structure s, int index, boolean spaceSep, int locantindex, boolean[] bondAdded, boolean cloned) {
        if (this.mul > 1 && spaceSep) {
            return 0;
        }
        return super.addBonds(mol, s, index, spaceSep, locantindex, bondAdded, cloned);
    }

    @Override
    public int getAtomIndex(int mappedIndex) {
        if (this.locantInParent != null) {
            for (int i = 0; i < this.locantInParent.size(); ++i) {
                if (this.locantInParent.getLocant(i).getValue() != mappedIndex) continue;
                return i;
            }
        }
        return super.getAtomIndex(mappedIndex);
    }

    @Override
    protected int getAtomIndex(int mappedIndex, int molindex) {
        if (!this.atomMap.containsKey(new Integer(mappedIndex))) {
            return Math.max(mappedIndex - 1, 0);
        }
        return super.getAtomIndex(mappedIndex, molindex);
    }

    public int getMultiplicity() {
        return this.mul;
    }
}

