/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class AminoAcid
extends SimpleStructure {
    private int configuration = 0;
    private static final int DEFAULT_AMINO_ACID_ATTACHPOINT = 10;

    public AminoAcid(String value, String name, int configuration) {
        super(value, name, 3);
        this.configuration = configuration;
    }

    public AminoAcid(String value, String name) {
        super(value, name, 3);
    }

    @Override
    protected void calcLocants(ArrayList<Structure> list) {
        int i = 0;
        while (i < 2 & !list.isEmpty()) {
            Structure struc = list.remove(i);
            struc.setLocantInParent(10);
            ++i;
        }
        if (!list.isEmpty()) {
            super.calcLocants(list);
        }
    }

    @Override
    protected Molecule getMol() {
        Molecule mol = super.getMol();
        if (this.configuration != 3) {
            this.changeStereo(mol);
        }
        this.removeOrAddOxygenIfNeeded(mol);
        return mol;
    }

    private void removeOrAddOxygenIfNeeded(Molecule mol) {
        if (this.parent != null && !this.isEster(this.parent)) {
            MolAtom atom = mol.getAtom(this.getAtomIndex(1));
            for (int i = 0; i < atom.getBondCount(); ++i) {
                MolBond bond = atom.getBond(i);
                MolAtom other = bond.getOtherAtom(atom);
                if (!Util.isOxygen(other) || bond.getType() != 1) continue;
                mol.removeAtom(other);
                LocantList l = new LocantList();
                l.tryAddLocant(new SimpleLocant(1, 0));
                this.addSuffix(SuffixFactory.createSuffix("|", "yl", l, 1, 2));
                return;
            }
        } else if (this.isEster(this.parent)) {
            MolAtom atom = mol.getAtom(this.getAtomIndex(1));
            if (atom.getBondCount() >= 3) {
                return;
            }
            Molecule hydroxy = this.readMol("O");
            mol.fuse(hydroxy);
            mol.add(new MolBond(atom, hydroxy.getAtom(0)));
        }
    }

    private boolean isEster(Structure struc) {
        if (!(struc instanceof SimpleStructure)) {
            return false;
        }
        return ((SimpleStructure)struc).getName().indexOf("ester") > -1;
    }

    private void changeStereo(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            int chirality = mol.getChirality(i);
            if ((chirality & 0x18) == 0) continue;
            if (this.configuration == 5) {
                mol.getAtom(i).setStereoGroupType(3);
                mol.getAtom(i).setStereoGroupNumber(1);
                continue;
            }
            if (this.configuration != 4) continue;
            if (chirality == 8) {
                mol.setChirality(i, 16);
                continue;
            }
            if (mol.getChirality(i) != 16) continue;
            mol.setChirality(i, 8);
        }
    }

    public void setConfiguration(int conf) {
        this.configuration = conf;
    }
}

