/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.NonStdValenceLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class BenzoFusedSystem
extends Structure {
    private static final String BENZO5 = "c12cccc1cccc2";
    private static final String BENZO6 = "c12ccccc1cccc2";
    private static final String BENZO7 = "c12cccccc1cccc2";
    private static IntVector BENZO5LOCANTS = new IntVector(new int[]{701, 1, 2, 3, 301, 4, 5, 6, 7});
    private static IntVector BENZO6LOCANTS = new IntVector(new int[]{801, 1, 2, 3, 4, 401, 5, 6, 7, 8});
    private static IntVector BENZO7LOCANTS = new IntVector(new int[]{901, 1, 2, 3, 4, 5, 501, 6, 7, 8, 9});
    public static final int BENZOOLE = 5;
    public static final int BENZOINE = 6;
    public static final int BENZOEPINE = 7;
    private Structure basicStruc = null;
    private ArrayList<Structure> heteroAtoms = new ArrayList();
    private int type;

    public BenzoFusedSystem(int type, ArrayList<HeteroAtom> heteroAtoms, LocantList locants) {
        this.type = type;
        this.basicStruc = new SimpleStructure(this.getBasicSmiles(), "benzofused");
        this.basicStruc.setAtomMap(this.getBasicNumbering());
        for (int i = 0; i < heteroAtoms.size(); ++i) {
            HeteroAtom atom = heteroAtoms.get(i);
            atom.setLocantInParent(locants.getLocant(i));
            this.basicStruc.addSubstituent(atom);
            this.heteroAtoms.add(atom);
            if (!(locants.getLocant(i) instanceof NonStdValenceLocant)) continue;
            this.nonStdValence.tryAddLocant(locants.getLocant(i));
        }
        this.setAtomMap(this.getBasicNumbering());
        this.basicStruc.parent = this;
    }

    private String getBasicSmiles() {
        String smiles = "";
        switch (this.type) {
            case 5: {
                smiles = BENZO5;
                break;
            }
            case 6: {
                smiles = BENZO6;
                break;
            }
            case 7: {
                smiles = BENZO7;
            }
        }
        return smiles;
    }

    private IntVector getBasicNumbering() {
        if (this.type == 5) {
            return BENZO5LOCANTS;
        }
        if (this.type == 6) {
            return BENZO6LOCANTS;
        }
        if (this.type == 7) {
            return BENZO7LOCANTS;
        }
        return null;
    }

    @Override
    protected String printValue() {
        return this.basicStruc.printValue();
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        ArrayList<HeteroAtom> cloneList = new ArrayList<HeteroAtom>();
        LocantList cloneLocants = new LocantList();
        for (int i = 0; i < this.heteroAtoms.size(); ++i) {
            HeteroAtom atom = (HeteroAtom)this.heteroAtoms.get(i);
            cloneList.add((HeteroAtom)atom.cloneStructure());
            cloneLocants.tryAddLocant(atom.getLocantInParent().getLocant(0));
        }
        BenzoFusedSystem newStructure = new BenzoFusedSystem(this.type, cloneList, cloneLocants);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        Molecule mol = this.basicStruc.buildMolecule();
        if (this.type == 5) {
            int index = -1;
            if (this.setBonds(mol, 1)) {
                this.setBondsType(mol, 3, 1);
                mol.getAtom(this.getAtomIndex(2)).getBondTo(mol.getAtom(this.getAtomIndex(3))).setType(2);
                index = 1;
            }
            if (this.setBonds(mol, 3) && index < 0) {
                this.setBondsType(mol, 1, 1);
                mol.getAtom(this.getAtomIndex(1)).getBondTo(mol.getAtom(this.getAtomIndex(2))).setType(2);
            }
            mol.aromatize();
        }
        return mol;
    }

    @Override
    protected void setNitrogenHydrogens(Molecule mol, int count, ArrayList<MolAtom> atomlist) {
    }

    private boolean setBonds(Molecule mol, int index) {
        if (Util.isOxygen(mol.getAtom(this.getAtomIndex(index)))) {
            this.setBondsType(mol, index, 1);
            return true;
        }
        return false;
    }

    @Override
    protected String toSmiles() {
        return this.basicStruc.toSmiles();
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        int locant = Util.locantToInt(loc);
        return this.getBasicNumbering().contains(locant);
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.basicStruc.hasAtom(atomSymbol);
    }
}

