/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class Ester
extends Structure {
    Structure acid;
    Structure basic;
    ArrayList<Structure> basics = new ArrayList();
    IntVector hydroxyAtoms = new IntVector();

    public Ester(Structure acid, Structure basic) {
        this.acid = acid;
        this.basic = basic;
        this.atomMap = basic.atomMap;
        this.basics.add(basic);
        this.substituentList.addAll(basic.substituentList);
        this.basic.substituentList = new ArrayList();
    }

    public Ester(Structure acid, ArrayList<Structure> basic) {
        this.acid = acid;
        this.basics.addAll(basic);
        this.atomMap = basic.get((int)0).atomMap;
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        Ester newStructure = new Ester(this.acid.cloneStructure(), this.basic.cloneStructure());
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        Molecule molecule = new Molecule();
        if (this.basic == null) {
            molecule = this.getMolOfMultiEster();
        } else {
            molecule = this.basic.buildMolecule();
            this.addAcidGroup(molecule);
            this.stereoData.addAll(this.basic.stereoData);
        }
        this.stereoData.addAll(this.acid.stereoData);
        this.setStereoData(this.stereoData, molecule, true);
        return molecule;
    }

    private Molecule getMolOfMultiEster() {
        Molecule molecule = this.acid.buildMolecule();
        for (int i = 0; i < this.basics.size(); ++i) {
            Structure basicStruc = this.basics.get(i);
            Molecule m = basicStruc.buildMolecule();
            molecule.fuse(m);
            int index = this.getAttachPointOfBasicStructure(i);
            MolAtom atom1 = m.getAtom(basicStruc.getAtomIndex(index));
            MolAtom atom2 = this.acid.buildMolecule().getAtom(this.getHydroxyIndex());
            molecule.add(new MolBond(atom1, atom2));
            this.removeGroupFromMol(atom1);
            this.stereoData.addAll(basicStruc.stereoData);
        }
        return molecule;
    }

    private int getAttachPointOfBasicStructure(int structureIndex) {
        int index;
        if (this.acid.hasLocant() && this.acid.getLocantInParent().size() > structureIndex && (index = this.acid.getLocantInParent().getLocant(structureIndex).getValue()) > 1) {
            return index;
        }
        Structure basicStructure = this.basics.get(structureIndex);
        for (int i = 0; i < basicStructure.suffixCount(); ++i) {
            int index2;
            Suffix s = basicStructure.getSuffix(i);
            if (s.getType() != 2 || !s.hasLocant() || (index2 = s.getLocant().getLocant(0).getValue()) <= 1) continue;
            return index2;
        }
        return 1;
    }

    private void addAcidGroup(Molecule molecule) {
        molecule.fuse(this.acid.buildMolecule());
        int index = this.acid.getLocantInParent() == null ? 1 : this.acid.getLocantInParent().getLocant(0).getValue();
        MolAtom atom1 = molecule.getAtom(this.getAtomIndex(index));
        MolAtom atom2 = this.acid.buildMolecule().getAtom(this.getHydroxyIndex());
        molecule.add(new MolBond(atom1, atom2));
        this.removeGroupFromMol(atom1);
    }

    private int getHydroxyIndex() {
        Molecule m = this.acid.buildMolecule();
        String symbols = "OSeSTe";
        int index = -1;
        for (int i = 0; i < m.getAtomCount(); ++i) {
            MolAtom atom = m.getAtom(i);
            if (symbols.indexOf(atom.getSymbol()) <= -1 || atom.getImplicitHcount() != 1) continue;
            MolAtom batom = atom.getBond(0).getOtherAtom(atom);
            if (batom.getBondCount() <= 3) {
                boolean canbeacid = true;
                boolean hasdoublebond = false;
                for (int j = 0; j < batom.getBondCount() && canbeacid; ++j) {
                    if (batom.getBond(j).getType() == 2) {
                        MolAtom oatom = batom.getBond(j).getOtherAtom(batom);
                        canbeacid = symbols.indexOf(oatom.getSymbol()) > -1;
                        hasdoublebond = true;
                        continue;
                    }
                    if (batom.getBond(j).getType() == 1) continue;
                    canbeacid = false;
                }
                if ((canbeacid &= hasdoublebond) && !this.hydroxyAtoms.contains(i)) {
                    this.hydroxyAtoms.add(i);
                    return i;
                }
            }
            if (this.hydroxyAtoms.contains(i)) continue;
            index = i;
        }
        if (index > -1) {
            this.hydroxyAtoms.add(index);
        }
        return index;
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    protected String printValue() {
        return this.basics.get(0).printValue() + "\t" + this.acid.printValue();
    }

    @Override
    protected String toSmiles() {
        return this.getMolecule().toFormat("smiles");
    }

    @Override
    public boolean hasLocant(Locant loc) {
        return false;
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return false;
    }
}

