/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Ester;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.TertChain;
import java.util.ArrayList;

public class EsterGenerator {
    public static boolean isEster(Structure ester) {
        boolean valid = EsterGenerator.canBeEster(ester);
        boolean t1 = valid && EsterGenerator.fitsForTemplate1(ester);
        valid = Util.isAcid(ester);
        boolean t2 = valid && EsterGenerator.fitsForTemplate2(ester);
        return t1 || t2;
    }

    private static boolean fitsForTemplate1(Structure ester) {
        return ester.substituentCount() == 2 ? Util.isAcid(ester.getSubstituent(1)) : (ester.substituentCount() == 1 ? EsterGenerator.findAcidGroup(ester) != null : ester.substituentCount() > 0 && Util.isAcid(ester.getSubstituent(ester.substituentCount() - 1)));
    }

    private static boolean fitsForTemplate2(Structure acid) {
        boolean isEster = EsterGenerator.canBeEster(acid);
        int i = 0;
        while (!isEster & i < acid.substituentCount()) {
            isEster |= EsterGenerator.canBeEster(acid.getSubstituent(i));
            ++i;
        }
        return isEster;
    }

    private static Structure findAcidGroup(Structure ester) {
        for (int i = 0; i < ester.substituentCount(); ++i) {
            Structure s = ester.getSubstituent(i);
            if (s.isSpaceSeparated() && Util.isAcid(s)) {
                return s;
            }
            if ((s = EsterGenerator.findAcidGroup(s)) == null) continue;
            return s;
        }
        return null;
    }

    public static Ester createEster(Structure ester) {
        Ester esterGroup = null;
        if (EsterGenerator.fitsForTemplate1(ester)) {
            esterGroup = EsterGenerator.createEster1(ester);
        } else if (EsterGenerator.fitsForTemplate2(ester)) {
            esterGroup = EsterGenerator.createEster2(ester);
        }
        EsterGenerator.checkImplicitPolyAcid(esterGroup);
        return esterGroup;
    }

    private static void checkImplicitPolyAcid(Ester ester) {
        if (ester == null || !Util.isImplicitPolyAcid(ester.acid) || ester.basic == null || ester.basic.isExplicitSingle()) {
            return;
        }
        ester.basics.add(ester.basic.cloneStructure());
        ester.basic = null;
    }

    private static Ester createEster1(Structure ester) {
        int subscount = ester.substituentCount();
        if (subscount > 2) {
            Structure acid = ester.getSubstituent(subscount - 1);
            ArrayList<Structure> basics = new ArrayList<Structure>();
            for (int i = 0; i < subscount - 1; ++i) {
                basics.add(ester.getSubstituent(i));
            }
            Ester newEster = new Ester(acid, basics);
            newEster.addSuffix(ester.getSuffixList());
            return newEster;
        }
        if (ester.substituentCount() == 1) {
            Structure s = EsterGenerator.findAcidGroup(ester);
            s.parent.removeSubstituent(s);
            ester.addSubstituent(s);
        }
        Structure basic = null;
        Structure acid = null;
        if (ester.substituentCount() == 1) {
            basic = new SimpleStructure("[*] |$_R1$|", "RGroup");
            acid = ester.getSubstituent(0);
        } else {
            basic = ester.getSubstituent(0);
            acid = ester.getSubstituent(1);
        }
        Suffix radical = EsterGenerator.getRadical(basic);
        if (radical != null) {
            Locant l;
            if (radical.getLocant() != null && (l = radical.getLocant().getLocant(0)) != null) {
                acid.addLocant(l);
                radical.setLocant((LocantList)null);
            }
            basic.removeSuffix(radical);
        }
        Ester newEster = new Ester(acid, basic);
        newEster.addSuffix(ester.getSuffixList());
        return newEster;
    }

    private static Ester createEster2(Structure acid) {
        if (acid.substituentCount() == 0) {
            return null;
        }
        Structure ester = null;
        if (EsterGenerator.canBeEster(acid)) {
            ester = acid;
            for (int i = 0; i < ester.suffixCount(); ++i) {
                if (ester.getSuffix(i).getType() != 0) continue;
                String value = ester.getSuffix(i).getValue();
                String name = ester.getSuffix(i).getName();
                ester.removeSuffix(i);
                acid = new SimpleStructure(value, name);
            }
        } else {
            for (int i = 0; i < acid.substituentCount(); ++i) {
                if (ester == null && EsterGenerator.canBeEster(acid.getSubstituent(i))) {
                    ester = acid.getSubstituent(i);
                    acid.removeSubstituent(i);
                    --i;
                    continue;
                }
                if (ester == null) continue;
                ester.addSubstituent(acid.getSubstituent(i));
                acid.removeSubstituent(i);
                --i;
            }
        }
        ester.addSubstituent(acid);
        return EsterGenerator.createEster1(ester);
    }

    private static boolean canBeEster(Structure struc) {
        return struc instanceof SimpleStructure && ((SimpleStructure)struc).getName().equals("ester");
    }

    private static Suffix getRadical(Structure struc) {
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix s = struc.getSuffix(i);
            if (s.type != 2) continue;
            if (struc instanceof TertChain) {
                s.addLocant(new SimpleLocant(2, 0));
            }
            return s;
        }
        return null;
    }
}

