/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.NamingCentral;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.FusedLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.RingUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.VonBaeyerSystem;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class FusedSystem
extends Structure {
    Structure leftStructure;
    Structure rightStructure;
    LocantList numbering;
    int[] fusedAtoms;
    Molecule leftMolecule;
    Molecule rightMolecule;
    LocantList tmpLocants;
    ArrayList<Hydro> leftHydro;
    ArrayList<Hydro> rightHydro;
    private FusedSystem cloneMolForLocantCheck;

    public FusedSystem(Structure leftStructure, Structure rigthStructure, LocantList numbering) {
        this.leftStructure = leftStructure;
        this.rightStructure = rigthStructure;
        this.numbering = numbering;
        this.leftStructure.setParent(this);
        this.rightStructure.setParent(this);
        this.checkStructures();
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        Structure leftStructure = this.leftStructure.cloneStructure();
        Structure rightStructure = this.rightStructure.cloneStructure();
        LocantList numbering = this.cloneList(this.numbering);
        FusedSystem newStructure = new FusedSystem(leftStructure, rightStructure, numbering);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    private LocantList cloneList(LocantList orig) {
        LocantList clone = new LocantList();
        for (int i = 0; i < orig.size(); ++i) {
            FusedLocant fused = (FusedLocant)orig.getLocant(i);
            clone.addLocant(new FusedLocant(fused.getFirst(), fused.getSecond(), fused.getValue()));
        }
        return clone;
    }

    @Override
    protected Molecule getMol() {
        this.getSubstructureHydrogens(this.leftStructure);
        this.getSubstructureSubstituents(this.leftStructure);
        this.storeDefaultHydrogens();
        if (this.leftMolecule == null) {
            this.leftMolecule = this.leftStructure.buildMolecule();
        }
        if (this.rightMolecule == null) {
            this.rightMolecule = this.rightStructure.buildMolecule();
        }
        this.getFusedAtoms(0);
        Molecule molecule = this.createFusedSystem();
        for (int i = 1; i < this.numbering.size(); ++i) {
            this.getFusedAtoms(i);
            this.fuseAtoms(molecule);
        }
        int[] numbering = NamingCentral.getNumbering(molecule, true);
        this.setAtomMap(numbering);
        return molecule;
    }

    @Override
    protected Molecule buildMolecule() {
        if (this.molecule == null) {
            this.molecule = super.buildMolecule();
            this.restoreDefaultHydrogens(this.molecule);
            if (this.stereoDataNeedToAdd(this.leftStructure)) {
                this.addDefaultStereoData(this.leftMolecule);
            }
        }
        return this.molecule;
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    protected String printValue() {
        String left = this.leftStructure.printValue();
        String right = this.rightStructure.printValue();
        return left + " " + this.numbering + " " + right;
    }

    @Override
    protected String toSmiles() {
        return this.getMolecule().toFormat("smiles");
    }

    @Override
    public LocantList getLocantInParent() {
        if (this.locantInParent != null && this.locantInParent.size() > 1) {
            this.tmpLocants = this.locantInParent;
            this.locantInParent = new LocantList();
        }
        return super.getLocantInParent();
    }

    private int[] getFusedAtoms(char bondindex, Structure struc) {
        int index = bondindex - 97;
        IntVector atomLocants = this.getRelevantLocants(struc);
        int secondAtomIndex = index < atomLocants.size() - 1 ? index + 1 : 0;
        return new int[]{atomLocants.get(index), atomLocants.get(secondAtomIndex)};
    }

    private IntVector getRelevantLocants(Structure struc) {
        int i;
        if (struc instanceof FusedSystem) {
            return this.getRelevantLocantsOfFusedSystem((FusedSystem)struc);
        }
        ArrayList<Integer> locants = new ArrayList<Integer>();
        if (struc.atomMap.isEmpty()) {
            struc.buildAtomMap();
        }
        locants.addAll(struc.atomMap.keySet());
        IntVector atomlocants = new IntVector();
        for (i = 0; i < locants.size(); ++i) {
            int loc = (Integer)locants.get(i);
            if (loc >= 100 && loc % 100 != 1) continue;
            if (loc < 100) {
                loc *= 100;
            }
            atomlocants.add(loc);
        }
        atomlocants.sort();
        for (i = 0; i < atomlocants.size(); ++i) {
            if (atomlocants.get(i) % 100 != 0) continue;
            int index = atomlocants.get(i) / 100;
            atomlocants.remove(i);
            atomlocants.add(i, index);
        }
        return atomlocants;
    }

    private IntVector getRelevantLocantsOfFusedSystem(FusedSystem fused) {
        Structure left = fused.leftStructure;
        IntVector leftLocants = this.getRelevantLocants(left);
        IntVector fusedLocants = new IntVector();
        for (int i = 0; i < leftLocants.size(); ++i) {
            MolAtom atom = left.getMolecule().getAtom(left.getAtomIndex(leftLocants.get(i)));
            int aIndex = fused.getMappedIndex(fused.getMolecule().indexOf(atom));
            fusedLocants.add(aIndex);
        }
        return fusedLocants;
    }

    private Molecule createFusedSystem() {
        Molecule molecule = new Molecule();
        molecule.fuse(this.leftMolecule);
        molecule.fuse(this.rightMolecule);
        molecule.aromatize();
        MolAtom left1 = this.leftMolecule.getAtom(this.leftStructure.getAtomIndex(this.fusedAtoms[0]));
        MolAtom right1 = this.rightMolecule.getAtom(this.rightStructure.getAtomIndex(this.fusedAtoms[2]));
        MolAtom left2 = this.leftMolecule.getAtom(this.leftStructure.getAtomIndex(this.fusedAtoms[1]));
        MolAtom right2 = this.rightMolecule.getAtom(this.rightStructure.getAtomIndex(this.fusedAtoms[3]));
        if (!right1.isBoundTo(right2)) {
            throw new NameImportException("Invalid fused numbering: " + this.numbering);
        }
        molecule.removeBond(right1.getBondTo(right2));
        RingUtil.createSpiroConnection(molecule, left1, right1);
        RingUtil.createSpiroConnection(molecule, left2, right2);
        return molecule;
    }

    private void fuseAtoms(Molecule molecule) {
        MolAtom left = this.leftMolecule.getAtom(this.leftStructure.getAtomIndex(this.fusedAtoms[1]));
        MolAtom right = this.rightMolecule.getAtom(this.rightStructure.getAtomIndex(this.fusedAtoms[3]));
        RingUtil.createSpiroConnection(molecule, left, right);
    }

    private void getFusedAtoms(int index) {
        FusedLocant numbering = (FusedLocant)this.numbering.getLocant(index);
        this.fusedAtoms = new int[4];
        this.fusedAtoms[0] = numbering.getFirst();
        this.fusedAtoms[1] = numbering.getSecond();
        int[] fa = this.getFusedAtoms((char)numbering.getValue(), this.rightStructure);
        this.fusedAtoms[2] = fa[0];
        this.fusedAtoms[3] = fa[1];
    }

    private void setAtomMap(int[] numbering) {
        if (numbering == null) {
            this.atomMap = null;
            return;
        }
        this.atomMap.clear();
        for (int i = 0; i < numbering.length; ++i) {
            numbering[i] = this.getLocant(numbering[i]);
            this.atomMap.put(new Integer(numbering[i]), new Integer(i));
        }
    }

    private int getLocant(int number) {
        if (number > 100) {
            int letter = number / 100 % 10;
            int index = number / 10000;
            if (letter == 0) {
                index /= 100;
            }
            return index + letter;
        }
        return number;
    }

    private void checkStructures() {
        if (this.leftStructure instanceof FusedSystem || this.rightStructure instanceof FusedSystem) {
            throw new NameImportException("More than one fusion in a name is not supported.");
        }
        if (this.leftStructure instanceof VonBaeyerSystem) {
            this.toAromatic((VonBaeyerSystem)this.leftStructure);
        } else if (this.leftStructure instanceof SimpleStructure) {
            this.prepareChromene((SimpleStructure)this.leftStructure);
        }
        if (this.rightStructure instanceof VonBaeyerSystem) {
            this.toAromatic((VonBaeyerSystem)this.rightStructure);
        } else if (this.rightStructure instanceof SimpleStructure) {
            this.prepareChromene((SimpleStructure)this.rightStructure);
        }
        if (this.leftStructure.getLocantInParent() != null && this.getLocantInParent() == null) {
            if (this.leftStructure.getLocantInParent().size() == 1) {
                this.locantInParent = this.leftStructure.locantInParent;
                this.leftStructure.locantInParent = new LocantList();
            }
            this.nonStdValence.tryAddLocant(this.leftStructure.nonStdValence);
            this.leftStructure.nonStdValence = new LocantList();
        }
    }

    private void getSubstructureHydrogens(Structure substruc) {
        int defHsize;
        int count = substruc.hydroCount();
        for (int i = defHsize = substruc.defaultHydro == null ? 0 : substruc.defaultHydro.size(); i < count; ++i) {
            Hydro hydro = substruc.getHydro(0);
            this.addHydro(hydro);
            substruc.removeHydro(0);
        }
    }

    private void getSubstructureSubstituents(Structure substruc) {
        boolean useLocant = false;
        for (int i = 0; i < substruc.substituentCount(); ++i) {
            Structure ligand = substruc.getSubstituent(i);
            if (Util.isHetero(ligand)) continue;
            this.addSubstituent(ligand);
            ligand.parent = this;
            substruc.removeSubstituent(i);
            if (ligand.getLocantInParent() == null) {
                if (this.tmpLocants != null && this.tmpLocants.size() > 0) {
                    ligand.setLocantInParent(this.tmpLocants.getLocant(0));
                    this.tmpLocants.removeLocant(0);
                    useLocant = true;
                } else if (this.getLocantInParent() != null && !useLocant) {
                    ligand.setLocantInParent(this.getLocantInParent().getLocant(0));
                    this.removeLocant(0);
                }
                if (this.getParent() instanceof Amine && ligand.getLocantInParent() != null && ligand.getLocantInParent().getLocant(0) instanceof AzaLocant) {
                    this.getParent().addSubstituent(ligand);
                    ligand.parent = this.getParent();
                    this.removeSubstituent(ligand);
                }
            }
            --i;
        }
    }

    private void toAromatic(VonBaeyerSystem struc) {
        if (struc.getNumbering().size() == 1) {
            struc.setAromatic(true);
        }
    }

    private void prepareChromene(SimpleStructure struc) {
        if (struc.getName().startsWith("chromen")) {
            if (struc.defaultHydro == null) {
                struc.defaultHydro = new ArrayList();
            }
            struc.defaultHydro.add(new Hydro(1));
            struc.parent = this;
        }
    }

    private void storeDefaultHydrogens() {
        if (this.hydroList != null && this.hydroList.size() > 0) {
            if (this.needToDeleteHydrogens(this.leftStructure)) {
                this.leftStructure.defaultHydro = null;
            }
            return;
        }
        this.leftHydro = this.leftStructure.defaultHydro;
        this.rightHydro = this.rightStructure.defaultHydro;
        this.leftStructure.defaultHydro = null;
        this.rightStructure.defaultHydro = null;
    }

    private boolean needToDeleteHydrogens(Structure struc) {
        return struc instanceof SimpleStructure && (((SimpleStructure)struc).getName().startsWith("inden") || ((SimpleStructure)struc).getName().startsWith("pyrazol"));
    }

    private void restoreDefaultHydrogens(Molecule mol) {
        this.restoreDefaultHydrogens(this.leftStructure, this.leftHydro, mol);
        this.restoreDefaultHydrogens(this.rightStructure, this.rightHydro, mol);
    }

    private void restoreDefaultHydrogens(Structure struc, ArrayList<Hydro> hydrogens, Molecule mol) {
        if (struc.getMolecule().dearomatize() || hydrogens == null) {
            return;
        }
        ArrayList<MolAtom> atomList = new ArrayList<MolAtom>();
        for (int i = 0; i < hydrogens.size(); ++i) {
            SimpleLocant locant = hydrogens.get(i).getLocant();
            MolAtom atom = struc.getMolecule().getAtom(struc.getAtomIndex(locant.getValue(), locant.getParent()));
            atomList.add(atom);
        }
        struc.removeFalseAromaticBonds(atomList);
    }

    private boolean stereoDataNeedToAdd(Structure struc) {
        if (!(struc instanceof VonBaeyerSystem)) {
            return false;
        }
        if (!((VonBaeyerSystem)struc).aromatic) {
            return false;
        }
        int atomCount = struc.molecule == null ? 0 : struc.molecule.getAtomCount();
        return (atomCount - 2) % 4 != 0;
    }

    private void addDefaultStereoData(Molecule molecule) {
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            MolBond bond = molecule.getBond(i);
            if (bond.getType() != 2 || bond.calcStereo2() != 128) continue;
            MolAtom atom2 = bond.getAtom1();
            MolAtom atom3 = bond.getAtom2();
            int bondindex1 = atom2.getBond(0) == bond ? 1 : 0;
            int bondindex2 = atom3.getBond(0) == bond ? 1 : 0;
            MolAtom atom1 = atom2.getBond(bondindex1).getOtherAtom(atom2);
            MolAtom atom4 = atom3.getBond(bondindex2).getOtherAtom(atom3);
            bond.setStereo2Flags(atom1, atom4, 128);
        }
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        if (this.molecule != null) {
            return this.atomMap.containsKey(Util.locantToInt(loc));
        }
        if (this.cloneMolForLocantCheck == null) {
            this.cloneMolForLocantCheck = (FusedSystem)this.cloneStructure();
            this.cloneMolForLocantCheck.getMol();
        }
        return this.cloneMolForLocantCheck.atomMap.containsKey(Util.locantToInt(loc));
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.leftStructure.hasAtom(atomSymbol) || this.rightStructure.hasAtom(atomSymbol) || this.getHeteroAtomCountOf(atomSymbol) > 0;
    }

    @Override
    protected boolean canSetHydrogenCount(Molecule mol, IntVector atomIndexes, int Hcount) {
        return true;
    }

    public boolean hasSubSystem(Structure struc) {
        if (struc == null) {
            return false;
        }
        return struc.equals(this.leftStructure) || struc.equals(this.rightStructure);
    }
}

