/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.EndingToken;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.ParserUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class HantzschWidmanSystem
extends Structure {
    private int ringSize;
    private boolean aromatic;
    private ArrayList<Structure> heteroAtoms = new ArrayList();
    private static final int SixC = -2;

    public HantzschWidmanSystem(int ringSize, ArrayList<Structure> heteroAtoms, boolean aromatic) {
        this.ringSize = ringSize == -2 ? 6 : ringSize;
        this.aromatic = aromatic;
        this.heteroAtoms.addAll(heteroAtoms);
        boolean isCorrectName = this.ringSize != 6;
        for (int i = 0; i < heteroAtoms.size(); ++i) {
            SimpleStructure smi = (SimpleStructure)heteroAtoms.get(i);
            HeteroAtom atom = new HeteroAtom(smi.getValue());
            isCorrectName |= this.endingCheck(atom, ringSize, aromatic, smi.getName());
            if (smi.nonStdValence != null && smi.nonStdValence.size() > 0) {
                atom.nonStdValence.tryAddLocant(smi.nonStdValence.getLocant(0));
            }
            atom.setLocantInParent(smi.getLocantInParent().getLocant(0));
            this.substituentList.add(atom);
        }
        if (!isCorrectName) {
            throw new NameImportException("Invalid Hantzsch-Widman structure name.");
        }
    }

    protected boolean endingCheck(HeteroAtom atom, int ringSize, boolean aromatic, String name) {
        if (name.equals("phosphor")) {
            return true;
        }
        if (!aromatic || Util.isNitrogen(atom.getMolecule().getAtom(0)) || ringSize != 6 && ringSize != -2) {
            return true;
        }
        return ringSize != -2 ^ ParserUtil.is6CAtom(atom.getMolecule().getAtom(0));
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        ArrayList<Structure> list = new ArrayList<Structure>();
        for (int i = 0; i < this.heteroAtoms.size(); ++i) {
            list.add(this.heteroAtoms.get(i).cloneStructure());
        }
        HantzschWidmanSystem newStructure = new HantzschWidmanSystem(this.ringSize, list, this.aromatic);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        return this.readMol(this.toSmiles());
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    protected String printValue() {
        return this.toSmiles();
    }

    @Override
    protected String toSmiles() {
        String smi = "C1";
        for (int i = 0; i < this.ringSize - 2; ++i) {
            smi = smi + "C";
        }
        smi = smi + "C1";
        if (this.aromatic) {
            smi = smi.toLowerCase();
        }
        return smi;
    }

    public static boolean isHantzschWidmanSuffix(EndingToken token) {
        return HantzschWidmanSystem.getRingSize(token) != -1 && HantzschWidmanSystem.isAromatic(token) != null;
    }

    public static int getRingSize(EndingToken s) {
        if (s.getName().startsWith("ir")) {
            return 3;
        }
        if (s.getName().startsWith("et")) {
            return 4;
        }
        if (s.getName().startsWith("ol")) {
            return 5;
        }
        if (s.getName().startsWith("inin")) {
            return -2;
        }
        if (s.getName().startsWith("in") || s.equalsName("ane")) {
            return 6;
        }
        if (s.getName().startsWith("ep")) {
            return 7;
        }
        if (s.getName().startsWith("oc")) {
            return 8;
        }
        if (s.getName().startsWith("on")) {
            return 9;
        }
        if (s.getName().startsWith("ec")) {
            return 10;
        }
        return -1;
    }

    public static Boolean isAromatic(EndingToken s) {
        String name = s.getName();
        if (name.endsWith("ane") || name.endsWith("an") || name.endsWith("idine") || name.endsWith("idin")) {
            return false;
        }
        if (name.endsWith("ine") || name.endsWith("in") || s.equalsName("irene") || s.equalsName("ete") || s.equalsName("ole")) {
            return true;
        }
        return null;
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        return this.ringSize >= Util.locantToInt(loc);
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.getHeteroAtomCountOf(atomSymbol) > 0;
    }

    @Override
    protected boolean fixBySpecificRules() {
        if (!this.aromatic || this.molecule == null) {
            return false;
        }
        for (int i = 0; i < this.ringSize; ++i) {
            MolAtom atom = this.molecule.getAtom(i);
            if (atom.hasAromaticBond()) {
                if (!this.tryDearomatize(atom, this.molecule)) continue;
                for (int j = 0; j < atom.getBondCount(); ++j) {
                    if (atom.getBond(j).getType() != 4) continue;
                    atom.getBond(j).setType(1);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

