/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

public class Hydrazone
extends SimpleStructure {
    public Hydrazone(String value, String name, LocantList locants) {
        super(value, name, locants);
    }

    @Override
    protected void addLigands() {
        int index = -1;
        Structure struc = null;
        for (int i = 0; i < this.substituentCount(); ++i) {
            struc = this.getSubstituent(i);
            if (!struc.isSpaceSeparated()) continue;
            Molecule ligand = struc.getMolecule();
            if (struc.hasLocant() || (index = this.getCarbonWithOxy(ligand)) < 0) continue;
            this.molecule.fuse(ligand);
            this.molecule.add(new MolBond(this.molecule.getAtom(0), ligand.getAtom(index), 2));
            this.removeSubstituent(i);
            break;
        }
        super.addLigands();
        if (index > -1) {
            this.addSubstituent(struc);
        }
    }

    private int getCarbonWithOxy(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            MolAtom otherAtom = atom.getBond(0).getOtherAtom(atom);
            if (atom.getAtno() != 8 || atom.getBondCount() != 1 || atom.getBond(0).getType() != 2 || otherAtom.getAtno() != 6) continue;
            atom.setAliasstr("toremove");
            return mol.indexOf(otherAtom);
        }
        return -1;
    }
}

