/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BondNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Bridge;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroChain;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class LocantCalculator {
    Structure structure;
    int basicAtomCount = 0;
    IntVector possiblePlaces = new IntVector();
    int[] reservedPlaces;
    int createdLocants = 0;
    boolean initialized = false;

    private void init() {
        if (this.initialized && this.basicAtomCount == 0) {
            return;
        }
        this.initialized = true;
        this.basicAtomCount = this.structure.molecule != null ? this.structure.basicAtomCount : (!this.structure.atomMap.isEmpty() ? this.structure.atomMap.size() : (this.structure instanceof SimpleStructure ? Util.atomCount(((SimpleStructure)this.structure).getValue()) : 0));
    }

    protected LocantCalculator(Structure struc) {
        this.structure = struc;
    }

    private void initReservedPlaces(boolean forLigand) {
        if (this.reservedPlaces == null) {
            IntVector vec = new IntVector();
            this.structure.getAtomNumbers(vec);
            vec.sort();
            if (vec.size() > 0) {
                this.reservedPlaces = new int[vec.get(vec.size() - 1) + 1];
            }
            if (!forLigand) {
                return;
            }
            this.addPriorToRGoups();
            if (this.structure.molecule != null && !this.structure.suffixList.isEmpty()) {
                for (int i = 0; i < this.structure.suffixCount(); ++i) {
                    boolean isTerminal;
                    Locant l;
                    Suffix s = this.structure.suffixList.get(i);
                    Locant locant = l = !s.hasLocant() ? new SimpleLocant(1, 0) : s.getLocant().getLocant(0);
                    boolean bl = s.hasLocant() ? this.isTerminalAtom(this.structure.molecule, this.structure.getAtomIndex(l.getValue())) || l.getValue() == 1 : (isTerminal = true);
                    if (this.structure.getParent() == null || l == null || l.getValue() >= this.reservedPlaces.length || !s.getValue().startsWith("|") || s.getValue().length() <= 1 && !isTerminal) continue;
                    int n = l.getValue();
                    this.reservedPlaces[n] = this.reservedPlaces[n] + 1;
                }
            }
        }
    }

    private boolean isTerminalAtom(Molecule mol, int atomIndex) {
        if (mol == null || mol.getAtomCount() <= atomIndex) {
            return false;
        }
        MolAtom atom = mol.getAtom(atomIndex);
        return atom.isTerminalAtom();
    }

    private void addPriorToRGoups() {
        if (this.structure.rgroups.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.structure.rgroups.size(); ++i) {
            int index = this.structure.rgroups.get(i).getNeighbour(0);
            if (index <= 0 || this.reservedPlaces.length <= index) continue;
            int n = index;
            this.reservedPlaces[n] = this.reservedPlaces[n] - 1;
        }
    }

    private void initReservedPlaces() {
        this.initReservedPlaces(false);
    }

    private void ignorePlaces(String name) {
        if (name == null) {
            return;
        }
        if (name.equals("on") && this.isChain()) {
            this.reservedPlaces[1] = this.reservedPlaces[1] + 10;
            int n = this.basicAtomCount;
            this.reservedPlaces[n] = this.reservedPlaces[n] + 10;
        }
    }

    private void reserve(int locant, int radical) {
        this.initReservedPlaces();
        if (this.reservedPlaces != null && this.reservedPlaces.length > locant) {
            if (radical > 0) {
                int n = locant;
                this.reservedPlaces[n] = this.reservedPlaces[n] + radical;
            } else {
                int n = locant;
                this.reservedPlaces[n] = this.reservedPlaces[n] + 10;
            }
        }
    }

    protected void calcLocantsForLigands(ArrayList<Structure> ligands) {
        if (ligands.isEmpty()) {
            return;
        }
        this.init();
        this.initReservedPlaces(true);
        int i = 0;
        int first = 0;
        while (i < ligands.size()) {
            ArrayList<Structure> structures = new ArrayList<Structure>();
            Structure struc = ligands.get(i++);
            structures.add(struc);
            while (i < ligands.size() && !(ligands.get(i) instanceof Bridge) && (ligands.get(i).isCloneOf(struc) || structures.get(0).isSpaceSeparated() && ligands.get(i).isSpaceSeparated())) {
                structures.add(ligands.get(i++));
            }
            this.calcLocantForMultiLigand(structures);
            this.createdLocants += structures.size();
            if (!(struc instanceof Bridge)) continue;
            i -= ++first % 2;
        }
        this.possiblePlaces.clear();
        this.reservedPlaces = null;
    }

    protected void calcLocantForSuffixes(Suffix suffix) {
        boolean isBond;
        this.init();
        this.initReservedPlaces();
        this.ignorePlaces(suffix.getName());
        suffix.setLocantCalculated(true);
        int radical = suffix.getRadicalMultiplicity();
        int multiplicity = suffix.getMultiplicity() - suffix.getLocantCount();
        ArrayList<Locant> locants = new ArrayList<Locant>();
        boolean isMultiBond = suffix.getValue().equals("=") || suffix.getValue().equals("#");
        boolean isUnambiguous = true;
        boolean isCharge = suffix.getValue().matches("[+|-]h[+|-]");
        boolean bl = isBond = !isCharge;
        if (!isMultiBond && suffix.getType() != 2 && suffix.getType() != 7) {
            this.addPriorToRGoups();
        }
        if (!isMultiBond && this.isChain()) {
            isUnambiguous = this.calcLocantsForChain(suffix, radical, isBond);
        } else if (this.isSingleSuffixAndHasConnectionPoint(suffix)) {
            suffix.addLocant(this.structure.connectionPoint.getLocant().getLocant(0));
        } else {
            isUnambiguous = this.calculateLocants(locants, radical, multiplicity, suffix.isSpaceSeparated(), isBond, isMultiBond, false, isCharge);
            for (int i = 0; i < locants.size(); ++i) {
                suffix.addLocant(locants.get(i));
            }
        }
        if (!isUnambiguous) {
            // empty if block
        }
        this.possiblePlaces.clear();
        this.reservedPlaces = null;
        this.createdLocants += multiplicity;
    }

    private boolean isSingleSuffixAndHasConnectionPoint(Suffix suffix) {
        return suffix.getType() == -1 && suffix.getMultiplicity() == 1 && this.structure.hasConnectionPoint() && this.structure.isConnectionPointDefaultForSuffix;
    }

    private boolean calculateLocants(ArrayList<Locant> locants, int radical, int multiplicity, boolean spaceSep, boolean isRealBond, boolean isMultiBond, boolean bridge, boolean isHeteroOrCharge) {
        int size;
        boolean isUnAmbigous = true;
        if (spaceSep && !this.structure.spaceAttach.isEmpty()) {
            int parent = this.structure.calcParentIndex();
            for (int i = 0; i < multiplicity; ++i) {
                IntVector vec = this.structure.spaceAttach;
                locants.add(new SimpleLocant(vec.get(i % vec.size()), parent));
            }
            return true;
        }
        this.possiblePlaces = this.processFreePlacesWithMultiplicity(radical, isRealBond, isMultiBond, isHeteroOrCharge);
        if (this.possiblePlaces.isEmpty()) {
            throw new NameImportException("Cannot calculate ligands.");
        }
        if (this.possiblePlaces.size() == 1) {
            isMultiBond = false;
        }
        int n = size = isMultiBond ? this.possiblePlaces.size() / 2 : this.possiblePlaces.size();
        if (size == multiplicity) {
            if (isMultiBond) {
                for (int i = 0; i < multiplicity; ++i) {
                    int atom1 = this.possiblePlaces.remove(0);
                    int atom2 = this.possiblePlaces.remove(0);
                    locants.add(new BondNumber(new SimpleLocant(atom1, 0), new SimpleLocant(atom2, 0)));
                    this.reserve(atom1, radical);
                    this.reserve(atom2, radical);
                }
            } else {
                for (int i = 0; i < multiplicity; ++i) {
                    int locant = this.possiblePlaces.remove(0);
                    locants.add(new SimpleLocant(locant, 0));
                    this.reserve(locant, radical);
                }
            }
        } else if (size > multiplicity) {
            if (!isMultiBond && !bridge && this.calcAsChain(this.possiblePlaces, multiplicity)) {
                if (multiplicity > 1) {
                    locants.add(new SimpleLocant(1, 0));
                    this.reserve(1, radical);
                }
                locants.add(new SimpleLocant(this.basicAtomCount, 0));
                this.reserve(this.basicAtomCount, radical);
                for (int i = 1; i < multiplicity - 1; ++i) {
                    locants.add(new SimpleLocant(i % this.basicAtomCount + 1, 0));
                    this.reserve(i % this.basicAtomCount + 1, radical);
                }
                this.possiblePlaces.clear();
            } else {
                int i;
                int[] pgrinv = this.getGraphInvariantsOfPossibleFreePlaces(this.possiblePlaces);
                int def = pgrinv[0];
                for (i = 1; i < pgrinv.length; ++i) {
                    if (def == pgrinv[i]) continue;
                    isUnAmbigous = false;
                    break;
                }
                if (isMultiBond) {
                    int atom1 = this.possiblePlaces.remove(0);
                    int atom2 = this.possiblePlaces.remove(0);
                    locants.add(new BondNumber(new SimpleLocant(atom1, 0), new SimpleLocant(atom2, 0)));
                    this.reserve(atom1, radical);
                    this.reserve(atom2, radical);
                } else {
                    for (i = 0; i < multiplicity; ++i) {
                        int locant = this.possiblePlaces.remove(0);
                        locants.add(new SimpleLocant(locant, 0));
                        this.reserve(locant, bridge ? -1 : radical);
                    }
                }
            }
        } else {
            int count = size;
            if (isMultiBond) {
                for (int i = 0; i < multiplicity; ++i) {
                    int atom1 = this.possiblePlaces.get(i++ % count);
                    int atom2 = this.possiblePlaces.get(i % count);
                    locants.add(new BondNumber(new SimpleLocant(atom1, 0), new SimpleLocant(atom2, 0)));
                    this.reserve(atom1, radical);
                    this.reserve(atom2, radical);
                }
            } else {
                for (int i = 0; i < multiplicity; ++i) {
                    int locant = this.possiblePlaces.get(i % count);
                    locants.add(new SimpleLocant(locant, 0));
                    this.reserve(locant, radical);
                }
            }
            this.possiblePlaces.clear();
        }
        return isUnAmbigous;
    }

    private void calcLocantForMultiLigand(ArrayList<Structure> structures) {
        Structure struc = structures.get(0);
        int multiplicity = structures.size();
        int radical = struc.getRadicalMultiplicity();
        ArrayList<Locant> locants = new ArrayList<Locant>();
        boolean isHetero = Util.isHetero(struc);
        boolean isUnambiguous = this.calculateLocants(locants, radical, multiplicity, struc.isSpaceSeparated(), true, false, struc instanceof Bridge, isHetero);
        this.addLocants(locants, structures, struc instanceof HeteroAtom || !isHetero);
        if (!isUnambiguous) {
            // empty if block
        }
    }

    private void addLocants(ArrayList<Locant> locants, ArrayList<Structure> structures, boolean isdefault) {
        if (isdefault || this.structure.molecule == null) {
            for (int i = 0; i < locants.size(); ++i) {
                Structure s = structures.get(i);
                s.addLocant(locants.get(i));
                s.setLocantCalculated(true);
            }
        } else {
            int sind = 0;
            for (int i = 0; i < locants.size() && sind < structures.size(); ++i) {
                int index = this.structure.getAtomIndex(locants.get(i).getValue());
                MolAtom atom = this.structure.molecule.getAtom(index);
                for (int j = 0; j < atom.getBondCount(); ++j) {
                    if (!Util.isOxygen(atom.getBond(j).getOtherAtom(atom)) || sind >= structures.size()) continue;
                    Structure s = structures.get(sind++);
                    s.addLocant(locants.get(i));
                    s.setLocantCalculated(true);
                }
            }
        }
    }

    private IntVector processFreePlacesWithMultiplicity(int radical, boolean isBond, boolean isMultiBond, boolean isHeteroOrCharge) {
        int index;
        IntVector atomIndexes = new IntVector();
        IntVector mul = new IntVector();
        IntVector atomnumbers = new IntVector();
        if (isHeteroOrCharge) {
            this.structure.getAtomNumbersForHeteroAtom(atomnumbers);
        } else {
            this.structure.getAtomNumbers(atomnumbers, radical);
        }
        int rgroupcount = 0;
        for (int i = 0; i < atomnumbers.size(); ++i) {
            int impH;
            int resval;
            index = atomnumbers.get(i);
            int n = resval = index < this.reservedPlaces.length ? this.reservedPlaces[index] : 0;
            if (resval < 0) {
                atomIndexes.add(rgroupcount, index);
                mul.add(rgroupcount++, -resval);
                continue;
            }
            int n2 = this.structure.molecule == null ? 0 : (impH = this.structure.ImplicitHCount(0, index) - resval + (isMultiBond ? 1 : 0));
            if (impH == 0 && resval >= 10) {
                impH = -1;
            }
            if (isHeteroOrCharge) {
                impH = 1;
            }
            if (!this.canAttach(index, radical, isBond, false, impH)) continue;
            atomIndexes.add(index);
            mul.add(radical > 0 && !isMultiBond ? Math.max(impH / radical, 1) : 1);
        }
        if (atomIndexes.isEmpty()) {
            atomIndexes.add(atomnumbers.isEmpty() ? 1 : atomnumbers.get(0));
            mul.add(1);
        }
        IntVector vec = this.calcMultiPlaces(atomIndexes, mul);
        if (!isMultiBond) {
            return vec;
        }
        atomIndexes = new IntVector();
        for (int i = 0; i < vec.size() - 1; ++i) {
            if (vec.get(i) == vec.get(i + 1) - 1) {
                atomIndexes.add(vec.get(i));
                atomIndexes.add(vec.get(i + 1));
                vec.remove(i + 1);
                continue;
            }
            index = this.getOtherAtomOfBond(vec, i);
            if (index <= 0) continue;
            atomIndexes.add(vec.get(i));
            atomIndexes.add(vec.get(index));
            vec.remove(index);
        }
        if (atomIndexes.isEmpty()) {
            atomIndexes.add(1);
        }
        return atomIndexes;
    }

    private int getOtherAtomOfBond(IntVector vec, int index) {
        if (this.structure.molecule == null) {
            return -1;
        }
        int atomIndex = vec.get(index);
        MolAtom atom = this.structure.molecule.getAtom(this.structure.getAtomIndex(atomIndex));
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolAtom atom2 = atom.getBond(i).getOtherAtom(atom);
            int atomIndex2 = this.structure.getMappedIndex(this.structure.getMolecule().indexOf(atom2));
            if (vec.indexOf(atomIndex2) <= index) continue;
            return vec.indexOf(atomIndex2);
        }
        return -1;
    }

    private boolean canAttach(int index, int radical, boolean isBond, boolean spaceAttach, int impH) {
        if (isBond && this.structure.noAttach.contains(index) && (!spaceAttach || !this.structure.spaceAttach.contains(index))) {
            return false;
        }
        if (radical == 0) {
            return this.reservedPlaces[index] == 0;
        }
        if (radical < 0) {
            return true;
        }
        if (this.structure.molecule == null) {
            return this.reservedPlaces[index] < 10;
        }
        return impH >= radical;
    }

    private int[] getGraphInvariantsOfPossibleFreePlaces(IntVector possiblePlaces) {
        if (this.structure.molecule == null) {
            return new int[possiblePlaces.size()];
        }
        int[] pgrinv = new int[possiblePlaces.size()];
        int[] grinv = new int[this.structure.molecule.getAtomCount()];
        this.structure.molecule.getGrinv(grinv);
        for (int i = 0; i < possiblePlaces.size(); ++i) {
            pgrinv[i] = grinv[this.structure.getAtomIndex(possiblePlaces.get(i))];
        }
        return pgrinv;
    }

    private IntVector calcMultiPlaces(IntVector places, IntVector mul) {
        IntVector vec = new IntVector();
        for (int i = 0; i < places.size(); ++i) {
            for (int j = 0; j < mul.get(i); ++j) {
                vec.add(places.get(i));
            }
        }
        return vec;
    }

    private boolean isChain() {
        boolean isHeteroChain = this.structure instanceof HeteroChain;
        String smi = this.structure instanceof SimpleStructure ? ((SimpleStructure)this.structure).getValue() : "";
        boolean isChain = isHeteroChain || Util.isCharbonChain(smi);
        int atomCount = isChain ? Util.atomCount(smi) : 0;
        return isChain && atomCount > 1;
    }

    private boolean calcAsChain(IntVector places, int mul) {
        if (!this.isChain() || !places.contains(this.basicAtomCount) || mul < 1) {
            return false;
        }
        if (mul < 2) {
            return true;
        }
        for (int i = 0; i < this.structure.suffixCount(); ++i) {
            Suffix s = this.structure.getSuffix(i);
            if (!s.getLocant().contains(new SimpleLocant(1, 0)) || !s.getName().endsWith("oic acid")) continue;
            Structure s1 = this.structure.substituentCount() > 0 ? this.structure.getSubstituent(0) : null;
            Structure s2 = this.structure.substituentCount() > 1 ? this.structure.getSubstituent(1) : null;
            return Util.canBeBasic(s1, s2) || s2 == null && s1 != null && s1.substituentCount() == 0;
        }
        return true;
    }

    protected boolean calcLocantsForChain(Suffix suffix, int radical, boolean isBond) {
        int index;
        IntVector vec = this.processFreePlacesWithMultiplicity(radical, isBond, false, false);
        LocantList ll = new LocantList();
        if (suffix.getMultiplicity() == 1 && this.createdLocants > 0 && suffix.getType() != 2 && (index = this.getFreeEndOfTheChain(vec, suffix)) > -1) {
            SimpleLocant loc = new SimpleLocant(index, 0);
            ll.tryAddLocant(loc);
        } else {
            for (int i = 0; !vec.isEmpty() && i < suffix.getMultiplicity(); i += 2) {
                SimpleLocant loc = new SimpleLocant(vec.remove(0), 0);
                ll.tryAddLocant(loc);
                if (vec.isEmpty() || i >= suffix.getMultiplicity() - 1) continue;
                loc = new SimpleLocant(vec.removeLast(), 0);
                ll.tryAddLocant(loc);
            }
        }
        if (suffix.getName().equals("on")) {
            if (this.basicAtomCount == 2 && suffix.getMultiplicity() > 1) {
                ll.addLocant(new SimpleLocant(2, 0));
            }
            if (ll.size() < suffix.getMultiplicity()) {
                throw new NameImportException("Cannot place ligand: \"one\"");
            }
        }
        suffix.setLocant(ll);
        return vec.size() == suffix.getMultiplicity();
    }

    private int getFreeEndOfTheChain(IntVector vec, Suffix suffix) {
        MolAtom atom;
        if (vec.contains(1) && !this.hasConnectionPointOn(this.structure, 1, suffix) && (atom = this.structure.getMolecule().getAtom(this.structure.getAtomIndex(1))) != null && atom.getBondCount() == 1) {
            return 1;
        }
        int index = this.basicAtomCount;
        if (vec.contains(index) && (atom = this.structure.getMolecule().getAtom(this.structure.getAtomIndex(index))) != null && atom.getBondCount() == 1) {
            return this.basicAtomCount;
        }
        return -1;
    }

    private boolean hasConnectionPointOn(Structure struc, int index, Suffix suffix) {
        if (struc.getParent() == null) {
            return false;
        }
        if (suffix.getType() == 2 || suffix.getType() == 5 || suffix.getType() == 1) {
            return false;
        }
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix s = struc.getSuffix(i);
            if (s.getType() != 2) continue;
            return s.getLocant().getLocant(0).getValue() == index;
        }
        return index == 1;
    }
}

