/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class Molecular
extends Structure {
    Structure atom;

    public Molecular(Structure atom) {
        this.atom = atom;
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        Molecular newStructure = new Molecular(this.atom.cloneStructure());
        this.cloneProperties(newStructure);
        return null;
    }

    @Override
    protected Molecule getMol() {
        Molecule m = this.atom.buildMolecule();
        int mul = 1;
        if (m.getAtom(0).getImplicitHcount() == 2) {
            mul = 2;
        } else if (m.getAtom(0).getImplicitHcount() == 3) {
            mul = 3;
        }
        Molecule molecule = m.cloneMolecule();
        molecule.fuse(m);
        molecule.add(new MolBond(molecule.getAtom(0), m.getAtom(0), mul));
        return molecule;
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    protected String printValue() {
        return this.atom.printValue();
    }

    @Override
    protected String toSmiles() {
        return this.getMolecule().toFormat("smiles");
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        return Util.locantToInt(loc) == 1;
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return ((SimpleStructure)this.atom).getValue().indexOf(atomSymbol) > -1;
    }
}

