/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BondNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.ComplexLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.RingUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Iterator;

public class MultipliedSpiroSystem
extends Structure {
    protected Structure structure;
    protected LocantList locants;
    protected ArrayList<Molecule> moleculeList = new ArrayList();

    public MultipliedSpiroSystem(Structure structure, LocantList complexLocants) {
        this.structure = structure;
        this.structure.setParent(this);
        this.locants = complexLocants;
    }

    public MultipliedSpiroSystem(Structure structure, ArrayList<ComplexLocant> complexLocants) {
        this.structure = structure;
        this.structure.setParent(this);
        this.locants = new LocantList();
        Iterator<ComplexLocant> iter = complexLocants.iterator();
        while (iter.hasNext()) {
            this.locants.tryAddLocant(iter.next());
        }
    }

    public Structure getStructure() {
        return this.structure;
    }

    public LocantList locants() {
        return this.locants;
    }

    @Override
    protected String printValue() {
        String loc = this.locants == null ? "" : this.locants.toString();
        return loc + "\t" + this.structure.printValue();
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        MultipliedSpiroSystem newStructure = new MultipliedSpiroSystem(this.structure, this.locants);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        Molecule mol = new Molecule();
        Molecule basic = this.structure.buildMolecule();
        this.moleculeList = new ArrayList();
        if (this.locants.getType() == 2) {
            int i;
            for (i = 0; i < this.locants.size(); ++i) {
                this.moleculeList.add(basic.cloneMolecule());
            }
            this.addLigands();
            for (i = 0; i < this.locants.size(); ++i) {
                mol.fuse(this.moleculeList.get(i));
            }
            this.connectWithSimpleLocant(mol);
        } else if (this.locants.getType() == 3) {
            int i;
            for (i = 0; i < RingUtil.getMaxParent(this.locants) + 1; ++i) {
                this.moleculeList.add(basic.cloneMolecule());
            }
            this.connectSuffixes();
            this.connectLigands();
            for (i = 0; i < RingUtil.getMaxParent(this.locants) + 1; ++i) {
                mol.fuse(this.moleculeList.get(i));
            }
            this.connectWithComplexLocant(mol);
        } else {
            throw new NameImportException("Invalid numbering: " + this.locants);
        }
        return mol;
    }

    @Override
    protected void addLigands() {
        int all = -1;
        this.hydrogenizedAtoms.addAll(this.addHydrogens());
        this.connectLigands(this.getLigandsByType(L_HETERO_ATOM, all));
        this.storeStereoData();
        this.connectSuffixes(this.getSuffixesByType(true, all));
        for (int i = 0; i < 3; ++i) {
            this.connectLigands(this.getLigandsByType(L_FUSED, i));
            this.connectLigands(this.getLigandsByType(L_DEFAULT, i));
            this.connectSuffixes(this.getSuffixesByType(false, i));
            this.connectLigands(this.getLigandsByType(L_REPLACEMENT, i));
        }
        this.connectLigands(this.getLigandsByType(L_SPACE_SEP, all));
    }

    protected void connectWithComplexLocant(Molecule mol) {
        for (int i = 0; i < this.locants.size(); ++i) {
            SimpleLocant first = ((ComplexLocant)this.locants.getLocant(i)).getFirstLocant();
            SimpleLocant second = ((ComplexLocant)this.locants.getLocant(i)).getSecondLocant();
            Molecule m = this.moleculeList.get(first.getParent());
            MolAtom atom1 = m.getAtom(this.structure.getAtomIndex(first.getValue()));
            m = this.moleculeList.get(second.getParent());
            MolAtom atom2 = m.getAtom(this.structure.getAtomIndex(second.getValue()));
            this.createConnection(mol, atom1, atom2);
        }
    }

    protected void connectWithSimpleLocant(Molecule mol) {
        SimpleLocant basiclocant = (SimpleLocant)this.locants.getLocant(0);
        Molecule m = this.moleculeList.get(basiclocant.getParent());
        MolAtom basicatom = m.getAtom(this.structure.getAtomIndex(basiclocant.getValue()));
        for (int i = 1; i < this.locants.size(); ++i) {
            SimpleLocant locant = (SimpleLocant)this.locants.getLocant(i);
            m = this.moleculeList.get(locant.getParent());
            MolAtom atom = m.getAtom(this.structure.getAtomIndex(locant.getValue()));
            this.createConnection(mol, basicatom, atom);
            if (mol.contains(basicatom)) continue;
            basicatom = atom;
        }
    }

    protected void createConnection(Molecule mol, MolAtom basicatom, MolAtom atom) {
        RingUtil.createSpiroConnection(mol, basicatom, atom);
    }

    @Override
    protected String toSmiles() {
        try {
            return this.getMolecule().toFormat("smiles");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Structure getStructure(int index) {
        return this.structure;
    }

    protected void connectSuffixes() {
        for (int i = 0; i < this.suffixList.size(); ++i) {
            Suffix suffix = (Suffix)this.suffixList.get(i);
            if (suffix.getLocant().size() <= 0) {
                this.calcLocants(suffix);
            }
            for (int j = 0; j < suffix.getMultiplicity(); ++j) {
                Locant locant = suffix.getLocant().getLocant(j);
                Molecule m = null;
                if (locant instanceof SimpleLocant) {
                    m = this.moleculeList.get(((SimpleLocant)locant).getParent());
                    if (this.addSuffix(m, suffix, (SimpleLocant)locant, -1)) continue;
                    throw new NameImportException("Invalid numbering. (" + locant + ")");
                }
                if (!(locant instanceof BondNumber)) continue;
                SimpleLocant l1 = ((BondNumber)locant).getFirstLocant();
                SimpleLocant l2 = ((BondNumber)locant).getSecondLocant();
                m = this.moleculeList.get(l1.getParent());
                if (this.addSuffix(m, suffix, l1, l2.getValue())) continue;
                throw new NameImportException("Invalid numbering. (" + locant + ")");
            }
        }
    }

    protected void connectLigands() {
        ArrayList<Molecule> substituents = new ArrayList<Molecule>();
        for (int i = 0; i < this.substituentCount(); ++i) {
            Structure s = (Structure)this.substituentList.get(i);
            if (s.getLocantInParent() != null) {
                SimpleLocant l = (SimpleLocant)s.getLocantInParent().getLocant(0);
                Molecule m = this.moleculeList.get(l.getParent());
                if (s instanceof HeteroAtom) {
                    Structure basicStruc = this.getStructure(l.getParent());
                    this.addHeteroAtom(m, basicStruc.getAtomIndex(l.getValue()), (HeteroAtom)s);
                    continue;
                }
                int index = s.getAtomIndex(1);
                m.fuse(s.buildMolecule());
                int index2 = this.getStructure(l.getParent()).getAtomIndex(l.getValue());
                Util.addBond(m, s.buildMolecule().getAtom(index), m.getAtom(index2), 1);
                continue;
            }
            substituents.add(s.buildMolecule());
        }
    }

    @Override
    protected Molecule getMolecule(int index) {
        if (index >= this.moleculeList.size()) {
            return null;
        }
        return this.moleculeList.get(index);
    }

    @Override
    protected MolAtom getAtom2(Locant locant1, int locant2, Molecule mol) {
        int atidx = locant2 > -1 ? this.structure.getAtomIndex(locant2) : this.structure.getAtomIndex(locant1.getValue() + 1);
        try {
            return mol.getAtom(atidx);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void addRadicals() {
        if (!this.radicals.isEmpty()) {
            Suffix s = (Suffix)this.radicals.get(0);
            if (!s.locantCalculated) {
                super.addRadicals();
            }
        }
    }

    @Override
    protected void getAtomNumbers(IntVector vec) {
        this.structure.getAtomNumbers(vec);
    }

    @Override
    protected void getAtomNumbers(IntVector vec, int radMul) {
        this.structure.getAtomNumbers(vec, radMul);
    }

    @Override
    public boolean isBasicAtom(MolAtom atom) {
        for (int i = 0; i < this.moleculeList.size(); ++i) {
            if (this.moleculeList.get(i).indexOf(atom) <= -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (this.locants != null && this.locants.getMaxParentIndex() < loc.getParent()) {
            return false;
        }
        int p = loc.getParent();
        loc.setParent(0);
        boolean b = this.structure.hasLocant(loc);
        loc.setParent(p);
        return b;
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return true;
    }
}

