/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class MultipliedSystem
extends MultipliedSpiroSystem {
    protected int multiplicity;

    public MultipliedSystem(Structure structure, LocantList locants) {
        super(structure, locants);
        if (locants != null) {
            this.multiplicity = locants.size() - 1;
        }
    }

    public MultipliedSystem(int mul, Structure structure, LocantList locants) {
        super(structure, locants);
        this.multiplicity = mul;
    }

    @Override
    public Structure cloneStructure() {
        MultipliedSystem newStructure = new MultipliedSystem(this.structure, this.locants);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() throws NameImportException {
        int i;
        Molecule mol = new Molecule();
        Molecule basic = this.structure.buildMolecule();
        basic.aromatize();
        if (this.multiplicity == 2 && this.locants == null && !this.structure.radicals.isEmpty() && !this.structure.hasConnectionPoint()) {
            this.locants = new LocantList();
            Locant l = this.structure.radicals.get(0).getLocant().getLocant(0);
            if (l instanceof SimpleLocant) {
                this.locants.tryAddLocant(l);
                this.locants.tryAddLocant(new SimpleLocant(l.getValue(), 1));
            }
        }
        this.moleculeList = new ArrayList();
        for (i = 0; i < this.multiplicity; ++i) {
            this.moleculeList.add(basic.cloneMolecule());
        }
        this.addLigands();
        for (i = 0; i < this.multiplicity; ++i) {
            mol.fuse((Molecule)this.moleculeList.get(i));
        }
        if (this.locants != null) {
            if (this.locants.getType() == 2) {
                this.connectWithSimpleLocant(mol);
            } else if (this.locants.getType() == 3) {
                this.connectWithComplexLocant(mol);
            } else {
                throw new NameImportException("Invalid numbering: " + this.locants);
            }
        }
        return mol;
    }

    @Override
    protected void createConnection(Molecule mol, MolAtom basicatom, MolAtom atom) {
        int mul = 1;
        if (!this.structure.radicals.isEmpty()) {
            String suff = this.structure.radicals.get(0).getValue();
            if (suff.endsWith("=")) {
                mul = 2;
            } else if (suff.endsWith("#")) {
                mul = 3;
            }
        }
        Util.addBond(mol, basicatom, atom, mul);
    }

    public int getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultpilicity(int mul) {
        this.multiplicity = mul;
    }

    public void setStructure(Structure struc) {
        this.structure = struc;
    }
}

