/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.Molecule;
import java.util.HashMap;

public class Oxime
extends SimpleStructure {
    int multiplicity = 1;

    public Oxime(String value, int multiplicity, String name) {
        super(value, name);
        this.multiplicity = multiplicity;
    }

    @Override
    protected String printValue() {
        String res = super.printValue();
        if (this.multiplicity == 1) {
            return res;
        }
        return res + "(" + this.multiplicity + "*)";
    }

    @Override
    protected void preProcess() {
        this.derivationCheck();
    }

    @Override
    protected Molecule getMol() {
        Molecule mol = super.getMol();
        if (this.substituentCount() == 1 && this.rgroups.size() == 2) {
            this.rgroups.remove(1);
        }
        return mol;
    }

    protected boolean derivationCheck() {
        if (this.checkAsIUPAC()) {
            return true;
        }
        return this.checkAsCAS();
    }

    protected boolean checkAsIUPAC() {
        if (this.substituentCount() == 0) {
            return false;
        }
        Structure basic = this.getSubstituent(0);
        if (basic.getLocantInParent() != null && basic.getLocantInParent().getType() == 6 && this.substituentCount() > 1) {
            basic = this.getSubstituent(1);
        }
        LocantList radicalNumbering = null;
        for (int i = 0; i < basic.suffixCount(); ++i) {
            Suffix suff = basic.getSuffix(i);
            boolean isKetone = this.isKetone(suff);
            if (suff.getType() == 2) {
                radicalNumbering = suff.getLocant();
            }
            if (!isKetone && !this.isAldehyde(suff)) continue;
            if (radicalNumbering != null && suff.getLocant() != null && !suff.getLocant().containsAll(radicalNumbering)) {
                return false;
            }
            this.setValue(isKetone ? "NO" : "C=NO");
            LocantList locant = this.getOximeNumbering(basic, suff, i, false);
            suff.setValue(isKetone ? "=NO" : "C=NO");
            String value = isKetone ? "|=" : "|";
            basic.addSuffix(SuffixFactory.createSuffix(value, "yl", locant, 1, 2));
            return true;
        }
        return false;
    }

    protected boolean checkAsCAS() {
        if (this.getParent() == null) {
            return false;
        }
        Structure basic = this.getParent();
        boolean hasLocant = this.hasLocant() && !this.getLocantInParent().getLocant(0).isGreekLetter();
        boolean isDefaultNumbering = hasLocant && this.getLocantInParent().getLocant(0).getValue() == 1;
        for (int i = 0; i < basic.suffixCount(); ++i) {
            Suffix suff = basic.getSuffix(i);
            boolean isKetone = this.isKetone(suff);
            if (!isKetone && !this.isAldehyde(suff)) continue;
            if (hasLocant && suff.hasLocant() && !suff.getLocant().containsAll(this.getLocantInParent()) && !isDefaultNumbering) {
                return false;
            }
            this.setValue(isKetone ? "NO" : "C=NO");
            LocantList locant = this.getOximeNumbering(basic, suff, i, true);
            suff.setValue(isKetone ? "=NO" : "C=NO");
            this.setLocantInParent(locant);
            String value = isKetone ? "|=" : "|";
            LocantList l = new LocantList();
            l.tryAddLocant(new SimpleLocant(1, 0));
            this.addSuffix(SuffixFactory.createSuffix(value, "yl", l, 1, 2));
            return true;
        }
        return false;
    }

    private LocantList getOximeNumbering(Structure basicStructure, Suffix suffix, int index, boolean inCAS) {
        int i;
        this.rgroups.clear();
        if (!suffix.hasLocant()) {
            if (!inCAS) {
                basicStructure.calcLocants(suffix);
            } else {
                Structure clone = basicStructure.cloneStructure();
                for (i = 0; i < clone.substituentCount(); ++i) {
                    if (clone.getSubstituent((int)i).cloneOf != this) continue;
                    clone.removeSubstituent(i);
                }
                clone.calcLocants(clone.getSuffix(index));
                suffix.setLocant(clone.getSuffix(index).getLocant());
            }
        }
        LocantList locant = new LocantList();
        if (this.multiplicity < suffix.getMultiplicity()) {
            if (this.hasLocant() && suffix.getLocant().containsAll(this.getLocantInParent())) {
                for (i = 0; i < suffix.getLocant().size(); ++i) {
                    if (this.getLocantInParent().contains(suffix.getLocant().getLocant(i))) continue;
                    locant.addLocant(suffix.getLocant().removeLocant(i--));
                }
            }
            int mul = suffix.getMultiplicity() - this.multiplicity - locant.size();
            for (int i2 = 0; i2 < mul; ++i2) {
                locant.addLocant(suffix.locant.removeLocant(suffix.locant.size() - i2 - 1));
            }
            Suffix newsuffix = SuffixFactory.createSuffix(suffix.getValue(), suffix.getName(), locant, locant.size(), suffix.getType(), suffix.getRadical());
            basicStructure.addSuffix(newsuffix);
        }
        if (this.multiplicity > 1) {
            suffix.setMultiplicity(this.multiplicity - 1);
            if (locant.size() == 0) {
                locant.tryAddLocant(suffix.getLocant().getLocant(suffix.getLocantCount() - 1));
                suffix.getLocant().removeLocant(suffix.getLocantCount() - 1);
            } else {
                locant = new LocantList();
                locant.addLocant(suffix.getLocant().removeLocant(0));
            }
            return locant;
        }
        basicStructure.removeSuffix(suffix);
        return suffix.getLocant();
    }

    private boolean isKetone(Suffix suffix) {
        return suffix.getName().equals("on") || suffix.getName().equals("al");
    }

    private boolean isAldehyde(Suffix suffix) {
        return suffix.getName().indexOf("aldehyd") > -1;
    }

    @Override
    protected void mapFunctionalGroup(Structure funcGroup, Locant oldlocant, Molecule mol, IntVector spaceAttach, HashMap<Integer, Integer> atomMap) {
        Molecule funcMol = funcGroup.buildMolecule();
        for (int i = 0; i < funcMol.getAtomCount(); ++i) {
            if (funcMol.getAtom(i).getCharge() >= 0) continue;
            int atomindex = i + mol.getAtomCount();
            int newLocant = oldlocant.getValue() + this.basicAtomCount;
            atomMap.put(newLocant, atomindex);
            spaceAttach.add(newLocant);
            if (oldlocant.getParent() <= 0) break;
            this.spaceAttach.add(newLocant);
            break;
        }
    }
}

