/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

public class PhenoIneSystem
extends Structure {
    private HeteroAtom atom1 = null;
    private HeteroAtom atom2 = null;
    private static String BASICSMILES = "c1c2ccccc2cc3ccccc13{Hydrogens: 10}";
    private static IntVector BASICNUMBERING = new IntVector(new int[]{10, 1001, 1, 2, 3, 4, 401, 5, 501, 6, 7, 8, 9, 901});
    private SimpleStructure mainStruc = new SimpleStructure(BASICSMILES, "phenoine");

    public PhenoIneSystem(HeteroAtom atom1, HeteroAtom atom2) {
        this.atom1 = (HeteroAtom)atom1.cloneStructure();
        this.atom1.setLocantInParent(5);
        this.atom2 = (HeteroAtom)atom2.cloneStructure();
        this.atom2.setLocantInParent(10);
        this.mainStruc.addSubstituent(this.atom1);
        this.mainStruc.addSubstituent(this.atom2);
        this.mainStruc.setAtomMap(BASICNUMBERING);
        this.setAtomMap(BASICNUMBERING);
    }

    public PhenoIneSystem(HeteroAtom atom) {
        this.atom1 = (HeteroAtom)atom.cloneStructure();
        this.atom1.setLocantInParent(5);
        this.atom2 = (HeteroAtom)atom.cloneStructure();
        this.atom2.setLocantInParent(10);
        this.mainStruc.addSubstituent(this.atom1);
        this.mainStruc.addSubstituent(this.atom2);
        this.mainStruc.setAtomMap(BASICNUMBERING);
        this.setAtomMap(BASICNUMBERING);
    }

    @Override
    protected String printValue() {
        return this.atom1.getValue() + " " + this.atom2.getValue();
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        PhenoIneSystem newStructure = new PhenoIneSystem(this.atom1, this.atom2);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() {
        this.mainStruc.hydroList.addAll(this.hydroList);
        this.hydroList.clear();
        Molecule mol = this.mainStruc.buildMolecule();
        if (this.atom2.getValue().equalsIgnoreCase("N") && this.atom1.getValue().equalsIgnoreCase("[AsH3]") || this.atom1.getValue().equalsIgnoreCase("P")) {
            this.setBondsType(mol, 0, 4);
            this.setBondsType(mol, 7, 4);
        }
        return mol;
    }

    @Override
    protected String toSmiles() {
        return this.getMolecule().toFormat("cxsmiles");
    }

    @Override
    protected Structure getStructure(int index) {
        return this;
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (loc instanceof AtomLocant) {
            return this.hasAtom(((AtomLocant)loc).getAtomSymbol(), true);
        }
        return BASICNUMBERING.contains(Util.locantToInt(loc));
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return this.getHeteroAtomCountOf(atomSymbol) > 0;
    }

    @Override
    protected void postProcess() {
        if (this.molecule.hasValenceError()) {
            int locant;
            MolAtom failingAtom = null;
            int index = -1;
            for (int i = 0; i < this.basicAtomCount && failingAtom == null; ++i) {
                if (!this.molecule.getAtom(i).hasValenceError()) continue;
                failingAtom = this.molecule.getAtom(i);
                index = i;
            }
            if (index > -1 && (locant = this.getMappedIndex(index)) % 2 == 1 && (locant < 4 || locant > 6)) {
                this.shiftBonds(failingAtom);
            }
        }
        super.postProcess();
    }

    private void shiftBonds(MolAtom atom) {
        MolBond bond = null;
        MolAtom parent = null;
        MolAtom actual = atom;
        while ((bond = this.getNext(actual, parent)) != null) {
            parent = actual;
            actual = bond.getOtherAtom(parent);
            bond.setType(bond.getType() == 1 ? 2 : 1);
        }
    }

    private MolBond getNext(MolAtom atom, MolAtom parent) {
        MolBond next = null;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond bond = atom.getBond(i);
            MolAtom other = bond.getOtherAtom(atom);
            if (atom.getAtno() != 6) {
                return null;
            }
            if (this.molecule.indexOf(other) >= this.basicAtomCount) continue;
            if (parent == null && bond.getType() == 2) {
                return bond;
            }
            if (other == parent) continue;
            if (other.getAtno() == 6) {
                next = bond;
            }
            return bond;
        }
        return next;
    }
}

