/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.ComplexLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.RingUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Structure;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.Iterator;

public class PolyCyclicSpiroSystem
extends Structure {
    protected ArrayList<Structure> structures;
    protected LocantList locants;
    protected ArrayList<Molecule> moleculeList = new ArrayList();

    public PolyCyclicSpiroSystem(ArrayList<Structure> structures, LocantList complexLocants) {
        this.structures = structures;
        this.setParent(this.structures);
        this.locants = complexLocants;
    }

    public PolyCyclicSpiroSystem(ArrayList<Structure> structures, ArrayList<ComplexLocant> complexLocants) {
        this.structures = structures;
        this.setParent(this.structures);
        this.locants = new LocantList();
        Iterator<ComplexLocant> iter = complexLocants.iterator();
        while (iter.hasNext()) {
            this.locants.tryAddLocant(iter.next());
        }
    }

    public ArrayList<Structure> getAllStructures() {
        return this.structures;
    }

    @Override
    public Structure getStructure(int index) {
        if (index > this.structures.size() - 1 || index < 0) {
            return null;
        }
        return this.structures.get(index);
    }

    public LocantList getLocants() {
        return this.locants;
    }

    @Override
    protected String printValue() {
        String value = "Spiro: ";
        for (int i = 0; i < this.structures.size(); ++i) {
            value = value + this.structures.get(i).printValue() + "\t";
        }
        return value;
    }

    @Override
    public boolean checkSyntax(ArrayList<Token> tokenlist) {
        return true;
    }

    @Override
    public Structure cloneStructure() {
        PolyCyclicSpiroSystem newStructure = new PolyCyclicSpiroSystem(this.structures, this.locants);
        this.cloneProperties(newStructure);
        return newStructure;
    }

    @Override
    protected Molecule getMol() throws NameImportException {
        int i;
        Molecule mol = new Molecule();
        this.moleculeList = new ArrayList();
        this.addStereoData();
        for (i = 0; i < this.structures.size(); ++i) {
            this.moleculeList.add(this.structures.get(i).buildMolecule());
        }
        this.addLigands();
        for (i = 0; i < this.structures.size(); ++i) {
            mol.fuse(this.moleculeList.get(i));
        }
        if (this.locants.getType() == 2) {
            for (i = 0; i < this.locants.size(); i += 2) {
                SimpleLocant locant = (SimpleLocant)this.locants.getLocant(i);
                Molecule m = this.moleculeList.get(locant.getParent());
                MolAtom atom1 = m.getAtom(this.structures.get(i).getAtomIndex(locant.getValue()));
                locant = (SimpleLocant)this.locants.getLocant(i + 1);
                m = this.moleculeList.get(locant.getParent());
                MolAtom atom2 = m.getAtom(this.structures.get(i + 1).getAtomIndex(locant.getValue()));
                int index = -1;
                index = this.stereoData.indexOf(atom2);
                if (index > -1) {
                    ((Structure.StereoInfo)this.stereoData.get(index)).setAtom(atom2);
                }
                RingUtil.createSpiroConnection(mol, atom1, atom2);
            }
        } else if (this.locants.getType() == 3) {
            for (i = 0; i < this.locants.size(); ++i) {
                SimpleLocant first = ((ComplexLocant)this.locants.getLocant(i)).getFirstLocant();
                SimpleLocant second = ((ComplexLocant)this.locants.getLocant(i)).getSecondLocant();
                Molecule m = this.moleculeList.get(first.getParent());
                MolAtom atom1 = m.getAtom(this.structures.get(first.getParent()).getAtomIndex(first.getValue()));
                m = this.moleculeList.get(second.getParent());
                MolAtom atom2 = m.getAtom(this.structures.get(second.getParent()).getAtomIndex(second.getValue()));
                RingUtil.createSpiroConnection(mol, atom1, atom2);
            }
        } else {
            throw new NameImportException("Invalid numbering: " + this.locants);
        }
        this.removeHalfAromaticBonds(this.hydrogenizedAtoms, mol);
        this.setStereoData(this.stereoData, mol, true);
        return mol;
    }

    private void addStereoData() {
        for (int i = 0; i < this.stereoLocants.size(); ++i) {
            StereoNumber loc = (StereoNumber)this.stereoLocants.getLocant(i);
            int parent = loc.getLocant().getParent();
            this.structures.get(parent).addStereoLocant(loc);
        }
    }

    @Override
    protected String toSmiles() {
        try {
            return this.getMolecule().toFormat("smiles");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected void aromatizeMolecule() {
        for (int i = 0; i < this.moleculeList.size(); ++i) {
            this.moleculeList.get(i).aromatize();
        }
    }

    protected void repairBeforeAcetateAttached(Molecule mol, SimpleStructure suffix, SimpleLocant oldlocant) {
        super.repairBeforeAcetateAttached(mol, suffix, oldlocant);
    }

    @Override
    protected int calcParentIndex() {
        for (int i = 0; i < this.structures.size(); ++i) {
            if (this.structures.get((int)i).spaceAttach.isEmpty()) continue;
            return i;
        }
        return super.calcParentIndex();
    }

    @Override
    protected void getAtomNumbers(IntVector vec) {
        for (int i = 0; i < this.structures.size(); ++i) {
            Structure struc = this.structures.get(i);
            IntVector v = new IntVector();
            struc.getAtomNumbers(v);
            vec.addAll(v);
        }
        vec.sort();
    }

    @Override
    protected void getAtomNumbers(IntVector vec, int radMul) {
        for (int i = 0; i < this.structures.size(); ++i) {
            Structure struc = this.structures.get(i);
            IntVector v = new IntVector();
            struc.getAtomNumbers(v, radMul);
            vec.addAll(v);
        }
        vec.sort();
    }

    @Override
    protected int getAtomIndex(int mappedIndex, int molindex) throws NameImportException {
        return this.getStructure(molindex).getAtomIndex(mappedIndex);
    }

    private void setParent(ArrayList<Structure> strucList) {
        for (int i = 0; i < strucList.size(); ++i) {
            strucList.get(i).setParent(this);
        }
    }

    @Override
    public boolean isBasicAtom(MolAtom atom) {
        int i;
        for (i = 0; i < this.substituentCount(); ++i) {
            Structure sub = this.getSubstituent(i);
            if (sub.molecule == null || sub.getMolecule().indexOf(atom) <= -1) continue;
            return false;
        }
        for (i = 0; i < this.structures.size(); ++i) {
            if (!this.structures.get(i).isBasicAtom(atom)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasLocant(Locant loc) {
        if (this.structures.size() <= loc.getParent()) {
            return false;
        }
        int p = loc.getParent();
        loc.setParent(0);
        boolean b = this.structures.get(p).hasLocant(loc);
        loc.setParent(p);
        return b;
    }

    @Override
    public boolean hasAtom(String atomSymbol) {
        return true;
    }

    @Override
    protected void setNitrogenHydrogens(Molecule mol, int count, ArrayList<MolAtom> exclude) {
    }
}

