/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;

public class SaltEnding
extends Suffix {
    private String atom = null;
    private boolean hydro = false;

    public SaltEnding(String value, int mul, String atom, int tokenCount) {
        super(value, null, mul, 3, tokenCount);
        this.atom = atom;
    }

    public SaltEnding(String value, int mul, String atom, int tokenCount, boolean hasHydro) {
        super(value, null, mul, 3, tokenCount);
        this.atom = atom;
        this.hydro = hasHydro;
    }

    public SaltEnding(String value, int mul, String atom, int tokenCount, boolean hasHydro, int radical) {
        this(value, mul, atom, tokenCount, hasHydro);
        this.radical = radical;
    }

    public String getAtom() {
        return this.atom;
    }

    public void setAtom(String atom) {
        this.atom = atom;
    }

    public boolean hasHydro() {
        return this.hydro;
    }

    public void setHydro(boolean hydro) {
        this.hydro = hydro;
    }

    @Override
    public Suffix cloneSuffix() {
        return new SaltEnding(this.value, this.multiplicity, this.atom, this.tokenCount, this.hydro);
    }

    @Override
    public String toString() {
        return super.toString() + " atom:" + this.atom + (this.hydro ? " hydro" : "");
    }

    @Override
    SimpleStructure buildStructure() {
        return new SimpleStructure(this.getAtom(), this.getName());
    }
}

