/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameimport.parse.data;

import chemaxon.calculations.TopologyAnalyser;
import chemaxon.common.util.IntVector;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.marvin.io.formats.name.nameimport.Hydrogenizator;
import chemaxon.marvin.io.formats.name.nameimport.NameImportException;
import chemaxon.marvin.io.formats.name.nameimport.Util;
import chemaxon.marvin.io.formats.name.nameimport.lex.LocantLexer;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AtomLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.AzaLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.BondNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.ComplexLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Hydro;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Locant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.LocantList;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.NonStdValenceLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.RingNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.SimpleLocant;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.StereoNumber;
import chemaxon.marvin.io.formats.name.nameimport.lex.data.Token;
import chemaxon.marvin.io.formats.name.nameimport.parse.IUPACParserCore;
import chemaxon.marvin.io.formats.name.nameimport.parse.ParserUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.StereoCalculator;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AcetateGroup;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.AggregateStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Amine;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Bridge;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Ester;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.FusedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.HeteroAtom;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Hydrazone;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.LocantCalculator;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.MultipliedSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Oxime;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.PolyCyclicSpiroSystem;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.RingUtil;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SaltEnding;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SimpleStructure;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.Suffix;
import chemaxon.marvin.io.formats.name.nameimport.parse.data.SuffixFactory;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class Structure {
    static int MAX_CACHE_SIZE = 200;
    public static LinkedHashMap<String, Molecule> molCache = new LinkedHashMap<String, Molecule>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Molecule> eldest) {
            return this.size() > MAX_CACHE_SIZE;
        }
    };
    static final boolean debug = false;
    public static final String remRGroup = "remRGroup";
    private static final String DEOXY = "deoxy";
    public static final String removeMark = "toremove";
    protected static final String HYDROXY = "HYDROXY";
    protected ArrayList<RGroup> rgroups = new ArrayList();
    protected ArrayList<Structure> substituentList = new ArrayList();
    protected ArrayList<Suffix> suffixList = new ArrayList();
    protected LocantList locantInParent;
    protected HashMap<Integer, Integer> atomMap = new HashMap();
    protected Molecule molecule = null;
    public ArrayList<Suffix> radicals = new ArrayList();
    protected ArrayList<Hydro> hydroList = new ArrayList();
    public ArrayList<Hydro> defaultHydro;
    protected ArrayList<StereoInfo> stereoData = Structure.getStereoInfoList();
    protected int basicAtomCount = 0;
    protected IntVector noAttach = new IntVector();
    protected IntVector spaceAttach = new IntVector();
    protected boolean spaceSeparated = false;
    protected boolean dashConnected = false;
    protected int moleculeCharge = 0;
    protected Structure parent = null;
    protected LocantList nonStdValence = new LocantList();
    protected LocantList stereoLocants = new LocantList();
    protected LocantList defaultStereo = new LocantList();
    protected boolean preProcessed = false;
    protected LocantList defaultSuffixNumbering = null;
    protected LocantList defaultLigandNumbering = null;
    protected ArrayList<Pair<MolAtom, Locant>> nitrogensForNConnections = new ArrayList();
    protected ArrayList<Pair<MolAtom, NonStdValenceLocant>> nonStdValenceAtoms = new ArrayList();
    public Structure cloneOf = null;
    protected ArrayList<MolAtom> removalHydroxyGroups = null;
    protected LocantCalculator locantCalculator = new LocantCalculator(this);
    protected boolean locantCalculated = false;
    public boolean isRoot = false;
    protected boolean canAddRadicals = false;
    protected boolean explicitSingle = false;
    protected ArrayList<MolAtom> hydrogenizedAtoms = new ArrayList();
    static int L_DEFAULT = 0;
    static int L_SPACE_SEP = 1;
    static int L_HETERO_ATOM = 2;
    static int L_FUSED = 3;
    static int L_REPLACEMENT = 4;
    static int L_HYDRAZONE = 5;
    static final IntVector neverAromaticAtoms = new IntVector(new int[]{8, 50, 17, 35, 53, 51, 13, 31, 49, 81});
    ArrayList<MolBond> stereoBonds = new ArrayList();
    private int cisTransLigandCount = 0;
    boolean isChain;
    protected Suffix connectionPoint = null;
    protected boolean isConnectionPointDefaultForSuffix = false;
    public int multiplicity = 1;

    public void setDashConnected(boolean dashconnect) {
        this.dashConnected = dashconnect;
    }

    public boolean getDashConnected() {
        return this.dashConnected;
    }

    public void setParent(Structure parent) {
        this.parent = parent;
    }

    public boolean hasDefaultSuffixNumbering() {
        return this.defaultSuffixNumbering != null;
    }

    public boolean isLocantCalculated() {
        return this.locantCalculated;
    }

    public void setLocantCalculated(boolean locantCalculated) {
        this.locantCalculated = locantCalculated;
    }

    protected void addRGroup(RGroup rgroup) {
        this.rgroups.add(rgroup);
    }

    protected RGroup getRGroup(int index) {
        if (index >= this.rgroups.size()) {
            return null;
        }
        return this.rgroups.get(index);
    }

    public boolean isExplicitSingle() {
        return this.explicitSingle;
    }

    public void setExplicitSingle(boolean explicitSingle) {
        this.explicitSingle = explicitSingle;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public Structure getParent() {
        return this.parent;
    }

    public LocantList getLocantInParent() {
        return this.locantInParent;
    }

    public void setLocantInParent(LocantList locantInParent) {
        if (locantInParent == null) {
            this.locantInParent = null;
            return;
        }
        this.locantInParent = new LocantList();
        for (int i = 0; i < locantInParent.size(); ++i) {
            this.addLocant(locantInParent.getLocant(i));
        }
    }

    public void setLocantInParent(Locant locantInParent) {
        if (locantInParent instanceof NonStdValenceLocant) {
            this.nonStdValence.tryAddLocant(locantInParent);
        }
        this.locantInParent = new LocantList();
        this.locantInParent.tryAddLocant(locantInParent);
    }

    public void setLocantInParent(int locantInParent) {
        this.locantInParent = new LocantList();
        this.locantInParent.tryAddLocant(new SimpleLocant(locantInParent, 0));
    }

    public void addLocant(Locant locant) {
        if (this.locantInParent == null) {
            this.locantInParent = new LocantList();
        }
        this.locantInParent.tryAddLocant(locant);
        if (locant instanceof NonStdValenceLocant) {
            this.nonStdValence.tryAddLocant(this.locantInParent);
        }
    }

    public void addLocant(LocantList locant) {
        if (locant == null) {
            return;
        }
        if (this.locantInParent == null) {
            this.locantInParent = new LocantList();
        }
        this.locantInParent.tryAddLocant(locant);
        if (locant.getLocant(0) instanceof NonStdValenceLocant) {
            this.nonStdValence.tryAddLocant(locant);
        }
    }

    public void removeLocant(int index) {
        if (this.locantInParent == null) {
            return;
        }
        this.locantInParent.removeLocant(Math.min(index, this.locantInParent.size() - 1));
    }

    public void removeLastLocant() {
        if (this.locantInParent == null) {
            return;
        }
        this.locantInParent.removeLocant(this.locantInParent.size() - 1);
        if (this.locantInParent.size() == 0) {
            this.locantInParent = null;
        }
    }

    public ArrayList<Structure> getSubstituentList() {
        return this.substituentList;
    }

    public Structure getSubstituent(int index) {
        if (this.substituentList.size() <= index || index < 0) {
            return null;
        }
        return this.substituentList.get(index);
    }

    public void removeSubstituent(int index) {
        if (this.substituentList.size() > index) {
            Structure s = this.substituentList.get(index);
            s.parent = null;
            this.substituentList.remove(index);
        }
    }

    public int indexOf(Structure struc) {
        return this.substituentList.indexOf(struc);
    }

    public void removeSubstituent(Structure struc) {
        for (int i = 0; i < this.substituentCount(); ++i) {
            if (!this.substituentList.get(i).equals(struc)) continue;
            this.substituentList.remove(i);
            struc.parent = null;
            return;
        }
    }

    public void clearSubstituentList() {
        this.substituentList = new ArrayList();
    }

    public void clearSubstituentList(boolean exceptHeteroAtoms) {
        int subCount = this.substituentCount();
        int index = 0;
        for (int i = 0; i < subCount; ++i) {
            if (exceptHeteroAtoms && this.getSubstituent(index) instanceof HeteroAtom) {
                ++index;
                continue;
            }
            this.removeSubstituent(index);
        }
    }

    public int substituentCount() {
        return this.substituentList.size();
    }

    public int substituentCount(boolean exceptHeteroAtom) {
        if (!exceptHeteroAtom) {
            return this.substituentCount();
        }
        int count = 0;
        for (int i = 0; i < this.substituentCount(); ++i) {
            if (this.getSubstituent(i) instanceof HeteroAtom) continue;
            ++count;
        }
        return count;
    }

    public void addSubstituent(Structure structure) {
        this.substituentList.add(structure);
        structure.setParent(this);
    }

    public void addSubstituent(int index, Structure structure) {
        this.substituentList.add(index, structure);
        structure.setParent(this);
    }

    public void addSubstituent(ArrayList<Structure> strucList) {
        if (strucList == null) {
            return;
        }
        this.substituentList.addAll(strucList);
        for (int i = 0; i < strucList.size(); ++i) {
            strucList.get((int)i).parent = this;
        }
    }

    public ArrayList<Suffix> getSuffixList() {
        return this.suffixList;
    }

    public Suffix getSuffix(int index) {
        if (this.suffixList.size() <= index) {
            return null;
        }
        return this.suffixList.get(index);
    }

    public Suffix removeSuffix(int index) {
        if (this.suffixList.size() > index) {
            return this.suffixList.remove(index);
        }
        return null;
    }

    public void removeSuffix(Suffix s) {
        for (int i = 0; i < this.suffixCount(); ++i) {
            if (!this.suffixList.get(i).equals(s)) continue;
            this.removeSuffix(i);
            break;
        }
    }

    public void clearSuffixList() {
        this.suffixList = new ArrayList();
    }

    public void addSuffix(Suffix suffix) {
        if (IUPACParserCore.revolution) {
            this.suffixList.add(suffix);
        } else {
            this.suffixList.add(0, suffix);
        }
        for (Locant l : suffix.locant.getLocantsList()) {
            if (!(l instanceof NonStdValenceLocant)) continue;
            this.nonStdValence.addLocant(l);
        }
        if (this.isCyclic()) {
            suffix.parentIsCyclic();
        }
    }

    public void addSuffix(ArrayList<Suffix> suffixList) {
        if (suffixList == null) {
            return;
        }
        for (Suffix s : suffixList) {
            this.addSuffix(s);
        }
    }

    public void addSuffixClones(ArrayList<Suffix> suffixList) {
        this.suffixList = new ArrayList();
        for (int i = 0; i < suffixList.size(); ++i) {
            Suffix s = suffixList.get(i);
            if (!this.isClonable(s)) continue;
            this.suffixList.add(s.cloneSuffix());
        }
    }

    private boolean isClonable(Suffix suffix) {
        return !"hydrat".equals(suffix.getName());
    }

    public int suffixCount() {
        return this.suffixList.size();
    }

    public int suffixCountWithMultiplicity() {
        int res = 0;
        for (Suffix s : this.suffixList) {
            res += s.multiplicity;
        }
        return res;
    }

    public int indexOf(Suffix suffix) {
        return this.suffixList.indexOf(suffix);
    }

    public boolean hasLocant() {
        return this.getLocantInParent() != null && this.getLocantInParent().hasLocant();
    }

    public void print() {
        this.print(0);
    }

    private void printTabs(int count) {
        for (int i = 0; i < count; ++i) {
            System.out.print("\t");
        }
    }

    public String getName() {
        return "";
    }

    public boolean is(String name) {
        return name.equals(this.getName());
    }

    boolean nameEndsWith(String suffix) {
        String name = this.getName();
        return name != null && name.endsWith(suffix);
    }

    public boolean isCyclic() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.printValue() + " " + (this.molecule != null ? this.molecule.toFormat("cxsmiles") : "");
    }

    String debugHashCode() {
        return "?";
    }

    protected void print(int depth) {
        int i;
        this.printTabs(depth);
        String cl = this.getClass().toString();
        cl = cl.substring(cl.lastIndexOf(46) + 1);
        String sp = this.spaceSeparated ? "\tspaceSep" : "";
        String clone = this.cloneOf == null ? "null (this=" + this.debugHashCode() + ")" : Integer.toString(this.cloneOf.hashCode());
        System.out.println(cl + " " + this.printValue() + "\t" + this.locantInParent + sp + "\tclone:" + clone + (this.isExplicitSingle() ? " explicitSingle" : "") + (this.isRoot() ? " root" : ""));
        if (this.suffixList.size() > 0) {
            this.printTabs(depth);
            System.out.println("Suffixes:");
        }
        for (i = 0; i < this.suffixList.size(); ++i) {
            this.printTabs(depth);
            Suffix s = this.suffixList.get(i);
            System.out.println(s.getMultiplicity() + "* " + s + " spacesep:" + s.isSpaceSeparated());
        }
        if (!this.hydroList.isEmpty()) {
            this.printTabs(depth);
            System.out.print("Hydrogens:  ");
            for (i = 0; i < this.hydroCount(); ++i) {
                Hydro h = this.hydroList.get(i);
                System.out.print(h + "  ");
            }
            System.out.println();
        }
        if (this.stereoLocants.size() > 0) {
            this.printTabs(depth);
            System.out.print("Stereo:  ");
            for (i = 0; i < this.stereoLocants.size(); ++i) {
                StereoNumber sn = (StereoNumber)this.stereoLocants.getLocant(i);
                System.out.print(sn + "  ");
            }
            System.out.println();
        }
        if (!this.spaceAttach.isEmpty()) {
            this.printTabs(depth);
            System.out.print("SpaceAttach:  ");
            for (i = 0; i < this.spaceAttach.size(); ++i) {
                int sn = this.spaceAttach.get(i);
                System.out.print(sn + "  ");
            }
            System.out.println();
        }
        if (this.substituentList.size() > 0) {
            this.printTabs(depth);
            System.out.println("Substituents:");
        }
        for (i = 0; i < this.substituentList.size(); ++i) {
            this.substituentList.get(i).print(depth + 1);
        }
    }

    protected abstract String printValue();

    public abstract boolean checkSyntax(ArrayList<Token> var1);

    public abstract Structure cloneStructure();

    protected void cloneProperties(Structure newStructure) {
        newStructure.setLocantInParent(this.locantInParent);
        newStructure.addSuffixClones(this.suffixList);
        for (int i = 0; i < this.substituentList.size(); ++i) {
            newStructure.addSubstituent(this.substituentList.get(i).cloneStructure());
        }
        newStructure.hydroList.addAll(this.hydroList);
        if (this.defaultHydro != null) {
            newStructure.defaultHydro = new ArrayList();
            newStructure.defaultHydro.addAll(this.defaultHydro);
        }
        newStructure.spaceSeparated = this.spaceSeparated;
        newStructure.stereoLocants.tryAddLocant(this.stereoLocants);
        newStructure.defaultStereo.tryAddLocant(this.defaultStereo);
        newStructure.spaceAttach.addAll(this.spaceAttach);
        newStructure.noAttach.addAll(this.noAttach);
        int cpIndex = this.connectionPoint == null ? -1 : this.suffixList.indexOf(this.connectionPoint);
        newStructure.connectionPoint = cpIndex < 0 ? null : newStructure.getSuffix(cpIndex);
        newStructure.setCloneOf(this.cloneOf == null ? this : this.cloneOf);
    }

    protected abstract Molecule getMol();

    protected Molecule buildMolecule() {
        if (this.molecule == null) {
            this.preProcessTree();
            this.molecule = this.getMol();
            this.basicAtomCount = this.molecule.getAtomCount();
            this.storeNonStandardValence();
            if (!(this instanceof PolyCyclicSpiroSystem || this instanceof MultipliedSpiroSystem || this instanceof HeteroAtom)) {
                this.addLigands();
            }
            this.setNitrogenHydrogens(this.molecule, 0, this.hydrogenizedAtoms);
            this.storeStereoData();
            if (this.parent == null || this instanceof FusedSystem || this.parent instanceof MultipliedSystem) {
                this.setStereoData();
            }
            this.addRGroups();
            if (!this.molecule.hasValenceError()) {
                this.dearomatize();
            }
            if (this.parent == null) {
                this.postProcess();
            }
            this.dearomatize();
        }
        return this.molecule;
    }

    protected void postProcess() {
        this.setNonStdValence();
        if (!this.molecule.hasValenceError()) {
            this.molecule.aromatize();
            this.dearomatize();
        }
        this.removeMarkedAtoms();
        this.removeFalseRGroups();
        if (this.canAddRadicals) {
            this.addRadicals();
        }
        this.removeFalseAromaticBonds(this.hydrogenizedAtoms);
        this.setStereoData();
        this.removeHydrogens();
    }

    protected void addLigands() {
        int all = -1;
        int nonGreekLocant = 0;
        int noLocant = 1;
        int greekLocant = 2;
        this.hydrogenizedAtoms.addAll(this.addHydrogens());
        this.connectLigands(this.getLigandsByType(L_HETERO_ATOM, all));
        this.setNitrogenHydrogens(this.molecule, 0, this.hydrogenizedAtoms);
        this.connectSuffixes(this.getSuffixesByType(true, all));
        LocantList notProcessed = this.storeStereoData();
        this.connectLigands(this.getLigandsByType(L_FUSED, nonGreekLocant));
        this.connectLigands(this.getLigandsByType(L_DEFAULT, nonGreekLocant));
        this.connectSuffixes(this.getSuffixesByType(false, nonGreekLocant));
        this.connectLigands(this.getLigandsByType(L_HYDRAZONE, nonGreekLocant));
        this.connectLigands(this.getLigandsByType(L_REPLACEMENT, nonGreekLocant));
        this.connectLigands(this.getLigandsByType(L_FUSED, noLocant));
        this.connectLigands(this.getLigandsByType(L_DEFAULT, noLocant));
        this.connectSuffixes(this.getSuffixesByType(false, noLocant));
        this.connectLigands(this.getLigandsByType(L_HYDRAZONE, noLocant));
        this.connectLigands(this.getLigandsByType(L_REPLACEMENT, noLocant));
        this.connectLigands(this.getLigandsByType(L_FUSED, greekLocant));
        this.connectLigands(this.getLigandsByType(L_DEFAULT, greekLocant));
        this.connectSuffixes(this.getSuffixesByType(false, greekLocant));
        this.connectLigands(this.getLigandsByType(L_HYDRAZONE, greekLocant));
        this.connectLigands(this.getLigandsByType(L_REPLACEMENT, greekLocant));
        this.connectLigands(this.getLigandsByType(L_SPACE_SEP, all));
        if (this.parent != null) {
            this.parent.hydrogenizedAtoms.addAll(this.hydrogenizedAtoms);
        }
        this.storeStereoData(notProcessed);
    }

    protected void connectSuffixes(ArrayList<Suffix> suffixList) {
        for (int i = 0; i < suffixList.size(); ++i) {
            this.connectSuffix(suffixList.get(i));
        }
    }

    protected ArrayList<Suffix> getSuffixesByType(boolean saltOrAmine, int locantType) {
        ArrayList<Suffix> substituentList = new ArrayList<Suffix>();
        for (int i = 0; i < this.suffixCount(); ++i) {
            Suffix suffix = this.getSuffix(i);
            if (saltOrAmine != this.saltOrAmineOrIon(suffix) || !this.canBeProcessed(suffix, locantType)) continue;
            substituentList.add(suffix);
        }
        return substituentList;
    }

    protected void connectLigands(ArrayList<Structure> ligands) {
        ArrayList<Structure> generatedLocantNeeded = this.getLigandsForlocantGeneration(ligands);
        this.calcLocants(generatedLocantNeeded);
        for (int i = 0; i < ligands.size(); ++i) {
            this.addLigand(ligands.get(i));
        }
    }

    protected ArrayList<Structure> getLigandsByType(int ligandType, int locantType) {
        ArrayList<Structure> substituentList = new ArrayList<Structure>();
        for (int i = 0; i < this.substituentCount(); ++i) {
            Structure struc = this.getSubstituent(i);
            if (!this.canBeProcessed(struc, locantType)) continue;
            if (struc.isSpaceSeparated()) {
                if (ligandType != L_SPACE_SEP) continue;
                substituentList.add(struc);
                continue;
            }
            if (struc instanceof FusedSystem) {
                if (ligandType != L_FUSED) continue;
                substituentList.add(struc);
                continue;
            }
            if (struc instanceof HeteroAtom) {
                if (ligandType != L_HETERO_ATOM) continue;
                substituentList.add(struc);
                continue;
            }
            if (struc instanceof SimpleStructure && ((SimpleStructure)struc).getType() == 4) {
                if (ligandType != L_REPLACEMENT) continue;
                substituentList.add(struc);
                continue;
            }
            if (struc instanceof Hydrazone) {
                if (ligandType != L_HYDRAZONE) continue;
                substituentList.add(struc);
                continue;
            }
            if (ligandType != L_DEFAULT) continue;
            substituentList.add(struc);
        }
        return substituentList;
    }

    protected boolean canBeProcessed(Structure struc, int locantType) {
        Locant locant;
        Locant locant2 = locant = struc.hasLocant() ? struc.getLocantInParent().getLocant(0) : null;
        if (locantType == 0) {
            return locant != null && (!locant.isGreekLetter() || this.hasLocant(locant));
        }
        if (locantType == 1) {
            return locant == null;
        }
        if (locantType == 2) {
            return locant != null && locant.isGreekLetter() && !this.hasLocant(locant);
        }
        return locantType < 0;
    }

    protected boolean canBeProcessed(Suffix suffix, int locantType) {
        if (locantType == 0) {
            return suffix.hasLocant() && !suffix.getLocant().getLocant(0).isGreekLetter();
        }
        if (locantType == 1) {
            return !suffix.hasLocant();
        }
        if (locantType == 2) {
            return suffix.hasLocant() && suffix.getLocant().getLocant(0).isGreekLetter();
        }
        return locantType < 0;
    }

    protected void dearomatize() {
        this.molecule.dearomatize();
    }

    protected void addRGroups() {
        if (IUPACParserCore.revolution) {
            // empty if block
        }
        for (int i = 0; i < this.rgroups.size(); ++i) {
            RGroup rg = this.rgroups.get(i);
            MolAtom rGroup = new MolAtom(134);
            rGroup.setRgroup(rg.getRGroupIndex());
            this.molecule.add(rGroup);
            for (int j = 0; j < rg.getNeighbourCount(); ++j) {
                MolAtom atom = this.molecule.getAtom(this.getAtomIndex(rg.getNeighbour(j)));
                int bond = rg.getBond(j);
                this.molecule.add(new MolBond(atom, rGroup, bond));
            }
        }
    }

    protected void removeFalseRGroups() {
        for (int i = 0; i < this.molecule.getAtomCount(); ++i) {
            MolAtom atom = this.molecule.getAtom(i);
            if (atom.getAliasstr() == null) continue;
            if (atom.getAliasstr().equals(remRGroup)) {
                for (int j = 0; j < atom.getBondCount(); ++j) {
                    MolAtom atom2 = atom.getBond(j).getOtherAtom(atom);
                    if (!Util.isRGroup(atom2)) continue;
                    this.molecule.removeAtom(atom2);
                    break;
                }
            }
            atom.setAliasstr(null);
        }
    }

    public Molecule getMolecule() {
        if (this.molecule == null) {
            this.canAddRadicals = true;
            this.preProcessTree();
            this.molecule = this.buildMolecule();
            this.molecule.dearomatize();
            this.molecule.setAbsStereo(true);
        }
        return this.molecule;
    }

    protected void addRadicals() {
        if (this.canAddRadicals()) {
            for (int j = 0; j < this.radicals.size(); ++j) {
                Suffix suff = this.radicals.get(j);
                if (suff.getName().equals("rad") && this.substituentCount() > 0 || this.radicals.subList(0, j).contains(suff)) continue;
                for (int i = 0; i < suff.locant.size(); ++i) {
                    Locant loc = suff.locant.getLocant(i);
                    ArrayList<Locant> v = this.getLigandsIndexesFromSuffix();
                    if (v.contains(loc) || this.hasSaltOrAcidEnding()) {
                        return;
                    }
                    int mul = 1;
                    if (suff.getValue().endsWith("=")) {
                        mul = 2;
                    } else if (suff.getValue().endsWith("#")) {
                        mul = 3;
                    }
                    MolAtom atom = this.molecule.getAtom(this.getAtomIndex(loc.getValue()));
                    int rad = atom.getRadical();
                    atom.setRadical(rad + mul);
                }
            }
        }
    }

    protected boolean canAddRadicals() {
        if (this.parent != null || this.radicals.isEmpty() || this.hasConnectionPoint()) {
            return false;
        }
        if (this.hasCloneLigands()) {
            return false;
        }
        return this.rgroups.isEmpty();
    }

    private boolean hasSaltOrAcidEnding() {
        for (int i = 0; i < this.suffixCount(); ++i) {
            if (this.getSuffix(i).getType() != 3 && this.getSuffix(i).getType() != 0) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Locant> getLigandsIndexesFromSuffix() {
        ArrayList<Locant> v = new ArrayList<Locant>();
        for (int i = 0; i < this.suffixCount(); ++i) {
            Suffix s = this.getSuffix(i);
            if (this.radicals.contains(s)) continue;
            v.add(s.getLocant().getLocant(0));
        }
        return v;
    }

    protected void removeHydrogens() {
        for (int i = 0; i < this.molecule.getAtomCount(); ++i) {
            MolAtom atom = this.molecule.getAtom(i);
            if (!atom.hasAromaticBond() || atom.getCharge() >= 0 || atom.getImplicitHcount() <= 0) continue;
            atom.setImplicitHcount(atom.getImplicitHcount() - 1);
            this.molecule.dearomatize();
        }
    }

    protected void removeHalfAromaticBonds(ArrayList<MolAtom> atomList, Molecule molecule) {
        this.fixOnP(molecule, atomList);
        if (this.removalHydroxyGroups != null) {
            for (int i = 0; i < this.removalHydroxyGroups.size(); ++i) {
                this.removeAtomAndKeepChirality(this.removalHydroxyGroups.get(i));
            }
        }
        if (molecule.dearomatize() && !molecule.hasValenceError()) {
            return;
        }
        ArrayList<MolAtom> aromAtoms = this.getAromAtoms(molecule);
        if (this.fixOnHydrogenizedAtoms(molecule, atomList)) {
            return;
        }
        if (this.fixOnNeverAromaticAtoms(molecule, aromAtoms)) {
            return;
        }
        if (this.fixByAll(molecule, aromAtoms)) {
            return;
        }
        this.fixBySpecificRules();
    }

    private void fixOnP(Molecule molecule, ArrayList<MolAtom> atomList) {
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            MolAtom atom = molecule.getAtom(i);
            if (atomList.contains(atom) || !Util.isAtom(atom, 15) || Util.sumBonds(atom) != 3) continue;
            atom.setImplicitHcount(0);
        }
    }

    protected ArrayList<MolAtom> getAromAtoms(Molecule molecule) {
        ArrayList<MolAtom> aromAtoms = new ArrayList<MolAtom>();
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            if (!molecule.getAtom(i).hasAromaticBond()) continue;
            aromAtoms.add(molecule.getAtom(i));
        }
        return aromAtoms;
    }

    protected boolean fixBySpecificRules() {
        return false;
    }

    private boolean fixOnHydrogenizedAtoms(Molecule molecule, ArrayList<MolAtom> atomList) {
        int i;
        ArrayList<MolBond> aromaticBonds = new ArrayList<MolBond>();
        for (i = 0; i < atomList.size(); ++i) {
            MolAtom atom = atomList.get(i);
            if (!this.TestAtom(atom, molecule, aromaticBonds)) continue;
            return true;
        }
        for (i = 0; i < aromaticBonds.size(); ++i) {
            if (!this.tryDearomatize(molecule.indexOf(aromaticBonds.get(i)), molecule)) continue;
            aromaticBonds.get(i).setType(1);
            return true;
        }
        if (!atomList.isEmpty()) {
            for (i = 0; i < atomList.size(); ++i) {
                if (!this.tryDearomatize(atomList.get(i), molecule)) continue;
                this.setBondsType(molecule, molecule.indexOf(atomList.get(i)), 1);
                return true;
            }
        }
        return false;
    }

    private boolean fixOnNeverAromaticAtoms(Molecule molecule, ArrayList<MolAtom> aromAtoms) {
        for (int i = 0; i < aromAtoms.size(); ++i) {
            MolAtom atom = aromAtoms.get(i);
            if (!Structure.isNeverAromaticAtom(atom)) continue;
            this.setAromaticBondsToSingle(atom, null);
        }
        molecule.valenceCheck();
        return molecule.dearomatize() && !molecule.hasValenceError();
    }

    private boolean fixByAll(Molecule molecule, ArrayList<MolAtom> aromAtoms) {
        if (this.fixOnOxoGroup(molecule, aromAtoms)) {
            return true;
        }
        if (this.fixOnSingleBond(molecule)) {
            return true;
        }
        return this.fixOnMoreBonds(molecule, aromAtoms);
    }

    private boolean fixOnOxoGroup(Molecule molecule, ArrayList<MolAtom> aromAtoms) {
        for (MolAtom atom : aromAtoms) {
            if (atom.getAtno() != 6 || atom.getBondCount() != 3) continue;
            for (int i = 0; i < atom.getBondCount(); ++i) {
                MolBond bond = atom.getBond(i);
                if (bond.getType() != 2 || bond.getOtherAtom(atom).getAtno() != 8) continue;
                this.setAromaticBondsToSingle(atom, null);
                return molecule.dearomatize();
            }
        }
        return false;
    }

    private boolean fixOnMoreBonds(Molecule molecule, ArrayList<MolAtom> aromAtoms) {
        ArrayList<MolAtom> atomsWithSingleAromBond = new ArrayList<MolAtom>();
        boolean change = true;
        while (change) {
            int i;
            change = false;
            for (i = 0; i < aromAtoms.size(); ++i) {
                if (this.getAromBondCount(aromAtoms.get(i)) != 1) continue;
                atomsWithSingleAromBond.add(aromAtoms.get(i));
            }
            for (i = 0; i < atomsWithSingleAromBond.size(); ++i) {
                MolAtom atom = (MolAtom)atomsWithSingleAromBond.get(i);
                if (atom.getValenceProp() >= 0 || this.isDefaultValence(atom, atom.getValence())) continue;
                this.setAromaticBondsToSingle(atom, null);
                change = true;
                if (!molecule.dearomatize()) continue;
                return true;
            }
            atomsWithSingleAromBond.clear();
        }
        return false;
    }

    private boolean isDefaultValence(MolAtom atom, int oxState) {
        int atno = atom.getAtno();
        int numoxstates = MolAtom.numoxstatesOf(atno);
        for (int i = 0; i < numoxstates; ++i) {
            if (oxState != MolAtom.oxstateOf(atno, i)) continue;
            return true;
        }
        return false;
    }

    private int getAromBondCount(MolAtom atom) {
        int count = 0;
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i).getType() != 4) continue;
            ++count;
        }
        return count;
    }

    private boolean fixOnSingleBond(Molecule molecule) {
        ArrayList<MolBond> aromaticBonds = new ArrayList<MolBond>();
        molecule.valenceCheck();
        if (molecule.hasValenceError() || !molecule.dearomatize()) {
            int i;
            for (i = 0; i < molecule.getAtomCount(); ++i) {
                MolAtom atom = molecule.getAtom(i);
                if (atom.hasValenceError() && this.tryFixValence(molecule, atom)) {
                    return true;
                }
                if (!this.TestAtom(atom, molecule, aromaticBonds)) continue;
                return true;
            }
            for (i = 0; i < aromaticBonds.size(); ++i) {
                if (!this.tryDearomatize(molecule.indexOf((MolBond)aromaticBonds.get(i)), molecule)) continue;
                aromaticBonds.get(i).setType(1);
                return true;
            }
        }
        return false;
    }

    private static boolean isNeverAromaticAtom(MolAtom atom) {
        return neverAromaticAtoms.contains(atom.getAtno());
    }

    private boolean tryFixValence(Molecule molecule, MolAtom atom) {
        for (int j = 0; j < atom.getBondCount(); ++j) {
            MolBond bond = atom.getBond(j);
            if (bond.getType() <= 1 || Util.isOxygen(bond.getOtherAtom(atom)) || !molecule.isRingBond(molecule.indexOf(bond))) continue;
            bond.setType(1);
        }
        return !molecule.hasValenceError() && molecule.dearomatize();
    }

    protected boolean tryDearomatize(int bondindex, Molecule molecule) {
        if (bondindex < 0 || bondindex >= molecule.getBondCount()) {
            return false;
        }
        Molecule mol = molecule.cloneMolecule();
        MolBond bond = mol.getBond(bondindex);
        bond.setType(1);
        return mol.dearomatize();
    }

    protected boolean tryDearomatize(MolAtom atom, Molecule molecule) {
        if (molecule.indexOf(atom) < 0) {
            return false;
        }
        boolean changed = false;
        Molecule mol = molecule.cloneMolecule();
        MolAtom molAtom = mol.getAtom(molecule.indexOf(atom));
        for (int i = 0; i < molAtom.getBondCount(); ++i) {
            MolBond bond = molAtom.getBond(i);
            if (bond.getType() != 4) continue;
            bond.setType(1);
            changed = true;
        }
        return changed && mol.dearomatize();
    }

    protected boolean TestAtom(MolAtom atom, Molecule molecule, ArrayList<MolBond> aromBonds) {
        ArrayList<MolBond> bonds = new ArrayList<MolBond>();
        for (int j = 0; j < atom.getBondCount() && atom.hasAromaticBond(); ++j) {
            if (atom.getBond(j).getType() != 4) continue;
            if (Util.isOxygen(atom)) {
                atom.getBond(j).setType(1);
                continue;
            }
            bonds.add(atom.getBond(j));
        }
        if (bonds.size() == 1) {
            if (this.tryDearomatize(molecule.indexOf((MolBond)bonds.get(0)), molecule)) {
                ((MolBond)bonds.get(0)).setType(1);
                return true;
            }
        } else if ((Util.isAtom(atom, 15) || Util.isAtom(atom, 50)) && bonds.size() == 2 && atom.getBondCount() == 2) {
            atom.getBond(0).setType(1);
            atom.getBond(1).setType(1);
            return molecule.dearomatize();
        }
        for (int i = 0; i < bonds.size(); ++i) {
            if (aromBonds.contains(bonds.get(i))) continue;
            aromBonds.add((MolBond)bonds.get(i));
        }
        return false;
    }

    protected void removeFalseAromaticBonds(ArrayList<MolAtom> atomList) {
        this.removeHalfAromaticBonds(atomList, this.molecule);
    }

    private void setAromaticBondsToSingle(MolAtom atom, ArrayList<MolBond> bondList) {
        if (bondList == null || bondList.isEmpty()) {
            for (int n = 0; n < atom.getBondCount(); ++n) {
                if (atom.getBond(n).getType() != 4) continue;
                atom.getBond(n).setType(1);
            }
        } else {
            for (int n = 0; n < bondList.size(); ++n) {
                bondList.get(n).setType(1);
            }
        }
    }

    protected void storeNonStandardValence() {
        for (int i = 0; i < this.nonStdValence.size(); ++i) {
            if (!(this.nonStdValence.getLocant(i) instanceof NonStdValenceLocant)) continue;
            NonStdValenceLocant loc = (NonStdValenceLocant)this.nonStdValence.getLocant(i);
            Molecule m = this.getStructure(loc.getParent()).buildMolecule();
            Pair<MolAtom, NonStdValenceLocant> pair = new Pair<MolAtom, NonStdValenceLocant>(m.getAtom(this.getAtomIndex(loc.getValue())), loc);
            this.nonStdValenceAtoms.add(pair);
        }
    }

    protected void setNonStdValence() {
        for (int i = 0; i < this.nonStdValenceAtoms.size(); ++i) {
            MolAtom atom = this.nonStdValenceAtoms.get(i).getFirst();
            NonStdValenceLocant loc = this.nonStdValenceAtoms.get(i).getSecond();
            if (atom.hasValenceError() || atom.getValence() != loc.getValence()) {
                atom.setValenceProp(loc.getValence());
            }
            atom.setImplicitHcount(1);
        }
        this.nonStdValenceAtoms.clear();
    }

    protected void getNonStandardValence() {
        if (this.locantInParent != null && this.locantInParent.getType() == 2) {
            for (int i = 0; i < this.locantInParent.size(); ++i) {
                if (!(this.locantInParent.getLocant(i) instanceof NonStdValenceLocant)) continue;
                this.nonStdValence.tryAddLocant(this.locantInParent.getLocant(i));
            }
        }
    }

    protected void setNitrogenHydrogens(Molecule mol, int count, ArrayList<MolAtom> exclude) {
        boolean nfix = this.nitrogenFixNeeded(mol);
        IntVector atomsToSet = new IntVector();
        for (int index = 0; index < mol.getAtomCount(); ++index) {
            MolAtom atom = mol.getAtom(index);
            boolean arom = atom.hasAromaticBond();
            if (nfix && arom && Util.isNitrogen(atom) && !exclude.contains(atom)) {
                atomsToSet.add(index);
                continue;
            }
            if (nfix && !arom && Util.isNitrogen(atom) && atom.getValence() > 3 + atom.getCharge()) {
                int c = Math.max(0, 3 + atom.getCharge() - Util.sumBonds(atom));
                atom.setImplicitHcount(c);
                continue;
            }
            if (atom.getValenceProp() <= -1 || exclude.contains(atom) || this instanceof HeteroAtom || mol.getAtomCount() <= 1) continue;
            atom.setValenceProp(-1);
        }
        if (nfix && !atomsToSet.isEmpty() && this.canSetHydrogenCount(mol, atomsToSet, count)) {
            for (int i = 0; i < atomsToSet.size(); ++i) {
                mol.getAtom(atomsToSet.get(i)).setImplicitHcount(count);
            }
        }
    }

    protected boolean canSetHydrogenCount(Molecule mol, IntVector atomIndexes, int Hcount) {
        try {
            Molecule m = mol.cloneMolecule();
            Molecule m2 = mol.cloneMolecule();
            for (int i = 0; i < atomIndexes.size(); ++i) {
                MolAtom atom = m.getAtom(atomIndexes.get(i));
                atom.setImplicitHcount(Hcount);
            }
            boolean b1 = m.dearomatize();
            boolean b2 = m2.dearomatize();
            return b1 || !b2;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    protected boolean nitrogenFixNeeded(Molecule mol) {
        Molecule m = mol.cloneMolecule();
        return !m.dearomatize();
    }

    protected ArrayList<MolAtom> addHydrogens() {
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        if (this.hydroList.isEmpty()) {
            if (this.defaultHydro == null) {
                return list;
            }
            this.hydroList.addAll(this.defaultHydro);
        }
        return this.addHydrogens(this.hydroList);
    }

    protected ArrayList<MolAtom> addHydrogens(ArrayList<Hydro> hydroList) {
        ArrayList<MolAtom> list = new ArrayList<MolAtom>();
        if (hydroList.isEmpty()) {
            return list;
        }
        if (!this.canAddHydrogens(hydroList)) {
            this.parent.hydrogenizedAtoms.addAll(this.parent.addHydrogens(hydroList));
            return list;
        }
        ArrayList<MolAtom> hydrogenizedAtoms = new ArrayList<MolAtom>();
        ArrayList<MolAtom> deHydrogenizedAtoms = new ArrayList<MolAtom>();
        int hCount = 0;
        int deHCount = 0;
        int parent = 0;
        for (int i = 0; i < hydroList.size(); ++i) {
            Hydro h = hydroList.get(i);
            if (h.getLocant() != null) {
                parent = h.getLocant().getParent();
                int value = h.getLocant().getValue();
                int atomindex = this.getAtomIndex(value, parent);
                Molecule m = this.getMolecule(parent);
                MolAtom atom = m.getAtom(atomindex);
                if (h.getType() == 0) {
                    hydrogenizedAtoms.add(atom);
                    continue;
                }
                deHydrogenizedAtoms.add(atom);
                continue;
            }
            if (h.getType() == 0) {
                ++hCount;
                continue;
            }
            ++deHCount;
        }
        if (this.molecule != null) {
            this.aromatizeMolecule();
        } else {
            this.getMolecule(parent).aromatize();
        }
        Hydrogenizator.addHydrogens(hydrogenizedAtoms, this);
        Hydrogenizator.remHydrogens(deHydrogenizedAtoms);
        if (!Hydrogenizator.addHydrogens(this.getMolecule(parent), hCount, list, this) || !Hydrogenizator.remHydrogens(this.getMolecule(parent), deHCount)) {
            throw new NameImportException("Hydrogenization failed.");
        }
        list.addAll(hydrogenizedAtoms);
        return list;
    }

    public boolean isBasicAtom(MolAtom atom) {
        if (this.molecule == null) {
            return false;
        }
        if (this.getMolecule().indexOf(atom) < 0) {
            return false;
        }
        for (int i = 0; i < this.substituentCount(); ++i) {
            Structure sub = this.getSubstituent(i);
            if (sub.molecule == null || sub.getMolecule().indexOf(atom) <= -1) continue;
            return false;
        }
        return true;
    }

    protected void aromatizeMolecule() {
        this.molecule.aromatize();
    }

    private boolean canAddHydrogens(ArrayList<Hydro> hydroList) {
        for (int i = 0; i < hydroList.size(); ++i) {
            Hydro h = hydroList.get(i);
            if (h.getLocant() == null) continue;
            int parent = h.getLocant() == null ? 0 : h.getLocant().getParent();
            int value = h.getLocant() == null ? 1 : h.getLocant().getValue();
            int atomindex = this.getAtomIndex(value);
            Molecule m = this.getMolecule(parent);
            if (m.getAtomCount() > atomindex) continue;
            this.parent.hydroList.addAll(hydroList);
            return false;
        }
        return true;
    }

    MolAtom getAtom(Locant locant) {
        if (!this.hasLocant(locant)) {
            return null;
        }
        int parent = locant.getParent();
        int value = locant.getValue();
        int atomindex = this.getAtomIndex(value, parent);
        Molecule m = this.getMolecule(parent);
        MolAtom atom = m.getAtom(atomindex);
        return atom;
    }

    protected LocantList storeStereoData() {
        if (this.stereoData.isEmpty()) {
            return this.addStereoData2(this, this.stereoLocants, true);
        }
        return null;
    }

    protected void storeStereoData(LocantList stereoData) {
        if (stereoData != null) {
            this.addStereoData2(this, stereoData, false);
        }
    }

    protected LocantList addStereoData2(Structure struc, LocantList stereoLocants, boolean firstRun) {
        if (stereoLocants.size() == 0) {
            stereoLocants.tryAddLocant(this.defaultStereo);
        }
        LocantList notProcessed = new LocantList();
        for (int i = 0; i < stereoLocants.size(); ++i) {
            int atomindex;
            boolean alwaysAdd;
            StereoNumber sn = (StereoNumber)stereoLocants.getLocant(i);
            Locant locant = sn.getLocant() == null ? new SimpleLocant(1, 0) : sn.getLocant();
            int parent = locant.getParent();
            int value = locant.getValue();
            Molecule m = struc.getMolecule(parent);
            boolean bl = alwaysAdd = sn.getStereoType() == 0 && sn.getValue() == 1;
            if (this.stereoData.contains(sn) && this.stereoData.contains(struc) && !alwaysAdd) {
                if (firstRun) {
                    notProcessed.addLocant(sn);
                    atomindex = -1;
                } else {
                    atomindex = Util.getIndexOfDoubleBoundedAtom(m, this.stereoData);
                }
            } else {
                atomindex = struc.hasLocant(locant) ? (sn.getLocant() instanceof AzaLocant ? this.getNitrogeneIndex(this.molecule, value, parent, true) : struc.getAtomIndex(value, parent)) : struc.getDefaultAtomIndex();
            }
            if (atomindex < 0) continue;
            MolAtom atom = m.getAtom(atomindex);
            this.stereoData.add(new StereoInfo(struc, atom, sn));
        }
        return notProcessed.size() > 0 ? notProcessed : null;
    }

    protected void setStereoData() {
        this.setStereoData(this.stereoData, this.molecule, true);
    }

    protected void setStereoData(ArrayList<StereoInfo> stereoData, Molecule molecule, boolean repeat) {
        int unSuccessfulCases = 0;
        for (int i = 0; i < stereoData.size(); ++i) {
            StereoInfo info = stereoData.get(i);
            if (info.getAtom() == null) continue;
            if (info.getStereoData().getLocant() instanceof ComplexLocant) {
                if (this.addComplexStereoLocants(info)) continue;
                ++unSuccessfulCases;
                continue;
            }
            if (info.getStereoData().isBondStereo()) {
                this.addEZLocants(info, molecule);
                continue;
            }
            if (this.addRSLocants(info, molecule)) continue;
            ++unSuccessfulCases;
        }
        if (repeat && unSuccessfulCases > 0 && unSuccessfulCases < stereoData.size()) {
            this.setStereoData(stereoData, molecule, false);
        } else if (repeat && StereoCalculator.isChiralDataFit(molecule, stereoData)) {
            TopologyAnalyser analyser = new TopologyAnalyser();
            analyser.setMolecule(molecule);
            int[] chiralPoints = analyser.chiralCenters();
            this.setStereoDataNumbering(stereoData, chiralPoints, molecule);
            this.setStereoData(stereoData, molecule, false);
        }
    }

    private void setStereoDataNumbering(ArrayList<StereoInfo> stereoData, int[] numbering, Molecule mol) {
        for (int i = 0; i < stereoData.size(); ++i) {
            StereoInfo info = stereoData.get(i);
            info.setAtom(mol.getAtom(numbering[i]));
        }
    }

    private boolean addComplexStereoLocants(StereoInfo info) {
        StereoNumber sn = info.getStereoData();
        Structure parentStruc = info.getParentStruc();
        ComplexLocant complex = (ComplexLocant)sn.getLocant();
        SimpleLocant l1 = complex.getFirstLocant();
        SimpleLocant l2 = complex.getSecondLocant();
        MolAtom a1 = parentStruc.getAtom(l1);
        MolAtom a2 = parentStruc.getAtom(l2);
        int stereo1 = this.getUpDownBond(a1);
        int stereo2 = this.getUpDownBond(a2);
        if (stereo1 != 0 && stereo2 == 0) {
            this.copyStereo(stereo1, a2, sn.getStereoData());
            return true;
        }
        if (stereo2 != 0 && stereo1 == 0) {
            this.copyStereo(stereo2, a1, sn.getStereoData());
            return true;
        }
        return false;
    }

    private void addEZLocants(StereoInfo info, Molecule molecule) {
        Structure struc = info.getParentStruc();
        MolAtom atom = info.getAtom();
        StereoNumber sn = info.getStereoData();
        MolBond bond = this.getDoubleBond(atom);
        if (bond != null) {
            StereoCalculator.setBondStereo(molecule, bond, sn.getStereoData());
            this.stereoBonds.add(bond);
        } else if (sn.getLocant().getValue() == 1) {
            MolBond dbond = this.findAtomToBondStereo();
            if (dbond != null) {
                StereoCalculator.setBondStereo(molecule, dbond, sn.getStereoData());
                this.stereoBonds.add(dbond);
            } else if (!struc.substituentList.isEmpty()) {
                Structure ligandNearStereoNumber = struc.getSubstituent(struc.substituentCount() - 1);
                MolAtom a = this.getAtomForStereo(ligandNearStereoNumber, sn);
                ArrayList<StereoInfo> list = Structure.getStereoInfoList();
                list.add(new StereoInfo(ligandNearStereoNumber, a, sn));
                this.setStereoData(list, molecule, true);
            }
        }
    }

    private MolAtom getAtomForStereo(Structure struc, StereoNumber sn) {
        int index = sn.getValue() > 1 ? struc.getAtomIndex(sn.getValue()) : struc.getDefaultAtomIndex();
        if (index >= 0 && struc.buildMolecule().getAtomCount() > index) {
            return struc.buildMolecule().getAtom(index);
        }
        return null;
    }

    private boolean addRSLocants(StereoInfo info, Molecule molecule) {
        MolAtom atom = info.getAtom();
        StereoNumber sn = info.getStereoData();
        int atomindex = molecule.indexOf(atom);
        if (atomindex > -1 && atomindex < molecule.getAtomCount()) {
            return StereoCalculator.setAtomStereo(molecule, atomindex, sn);
        }
        return false;
    }

    private void copyStereo(int stereo1, MolAtom a2, int cisOrTrans) {
        int stereo2;
        MolBond bond2 = this.getNonRingBond(a2);
        if (cisOrTrans == 128) {
            stereo2 = stereo1;
        } else if (cisOrTrans == 64) {
            stereo2 = Structure.invertUpDown(stereo1);
        } else {
            throw new NameImportException.Failure("Unhandled bond stereo: " + cisOrTrans);
        }
        bond2.setFlags(stereo2, 48);
    }

    private MolBond findAtomToBondStereo() {
        if (this.molecule == null) {
            return null;
        }
        int steps = this.getParent() == null ? this.molecule.getAtomCount() : this.basicAtomCount;
        for (int i = 0; i < steps; ++i) {
            MolBond bond = this.getDoubleBond(this.molecule.getAtom(i), false);
            if (bond == null || this.stereoBonds.contains(bond)) continue;
            return bond;
        }
        return null;
    }

    private MolBond getDoubleBond(MolAtom atom) {
        return this.getDoubleBond(atom, true);
    }

    private MolBond getDoubleBond(MolAtom atom, boolean canStepForward) {
        if (atom == null || !canStepForward && Util.isOxygen(atom)) {
            return null;
        }
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond bond = atom.getBond(i);
            if (bond.getType() != 2 || Util.isOxygen(bond.getOtherAtom(atom)) || this.stereoBonds.contains(bond)) continue;
            return atom.getBond(i);
        }
        if (!canStepForward) {
            return null;
        }
        ArrayList<Pair<MolAtom, MolBond>> bonds = new ArrayList<Pair<MolAtom, MolBond>>();
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolAtom atom2;
            MolBond bond2;
            if (atom.getBond(i).getType() != 1 || (bond2 = this.getDoubleBond(atom2 = atom.getBond(i).getOtherAtom(atom), false)) == null) continue;
            bonds.add(new Pair<MolAtom, MolBond>(atom2, bond2));
        }
        if (!bonds.isEmpty()) {
            int atno = atom.getAtno();
            for (int i = 0; i < bonds.size(); ++i) {
                MolBond b = (MolBond)((Pair)bonds.get(i)).getSecond();
                MolAtom a = (MolAtom)((Pair)bonds.get(i)).getFirst();
                if (atno != a.getAtno()) continue;
                return b;
            }
            return (MolBond)((Pair)bonds.get(0)).getSecond();
        }
        return null;
    }

    protected void addHeteroAtom(Molecule m, int index, HeteroAtom s) {
        MolAtom atom = m.getAtom(index);
        MolAtom hatom = s.buildMolecule().getAtom(0);
        int origvalence = atom.getValence();
        atom.setAtno(hatom.getAtno());
        int newhcount = hatom.getImplicitHcount();
        int implH = Math.max(atom.getImplicitHcount() + (newhcount - origvalence), 0);
        String alias = atom.getAliasstr();
        atom.clear();
        atom.setAliasstr(alias);
        atom.setImplicitHcount(implH);
        if (atom.getCharge() == 0) {
            atom.setCharge(hatom.getCharge());
        }
        if (s.nonStdValence != null && s.nonStdValence.size() > 0) {
            this.nonStdValenceAtoms.add(new Pair<MolAtom, NonStdValenceLocant>(atom, (NonStdValenceLocant)s.nonStdValence.getLocant(0)));
        } else if (atom.hasAromaticBond() && Util.isAtom(atom, 15)) {
            atom.setImplicitHcount(0);
        }
    }

    protected boolean canBeProcessed(Structure struc, boolean hasLocant) {
        boolean simpleCase = hasLocant && struc.hasLocant() && struc.getLocantInParent().getLocant(0) instanceof SimpleLocant;
        boolean atomLocantCase = !hasLocant && (!struc.hasLocant() || !(struc.getLocantInParent().getLocant(0) instanceof SimpleLocant));
        return simpleCase || atomLocantCase;
    }

    private ArrayList<Structure> getLigandsForlocantGeneration(ArrayList<Structure> substituentList) {
        ArrayList<Structure> generatedLocantNeeded = new ArrayList<Structure>();
        for (int i = 0; i < substituentList.size(); ++i) {
            Structure s = substituentList.get(i);
            if (s.hasLocant()) continue;
            generatedLocantNeeded.add(s);
        }
        return generatedLocantNeeded;
    }

    protected void addLigand(Structure s) {
        MolBond b;
        if (s.isYlene() && this.getSpaceAttachPoints().size() == 2 && (b = Util.getDoubleBond(s.buildMolecule())) != null) {
            MolAtom a1 = this.getMolecule().getAtom(this.getAtomIndex(this.getSpaceAttachPoints().get(0)));
            MolAtom a2 = this.getMolecule().getAtom(this.getAtomIndex(this.getSpaceAttachPoints().get(1)));
            Molecule parent = this.buildMolecule();
            parent.fuse(s.buildMolecule());
            parent.add(new MolBond(a1, b.getAtom1()));
            parent.add(new MolBond(a2, b.getAtom2()));
            if (!s.is("vinylene")) {
                b.setType(1);
            }
            a1.setCharge(0);
            a2.setCharge(0);
            this.spaceAttach.clear();
            s.removeAllRGroups();
            return;
        }
        if (!s.hasLocant() && s instanceof AcetateGroup) {
            MolAtom o = this.getHydroxy();
            if (o == null) {
                throw new NameImportException("Could not attach acetate");
            }
            Molecule parent = this.buildMolecule();
            parent.fuse(s.buildMolecule());
            MolAtom oParent = o.getLigand(0);
            MolAtom acetateO = s.getHydroxy();
            acetateO.setCharge(0);
            parent.add(new MolBond(oParent, acetateO));
            parent.removeAtom(o);
            return;
        }
        if (!s.hasLocant()) {
            s.addLocant(new SimpleLocant(1, 0));
            s.setLocantCalculated(true);
        }
        boolean[] bondAdded = new boolean[s.getLocantInParent().size()];
        for (int index = 0; index < s.getLocantInParent().size(); ++index) {
            Locant l = s.getLocantInParent().getLocant(index);
            boolean isaza = l instanceof AzaLocant;
            int type = 0;
            int index2 = -1;
            if (isaza) {
                int realLocant = -1;
                if (l.getValue() == 1) {
                    realLocant = Util.N_PRIME;
                } else if (l.getValue() == 0) {
                    realLocant = Util.N;
                }
                if (realLocant != -1 && this.atomMap.containsKey(realLocant)) {
                    index2 = this.atomMap.get(realLocant);
                }
            }
            if (index2 == -1) {
                type = this.setLocantAndGetItsTypeAtLigandAddition(s, l);
                if (l.getValue() < 0) {
                    throw new NameImportException("Invalid numbering.");
                }
                index2 = this.indexOfAttachPointInChild(l, type);
            }
            this.removeGroup(l.getValue());
            this.spaceAttach.removeElement(l.getValue());
            Molecule m = this.getMolecule(l.getParent());
            if (s instanceof HeteroAtom && index == 0) {
                this.addHeteroAtom(m, index2, (HeteroAtom)s);
                if (s.nonStdValence != null && s.nonStdValence.size() > 0) {
                    NonStdValenceLocant ns = (NonStdValenceLocant)s.nonStdValence.getLocant(0);
                    ns.setValue(s.getLocantInParent().getLocant(index).getValue());
                    this.nonStdValence.tryAddLocant(ns);
                }
            } else if (s instanceof SimpleStructure && ((SimpleStructure)s).getValue().equals("[H+]")) {
                m.getAtom(index2).setCharge(m.getAtom(index2).getCharge() + 1);
            } else if (this.isRemovalGroup(s)) {
                this.removeGroup(s, m.getAtom(index2), m);
            } else {
                int oxoIndex;
                int ligandType;
                int n = ligandType = s instanceof SimpleStructure ? ((SimpleStructure)s).getType() : -1;
                if (ligandType == L_REPLACEMENT && this.replaceIfPossible(s, m, index2, index)) break;
                if (s instanceof Hydrazone && !this.isEster(this.parent) && (oxoIndex = this.getOxoGroup(this.getMolecule())) > -1) {
                    MolAtom oxo = this.molecule.getAtom(oxoIndex);
                    oxo.setAliasstr(removeMark);
                    int tmpindex = this.molecule.indexOf(oxo.getBond(0).getOtherAtom(oxo));
                    if (tmpindex < this.basicAtomCount) {
                        index2 = tmpindex;
                    }
                }
                if (index == 0) {
                    index2 = this.createLigand(s, m, isaza, index2);
                }
                if (!s.spaceSeparated && type == 0 && index2 >= this.basicAtomCount && this.basicAtomCount > 0) {
                    throw new NameImportException("Invalid numbering. Locant=" + s.getLocantInParent());
                }
                int tmp = index;
                index += this.addBonds(m, s, index2, s.isSpaceSeparated(), index, bondAdded, false);
                if (tmp > 0 && !bondAdded[tmp] && bondAdded[tmp - 1]) {
                    Structure clone = s.cloneStructure();
                    index2 = this.createLigand(clone, m, isaza, index2);
                    index += this.addBonds(m, clone, index2, clone.isSpaceSeparated(), tmp - 1, bondAdded, true);
                }
            }
            if (index != 0) continue;
            this.stereoData.addAll(s.stereoData);
            this.nonStdValenceAtoms.addAll(s.nonStdValenceAtoms);
        }
    }

    private boolean isEster(Structure struc) {
        if (struc instanceof Ester) {
            return true;
        }
        if (!(struc instanceof SimpleStructure) || struc.getName() == null) {
            return false;
        }
        return struc.getName().equalsIgnoreCase("ester");
    }

    private boolean replaceIfPossible(Structure ligand, Molecule parentmol, int atomindex, int index) {
        MolAtom atom2;
        int i;
        if (!(ligand instanceof SimpleStructure)) {
            return false;
        }
        SimpleStructure ss = (SimpleStructure)ligand;
        if (ss.getType() != 4) {
            return false;
        }
        MolAtom atom = parentmol.getAtom(atomindex);
        if (!Util.isOxygen(atom)) {
            for (i = 0; i < atom.getBondCount(); ++i) {
                atom2 = atom.getBond(i).getOtherAtom(atom);
                if (!Util.isOxygen(atom2)) continue;
                atom = atom2;
                break;
            }
        }
        if (ligand.isLocantCalculated() && !Util.isOxygen(atom)) {
            for (i = 0; i < this.basicAtomCount; ++i) {
                atom2 = parentmol.getAtom(i);
                if (!Util.isOxygen(atom2) || atom2.getBondCount() != 1) continue;
                atom = parentmol.getAtom(i);
                break;
            }
        }
        if (!Util.isOxygen(atom)) {
            return false;
        }
        HeteroAtom s = new HeteroAtom(ss.getValue());
        s.nonStdValence.tryAddLocant(ligand.nonStdValence);
        this.addHeteroAtom(parentmol, parentmol.indexOf(atom), s);
        return true;
    }

    private int createLigand(Structure ligand, Molecule parentmol, boolean isaza, int attachpoint) {
        Molecule ligandMol = ligand.buildMolecule();
        parentmol.fuse(ligandMol);
        if (ligand instanceof FusedSystem && !isaza || ligand instanceof Oxime) {
            return ligand.getLocantInParent() != null && ligand.getLocantInParent().size() > 0 ? this.getAtomIndex(ligand.getLocantInParent().getLocant(0).getValue()) : 0;
        }
        return attachpoint;
    }

    private int setLocantAndGetItsTypeAtLigandAddition(Structure ligand, Locant locant) {
        if (ligand.getLocantInParent() != null) {
            if (locant instanceof SimpleLocant) {
                return 0;
            }
            if (locant instanceof AzaLocant) {
                AzaLocant aza = (AzaLocant)locant;
                Molecule mol = this.getStructure(aza.getParent()).buildMolecule();
                int index2 = aza.getParent() > 0 ? aza.getParent() : -1;
                boolean amideParent = ParserUtil.isAmide(this, false);
                locant.setValue(this.getNitrogeneIndex(mol, aza.getValue(), index2, amideParent));
                return 1;
            }
            if (locant instanceof AtomLocant) {
                Molecule mol = this.getStructure(0).buildMolecule();
                AtomLocant loc = (AtomLocant)locant;
                int locantIndex = loc.getLocantIndex();
                int[] flags = new int[1];
                int atomindex = this.getAtomBySymbol(mol, loc, locantIndex, flags);
                locant.setValue(atomindex);
                return 1;
            }
        }
        return 0;
    }

    protected boolean isRemovalGroup(Structure s) {
        if (!(s instanceof SimpleStructure)) {
            return false;
        }
        String name = ((SimpleStructure)s).getName();
        return name.equals(DEOXY);
    }

    protected boolean removeGroup(Structure s, MolAtom atomToRemoveFrom, Molecule mol) {
        String symbol = ((SimpleStructure)s).getValue().substring(1);
        for (int i = 0; i < atomToRemoveFrom.getBondCount(); ++i) {
            MolAtom atom = atomToRemoveFrom.getBond(i).getOtherAtom(atomToRemoveFrom);
            if (!atom.getSymbol().equals(symbol) || atom.getBondCount() != 1) continue;
            atom.setAliasstr(removeMark);
            return true;
        }
        if (atomToRemoveFrom.getSymbol().equals(symbol) && atomToRemoveFrom.getBondCount() == 1) {
            atomToRemoveFrom.setAliasstr(removeMark);
            return true;
        }
        return false;
    }

    protected void removeMarkedAtoms() {
        if (this.molecule == null) {
            return;
        }
        for (int i = 0; i < this.molecule.getAtomCount(); ++i) {
            String alias = this.molecule.getAtom(i).getAliasstr();
            if (alias == null || !alias.equals(removeMark)) continue;
            this.molecule.removeAtom(i--);
        }
    }

    private int indexOfAttachPointInChild(Locant locant, int locantType) {
        if (locantType > 0) {
            return locant.getValue();
        }
        if (locant.getParent() > 0 && this.getStructure(locant.getParent()) == this) {
            return this.getAtomIndex(Util.locantToInt(locant));
        }
        if (locant instanceof RingNumber) {
            return this.getStructure(locant.getParent()).getAtomIndex(Util.stringToLocant(locant.toString()));
        }
        return this.getStructure(locant.getParent()).getAtomIndex(locant.getValue());
    }

    private void removeAllRGroups() {
        this.rgroups.clear();
        if (this.molecule != null) {
            int i = this.molecule.getAtomCount();
            while (--i >= 0) {
                MolAtom a = this.molecule.getAtom(i);
                if (a.getAtno() != 134) continue;
                a.setAliasstr(removeMark);
            }
        }
    }

    private void removeGroup(int index) {
        this.removeAllRGroups();
    }

    protected void removeGroupFromMol(int atomIndex) {
        if (this.molecule == null) {
            return;
        }
        this.molecule.getAtom(atomIndex).setAliasstr(remRGroup);
    }

    protected void removeGroupFromMol(MolAtom atom) {
        atom.setAliasstr(remRGroup);
    }

    private int getAtomBySymbol(Molecule mol, AtomLocant atom, int locantIndex, int[] flags) {
        int atomindex;
        String symbol = atom.getAtomSymbol();
        if (locantIndex <= 0) {
            MolAtom a;
            int i;
            for (i = 0; i < mol.getAtomCount(); ++i) {
                a = mol.getAtom(i);
                if (!a.getSymbol().equals(symbol) || a.getImplicitHcount() <= 0 && a.getCharge() == 0) continue;
                return i;
            }
            for (i = 0; i < mol.getAtomCount(); ++i) {
                a = mol.getAtom(i);
                if (!a.getSymbol().equals(symbol)) continue;
                return i;
            }
        }
        if (mol.getAtom(atomindex = this.getAtomIndex(locantIndex)).getSymbol().equals(symbol)) {
            return atomindex;
        }
        ArrayList<Structure> ligands = this.getLigand(new SimpleLocant(locantIndex, 0));
        for (int i = 0; i < ligands.size(); ++i) {
            int index = ligands.get(i).getAtomBySymbol(ligands.get(i).buildMolecule(), atom, 0, flags);
            if (index <= -1) continue;
            MolAtom a = ligands.get(i).buildMolecule().getAtom(index);
            for (int j = 0; j < a.getBondCount(); ++j) {
                if (!this.isBasicAtom(a.getBond(j).getOtherAtom(a))) continue;
                flags[0] = this.molecule.indexOf(a.getBond(j));
            }
            return this.buildMolecule().indexOf(a);
        }
        return -1;
    }

    private ArrayList<Structure> getLigand(Locant loc) {
        int i;
        ArrayList<Structure> ligands = new ArrayList<Structure>();
        for (i = 0; i < this.suffixCount(); ++i) {
            if (!this.getSuffix(i).getLocant().contains(loc) || this.getSuffix(i).getStructure() == null) continue;
            ligands.add(this.getSuffix(i).getStructure());
        }
        for (i = 0; i < this.substituentCount(); ++i) {
            if (!this.getSubstituent(i).getLocantInParent().contains(loc)) continue;
            ligands.add(this.getSubstituent(i));
        }
        return ligands;
    }

    private int getNitrogeneIndex(Molecule mol, int index, int index2, boolean amideParent) {
        int atom;
        MolAtom a;
        int i;
        int last = -1;
        if (this instanceof Amine && index2 > 0) {
            int atomindex = this.getAtomIndex(index2);
            return atomindex;
        }
        if (!amideParent && !this.nitrogensForNConnections.isEmpty()) {
            int i2;
            for (i2 = 1; i2 < this.nitrogensForNConnections.size(); ++i2) {
                Locant loc = this.nitrogensForNConnections.get(i2).getSecond();
                if (loc.getValue() != index2) continue;
                MolAtom atom2 = this.nitrogensForNConnections.get(i2).getFirst();
                return mol.indexOf(atom2);
            }
            i2 = this.nitrogensForNConnections.size() <= index ? this.nitrogensForNConnections.size() - 1 : index;
            MolAtom atom3 = this.nitrogensForNConnections.get(i2).getFirst();
            return mol.indexOf(atom3);
        }
        if (amideParent || index2 < 1) {
            for (i = 0; i < mol.getAtomCount(); ++i) {
                if (!Util.isNitrogen(mol.getAtom(i))) continue;
                if (index == 0) {
                    return i;
                }
                last = i;
                --index;
            }
        } else if (index2 > 0) {
            for (i = 0; i < mol.getAtomCount(); ++i) {
                a = mol.getAtom(i);
                if (!Util.isNitrogen(a) || a.getAliasstr() == null || !a.getAliasstr().equals(Integer.toString(index))) continue;
                last = i;
                if (--index2 != 0) continue;
                return i;
            }
        }
        if (last == -1 && (atom = this.getAtomIndex(index2)) != -1) {
            a = mol.getAtom(atom);
            if (Util.isNitrogen(a)) {
                return atom;
            }
            for (MolAtom ligand : a.getLigands()) {
                if (!Util.isNitrogen(ligand)) continue;
                return mol.indexOf(ligand);
            }
        }
        return last;
    }

    protected int addBonds(Molecule mol, Structure s, int index, boolean spaceSep, int locantindex, boolean[] bondAdded, boolean cloned) {
        int count;
        int index1;
        block20: {
            int mul;
            block21: {
                block19: {
                    bondAdded[locantindex] = false;
                    mul = 1;
                    index1 = s.getDefaultAtomIndex();
                    count = -1;
                    if (!(s instanceof Bridge)) break block19;
                    this.addBridge(mol, s, index, spaceSep, locantindex);
                    bondAdded[locantindex] = true;
                    break block20;
                }
                if (!s.radicals.isEmpty()) break block21;
                if (!s.rgroups.isEmpty()) {
                    index1 = s.getAtomIndex(s.rgroups.get((int)0).neighbours.get(0));
                } else if (s instanceof SimpleStructure && ((SimpleStructure)s).locantsBefore != null) {
                    index1 = s.getAtomIndex(((SimpleStructure)s).locantsBefore.getSimpleLocant());
                }
                if (!this.bondNeeded(s, index1, mol, index)) break block20;
                this.checkBond(s);
                bondAdded[locantindex] = true;
                this.addBond(mol, mol.getAtom(index), s.buildMolecule().getAtom(index1), mul);
                if (mol.getAtom(index).getCharge() != -1 || !Util.isOxygen(mol.getAtom(index)) || s.buildMolecule().getAtom(index1).getCharge() < 0) break block20;
                mol.getAtom(index).setCharge(0);
                break block20;
            }
            if (s.radicals.size() > locantindex || cloned) {
                int radIndex = s.radicals.size() > locantindex ? locantindex : 0;
                Suffix suff = s.radicals.get(radIndex);
                LocantList list = suff.getLocant();
                for (int i = 0; i < list.size(); ++i) {
                    SimpleLocant l = (SimpleLocant)list.getLocant(i);
                    index1 = s.getAtomIndex(l);
                    if (suff.getValue().endsWith("=")) {
                        mul = 2;
                    } else if (suff.getValue().endsWith("#")) {
                        mul = 3;
                    }
                    if (this instanceof MultipliedSpiroSystem && suff.getLocant().size() <= s.getLocantInParent().size() && suff.getLocant().size() > 1) {
                        int mind = s.getLocantInParent().getLocant(i + locantindex).getParent();
                        mol = this.getMolecule(mind);
                        index = this.getAtomIndex(s.getLocantInParent().getLocant(i + locantindex));
                        ++count;
                    }
                    if (this.bondNeeded(s, index1, mol, index)) {
                        this.checkBond(s);
                        bondAdded[locantindex] = true;
                        MolAtom cAtom = s.getMolecule(l.getParent()).getAtom(index1);
                        MolAtom pAtom = mol.getAtom(index);
                        if (this instanceof Amine && this.parent == null && !this.atomMap.containsValue(index)) {
                            this.atomMap.put(s.getMappedIndex(index1), index);
                        }
                        if (cAtom.getImplicitHcount() < mul && pAtom.getImplicitHcount() > 0) {
                            mol.aromatize();
                            this.addBond(mol, pAtom, cAtom, mul);
                            mol.dearomatize();
                        } else {
                            this.addBond(mol, pAtom, cAtom, mul);
                        }
                        if (pAtom.getCharge() == -1 && Util.isOxygenOrAnalog(pAtom) && cAtom.getCharge() >= 0) {
                            this.extraOxygenCheck(pAtom, cAtom);
                            pAtom.setCharge(0);
                        } else if (this.hasAcetateEnding() && spaceSep) {
                            pAtom.setCharge(0);
                        } else if (mul == 2 && Util.isAtom(pAtom, 6) && pAtom.hasAromaticBond()) {
                            this.removeAromaticBondsWhenDoublebondAdded(pAtom, cAtom, mul);
                        }
                    }
                    if (!(this instanceof Amine)) continue;
                    ++index;
                }
            }
        }
        s.removeGroupFromMol(index1);
        if (this.rgroups.isEmpty()) {
            this.removeGroupFromMol(index);
        }
        return Math.max(count, 0);
    }

    private void checkBond(Structure s) {
        if (this instanceof AggregateStructure || s instanceof AggregateStructure) {
            throw new NameImportException("Bond with a multiplied structure");
        }
    }

    private void addBond(Molecule m, MolAtom structureAtom, MolAtom externalAtom, int multiplicity) {
        int flags = this.computeBondType(m, structureAtom, multiplicity);
        this.handleEsterConnection(structureAtom);
        Util.addBond(m, structureAtom, externalAtom, flags);
    }

    private int computeBondType(Molecule m, MolAtom sourceAtom, int multiplicity) {
        if (multiplicity != 1) {
            return multiplicity;
        }
        if (!this.isCis() && !this.isTrans()) {
            return 1;
        }
        if (!Util.isRingAtom(sourceAtom)) {
            return 1;
        }
        int stereo = this.getCurrentStereoLigand(m);
        int numLigands = this.substituentList.size() + this.suffixCountWithMultiplicity();
        if (stereo != 0) {
            ++numLigands;
        }
        if (numLigands != 2) {
            return 1;
        }
        if (stereo == 0) {
            assert (this.cisTransLigandCount == 0);
            stereo = 528;
        }
        if (this.isTrans()) {
            stereo = Structure.invertUpDown(stereo);
        }
        return 1 | stereo;
    }

    private static int invertUpDown(int stereo) {
        if ((stereo & 0x10) != 0) {
            return 0x20 | stereo & 0x200;
        }
        return 0x10 | stereo & 0x200;
    }

    private MolBond getNonRingBond(MolAtom fromAtom) {
        MoleculeGraph m = fromAtom.getParent();
        int i = fromAtom.getBondCount();
        while (--i >= 0) {
            MolBond b = fromAtom.getBond(i);
            if (m.isRingBond(m.indexOf(b))) continue;
            return b;
        }
        return null;
    }

    private int getUpDownBond(MolAtom fromAtom) {
        MoleculeGraph m = fromAtom.getParent();
        if (m.getDim() == 0) {
            m.clean(2, null);
        }
        int i = fromAtom.getBondCount();
        while (--i >= 0) {
            MolBond b = fromAtom.getBond(i);
            int stereo = b.getFlags() & 0x30;
            if (stereo == 0) continue;
            if (b.getAtom1().getStereoGroupType() == 2 || b.getAtom2().getStereoGroupType() == 2) {
                stereo |= 0x200;
            }
            return stereo;
        }
        return 0;
    }

    private int getCurrentStereoLigand(Molecule m) {
        if (m.getDim() == 0) {
            m.clean(2, null);
        }
        int i = m.getBondCount();
        while (--i >= 0) {
            MolBond b = m.getBond(i);
            int stereo = b.getFlags() & 0x30;
            if (stereo == 0) continue;
            if (b.getAtom1().getStereoGroupType() == 2 || b.getAtom2().getStereoGroupType() == 2) {
                stereo |= 0x200;
            }
            return stereo;
        }
        return 0;
    }

    boolean isCis() {
        return this.stereoLocants.isCis();
    }

    boolean isTrans() {
        return this.stereoLocants.isTrans();
    }

    private void addBridge(Molecule mol, Structure s, int index, boolean spaceSep, int locantindex) {
        int index1 = s.getAtomIndex(1);
        int mul = 1;
        if (s.suffixCount() > locantindex && s.getAtomCount() == 1) {
            String suff = s.getSuffix(0).getValue();
            if (suff.endsWith("=")) {
                mul = 2;
            } else if (suff.endsWith("#")) {
                mul = 3;
            }
        }
        if (!s.radicals.isEmpty() && s.radicals.get(0).getLocant().size() > locantindex) {
            index1 = s.radicals.get(0).getLocant().getLocant(locantindex).getValue();
            index1 = s.getAtomIndex(index1);
        } else if (locantindex > 0) {
            index1 = s.getAtomIndex(s.getAtomCount());
        }
        Util.addBond(mol, s.buildMolecule().getAtom(index1), mol.getAtom(index), mul);
    }

    protected void extraOxygenCheck(MolAtom pAtom, MolAtom cAtom) {
        if (pAtom.getCharge() >= 0 || !Util.isOxygen(pAtom) || !cAtom.hasValenceError()) {
            return;
        }
        for (int i = 0; i < cAtom.getBondCount(); ++i) {
            MolBond bond = cAtom.getBond(i);
            MolAtom otherAtom = bond.getOtherAtom(cAtom);
            if (bond.getType() != 1 || !Util.isOxygen(otherAtom) || otherAtom.getBondCount() != 1) continue;
            this.molecule.removeAtom(otherAtom);
        }
    }

    protected void handleEsterConnection(MolAtom atom) {
        if (!Util.isOxygenOrAnalog(atom)) {
            return;
        }
        if (atom.getBondCount() != 1 || atom.getBond(0).getType() != 2) {
            return;
        }
        MolAtom center = atom.getLigand(0);
        for (int i = 0; i < center.getBondCount(); ++i) {
            MolAtom ion = center.getLigand(i);
            if (ion == atom || !Util.isOxygenOrAnalog(ion) || ion.getCharge() != -1) continue;
            atom.getBond(0).setType(1);
            center.getBond(i).setType(2);
            ion.setCharge(0);
        }
    }

    private void removeAromaticBondsWhenDoublebondAdded(MolAtom pAtom, MolAtom cAtom, int mul) {
        if (mul == 2 && Util.isAtom(pAtom, 6) && pAtom.hasAromaticBond()) {
            for (int j = 0; j < pAtom.getBondCount(); ++j) {
                if (Util.isNitrogen(cAtom) && cAtom.getCharge() > 0) {
                    pAtom.getBondTo(cAtom).setType(1);
                    continue;
                }
                if (pAtom.getBond(j).getType() < 4) continue;
                pAtom.getBond(j).setType(1);
            }
        }
    }

    boolean hasAcetateEnding() {
        for (int i = 0; i < this.suffixCount(); ++i) {
            if (this.getSuffix(i).getType() != 4) continue;
            return true;
        }
        return false;
    }

    protected boolean bondNeeded(Structure child, int index1, Molecule parent, int index2) {
        String childname;
        boolean hasRadical = !child.radicals.isEmpty();
        boolean spaceSeparated = child.spaceSeparated;
        MolAtom parentAtom = parent.getAtom(index2);
        MolAtom childAtom = child.buildMolecule().getAtom(index1);
        String string = childname = child.getName() == null ? "" : child.getName();
        if (hasRadical) {
            return true;
        }
        child.buildMolecule().valenceCheck();
        if (this.isChargedNOConnection(parentAtom, childAtom)) {
            return false;
        }
        if (child.isSpaceSeparated() && childname.contains("acid")) {
            return false;
        }
        if (child.isSpaceSeparated() && child.isMetal()) {
            return false;
        }
        if (!(child.getLocantInParent() != null && childAtom.getImplicitHcount() != 0 || childAtom.getCharge() == 0 || childAtom.hasValenceError())) {
            return false;
        }
        if (!(Util.isOxygen(parentAtom) && parentAtom.getCharge() == -1 || child.getLocantInParent() != null)) {
            return false;
        }
        if (!spaceSeparated && parentAtom.getCharge() != 0 && childAtom.getCharge() != 0 && Util.isNitrogen(parentAtom) && Util.isOxygen(childAtom) || Util.isOxygen(parentAtom) && Util.isNitrogen(childAtom)) {
            return true;
        }
        if (!(childAtom.getCharge() <= 0 && parentAtom.getCharge() == 0 || !spaceSeparated && !this.hasIonNeighbour(parent, index2) || Util.isOxygen(parentAtom))) {
            return false;
        }
        if (!this.canHasBond(parentAtom, childAtom)) {
            return false;
        }
        return childAtom.getCharge() == 0 || parentAtom.getCharge() == 0;
    }

    boolean isMetal() {
        Molecule m = this.getMolecule();
        if (m.getAtomCount() != 1) {
            return false;
        }
        MolAtom a = m.getAtom(0);
        return PeriodicSystem.isMetal(a.getAtno());
    }

    private boolean isChargedNOConnection(MolAtom atom1, MolAtom atom2) {
        if (atom1.getAtno() == 8 && atom1.getCharge() < 0 && atom2.getAtno() == 7 && atom2.getCharge() > 0) {
            return true;
        }
        return atom2.getAtno() == 8 && atom1.getCharge() < 0 && atom1.getAtno() == 7 && atom1.getCharge() > 0;
    }

    private boolean canHasBond(MolAtom atom1, MolAtom atom2) {
        if (Util.isAtom(atom1, 6) || Util.isAtom(atom2, 6)) {
            return true;
        }
        if (Util.isAtom(atom1, 17) || Util.isAtom(atom2, 17)) {
            return true;
        }
        IntVector noBond = new IntVector(new int[]{25, 28});
        return !noBond.contains(atom1.getAtno()) && !noBond.contains(atom2.getAtno());
    }

    private boolean hasIonNeighbour(Molecule mol, int index) {
        MolAtom atom = mol.getAtom(index);
        for (int i = 0; i < atom.getBondCount(); ++i) {
            MolBond b = mol.getAtom(index).getBond(i);
            MolAtom a = b.getOtherAtom(atom);
            if (a.getCharge() == 0 || a.getBondCount() != 1) continue;
            return true;
        }
        return false;
    }

    protected abstract String toSmiles();

    public int getAtomIndex(Locant locant) {
        return this.getAtomIndex(locant.getValue(), locant.getParent());
    }

    public int getAtomIndex(int mappedIndex) {
        return this.getAtomIndex(mappedIndex, 0);
    }

    protected int getAtomIndex(int mappedIndex, int molindex) {
        if (this.getStructure((int)molindex).atomMap.isEmpty()) {
            return Math.max(mappedIndex - 1, 0);
        }
        try {
            SimpleLocant sl;
            if (this.getStructure(molindex).equals(this) && this.hasLocant(sl = new SimpleLocant(mappedIndex, molindex))) {
                return this.atomMap.get(Util.locantToInt(sl));
            }
            Integer res = this.getStructure((int)molindex).atomMap.get(mappedIndex);
            if (res == null) {
                return -1;
            }
            return res;
        }
        catch (Exception e) {
            throw new NameImportException("Invalid locant: " + mappedIndex);
        }
    }

    protected int getMappedIndex(int atomIndex) {
        if (this.atomMap.isEmpty()) {
            return atomIndex + 1;
        }
        if (this.atomMap.containsValue(new Integer(atomIndex))) {
            Set<Integer> set = this.atomMap.keySet();
            Iterator<Integer> it = set.iterator();
            Integer value = new Integer(atomIndex);
            while (it.hasNext()) {
                Integer key = it.next();
                if (!value.equals(this.atomMap.get(key))) continue;
                return key;
            }
        }
        return -1;
    }

    protected int getAtomIndex0(int mappedIndex) {
        if (this.atomMap.isEmpty()) {
            return mappedIndex - 1;
        }
        return this.atomMap.get(new Integer(mappedIndex));
    }

    public int getAtomIndex(int mappedIndex, Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            String aliasstr = mol.getAtom(i).getAliasstr();
            if (aliasstr == null || new Integer(aliasstr) != mappedIndex) continue;
            return i;
        }
        return mappedIndex - 1;
    }

    protected void setAtomMap(String smiles) {
        if (smiles.indexOf(32) < 0 || !this.atomMap.isEmpty()) {
            return;
        }
        int startOfNumbering = smiles.lastIndexOf("|$") + 2;
        int endOfNumbering = smiles.indexOf("$", startOfNumbering);
        String map = smiles.substring(startOfNumbering, endOfNumbering);
        String[] locantList = map.split(";");
        int numbering = 90;
        for (int i = 0; i < locantList.length; ++i) {
            String[] locants = locantList[i].split(",");
            for (int j = 0; j < locants.length; ++j) {
                if (locants[j].equals("_")) {
                    this.atomMap.put(numbering++, i);
                    continue;
                }
                if (locants[j].length() <= 0) continue;
                this.atomMap.put(new Integer(Util.stringToLocant(locants[j])), new Integer(i));
            }
        }
    }

    protected void setAtomMap(IntVector atomnumbering) {
        for (int i = 0; i < atomnumbering.size(); ++i) {
            this.atomMap.put(atomnumbering.get(i), i);
        }
    }

    protected void connectSuffix(Suffix suffix) {
        this.hydroxyDuplicationCheck(suffix);
        if (suffix.getLocant() == null || suffix.getLocant().size() < suffix.getMultiplicity()) {
            this.calcLocants(suffix);
        }
        for (int j = 0; j < suffix.getMultiplicity(); ++j) {
            int second;
            Locant locant = suffix.getLocant().getLocant(j);
            Molecule m = null;
            if (locant instanceof AtomLocant) {
                locant = this.getPlaceOfAtom((AtomLocant)locant);
                suffix.setLocant(locant);
            }
            if (locant instanceof SimpleLocant) {
                m = this.getMolecule(locant.getParent());
                if (this.addSuffix(m, suffix, locant, -1)) continue;
                throw new NameImportException("Invalid numbering. (" + locant + ")");
            }
            if (!(locant instanceof BondNumber)) continue;
            SimpleLocant l1 = ((BondNumber)locant).getFirstLocant();
            SimpleLocant l2 = ((BondNumber)locant).getSecondLocant();
            m = this.getStructure(l1.getParent()).buildMolecule();
            int n = second = l2 == null ? -1 : l2.getValue();
            if (this.addSuffix(m, suffix, l1, second)) continue;
            throw new NameImportException("Invalid numbering. (" + locant + ")");
        }
    }

    protected void hydroxyDuplicationCheck(Suffix suffix) {
        if (suffix.getType() == 4 && this.removalHydroxyGroups == null) {
            this.removalHydroxyGroups = new ArrayList();
            for (int j = 0; j < this.substituentCount(); ++j) {
                if (!this.getSubstituent(j).isSpaceSeparated()) continue;
                this.removeExtraHydroxyGroup(this.getSubstituent(j), "O", this.removalHydroxyGroups);
            }
        }
    }

    private SimpleLocant getPlaceOfAtom(AtomLocant atomLocant) {
        if (this.molecule != null) {
            for (int i = 0; i < this.molecule.getAtomCount(); ++i) {
                if (!this.molecule.getAtom(i).getSymbol().equals(atomLocant.getAtomSymbol())) continue;
                int mappedIndex = this.getMappedIndex(i);
                if (mappedIndex < 0) {
                    mappedIndex = this.getMaxLocant() + 1;
                    this.atomMap.put(mappedIndex, i);
                }
                return new SimpleLocant(mappedIndex);
            }
        }
        return new SimpleLocant(1);
    }

    private boolean saltOrAmineOrIon(Suffix suffix) {
        boolean acid;
        String smiles = suffix.getValue();
        boolean salt = smiles.startsWith("-") || smiles.startsWith("+") || smiles.equals("[SALT]");
        boolean amine = smiles.indexOf(78) > -1;
        boolean ion = suffix.getType() == 7;
        boolean bl = acid = suffix.getType() == 0;
        if ("at".equals(suffix.getName())) {
            // empty if block
        }
        boolean acetate = false;
        return salt || amine || ion || acid || acetate;
    }

    protected int getMinLocant() {
        for (int i = 1; i < this.basicAtomCount; ++i) {
            if (!this.atomMap.isEmpty() && !this.atomMap.containsKey(new Integer(i)) || this.noAttach.contains(i)) continue;
            return i;
        }
        return 1;
    }

    protected void calcLocants(ArrayList<Structure> list) {
        if (!(this.getFirstSuffixWithoutLocant() != -1 || this.defaultLigandNumbering == null || this.hasConnectionPoint() && this.parent != null || this.defaultLigandNumbering.size() != list.size())) {
            for (Structure s : list) {
                s.setLocantCalculated(true);
                s.setLocantInParent(this.defaultLigandNumbering.removeLocant(0));
            }
            return;
        }
        this.locantCalculator.calcLocantsForLigands(list);
    }

    protected int calcParentIndex() {
        return 0;
    }

    protected boolean isHydro(Structure s) {
        return s instanceof SimpleStructure && ((SimpleStructure)s).getValue().equals("[H+]");
    }

    protected int ImplicitHCount(int parent, int index) {
        Molecule mol = this.getStructure(parent).buildMolecule();
        MolAtom atom = mol.getAtom(this.getAtomIndex(index));
        if (atom == null) {
            return -1;
        }
        int HCount = atom.getImplicitHcount() + atom.getExplicitHcount();
        boolean needRadical = this.needRadical(index);
        for (int i = 0; needRadical && i < this.radicals.size(); ++i) {
            Suffix s = this.radicals.get(i);
            LocantList list = s.getLocant();
            for (int j = 0; j < list.size(); ++j) {
                Locant l = list.getLocant(i);
                if (!(l instanceof SimpleLocant) || ((SimpleLocant)l).getParent() != parent || ((SimpleLocant)l).getValue() != index) continue;
                int mul = 1;
                if (s.getValue().endsWith("=")) {
                    mul = 2;
                }
                if (s.getValue().endsWith("#")) {
                    mul = 3;
                }
                HCount -= mul;
            }
        }
        return HCount;
    }

    protected boolean needRadical(int index) {
        return !this.hasConnectionPoint() || this.getParent() != null;
    }

    protected void calcLocants(Suffix suffix) {
        Suffix s;
        suffix.setLocantCalculated(true);
        int index = this.suffixList.indexOf(suffix);
        if (index > 0 && (s = this.suffixList.get(index - 1)).getType() == 2 && !this.realRadical(s) && s.getLocant() != null && s.getLocant().size() > 0) {
            suffix.setLocant(s.getLocant());
            return;
        }
        if (!(this.defaultSuffixNumbering == null || this.hasConnectionPoint() && this.parent != null)) {
            if (this.defaultSuffixNumbering.size() != suffix.getMultiplicity()) {
                throw new NameImportException("Invalid ending: " + suffix);
            }
            suffix.setLocant(this.defaultSuffixNumbering);
            this.defaultSuffixNumbering = new LocantList();
            return;
        }
        this.locantCalculator.calcLocantForSuffixes(suffix);
    }

    protected void getIonNumbers(IntVector vec) {
        vec.addAll(this.spaceAttach);
    }

    protected void getAtomNumbers(IntVector vec) {
        this.getAtomNumbers(vec, -1);
    }

    protected void getAtomNumbers(IntVector vec, int radMul) {
        if (!this.atomMap.isEmpty()) {
            Set<Integer> locants = this.atomMap.keySet();
            Iterator i = locants.iterator();
            while (i.hasNext()) {
                MolAtom atom;
                int num = (Integer)i.next();
                if (num < 100 && this.canAttach(num) && this.ImplicitHCount(0, num) > 0) {
                    vec.add(num);
                    continue;
                }
                if (radMul <= 0 || this.molecule == null || (atom = this.molecule.getAtom(this.getAtomIndex(num))).hasAromaticBond() || !this.isDefaultValence(atom, atom.getValence() + radMul)) continue;
                vec.add(num);
            }
        } else {
            int acount = this.getStructure((int)0).basicAtomCount;
            for (int i = 0; i < this.getStructure((int)0).basicAtomCount; ++i) {
                MolAtom atom;
                if ((acount == 1 || this.ImplicitHCount(0, i + 1) > 0) && this.canAttach(i + 1)) {
                    vec.add(i + 1);
                    continue;
                }
                if (radMul <= 0 || this.molecule == null || (atom = this.molecule.getAtom(i)).hasAromaticBond() || !this.isDefaultValence(atom, atom.getValence() + radMul)) continue;
                vec.add(i + 1);
            }
        }
        if (vec.isEmpty()) {
            vec.add(1);
        }
        vec.sort();
    }

    protected void getAtomNumbersForHeteroAtom(IntVector vec) {
        if (!this.atomMap.isEmpty()) {
            Set<Integer> locants = this.atomMap.keySet();
            Iterator i = locants.iterator();
            while (i.hasNext()) {
                int num = (Integer)i.next();
                vec.add(num);
            }
        } else {
            for (int i = 0; i < this.getStructure((int)0).basicAtomCount; ++i) {
                vec.add(i + 1);
            }
        }
        if (vec.isEmpty()) {
            vec.add(1);
        }
        vec.sort();
    }

    protected void getAtomNumbersForCharge(IntVector vec) {
        if (!this.atomMap.isEmpty()) {
            Set<Integer> locants = this.atomMap.keySet();
            Iterator i = locants.iterator();
            while (i.hasNext()) {
                int num = (Integer)i.next();
                if (num >= 100 || !this.canAttach(num)) continue;
                vec.add(num);
            }
        } else {
            int acount = this.getStructure((int)0).basicAtomCount;
            for (int i = 0; i < this.getStructure((int)0).basicAtomCount; ++i) {
                if (acount != 1 && this.ImplicitHCount(0, i + 1) <= 0 || !this.canAttach(i + 1)) continue;
                vec.add(i + 1);
            }
        }
        if (vec.isEmpty()) {
            vec.add(1);
        }
        vec.sort();
    }

    protected int getMaxLocant() {
        if (!this.atomMap.isEmpty()) {
            int max = 1;
            Set<Integer> locants = this.atomMap.keySet();
            Iterator i = locants.iterator();
            while (i.hasNext()) {
                int num = (Integer)i.next();
                max = num > max && num < 100 ? num : max;
            }
            return max;
        }
        return this.basicAtomCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean addSuffix(Molecule mol, Suffix s, Locant locant1, int locant2) {
        String suffix;
        String string = suffix = s.getValue().indexOf(123) < 0 ? s.getValue() : s.getValue().substring(0, s.getValue().indexOf("{"));
        if (suffix.length() < 1 && s.getType() != 8) {
            return true;
        }
        int a1 = this.getAtomIndex(locant1);
        if (mol.getAtomCount() <= a1) return false;
        MolAtom molAtom = mol.getAtom(a1);
        MolAtom atom1 = molAtom;
        if (atom1 == null) {
            return false;
        }
        if (Util.isOxygen(atom1) && s.getName().startsWith("hydrazid")) {
            s.setValue("&NN");
        }
        if (s.getType() == 8) {
            s.getStructure().setLocantInParent(s.getLocant());
            s.getStructure().setParent(this);
            this.addLigand(s.getStructure());
            return true;
        }
        if (suffix.startsWith("|") && Util.atomCount(suffix) > 0) {
            this.addRadical(s);
            suffix = suffix.substring(1);
            s.setValue(s.getValue().substring(1));
        }
        int mul = s.getRadical();
        if (s.getName() != null && s.getName().startsWith("ylen") && this.parent == null) {
            if (this.getFirstSuffixWithStructureProp() > -1) return true;
            if (this.hasDiamineSuffix()) return true;
            if (this.hasCloneLigands()) {
                return true;
            }
        }
        if (suffix.equals("=") || suffix.equals("#")) {
            MolBond bond;
            MolAtom atom2 = this.getAtom2(locant1, locant2, mol);
            MolBond molBond = bond = atom2 != null ? atom1.getBondTo(atom2) : null;
            if (this.basicAtomCount != 1 && bond != null) {
                bond.setType(mul);
                return true;
            } else {
                if (locant1.getValue() != 1) throw new NameImportException("Invalid numbering for bond: " + locant1 + "(" + locant2 + ")");
                if (this.basicAtomCount != 1) throw new NameImportException("Invalid numbering for bond: " + locant1 + "(" + locant2 + ")");
                if (mul <= 1) throw new NameImportException("Invalid numbering for bond: " + locant1 + "(" + locant2 + ")");
                s.setValue("|" + suffix);
                this.addRadical(s);
            }
            return true;
        } else if (suffix.startsWith("+")) {
            atom1.setCharge(atom1.getCharge() + 1);
            if (suffix.equalsIgnoreCase("+h-")) {
                this.setNonStdValence();
                atom1.setValenceProp(atom1.getValence() - 1);
            }
            if (!suffix.equalsIgnoreCase("+h+")) return true;
            if (Util.isNitrogen(atom1)) return true;
            int v = atom1.getValence();
            atom1.setValenceProp(v + 1);
            return true;
        } else if (!(s instanceof SaltEnding) && suffix.equalsIgnoreCase("[SALT]")) {
            atom1.setCharge(atom1.getCharge() - 1);
            return true;
        } else {
            if (suffix.equalsIgnoreCase("[ION]")) return true;
            if (suffix.startsWith("-")) {
                atom1.setCharge(atom1.getCharge() - 1);
                if (suffix.equalsIgnoreCase("-h-")) {
                    atom1.setValenceProp(atom1.getValence() + 1);
                    return true;
                } else {
                    if (!suffix.equalsIgnoreCase("-h+")) return true;
                    atom1.setValenceProp(atom1.getValence() - 1);
                }
                return true;
            } else if (suffix.startsWith("|")) {
                this.addRadical(s);
                return true;
            } else {
                boolean noRepair;
                if (suffix.length() <= 0) return true;
                SimpleStructure ss = s.buildStructure();
                if (s instanceof SaltEnding && this.molecule != null && this.molecule.getAtom(0).getCharge() == 0) {
                    mul = Math.max(ss.getMolecule().getAtom(0).getImplicitHcount(), 1);
                }
                Molecule suff = ss.buildMolecule();
                if (s.getType() == 0) {
                    this.markHydroxy(suff);
                }
                s.setStructure(ss);
                if (s.getType() == 5 || s.getType() == 1) {
                    for (int i = 0; i < ss.getAtomCount(); ++i) {
                        if (!Util.isNitrogen(ss.buildMolecule().getAtom(i))) continue;
                        this.nitrogensForNConnections.add(new Pair<MolAtom, Locant>(ss.buildMolecule().getAtom(i), locant1));
                    }
                }
                boolean bl = noRepair = mul > 0;
                if (mul <= 0 && (s.getType() == 2 || suff.getAtom(0).getImplicitHcount() > 0 && ss.radicals.isEmpty() && ss.spaceAttach.isEmpty())) {
                    noRepair = true;
                }
                boolean b = false;
                if (s instanceof SaltEnding) {
                    if (((SaltEnding)s).hasHydro()) {
                        b = true;
                    } else if (atom1.getCharge() != 0) {
                        suff.getAtom(0).setCharge(-1);
                        b = true;
                    } else if (this.getMoleculeCharge(this) > 0) {
                        suff.getAtom(0).setCharge(-1);
                        b = true;
                    } else if (this.parent != null && this.parent.basicAtomCount == 1 && this.getMoleculeCharge(this.parent) > 0) {
                        suff.getAtom(0).setCharge(-1);
                    }
                }
                this.fuseSuffix(mol, atom1, locant1, ss, suff, s, mul, noRepair, b);
            }
        }
        return true;
    }

    protected int markHydroxy(Molecule mol) {
        int count = 0;
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (atom.getAtno() != 8 || atom.getImplicitHcount() != 1) continue;
            atom.setAliasstr(HYDROXY);
            ++count;
        }
        return count;
    }

    private boolean hasCloneLigands() {
        for (int i = 0; i < this.substituentCount() - 1; ++i) {
            Structure clone1 = this.getSubstituent(i).getCloneOf();
            Structure clone2 = this.getSubstituent(i + 1).getCloneOf();
            if (clone2 == null) continue;
            if (clone1 == null && clone2 == this.getSubstituent(i)) {
                return false;
            }
            if (clone1 != clone2) continue;
            return true;
        }
        return false;
    }

    boolean hasSuffix(String name) {
        int i = this.suffixCount();
        while (--i >= 0) {
            if (!name.equals(this.getSuffix(i).getName())) continue;
            return true;
        }
        return false;
    }

    boolean hasRadical() {
        return this.hasSuffix("yl") || this.hasSuffix("oyl") || this.getName().endsWith("yl");
    }

    boolean removeSuffix(String name) {
        int i = this.suffixCount();
        while (--i >= 0) {
            if (!name.equals(this.getSuffix(i).getName())) continue;
            this.removeSuffix(i);
            return true;
        }
        return false;
    }

    public boolean isChain() {
        return this.isChain;
    }

    boolean isYlene() {
        if (this.is("acetylene")) {
            return false;
        }
        if (!this.isChain()) {
            return false;
        }
        return this.nameEndsWith("ylene") || this.hasSuffix("ylene");
    }

    private boolean hasDiamineSuffix() {
        for (int i = 0; i < this.suffixCount(); ++i) {
            if (this.getSuffix(i).getType() != 1 || this.getSuffix(i).getMultiplicity() != 2) continue;
            return true;
        }
        return false;
    }

    private void fuseSuffix(Molecule parentMol, MolAtom parentAttachPoint, Locant parentAttachLocant, Structure childStructure, Molecule childMol, Suffix childSuffix, int mul, boolean noRepair, boolean fuseOnly) {
        if (mul <= 0) {
            mul = this.fixConnectionAtRings(parentAttachPoint, noRepair, parentMol, childStructure, parentAttachLocant);
        }
        MolAtom childAtom = childMol.getAtom(0);
        if (mul > 0) {
            if (Structure.isProton(parentMol)) {
                parentMol.clear();
                childAtom.setCharge(childAtom.getCharge() + 1);
            } else {
                if (!fuseOnly) {
                    if (childSuffix.getType() == 4) {
                        this.repairBeforeAcetateAttached(parentMol, childStructure, parentAttachLocant);
                    }
                    if (this.addBond(childSuffix)) {
                        this.addBond(parentMol, parentAttachPoint, childAtom, mul);
                        this.removeGroupFromMol(parentAttachPoint);
                        this.removeAromaticBondsWhenDoublebondAdded(parentAttachPoint, childAtom, mul);
                    }
                }
                parentMol.fuse(childMol);
            }
        } else {
            if (!noRepair) {
                this.repairBeforeSpiro(parentMol, childStructure, parentAttachLocant, true);
            }
            parentMol.fuse(childMol);
            RingUtil.createSpiroConnection(parentMol, parentAttachPoint, childAtom);
            this.removeGroupFromMol(parentAttachPoint);
        }
        this.removeGroupFromMol(childAtom);
        if (childSuffix.is("oyl") && this.isCyclic()) {
            this.atomMap.put(1, parentMol.indexOf(childMol.getAtom(0)));
        }
    }

    private int fixConnectionAtRings(MolAtom atom, boolean noRepair, Molecule mol, Structure struc, Locant loc) {
        boolean inRing;
        boolean bl = inRing = atom.sringsize() < Integer.MAX_VALUE;
        if (inRing || atom.hasAromaticBond()) {
            if (inRing && !noRepair) {
                this.repairBeforeSpiro(mol, struc, loc, false);
            }
            return 1;
        }
        return 0;
    }

    private boolean addBond(Suffix s) {
        String value = s.getValue();
        return !value.equals("[OH2]") && !this.equals("[OH-]");
    }

    private static boolean isProton(Molecule molecule) {
        if (molecule.getAtomCount() != 1) {
            return false;
        }
        MolAtom atom = molecule.getAtom(0);
        return Util.isAtom(atom, 1) && atom.getCharge() == 1;
    }

    private void addRadical(Suffix radical) {
        Suffix s;
        if (!this.realRadical(radical)) {
            return;
        }
        if (!this.radicals.isEmpty() && radical.getValue().equals("|") && !radical.isLocantCalculated() && (s = this.radicals.get(0)).isLocantCalculated()) {
            s.setLocant(radical.getLocant());
        } else if (!this.radicals.isEmpty() && (s = this.radicals.get(0)).getValue().equals("|") && !s.isLocantCalculated() && radical.isLocantCalculated()) {
            radical.setLocant(s.getLocant());
            this.radicals.remove(s);
            this.radicals.add(0, radical);
        } else {
            this.radicals.add(radical);
        }
    }

    private boolean realRadical(Suffix radical) {
        int index = this.suffixList.indexOf(radical);
        return !this.radicals.isEmpty() || !radical.getValue().equals("|") || this.getParent() != null || this.suffixCount() <= index + 1 || !this.getSuffix(index + 1).isLocantCalculated() || this.getSuffix(index + 1) instanceof SaltEnding;
    }

    protected MolAtom getAtom2(Locant locant1, int locant2, Molecule mol) {
        int numbering;
        if ((locant1.isGreekLetter() || !this.hasLocant(locant1)) && (numbering = Util.greekLetterToNumbering(locant1.getValue())) > -1) {
            locant1.setValue(numbering);
        }
        int atidx = -1;
        if (this.hasLocant(locant1)) {
            int n = atidx = locant2 > -1 ? this.getAtomIndex(locant2, locant1.getParent()) : this.getAtomIndex(locant1.getValue() + 1, locant1.getParent());
        }
        if (atidx > -1 && mol.getAtomCount() > atidx) {
            return mol.getAtom(atidx);
        }
        MolAtom atom = mol.getAtom(this.getAtomIndex(locant1));
        if (atom != null && atom.getBondCount() == 1) {
            return atom.getBond(0).getOtherAtom(atom);
        }
        return null;
    }

    protected int getMoleculeCharge(Structure s) {
        int i;
        if (this.moleculeCharge != 0 || this.molecule == null) {
            return this.moleculeCharge;
        }
        Molecule mol = s.buildMolecule();
        int charge = 0;
        for (i = 0; i < mol.getAtomCount(); ++i) {
            charge += mol.getAtom(i).getCharge();
        }
        for (i = 0; i < s.substituentCount(); ++i) {
            charge += this.getMoleculeCharge(s.getSubstituent(i));
        }
        this.moleculeCharge = charge;
        return charge;
    }

    protected void repairBeforeAcetateAttached(Molecule mol, Structure suffix, Locant oldlocant) {
        HashMap<Integer, Integer> atomMap = this.atomMap;
        int basicAtomCount = this.basicAtomCount;
        IntVector spaceAttach = this.spaceAttach;
        if (basicAtomCount == 0) {
            atomMap = this.getStructure((int)oldlocant.getParent()).atomMap;
            basicAtomCount = this.getStructure((int)oldlocant.getParent()).basicAtomCount;
            spaceAttach = this.getStructure((int)oldlocant.getParent()).spaceAttach;
        }
        if (atomMap.isEmpty()) {
            for (int i = 1; i < basicAtomCount + 1; ++i) {
                atomMap.put(new Integer(i), new Integer(i - 1));
            }
        }
        this.mapFunctionalGroup(suffix, oldlocant, mol, spaceAttach, atomMap);
    }

    protected void mapFunctionalGroup(Structure funcGroup, Locant oldlocant, Molecule mol, IntVector spaceAttach, HashMap<Integer, Integer> atomMap) {
        Molecule funcMol = funcGroup.buildMolecule();
        for (int i = 0; i < funcMol.getAtomCount(); ++i) {
            if (funcMol.getAtom(i).getCharge() >= 0) continue;
            atomMap.remove(new Integer(oldlocant.getValue()));
            int newlocant = i + mol.getAtomCount();
            atomMap.put(new Integer(oldlocant.getValue()), new Integer(newlocant));
            spaceAttach.add(oldlocant.getValue());
            if (oldlocant.getParent() <= 0) break;
            this.spaceAttach.add(oldlocant.getValue());
            break;
        }
    }

    public void buildAtomMap() {
        if (this.atomMap.isEmpty()) {
            for (int i = 1; i < this.basicAtomCount + 1; ++i) {
                this.atomMap.put(new Integer(i), new Integer(i - 1));
            }
        }
    }

    protected void repairBeforeSpiro(Molecule mol, Structure suffix, Locant oldlocant, boolean realSpiro) {
        int newlocant;
        int i;
        HashMap<Integer, Integer> atomMap = this.atomMap;
        int basicAtomCount = this.basicAtomCount;
        if (oldlocant.getParent() > 0) {
            atomMap = this.getStructure((int)oldlocant.getParent()).atomMap;
            basicAtomCount = this.getStructure((int)oldlocant.getParent()).basicAtomCount;
        }
        if (atomMap.isEmpty()) {
            for (int i2 = 1; i2 < basicAtomCount + 1; ++i2) {
                atomMap.put(new Integer(i2), new Integer(i2 - 1));
            }
        }
        if (!suffix.radicals.isEmpty()) {
            atomMap.remove(new Integer(oldlocant.getValue()));
            Suffix s = suffix.radicals.get(0);
            int newlocant2 = suffix.getAtomIndex(s.locant.getLocant(0).getValue());
            atomMap.put(new Integer(oldlocant.getValue()), new Integer(newlocant2 += realSpiro ? mol.getAtomCount() - 1 : mol.getAtomCount()));
            return;
        }
        boolean b = false;
        for (i = 0; i < suffix.buildMolecule().getAtomCount(); ++i) {
            if (suffix.buildMolecule().getAtom(i).getCharge() >= 0) continue;
            atomMap.remove(new Integer(oldlocant.getValue()));
            newlocant = i + mol.getAtomCount() - 1;
            atomMap.put(new Integer(oldlocant.getValue()), new Integer(newlocant));
            if (suffix.spaceAttach.size() > 0 && suffix.getAtomIndex(suffix.spaceAttach.get(0)) == i) {
                this.spaceAttach.add(oldlocant.getValue());
            }
            b = true;
            break;
        }
        if (b) {
            return;
        }
        for (i = suffix.basicAtomCount - 1; i > -1; --i) {
            if (!suffix.canAttach(i)) continue;
            atomMap.remove(new Integer(oldlocant.getValue()));
            newlocant = i + mol.getAtomCount() - 1;
            atomMap.put(new Integer(oldlocant.getValue()), new Integer(newlocant));
            break;
        }
    }

    protected Molecule readMol(String smiles) {
        Molecule mol = molCache.get(smiles);
        if (mol != null) {
            return mol.cloneMolecule();
        }
        try {
            mol = MolImporter.importMol(smiles, "cxsmiles");
            molCache.put(smiles, mol);
            return mol.cloneMolecule();
        }
        catch (MolFormatException e) {
            throw new NameImportException.Failure(e);
        }
    }

    protected abstract Structure getStructure(int var1);

    public void addHydro(Hydro h) {
        this.hydroList.add(h);
    }

    public Hydro getHydro(int i) {
        if (this.hydroList.size() > i) {
            return this.hydroList.get(i);
        }
        return null;
    }

    public void removeHydro(int i) {
        if (this.hydroList.size() > i) {
            this.hydroList.remove(i);
        }
    }

    public ArrayList<Hydro> getHydroList() {
        return this.hydroList;
    }

    public int hydroCount() {
        return this.hydroList.size();
    }

    protected void setBondsType(Molecule mol, int atomIndex, int bondType) {
        MolAtom atom = mol.getAtom(atomIndex);
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (Util.isOxygen(atom.getBond(i).getOtherAtom(atom))) continue;
            atom.getBond(i).setType(bondType);
        }
    }

    protected Molecule getMolecule(int index) {
        return this.getStructure(index).buildMolecule();
    }

    public void addAtomToNoAttach(int atomindex) {
        this.noAttach.add(atomindex);
    }

    public void addAllAtomToNoAttach(IntVector vec) {
        this.noAttach.addAll(vec);
    }

    protected IntVector getNoAttachPoints() {
        return this.noAttach;
    }

    protected boolean canAttach(int index) {
        if (this.hasSpaceSeparatedLigand() && this.spaceAttach.contains(index)) {
            return false;
        }
        if (this.atomMap.containsKey(new Integer(index)) && !this.noAttach.contains(index)) {
            return true;
        }
        return this.atomMap.isEmpty();
    }

    private boolean hasSpaceSeparatedLigand() {
        for (Structure ligand : this.getSubstituentList()) {
            if (!ligand.isSpaceSeparated()) continue;
            return true;
        }
        return false;
    }

    public void addAtomToSpaceAttach(int atomindex) {
        this.spaceAttach.add(atomindex);
    }

    public void addAllAtomToSpaceAttach(IntVector vec) {
        this.spaceAttach.addAll(vec);
    }

    protected IntVector getSpaceAttachPoints() {
        return this.spaceAttach;
    }

    protected void handleFlags(Structure struc, String[] flags) {
        if (flags == null) {
            return;
        }
        for (int i = 0; i < flags.length; ++i) {
            String value;
            flags[i] = flags[i].trim();
            int ind = flags[i].indexOf(58);
            String keyWord = ind > -1 ? flags[i].substring(0, ind).trim() + ':' : flags[i];
            String string = value = ind > -1 ? flags[i].substring(ind + 1).trim() : "";
            if (keyWord.equals("ConnectionPoint:")) {
                int cp = Integer.parseInt(value);
                Util.addSuffix(struc, "yl", "|", cp);
                this.connectionPoint = this.getSuffix(this.suffixCount() - 1);
                continue;
            }
            if (keyWord.equals("NoAttach:")) {
                String[] atomindexes = value.split(" ");
                for (int j = 0; j < atomindexes.length; ++j) {
                    int index = Integer.parseInt(atomindexes[j]);
                    struc.addAtomToNoAttach(index);
                }
                continue;
            }
            if (keyWord.equals("SpaceAttach:")) {
                String[] atomindexes = value.split(" ");
                for (int j = 0; j < atomindexes.length; ++j) {
                    int index = Integer.parseInt(atomindexes[j]);
                    struc.addAtomToNoAttach(index);
                    struc.addAtomToSpaceAttach(index);
                }
                continue;
            }
            if (keyWord.equals("CanSpaceAttach:")) {
                String[] atomindexes = value.split(" ");
                for (int j = 0; j < atomindexes.length; ++j) {
                    int index = Integer.parseInt(atomindexes[j]);
                    struc.addAtomToSpaceAttach(index);
                }
                continue;
            }
            if (keyWord.equals("Substituent:")) {
                String[] atoms = value.split(" ");
                Suffix s = null;
                for (int j = 0; j < atoms.length; ++j) {
                    String atom = atoms[j].substring(0, atoms[j].lastIndexOf(58));
                    SimpleLocant l = LocantLexer.parseSimpleLocant(atoms[j].substring(atoms[j].lastIndexOf(58) + 1, atoms[j].length()));
                    if (atom.equals("=O")) {
                        if (s != null) {
                            s.setMultiplicity(s.getMultiplicity() + 1);
                        } else {
                            s = SuffixFactory.createSuffix(atom, "on", (LocantList)null, 1, 0);
                            this.addSuffix(s);
                        }
                        s.addLocant(l);
                        continue;
                    }
                    SimpleStructure ss = new SimpleStructure(atom, atom);
                    ss.addLocant(l);
                    this.addSubstituent(ss);
                }
                continue;
            }
            if (keyWord.equals("AtomsToReplace:")) {
                String[] atoms = value.split(" ");
                for (int j = 0; j < atoms.length; ++j) {
                    String atom = atoms[j].substring(0, atoms[j].indexOf(58));
                    int locant = Integer.parseInt(atoms[j].substring(atoms[j].indexOf(58) + 1, atoms[j].length()));
                    HeteroAtom hAtom = new HeteroAtom(atom);
                    hAtom.addLocant(new SimpleLocant(locant, 0));
                    this.addSubstituent(hAtom);
                }
                continue;
            }
            if (keyWord.equals("Stereo:")) {
                struc.defaultStereo = LocantLexer.parseSpaceSeparatedLocants(value);
                continue;
            }
            if (keyWord.equals("Hydrogens:")) {
                String[] atoms = value.split(" ");
                if (this.defaultHydro == null) {
                    this.defaultHydro = new ArrayList();
                }
                for (int j = 0; j < atoms.length; ++j) {
                    Hydro hydro = new Hydro(atoms[j] + "H", atoms[j] + "H");
                    struc.defaultHydro.add(hydro);
                }
                continue;
            }
            if (keyWord.equals("DoubleBonds:")) {
                LocantList list = LocantLexer.parseSpaceSeparatedLocants(value);
                Suffix s = new Suffix("=", list, list.size(), -1, 1, 2);
                this.addSuffix(s);
                continue;
            }
            if (keyWord.equals("Valence:")) {
                this.nonStdValence = LocantLexer.parseSpaceSeparatedLocants(value);
                continue;
            }
            if (keyWord.equals("AminoAcid")) {
                if (!(this instanceof SimpleStructure)) continue;
                ((SimpleStructure)this).setType(3);
                continue;
            }
            if (keyWord.equals("NucleoBase")) continue;
            if (keyWord.equals("RGroups:") || keyWord.equals("RGroups_optional:")) {
                String[] groups = value.split(" ");
                for (int j = 0; j < groups.length; ++j) {
                    int groupindex = Integer.parseInt(groups[j].substring(1, groups[j].indexOf(58)));
                    RGroup rg = new RGroup(groupindex);
                    this.addRGroup(rg);
                    String atoms = groups[j].substring(groups[j].indexOf(58) + 1, groups[j].length());
                    String[] st = atoms.split(",");
                    for (int k = 0; k < st.length; ++k) {
                        int mul = 1;
                        int atom = 0;
                        if (st[k].startsWith("=")) {
                            mul = 2;
                            atom = Integer.parseInt(st[k].substring(1));
                        } else if (st[k].startsWith("#")) {
                            mul = 3;
                            atom = Integer.parseInt(st[k].substring(1));
                        } else {
                            atom = Integer.parseInt(st[k]);
                        }
                        rg.addNeighbour(atom, mul);
                    }
                }
                continue;
            }
            if (keyWord.equals("FixOxoGroup:")) {
                String[] atomindexes = value.split(" ");
                LocantList list = new LocantList();
                for (int j = 0; j < atomindexes.length; ++j) {
                    int index = Integer.parseInt(atomindexes[j]);
                    SimpleLocant locant = new SimpleLocant(index);
                    list.addLocant(locant);
                }
                Suffix oxo = SuffixFactory.createSuffix("=O", "on", list, list.size(), -1);
                this.addSuffix(oxo);
                continue;
            }
            if (keyWord.equals("Radical:")) {
                String suff = "|";
                if (value.equals("2")) {
                    suff = suff + "=";
                } else if (value.equals("3")) {
                    suff = suff + "#";
                }
                Suffix s = SuffixFactory.createSuffix(suff, "rad", (LocantList)null, 1, 2);
                this.addSuffix(s);
                continue;
            }
            if (keyWord.equals("DefaultSuffix:")) {
                this.defaultSuffixNumbering = new LocantList();
                this.parseToList(value, this.defaultSuffixNumbering);
                continue;
            }
            if (keyWord.equals("DefaultLigand:")) {
                this.defaultLigandNumbering = new LocantList();
                this.parseToList(value, this.defaultLigandNumbering);
                continue;
            }
            if (keyWord.equals("Chain")) {
                this.isChain = true;
                continue;
            }
            throw new NameImportException.Failure("Unknown field name: " + keyWord);
        }
    }

    private void parseToList(String numbering, LocantList numberingList) {
        String[] atomindexes = numbering.split(" ");
        for (int j = 0; j < atomindexes.length; ++j) {
            int index = Integer.parseInt(atomindexes[j]);
            SimpleLocant locant = new SimpleLocant(index);
            numberingList.addLocant(locant);
        }
    }

    public boolean isSpaceSeparated() {
        return this.spaceSeparated;
    }

    public void setSpaceSeparated(boolean spaceSeparated) {
        this.spaceSeparated = spaceSeparated;
    }

    protected String removeHydrogens(String atom) {
        if (atom == null || atom.length() < 3) {
            return atom;
        }
        if (atom.indexOf(72) > 0 && Character.isDigit(atom.charAt(atom.length() - 2))) {
            int digit = Character.getNumericValue(atom.charAt(atom.length() - 2));
            char digi = ("" + digit).charAt(0);
            char digi2 = ("" + (digit - 1)).charAt(0);
            atom = atom.replace(digi, digi2);
        }
        return atom;
    }

    public void addStereoLocant(LocantList l) {
        for (int i = 0; l != null && i < l.size(); ++i) {
            this.addStereoLocant((StereoNumber)l.getLocant(i));
        }
    }

    public void addStereoLocant(StereoNumber l) {
        this.stereoLocants.tryAddLocant(l);
    }

    public LocantList getStereoLocants() {
        return this.stereoLocants;
    }

    public void clearStereoLocants() {
        this.stereoLocants = new LocantList();
    }

    public boolean hasConnectionPoint() {
        return this.connectionPoint != null;
    }

    public Suffix getConnectionPoint() {
        return this.connectionPoint;
    }

    public void setConnectionPoint(int connPoint) {
        if (connPoint < this.suffixCount()) {
            this.connectionPoint = this.getSuffix(connPoint);
        }
    }

    public void dropConnectionPoint() {
        if (this.connectionPoint == null) {
            return;
        }
        this.suffixList.remove(this.connectionPoint);
        this.connectionPoint = null;
    }

    protected void setCloneOf(Structure struc) {
        this.cloneOf = struc;
    }

    public boolean isCloneOf(Structure struc) {
        return this.cloneOf != null && this.cloneOf.equals(struc);
    }

    public Structure getCloneOf() {
        return this.cloneOf;
    }

    public boolean hasAtom(String symbol, boolean withSuffixes) {
        if (this.hasAtom(symbol)) {
            return true;
        }
        if (!withSuffixes) {
            return false;
        }
        for (int i = 0; i < this.suffixCount(); ++i) {
            if (this.getSuffix(i).getValue().indexOf(symbol) < 0) continue;
            return true;
        }
        return false;
    }

    public int getAtomCount() {
        return Util.atomCount(this.toSmiles());
    }

    public boolean hasSpaceseparatedParent() {
        Structure struc = this;
        while (struc.getParent() != null) {
            if (struc.getParent().isSpaceSeparated()) {
                return true;
            }
            struc = struc.getParent();
        }
        return false;
    }

    public Structure getSpaceseparatedParent() {
        Structure struc = this;
        while (struc.getParent() != null) {
            if (struc.getParent().isSpaceSeparated()) {
                return struc.getParent();
            }
            struc = struc.getParent();
        }
        return null;
    }

    protected int getRadicalMultiplicity() {
        int mul = 1;
        Suffix s = null;
        if (!this.radicals.isEmpty()) {
            s = this.radicals.get(0);
        } else if (!this.suffixList.isEmpty()) {
            int suffIndex = this.getFirstRadicalSuffixIndex();
            s = suffIndex > -1 ? this.suffixList.get(suffIndex) : null;
            for (int i = 0; s == null && i < this.suffixList.size() && (s = this.suffixList.get(i)).getType() != 2; ++i) {
            }
        }
        return s != null ? s.getRadical() : mul;
    }

    public int getFirstRadicalSuffixIndex() {
        for (int i = 0; i < this.suffixList.size(); ++i) {
            if (this.suffixList.get(i).getType() != 2) continue;
            return i;
        }
        return -1;
    }

    public int getFirstSuffixWithoutLocant() {
        for (int i = 0; i < this.suffixList.size(); ++i) {
            Suffix suffix = this.suffixList.get(i);
            if (suffix.hasLocant() || suffix.getType() == 3 || suffix.getValue().equals("") || suffix.getRadical() < 1) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    protected void removeExtraHydroxyGroup(Structure struc, String atomSymbol, ArrayList<MolAtom> toRemove) {
        void var5_11;
        if (struc == null) {
            return;
        }
        for (int i = 0; i < struc.suffixCount(); ++i) {
            Suffix suffix = struc.getSuffix(i);
            if (!suffix.getValue().equals(atomSymbol) || suffix.radical != 1) continue;
            struc.removeSuffix(i);
            if (suffix.hasLocant() && !struc.hasRadical()) {
                struc.addSuffix(new Suffix("|", suffix.locant, 1, 2, 1));
            }
            return;
        }
        if (!struc.hasRadical() && atomSymbol.equals("O")) {
            for (Structure structure : struc.getSubstituentList()) {
                if (!structure.is("hydroxy")) continue;
                struc.removeSubstituent(structure);
                if (structure.hasLocant() && !struc.hasRadical()) {
                    struc.addSuffix(new Suffix("|", structure.locantInParent, 1, 2, 1));
                }
                return;
            }
        }
        Molecule mol = struc.buildMolecule();
        if (struc.basicAtomCount == 1) {
            return;
        }
        boolean bl = false;
        while (var5_11 < mol.getAtomCount()) {
            MolAtom other;
            int index;
            MolAtom atom = mol.getAtom((int)var5_11);
            if (atom.getBondCount() == 1 && atom.getSymbol().equals(atomSymbol) && struc.isBasicAtom(atom) && atom.getBond(0).getType() == 1 && (index = struc.getMappedIndex(mol.indexOf(other = atom.getBond(0).getOtherAtom(atom)))) > 0) {
                toRemove.add(atom);
                index = struc.getMappedIndex(mol.indexOf(other));
                LocantList l = new LocantList();
                l.tryAddLocant(new SimpleLocant(index, 0));
                Suffix s = SuffixFactory.createSuffix("|", "yl", l, 1, 2);
                struc.radicals.add(s);
                return;
            }
            ++var5_11;
        }
    }

    protected void removeAtomAndKeepChirality(MolAtom atom) {
        int i;
        ArrayList<MolAtom> atoms = new ArrayList<MolAtom>();
        IntVector chirality = new IntVector();
        for (i = 0; i < atom.getBondCount(); ++i) {
            int ch;
            MolAtom atom2 = atom.getBond(i).getOtherAtom(atom);
            int index = this.molecule.indexOf(atom2);
            if (index <= -1 || (ch = this.molecule.getChirality(index)) <= 0) continue;
            atoms.add(atom2);
            chirality.add(ch);
        }
        this.molecule.removeAtom(atom);
        for (i = 0; i < atoms.size(); ++i) {
            this.molecule.setChirality(this.molecule.indexOf((MolAtom)atoms.get(i)), chirality.get(i));
        }
    }

    public abstract boolean hasLocant(Locant var1);

    public abstract boolean hasAtom(String var1);

    public int getHeteroAtomCountOf(String heteroAtomSymbol) {
        int mul = 0;
        for (int i = 0; i < this.substituentCount(); ++i) {
            Structure s = this.getSubstituent(i);
            if (!(s instanceof HeteroAtom) || !((HeteroAtom)s).getName().equalsIgnoreCase(heteroAtomSymbol)) continue;
            ++mul;
        }
        return mul;
    }

    public int getDefaultAtomIndex() {
        Locant locant;
        if (this.hasConnectionPoint() && !((locant = this.connectionPoint.getLocant().getLocant(0)) instanceof AtomLocant)) {
            return this.getAtomIndex(locant.getValue());
        }
        if (!this.atomMap.isEmpty()) {
            Set<Integer> numbering = this.atomMap.keySet();
            Iterator lit = numbering.iterator();
            IntVector vec = new IntVector();
            while (lit.hasNext()) {
                vec.add((Integer)lit.next());
            }
            vec.sort();
            for (int i = 0; i < vec.size(); ++i) {
                int index = this.atomMap.get(vec.get(i));
                if (this.molecule.getAtom(index).getImplicitHcount() <= 0) continue;
                return index;
            }
        } else {
            for (int i = 0; i < this.basicAtomCount; ++i) {
                if (this.molecule.getAtom(i).getImplicitHcount() <= 0) continue;
                return i;
            }
        }
        return this.getAtomIndex(1);
    }

    public int indexOfUnLocantedSuffix() {
        for (int i = 0; i < this.suffixCount(); ++i) {
            if (this.getSuffix(i).getType() == 2 && i != this.suffixCount() - 1 || this.getSuffix(i).getValue().length() <= 0 || this.getSuffix(i).hasLocant()) continue;
            return i;
        }
        return -1;
    }

    protected void preProcessTree() {
        if (this.preProcessed) {
            return;
        }
        this.preProcessed = true;
        for (int i = 0; i < this.substituentCount(); ++i) {
            this.getSubstituent(i).preProcessTree();
        }
        this.checkAtomLocant();
        this.preProcess();
    }

    protected void preProcess() {
    }

    protected void checkAtomLocant() {
        if (!this.hasLocant() || this.getLocantInParent().getType() != 6) {
            return;
        }
        if (!Util.hasRealParent(this) || !Util.hasRealParent(this.getParent()) || this.getParent().hasLocant()) {
            return;
        }
        AtomLocant atomLocant = (AtomLocant)this.getLocantInParent().getLocant(0);
        Structure parentClone = this.getParent().cloneStructure();
        parentClone.clearSubstituentList();
        if (parentClone.hasAtomWithFreeRadical(atomLocant)) {
            return;
        }
        Structure grandParentClone = this.getParent().getParent().cloneStructure();
        grandParentClone.clearSubstituentList();
        if (grandParentClone.hasAtomWithFreeRadical(atomLocant)) {
            this.getParent().setLocantInParent(this.getLocantInParent());
            this.setLocantInParent(new LocantList());
        }
    }

    protected boolean hasAtomWithFreeRadical(AtomLocant atomLocant) {
        int atomIndex = this.getAtomBySymbol(this.getMolecule(), atomLocant, -1, new int[1]);
        return atomIndex > -1 && this.getMolecule().getAtom(atomIndex).getImplicitHcount() > 0;
    }

    public int getFirstSuffixWithStructureProp() {
        int index;
        for (index = 0; index < this.suffixCount() && this.getSuffix(index).getType() != 8; ++index) {
        }
        return index < this.suffixCount() && this.getSuffix(index).getStructure() != null ? index : -1;
    }

    protected static ArrayList<StereoInfo> getStereoInfoList() {
        return new ArrayList<StereoInfo>(){
            private static final long serialVersionUID = 107270552347797478L;

            @Override
            public boolean contains(Object o) {
                for (int i = 0; i < this.size(); ++i) {
                    if (!((StereoInfo)this.get(i)).contains(o)) continue;
                    return true;
                }
                return super.contains(o);
            }

            @Override
            public int indexOf(Object o) {
                for (int i = 0; i < this.size(); ++i) {
                    if (!((StereoInfo)this.get(i)).contains(o)) continue;
                    return i;
                }
                return super.indexOf(o);
            }
        };
    }

    private int getOxyGroup(Molecule mol) {
        return this.getOxygen(mol, 1);
    }

    private int getOxoGroup(Molecule mol) {
        return this.getOxygen(mol, 2);
    }

    private int getOxygen(Molecule mol, int bondType) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom atom = mol.getAtom(i);
            if (removeMark.equals(atom.getAliasstr()) || atom.getAtno() != 8 || atom.getBondCount() != 1 || atom.getBond(0).getType() != bondType) continue;
            return i;
        }
        return -1;
    }

    protected MolAtom getHydroxy() {
        Molecule m = this.buildMolecule();
        int res = this.getOxyGroup(m);
        if (res == -1) {
            return null;
        }
        return m.getAtom(res);
    }

    static class Pair<U, V> {
        private U first;
        private V second;

        public Pair(U first, V second) {
            this.first = first;
            this.second = second;
        }

        U getFirst() {
            return this.first;
        }

        void setFirst(U first) {
            this.first = first;
        }

        V getSecond() {
            return this.second;
        }

        void setSecond(V second) {
            this.second = second;
        }
    }

    public static class StereoInfo {
        Structure parentStruc;
        MolAtom atom;
        StereoNumber stereoData;

        public StereoInfo(Structure parentStruc, MolAtom atom, StereoNumber stereoData) {
            this.parentStruc = parentStruc;
            this.atom = atom;
            this.stereoData = stereoData;
        }

        Structure getParentStruc() {
            return this.parentStruc;
        }

        void setParentStruc(Structure parentStruc) {
            this.parentStruc = parentStruc;
        }

        MolAtom getAtom() {
            return this.atom;
        }

        void setAtom(MolAtom atom) {
            this.atom = atom;
        }

        public StereoNumber getStereoData() {
            return this.stereoData;
        }

        void setStereoData(StereoNumber stereoData) {
            this.stereoData = stereoData;
        }

        public boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            return o.equals(this.parentStruc) || o.equals(this.atom) || o.equals(this.stereoData);
        }

        public String toString() {
            return this.stereoData + " " + this.parentStruc + " " + this.atom;
        }
    }

    static class RGroup {
        int rgroupIndex;
        IntVector neighbours;
        IntVector bonds;

        RGroup(int index) {
            this.rgroupIndex = index;
        }

        int getRGroupIndex() {
            return this.rgroupIndex;
        }

        void setRGroupIndex(int index) {
            this.rgroupIndex = index;
        }

        void addNeighbour(int index, int bondtype) {
            if (this.neighbours == null) {
                this.neighbours = new IntVector();
                this.bonds = new IntVector();
            }
            this.neighbours.add(index);
            this.bonds.add(bondtype);
        }

        int getNeighbourCount() {
            if (this.neighbours == null) {
                return 0;
            }
            return this.neighbours.size();
        }

        int getNeighbour(int index) {
            if (this.neighbours == null || this.neighbours.size() <= index) {
                return -1;
            }
            return this.neighbours.get(index);
        }

        void setNeighbour(int index) {
            this.neighbours = new IntVector();
            this.neighbours.add(index);
        }

        int getBond(int index) {
            if (this.bonds == null || this.bonds.size() <= index) {
                return -1;
            }
            return this.bonds.get(index);
        }
    }
}

