/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.util;

import java.util.ArrayList;
import java.util.regex.Pattern;

public class StringRewriter {
    private ArrayList<Rewriter> rewriters = new ArrayList();

    public String rewrite(String input) {
        String res = input;
        for (Rewriter w : this.rewriters) {
            res = w.rewrite(res);
        }
        return res;
    }

    public void replaceAll(String regex, String replacement) {
        this.rewriters.add(new RegexRewriter(regex, replacement));
    }

    public void replaceLiteral(String literal, String replacement) {
        this.rewriters.add(new LiteralRewriter(literal, replacement));
    }

    private static class RegexRewriter
    extends Rewriter {
        private Pattern pattern;
        private String replacement;

        RegexRewriter(String regex, String replacement) {
            this.pattern = Pattern.compile(regex);
            this.replacement = replacement;
        }

        @Override
        String rewrite(String s) {
            return this.pattern.matcher(s).replaceAll(this.replacement);
        }
    }

    private static class LiteralRewriter
    extends Rewriter {
        private Pattern pattern;
        private String replacement;

        LiteralRewriter(String literal, String replacement) {
            this.pattern = Pattern.compile(literal, 16);
            this.replacement = replacement;
        }

        @Override
        String rewrite(String s) {
            return this.pattern.matcher(s).replaceAll(this.replacement);
        }
    }

    private static abstract class Rewriter {
        private Rewriter() {
        }

        abstract String rewrite(String var1);
    }
}

