/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.pdb;

import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.modules.ResidueInfo;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.Sgroup;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class PDBExport
extends MolExportModule {
    private StringBuffer tmpsbuf = new StringBuffer();
    private boolean storeConnections;

    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
        super.getOptionDescriptors(fmtname, "H -H", l);
        ResourceBundle rc = LocaleUtil.getResourceBundle(PDBExport.class.getName(), null);
        PDBExport.getOptionDescriptors(rc, fmtname, null, l);
    }

    @Override
    public Object open(String fmtopts) throws MolExportException {
        this.storeConnections = true;
        return super.open(fmtopts);
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        if ((i = this.parseCharIfOptionSign(opts, i)) >= opts.length()) {
            return i;
        }
        char c = opts.charAt(i);
        if (c == 'c') {
            this.storeConnections = this.getOptionSign() >= 0;
            ++i;
        }
        return i;
    }

    @Override
    public Object convert(Molecule mol) {
        mol = this.preconvert(mol);
        StringBuffer sb = this.stringBuffer;
        sb.setLength(0);
        sb.append("HEADER    ");
        String classification = mol.getProperty("pdb.classfication");
        if (classification == null || classification.length() == 0) {
            classification = "PROTEIN";
        }
        this.appendLeft(classification, 40);
        Date date = new Date();
        date.setTime(System.currentTimeMillis());
        int mday = date.getDate();
        StringBuffer sb1 = new StringBuffer(mday < 10 ? "0" + mday : String.valueOf(mday));
        sb1.append('-');
        StringTokenizer st = new StringTokenizer("JAN FEB MAR APR MAY JUN JUL AUG SEP OCT NOV DEC");
        for (int i = date.getMonth(); i > 0; --i) {
            st.nextToken();
        }
        sb1.append(st.nextToken());
        sb1.append('-');
        if (date.getYear() % 100 < 10) {
            sb1.append('0');
        }
        sb1.append(date.getYear() % 100);
        String modDate = sb1.toString();
        this.appendLeft(modDate, 12);
        String idCode = mol.getProperty("pdb.idcode");
        if (idCode == null || idCode.length() == 0) {
            idCode = "NONE";
        }
        this.appendLeft(idCode, 4);
        sb.append('\n');
        st = new StringTokenizer("title compnd source keywds expdta author");
        while (st.hasMoreTokens()) {
            String field = st.nextToken();
            String val = mol.getProperty("pdb." + field);
            if (val == null || val.length() == 0) {
                if (field.equals("compnd")) {
                    String name = mol.getName();
                    if (name != null && name.length() != 0) {
                        val = "MOLECULE: " + name;
                    }
                } else {
                    val = field.equals("author") ? "Marvin" : null;
                }
            }
            if (val == null) {
                val = "NULL";
            }
            StringTokenizer st1 = new StringTokenizer(val, "\n");
            int i = 0;
            while (st1.hasMoreElements()) {
                this.appendLeft(field.toUpperCase(), 8);
                if (i > 0) {
                    this.appendRight(i, 2, ' ');
                    sb.append(' ');
                } else {
                    sb.append("  ");
                }
                this.appendLeft(st1.nextToken(), 60);
                sb.append('\n');
                ++i;
            }
        }
        String value = mol.getProperty("pdb.revdat");
        int modNum = 0;
        if (value != null) {
            try {
                modNum = Integer.parseInt(value.substring(1, 4).trim());
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        sb.append("REVDAT ");
        this.appendRight(++modNum, 3, ' ');
        sb.append("   ");
        sb.append(modDate);
        sb.append("         ");
        sb.append(modNum > 1 ? (char)'3' : '0');
        this.appendChars(34, ' ');
        sb.append('\n');
        if (value != null) {
            st = new StringTokenizer(value, "\n");
            while (st.hasMoreTokens()) {
                sb.append("REVDAT ");
                this.appendLeft(st.nextToken(), 67);
                sb.append('\n');
            }
        }
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom a = mol.getAtom(i);
            int resType = a.getResidueType();
            sb.append(resType > 0 ? "ATOM  " : "HETATM");
            this.appendRight(i + 1, 5, ' ');
            String sym = a.getSymbol();
            int atomId = a.getResidueAtomId();
            String atomName = ResidueInfo.getAtomName(resType, atomId);
            if (atomName == null) {
                atomName = sym;
            }
            if (sym.length() == 1) {
                this.stringBuffer.append("  ");
                this.appendLeft(atomName, 3);
            } else {
                this.stringBuffer.append(' ');
                this.appendLeft(atomName, 4);
            }
            this.stringBuffer.append(' ');
            String resName = null;
            int resSeq = 0;
            if (resType != 0) {
                resName = Molecule.residueSymbolOf(resType);
                if (resName != null) {
                    resName = resName.toUpperCase();
                }
                resSeq = a.getResidueSeq();
            } else {
                Sgroup sg = mol.findSgroupContaining(a);
                if (sg != null) {
                    resName = sg.getSubscript();
                    resSeq = mol.indexOf(sg) + 1;
                }
            }
            this.appendRight(resName != null ? resName : "UNK", 3, ' ');
            this.stringBuffer.append("  ");
            this.appendRight(resSeq, 4, ' ');
            this.stringBuffer.append("    ");
            this.appendRight(a.getX());
            this.appendRight(a.getY());
            this.appendRight(a.getZ());
            this.stringBuffer.append("  0.00  0.00          ");
            this.appendRight(a.getSymbol(), 2, ' ');
            if (a.getCharge() >= 0) {
                sb.append('+');
            }
            sb.append(String.valueOf(a.getCharge()));
            sb.append('\n');
        }
        int nb = 0;
        if (this.storeConnections) {
            for (int i = 0; i < mol.getAtomCount(); ++i) {
                MolAtom a = mol.getAtom(i);
                int nba = 0;
                for (int j = 0; j < a.getBondCount(); ++j) {
                    int ii;
                    MolAtom aa = a.getLigand(j);
                    if (a.getResidueAtomId() > 0 && aa.getResidueAtomId() > 0 && a.getResidueSeq() == aa.getResidueSeq() && a.getResidueType() == aa.getResidueType() && a.getResidueType() > 0 || (ii = mol.indexOf(aa)) < 0) continue;
                    if (nba % 4 == 0) {
                        if (nba > 0) {
                            this.appendChars(65 - nba * 5, ' ');
                            sb.append('\n');
                        }
                        sb.append("CONECT");
                        this.appendRight(i + 1, 5, ' ');
                    }
                    this.appendRight(ii + 1, 5, ' ');
                    ++nba;
                    ++nb;
                }
                if (nba <= 0) continue;
                this.appendChars(65 - nba * 5, ' ');
                sb.append('\n');
            }
        }
        sb.append("MASTER        0    0    0    0    0    0    0    0");
        this.appendRight(mol.getAtomCount(), 5, ' ');
        sb.append("    0");
        this.appendRight(nb, 5, ' ');
        sb.append("    0\nEND\n");
        return sb.toString();
    }

    private void appendRight(double t) {
        int iy;
        double y = Math.abs(t);
        int a = (int)(1000.0 * (y - (double)(iy = (int)y)) + 0.5);
        if (a == 1000) {
            ++iy;
        }
        String sa = "000" + a;
        int l = sa.length();
        StringBuffer sb = this.tmpsbuf;
        sb.setLength(0);
        sb.append(t < 0.0 ? "  -" : "   ");
        sb.append(iy);
        sb.append('.');
        sb.append(sa.substring(l - 3, l));
        String s = sb.toString();
        l = s.length();
        this.stringBuffer.append(s.substring(l - 8, l));
    }
}

