/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.peptide;

import chemaxon.common.util.BasicEnvironment;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.marvin.util.Environment;
import chemaxon.struc.Molecule;
import chemaxon.util.DotfileUtil;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class AminoAcidSource {
    protected static final String defaultDictPath = "/chemaxon/aminoacids.dict";
    private static AminoAcidSource instance;
    protected static boolean alreadyInitialized;
    protected static String customDictionaryPath;
    protected String[] IMPORT_3_LETTERS;
    protected String[] IMPORT_1_LETTER;
    protected String[] IMPORT_SMILES;
    protected int[] IMPORT_1ST_ATTACH_POINT;
    protected int[] IMPORT_2ND_ATTACH_POINT;
    protected Vector<String> EXPORT_SHORT_NAMES = new Vector();
    protected Vector<String> EXPORT_LONG_NAMES = new Vector();
    protected Vector EXPORT_MOLS = new Vector();
    protected HashMap<String, Molecule> CACHE = new HashMap();

    public static synchronized AminoAcidSource getInstance() {
        return instance;
    }

    private AminoAcidSource() {
        if (!alreadyInitialized) {
            alreadyInitialized = this.initDictionary();
        }
        if (!alreadyInitialized) {
            this.clearDataFields();
        }
    }

    protected void clearDataFields() {
        this.IMPORT_1_LETTER = null;
        this.IMPORT_3_LETTERS = null;
        this.IMPORT_SMILES = null;
        this.IMPORT_1ST_ATTACH_POINT = null;
        this.IMPORT_2ND_ATTACH_POINT = null;
        this.EXPORT_LONG_NAMES = new Vector();
        this.EXPORT_SHORT_NAMES = new Vector();
        this.EXPORT_MOLS = new Vector();
        this.CACHE = new HashMap();
    }

    protected boolean initDictionary() {
        this.clearDataFields();
        InputStream dictFile = BasicEnvironment.getResourceAsStream(AminoAcidSource.class, defaultDictPath);
        if (dictFile == null) {
            System.err.println("Cannot find /chemaxon/aminoacids.dict");
            return false;
        }
        boolean readSuccessful = this.readDictionary(dictFile);
        try {
            dictFile.close();
        }
        catch (IOException ioex) {
            readSuccessful = false;
            ioex.printStackTrace();
        }
        if (readSuccessful && customDictionaryPath != null) {
            try {
                dictFile = new FileInputStream(customDictionaryPath);
                readSuccessful = this.readDictionary(dictFile);
            }
            catch (IOException e) {
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        return readSuccessful;
    }

    private boolean readDictionary(InputStream dictFile) {
        boolean readSuccessful = true;
        DataInputStream in = new DataInputStream(dictFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        Vector<String> aa3name = new Vector<String>();
        Vector<String> aa1name = new Vector<String>();
        Vector<String> aaSMILESs = new Vector<String>();
        Vector<String> firstAttach = new Vector<String>();
        Vector<String> secondAttach = new Vector<String>();
        try {
            String strLine;
            while ((strLine = br.readLine()) != null) {
                StringTokenizer st;
                int tc;
                if (strLine.startsWith("#") || (tc = (st = new StringTokenizer(strLine, " \t")).countTokens()) != 5) continue;
                aa3name.add(st.nextToken());
                aa1name.add(st.nextToken());
                aaSMILESs.add(st.nextToken());
                firstAttach.add(st.nextToken());
                secondAttach.add(st.nextToken());
            }
            int tableSize = aa3name.size();
            this.IMPORT_3_LETTERS = (String[])AminoAcidSource.makeArray(this.IMPORT_3_LETTERS, tableSize, String.class, aa3name);
            this.IMPORT_1_LETTER = (String[])AminoAcidSource.makeArray(this.IMPORT_1_LETTER, tableSize, String.class, aa1name);
            this.IMPORT_SMILES = (String[])AminoAcidSource.makeArray(this.IMPORT_SMILES, tableSize, String.class, aaSMILESs);
            this.IMPORT_1ST_ATTACH_POINT = (int[])AminoAcidSource.makeArray(this.IMPORT_1ST_ATTACH_POINT, tableSize, Integer.TYPE, firstAttach);
            this.IMPORT_2ND_ATTACH_POINT = (int[])AminoAcidSource.makeArray(this.IMPORT_2ND_ATTACH_POINT, tableSize, Integer.TYPE, secondAttach);
            for (int i = 0; i < this.IMPORT_3_LETTERS.length; ++i) {
                String shortAbbrev = this.IMPORT_1_LETTER[i];
                String longAbbrev = this.IMPORT_3_LETTERS[i];
                this.EXPORT_SHORT_NAMES.add(shortAbbrev);
                this.EXPORT_LONG_NAMES.add(longAbbrev);
                this.EXPORT_MOLS.add(this.IMPORT_SMILES[i]);
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
            readSuccessful = false;
        }
        return readSuccessful;
    }

    public String[] getImportNamesWithThreeLetters() {
        return this.IMPORT_3_LETTERS;
    }

    public String[] getImportNamesWithOneLetter() {
        return this.IMPORT_1_LETTER;
    }

    public String[] getImportSMILES() {
        return this.IMPORT_SMILES;
    }

    public Vector<String> getSMILESVector() {
        Vector<String> aaSMILES = new Vector<String>();
        for (int i = 0; i < this.IMPORT_SMILES.length; ++i) {
            aaSMILES.add(this.IMPORT_SMILES[i]);
        }
        return aaSMILES;
    }

    public int[] getImportFirtsAttachPoints() {
        return this.IMPORT_1ST_ATTACH_POINT;
    }

    public int[] getImportSecondAttachPoints() {
        return this.IMPORT_2ND_ATTACH_POINT;
    }

    public Vector getExportShortNames() {
        return this.EXPORT_SHORT_NAMES;
    }

    public Vector getExportLongNames() {
        return this.EXPORT_LONG_NAMES;
    }

    protected static Object makeArray(Object oldArray, int increment, Class elementType, Vector items) {
        Object newArray;
        if (oldArray == null && increment >= 0) {
            newArray = Array.newInstance(elementType, increment);
            if (elementType == Integer.TYPE) {
                for (int i = 0; i < increment; ++i) {
                    ((int[])newArray)[i] = Integer.parseInt((String)items.elementAt(i));
                }
            } else {
                items.copyInto((Object[])newArray);
            }
        } else {
            int oldSize = Array.getLength(oldArray);
            int newSize = increment + oldSize;
            newArray = Array.newInstance(elementType, newSize);
            System.arraycopy(oldArray, 0, newArray, 0, oldSize);
            if (elementType == Integer.TYPE) {
                int i = oldSize;
                int j = 0;
                while (i < newSize) {
                    ((int[])newArray)[i] = Integer.parseInt((String)items.elementAt(j));
                    ++i;
                    ++j;
                }
            } else {
                int i = oldSize;
                int j = 0;
                while (i < newSize) {
                    ((Object[])newArray)[i] = items.elementAt(j);
                    ++i;
                    ++j;
                }
            }
        }
        return newArray;
    }

    public Vector getExportMols() {
        if (this.EXPORT_MOLS.firstElement() instanceof String) {
            SmilesImport si = new SmilesImport();
            for (int i = 0; i < this.EXPORT_MOLS.size(); ++i) {
                String ns = (String)this.EXPORT_MOLS.elementAt(i);
                Molecule aa = new Molecule();
                try {
                    si.readMol(ns, aa);
                }
                catch (IOException e) {
                    System.out.println("Could not interpret amin acid SMARTS " + ns + "in dictionary");
                    e.printStackTrace();
                }
                this.EXPORT_MOLS.set(i, aa);
            }
        }
        return this.EXPORT_MOLS;
    }

    Molecule getFromCache(String threeLetterAbbrev) {
        return this.CACHE.get(threeLetterAbbrev);
    }

    void storePeptide(String threeLetterAbbrev, Molecule peptideMol) {
        this.CACHE.put(threeLetterAbbrev, peptideMol);
    }

    public Vector<Molecule> getExportMols(boolean setData) {
        Vector mols = this.getExportMols();
        if (setData) {
            for (int i = 0; i < mols.size(); ++i) {
                ((Molecule)mols.get(i)).setProperty("short", this.getExportShortNames().get(i).toString());
                ((Molecule)mols.get(i)).setProperty("long", this.getExportLongNames().get(i).toString());
                ((Molecule)mols.get(i)).getAtom(this.getImportFirtsAttachPoints()[i] - 1).setAttach(1);
                ((Molecule)mols.get(i)).getAtom(this.getImportSecondAttachPoints()[i] - 1).setAttach(2);
            }
        }
        return mols;
    }

    static {
        alreadyInitialized = false;
        customDictionaryPath = null;
        if (!Environment.UNTRUSTED) {
            customDictionaryPath = DotfileUtil.getDotDir().toString() + File.separator + "custom_aminoacids.dict";
        }
        instance = new AminoAcidSource();
    }
}

