/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.peptide;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.peptide.AminoAcidSource;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.marvin.util.SSS;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;

public class PeptideExport
extends MolExportModule {
    private boolean toOneLetterName;
    private static final int GENERAL_MATCH_MODE = 0;
    private static final int ONE_LETTER_MODE = 1;
    private static final int THREE_LETTER_MODE = 2;

    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
        ResourceBundle rc = LocaleUtil.getResourceBundle(PeptideExport.class.getName(), null);
        PeptideExport.getOptionDescriptors(rc, fmtname, null, l);
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        this.stringBuffer.setLength(0);
        if (mol.getAtomCount() == 0) {
            return "";
        }
        Molecule molToConvert = (Molecule)mol.clone();
        String inputFormat = molToConvert.getInputFormat();
        if (inputFormat == null || !inputFormat.startsWith("peptide")) {
            molToConvert.ungroupSgroups();
            Vector amideAtoms = this.findAmides(molToConvert);
            IntVector bb = this.findBackbone(amideAtoms, molToConvert);
            if (bb != null && bb.size() > 0) {
                Hashtable ih = this.matchAminoacids(molToConvert, this.toOneLetterName);
                if (!this.isMissingIgnorable(ih = this.removeDanglingAAs(molToConvert, bb, ih), molToConvert)) {
                    throw new MolExportException("Unmatched atoms in peptide chain. Likely amino acid template mismatch.");
                }
                molToConvert.setGUIContracted(true);
                this.buildPeptideString(ih, molToConvert, bb);
            }
        } else {
            int fc = molToConvert.getFragCount();
            int sc = molToConvert.getSgroupCount();
            if (fc != 1 || sc == 0) {
                throw new MolExportException("Molecule not recognized as peptide...");
            }
            molToConvert.setGUIContracted(true);
            this.buildPeptideString(molToConvert, this.findStartingH(molToConvert), this.toOneLetterName);
        }
        if (this.stringBuffer.length() == 0) {
            throw new MolExportException("Molecule not recognized as peptide...");
        }
        this.stringBuffer.append('\n');
        return this.stringBuffer.toString();
    }

    private Hashtable removeDanglingAAs(Molecule m, IntVector bb, Hashtable ih) {
        Vector<int[]> aasToRemove = new Vector<int[]>();
        for (int[] aa : ih.keySet()) {
            boolean isNinBB = false;
            for (int i = 0; i < aa.length && !isNinBB; ++i) {
                MolAtom a = m.getAtom(aa[i]);
                if (a.getAtno() != 7) continue;
                isNinBB = bb.contains(aa[i]);
            }
            if (isNinBB) continue;
            aasToRemove.add(aa);
        }
        Iterator<Object> iter = aasToRemove.iterator();
        while (iter.hasNext()) {
            ih.remove(iter.next());
        }
        int N_count = 0;
        int O_count = 0;
        for (int i = 0; i < bb.size(); ++i) {
            MolAtom a = m.getAtom(bb.elementAt(i));
            if (a.getAtno() == 7) {
                ++N_count;
            }
            if (a.getAtno() != 8) continue;
            ++O_count;
        }
        if (O_count > 1 || N_count != ih.size()) {
            ih.clear();
        }
        return ih;
    }

    private IntVector findBackbone(Vector amideAtoms, Molecule cmol) {
        int[][] sssr = cmol.getSSSR();
        IntVector ringAtoms = new IntVector();
        for (int i = 0; i < sssr.length; ++i) {
            for (int j = 0; j < sssr[i].length; ++j) {
                if (ringAtoms.contains(sssr[i][j])) continue;
                ringAtoms.addElement(sssr[i][j]);
            }
        }
        IntVector termNs = new IntVector();
        IntVector bbIdx = new IntVector();
        for (int i = 0; i < amideAtoms.size(); ++i) {
            int[] chunk = (int[])amideAtoms.elementAt(i);
            for (int j = 0; j < chunk.length; ++j) {
                MolAtom a = cmol.getAtom(chunk[j]);
                if (a.getAtno() == 7 && (a.getBondCount() - a.getExplicitHcount() == 1 || ringAtoms.contains(chunk[j]))) {
                    termNs.addElement(chunk[j]);
                }
                if (bbIdx.contains(chunk[j])) continue;
                bbIdx.addElement(chunk[j]);
            }
        }
        IntVector longestWalk = null;
        for (int i = 0; i < termNs.size(); ++i) {
            IntVector bfsWalk = this.bfs(termNs.elementAt(i), cmol, bbIdx);
            IntVector sp = this.shortestPath(bfsWalk, cmol);
            if (longestWalk != null && sp.size() <= longestWalk.size()) continue;
            longestWalk = sp;
        }
        return longestWalk;
    }

    private Vector findAmides(Molecule cmol) {
        Vector bbV = new Vector();
        SSS mcs = new SSS();
        mcs.setIgnoreBondType(false);
        mcs.setSSSMode(true);
        mcs.setIgnoreQueryProperties(false);
        mcs.setIgnoreCharge(false);
        mcs.setIgnoreAtomType(false);
        mcs.setIgnoreHybridization(false);
        SmilesImport si = new SmilesImport();
        Molecule query = new Molecule();
        try {
            Hashtable backboneAmides = new Hashtable();
            si.readMol("[N;X3][C;X4][C;X3]=[O;X1]", query);
            mcs.setMolecules(query, cmol);
            if (mcs.findFirst()) {
                do {
                    int[] res = mcs.getResult();
                    IntVector resV = new IntVector(res);
                    resV.sort();
                    resV.copyInto(res);
                    backboneAmides.put(res, "NCC=O");
                } while (mcs.findNext());
            }
            backboneAmides = PeptideExport.checkMatch(backboneAmides, 0);
            Iterator iter = backboneAmides.keySet().iterator();
            while (iter.hasNext()) {
                bbV.add(iter.next());
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return bbV;
    }

    private void buildPeptideString(Hashtable idxHash, Molecule molToConvert, IntVector bb) {
        Vector<int[]> singleAtoms = new Vector<int[]>();
        for (int[] frag : idxHash.keySet()) {
            if (frag.length > 1) continue;
            singleAtoms.add(frag);
        }
        Iterator iter = singleAtoms.iterator();
        while (iter.hasNext()) {
            idxHash.remove(iter.next());
        }
        Vector idxVect = new Vector();
        Iterator ii = idxHash.keySet().iterator();
        while (ii.hasNext()) {
            idxVect.add(ii.next());
        }
        int[] terminal = this.findNTerminal(idxHash, bb);
        int[][] ct = molToConvert.getCtab();
        while (terminal != null && terminal.length > 0 && idxVect.size() > 0) {
            String aaStr = (String)idxHash.get(terminal);
            this.stringBuffer.append(aaStr);
            idxVect.remove(terminal);
            IntVector termV = new IntVector(terminal);
            boolean foundNeighbour = false;
            for (int i = 0; i < terminal.length && !foundNeighbour; ++i) {
                int[] neighbours = ct[terminal[i]];
                for (int j = 0; j < neighbours.length && !foundNeighbour; ++j) {
                    if (termV.contains(neighbours[j])) continue;
                    for (int k = 0; k < idxVect.size() && !foundNeighbour; ++k) {
                        int[] nextTerminal = (int[])idxVect.elementAt(k);
                        IntVector nextTermV = new IntVector(nextTerminal);
                        if (!nextTermV.contains(neighbours[j])) continue;
                        terminal = nextTerminal;
                        foundNeighbour = true;
                    }
                }
            }
        }
    }

    private int[] findNTerminal(Hashtable idxHash, IntVector bb) {
        int N_idx = bb.firstElement();
        int[] terminalAA = null;
        for (int[] aaIdx : idxHash.keySet()) {
            IntVector idxV = new IntVector(aaIdx);
            if (!idxV.contains(N_idx)) continue;
            terminalAA = aaIdx;
        }
        return terminalAA;
    }

    private Hashtable matchAminoacids(Molecule mol, boolean toOneLetterName) throws MolExportException {
        AminoAcidSource aas = AminoAcidSource.getInstance();
        SSS mcs = new SSS();
        mcs.setIgnoreBondType(false);
        mcs.setSSSMode(true);
        mcs.setIgnoreQueryProperties(false);
        mcs.setIgnoreCharge(false);
        mcs.setIgnoreAtomType(false);
        mcs.setIgnoreHybridization(false);
        Hashtable aaIndices = new Hashtable();
        for (int i = 0; i < aas.getExportMols().size(); ++i) {
            String aaAbbrev = toOneLetterName ? (String)aas.getExportShortNames().elementAt(i) : (String)aas.getExportLongNames().elementAt(i);
            Molecule queryAA = (Molecule)aas.getExportMols().elementAt(i);
            mcs.setMolecules(queryAA, mol);
            if (!mcs.findFirst()) continue;
            do {
                int[] res = mcs.getResult();
                IntVector resV = new IntVector(res);
                resV.sort();
                resV.copyInto(res);
                aaIndices.put(res, aaAbbrev);
            } while (mcs.findNext());
        }
        aaIndices = PeptideExport.checkMatch(aaIndices, toOneLetterName ? 1 : 2);
        return aaIndices;
    }

    private boolean isMissingIgnorable(Hashtable matched, Molecule mol) {
        IntVector matchedAtoms = new IntVector();
        for (int[] res : matched.keySet()) {
            matchedAtoms.addAll(new IntVector(res));
        }
        int danglingHeavyCount = 0;
        boolean isDanglingAllowedAtom = true;
        for (int i = 0; i < mol.getAtomCount() && isDanglingAllowedAtom; ++i) {
            MolAtom a;
            int atno;
            if (matchedAtoms.contains(i) || (atno = (a = mol.getAtom(i)).getAtno()) <= 1) continue;
            isDanglingAllowedAtom = atno == 8 || atno == 7;
            ++danglingHeavyCount;
        }
        return danglingHeavyCount < 2 && isDanglingAllowedAtom;
    }

    private static Hashtable checkMatch(Hashtable res, int mode) {
        switch (mode) {
            case 1: {
                res = PeptideExport.peptideNameMatch(res, AminoAcidSource.getInstance().getExportShortNames());
                break;
            }
            case 2: {
                res = PeptideExport.peptideNameMatch(res, AminoAcidSource.getInstance().getExportLongNames());
                break;
            }
            default: {
                res = PeptideExport.generalMatch(res);
            }
        }
        return res;
    }

    private static Hashtable peptideNameMatch(Hashtable res, Vector aas) {
        int i;
        Vector entriesToRemove = new Vector();
        for (i = 0; i < aas.size(); ++i) {
            String aaName = (String)aas.elementAt(i);
            if (!res.containsValue(aaName)) continue;
            for (int[] aaIdx : res.keySet()) {
                String hashAAName = (String)res.get(aaIdx);
                if (!hashAAName.equals(aaName) || entriesToRemove.contains(aaIdx)) continue;
                entriesToRemove.addAll(PeptideExport.matchIndices(res, aaIdx));
            }
        }
        for (i = 0; i < entriesToRemove.size(); ++i) {
            res.remove(entriesToRemove.elementAt(i));
        }
        return res;
    }

    private static Hashtable generalMatch(Hashtable res) {
        Vector<int[]> entriesToRemove = new Vector<int[]>();
        for (int[] aaIdx : res.keySet()) {
            for (int[] otherAA : res.keySet()) {
                IntVector otherV = new IntVector(otherAA);
                if (otherAA == aaIdx || otherAA.length < aaIdx.length || entriesToRemove.contains(otherAA)) continue;
                boolean allCoveredByOther = true;
                for (int i = 0; i < aaIdx.length && allCoveredByOther; ++i) {
                    allCoveredByOther = otherV.contains(aaIdx[i]);
                }
                if (!allCoveredByOther || entriesToRemove.contains(aaIdx)) continue;
                entriesToRemove.add(aaIdx);
            }
        }
        for (int i = 0; i < entriesToRemove.size(); ++i) {
            res.remove(entriesToRemove.elementAt(i));
        }
        return res;
    }

    private static Vector matchIndices(Hashtable res, int[] aaIdx) {
        Vector<int[]> entriesToRemove = new Vector<int[]>();
        for (int[] otherAA : res.keySet()) {
            IntVector otherV = new IntVector(otherAA);
            if (otherAA == aaIdx || otherAA.length < aaIdx.length || entriesToRemove.contains(otherAA)) continue;
            boolean allCoveredByOther = true;
            for (int i = 0; i < aaIdx.length && allCoveredByOther; ++i) {
                allCoveredByOther = otherV.contains(aaIdx[i]);
            }
            if (!allCoveredByOther || entriesToRemove.contains(aaIdx)) continue;
            entriesToRemove.add(otherAA);
        }
        return entriesToRemove;
    }

    private void buildPeptideString(Molecule mol, int startingH, boolean toOneLetterName) throws MolExportException {
        AminoAcidSource aas = AminoAcidSource.getInstance();
        if (startingH < 0) {
            throw new MolExportException("Molecule not recognized as peptide...");
        }
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            int nameIdx;
            SuperatomSgroup aa = (SuperatomSgroup)mol.getSgroup(i);
            String aaName = aa.getSubscript();
            if (toOneLetterName) {
                nameIdx = aas.getExportShortNames().indexOf(aaName);
                if (nameIdx < 0) {
                    nameIdx = aas.getExportLongNames().indexOf(aaName);
                }
                if (nameIdx < 0) continue;
                this.stringBuffer.append(aas.getExportShortNames().elementAt(nameIdx));
                continue;
            }
            nameIdx = aas.getExportLongNames().indexOf(aaName);
            if (nameIdx < 0) {
                nameIdx = aas.getExportShortNames().indexOf(aaName);
            }
            if (nameIdx < 0) continue;
            String aaStr = (String)aas.getExportLongNames().elementAt(nameIdx);
            if (aaStr.equals("Try")) {
                aaStr = "Trp";
            }
            this.stringBuffer.append(aaStr);
        }
    }

    private int findStartingH(Molecule mol) {
        int i;
        for (i = mol.getAtomCount() - 1; i >= 0 && mol.getAtom(i).getAtno() != 1; --i) {
        }
        return i;
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        String c = opts.substring(i, i + 1);
        if (c.equals("1")) {
            this.toOneLetterName = true;
        } else if (c.equals("3")) {
            this.toOneLetterName = false;
        } else {
            throw new IllegalArgumentException("Unknown option : " + i);
        }
        return 1;
    }

    private IntVector shortestPath(IntVector tree, Molecule cmol) {
        IntVector path = new IntVector();
        IntVector parents = new IntVector();
        if (tree != null && tree.size() > 0) {
            int i;
            int[][] ctab = cmol.getCtab();
            int root = tree.firstElement();
            int target = tree.lastElement();
            boolean[] state = new boolean[tree.size()];
            for (int i2 = 1; i2 < state.length; ++i2) {
                state[i2] = false;
            }
            IntVector queue = new IntVector();
            IntVector parentQueue = new IntVector();
            queue.addElement(root);
            boolean targetFound = false;
            int cparent = root;
            parentQueue.addElement(cparent);
            while (!queue.isEmpty() && !targetFound) {
                int current = queue.firstElement();
                cparent = parentQueue.firstElement();
                queue.removeElement(current);
                parentQueue.removeElement(cparent);
                int[] neighbours = ctab[current];
                for (i = 0; i < neighbours.length; ++i) {
                    int idx = tree.indexOf(neighbours[i]);
                    if (idx <= 0 || state[idx]) continue;
                    state[idx] = true;
                    if (!queue.contains(neighbours[i])) {
                        queue.addElement(neighbours[i]);
                        parentQueue.addElement(current);
                    }
                    if (neighbours[i] != target) continue;
                    targetFound = true;
                    path.addElement(target);
                    parents.addElement(current);
                    break;
                }
                path.addElement(current);
                parents.addElement(cparent);
            }
            IntVector sp = new IntVector();
            int node = target;
            while (node != root) {
                sp.addElement(node);
                int parentIdx = path.indexOf(node);
                node = parents.elementAt(parentIdx);
            }
            sp.addElement(root);
            path = new IntVector();
            for (i = sp.size() - 1; i >= 0; --i) {
                path.addElement(sp.elementAt(i));
            }
        }
        return path;
    }

    private IntVector bfs(int rootnode, Molecule cmol, IntVector subset) {
        IntVector walk = new IntVector();
        if (subset.contains(rootnode)) {
            int[][] ctab = cmol.getCtab();
            IntVector queue = new IntVector();
            queue.addElement(rootnode);
            walk.addElement(rootnode);
            while (!queue.isEmpty()) {
                int node = queue.firstElement();
                queue.removeElement(node);
                int[] neighbours = ctab[node];
                for (int i = 0; i < neighbours.length; ++i) {
                    int nextNode = neighbours[i];
                    if (walk.contains(nextNode) || !subset.contains(nextNode)) continue;
                    queue.addElement(nextNode);
                    walk.addElement(nextNode);
                }
            }
        }
        return walk;
    }
}

