/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.peptide;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.formats.recognizer.PeptideRecognizer;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.peptide.PeptideReader;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class PeptideImport
extends MolImportModule {
    private MolInputStream istream;
    private String options = null;
    private int abbrev;
    public static final String ONE_LETTER_NAME = "1";
    public static final String THREE_LETTER_NAME = "3";

    @Override
    public void setOptions(String opts) {
        this.options = opts;
    }

    @Override
    public void initMolImport(MolInputStream is) throws IOException {
        this.istream = is;
        this.abbrev = this.options == null || this.options.length() == 0 ? -1 : (ONE_LETTER_NAME.equals(this.options.substring(0, 1)) || this.istream.getFormat().equals("peptide:1") ? 1 : (THREE_LETTER_NAME.equals(this.options.substring(0, 1)) || this.istream.getFormat().equals("peptide:3") ? 3 : -1));
    }

    @Override
    public boolean readMol(Molecule m) throws IOException {
        boolean isCorrectFormat;
        String line = this.istream.readLine();
        if (this.abbrev < 0) {
            this.abbrev = PeptideRecognizer.canBe3LetterPeptide(line) ? 3 : 1;
        }
        String format2 = "peptide:" + this.abbrev;
        m.clearForImport(format2);
        boolean bl = isCorrectFormat = line != null;
        if (isCorrectFormat && line.trim().equals("")) {
            return true;
        }
        if (isCorrectFormat && this.abbrev == 1) {
            isCorrectFormat = PeptideRecognizer.canBe1LetterPeptide(line);
        }
        if (!isCorrectFormat && line != null) {
            int maxReportLength = 50;
            if (line.length() > maxReportLength) {
                line = line.substring(0, maxReportLength) + "...";
            }
            throw new MolFormatException("Incorrect peptide format: " + line + "\n Use " + "all uppercase for one letter peptides and \"AlaTyrGly\"" + " format for three-letter notation.");
        }
        if (isCorrectFormat) {
            try {
                int brInd = line.indexOf(123);
                if (brInd > -1) {
                    line = line.substring(0, brInd);
                }
                new PeptideReader().convert(m, line, this.abbrev == 1);
                m.setInputFormat(format2);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MolFormatException(line + " : error in molecule file");
            }
        }
        return isCorrectFormat;
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }
}

