/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.marvin.io.formats.skc.utils.ChemAtomData;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class ChemUtil {
    private static final int MIN_FACTOR_NUMBER = 8;
    private static final int MAX_FACTOR_NUMBER = 1000;
    public static final List<String> beilsteinGenericsAtoms = Arrays.asList("AH", "QH", "M", "MH", "XH", "G", "GH", "G*", "GH*", "ACY", "ACH", "ABC", "ABH", "AYL", "AYH", "ALK", "ALH", "AEL", "AEH", "AHC", "AHH", "AOX", "AOH", "CYC", "CYH", "CBC", "CBH", "ARY", "ARH", "CAL", "CAH", "CEL", "CEH", "CHC", "CHH", "HAR", "HAH", "CXX", "CXH");
    public static final List<String> pseudoAtoms = Arrays.asList("H+", "H2", "D", "T", "R", "X", "Gly", "Ala", "Val", "Leu", "Ile", "Ser", "Thr", "Asp", "Asn", "Glu", "Gln", "Lys", "Hyl", "His", "Arg", "Phe", "Tyr", "Trp", "Thy", "Cys", "Cst", "Met", "Pro", "Hyp", "Pol");
    public static final byte[] baseReactionData = new byte[]{77, 0, -92, -5, 6, 0, -13, -103, -125, 124, -96, 1, -127, 124, 1, 0, 10, 0, 1, 0, 1, 0, 0, -64, 0, 0, 0, 0, 65, 114, 105, 97, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Hashtable<Integer, ChemAtomData> chemAtomDatas = new Hashtable(200);
    private static int HPLUS = -1;
    private static int[] skcDataSectionArray;
    public static int[] skcDataArray;

    public static int getMinContrastValue(int bit, int value) {
        return (8 << bit) - value;
    }

    public static int getFactorValue(int bit) {
        return 2 << bit;
    }

    public static int getFactorValue(int bit, int value) {
        return (2 << bit) - value;
    }

    public static int getMaxContrastValue(int bit) {
        return 1000 << bit;
    }

    public static int[] getSkcDataSectionArray() {
        if (skcDataSectionArray == null) {
            ChemUtil.initMappingData();
        }
        return skcDataSectionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMappingData() {
        Class<ChemUtil> clazz = ChemUtil.class;
        synchronized (ChemUtil.class) {
            if (skcDataSectionArray == null) {
                int i;
                int a = 0;
                int b = 0;
                for (i = 0; i < skcDataArray.length; i += 3) {
                    a = skcDataArray[i];
                    b = Math.max(b, a);
                }
                skcDataSectionArray = new int[b + 1];
                for (i = 0; i < b; ++i) {
                    ChemUtil.skcDataSectionArray[i] = -1;
                }
                for (i = 0; i < skcDataArray.length; i += 3) {
                    a = skcDataArray[i];
                    if (a < 0) continue;
                    ChemUtil.skcDataSectionArray[a] = i;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void addChemAtomData(ChemAtomData element) {
        chemAtomDatas.put(element.getAtomicNumber(), element);
    }

    private static ChemAtomData getChemAtomDataByAtomNumber(int i) {
        return chemAtomDatas.get(i);
    }

    public static String getAtomSymbolByType(int type) {
        switch (type) {
            case -1: {
                return "?";
            }
            case 153: {
                return "X";
            }
            case 257: {
                return "Q";
            }
            case 258: {
                return "A";
            }
            case 259: {
                return "*";
            }
            case 270: 
            case 271: {
                return "L";
            }
            case 275: {
                return "R#";
            }
            case 276: {
                return "LP";
            }
            case 278: {
                return "M";
            }
            case 279: {
                return "~X";
            }
            case 280: {
                return "~M";
            }
            case 281: {
                return "AH";
            }
            case 282: {
                return "QH";
            }
            case 283: {
                return "XH";
            }
            case 284: {
                return "MH";
            }
        }
        ChemAtomData element = ChemUtil.getChemAtomDataByAtomNumber(type);
        if (element != null) {
            return element.getName();
        }
        return "";
    }

    public static int getAtomTypeBySymbol(String symbol) {
        int num = -1;
        int length = symbol.length();
        if (length < 1 || length > 3) {
            return -1;
        }
        if (length == 1) {
            char ch = Character.toUpperCase(symbol.charAt(0));
            switch (ch) {
                case 'C': {
                    return 6;
                }
                case 'H': {
                    return 1;
                }
                case 'N': {
                    return 7;
                }
                case 'O': {
                    return 8;
                }
                case 'A': {
                    return 258;
                }
                case 'Q': {
                    return 257;
                }
                case 'X': {
                    return 153;
                }
                case 'M': {
                    return 278;
                }
                case 'L': {
                    return 270;
                }
                case '?': {
                    return -1;
                }
                case '*': {
                    return 259;
                }
            }
            for (ChemAtomData chemAtomData : chemAtomDatas.values()) {
                if (chemAtomData.getNameLength() != 1 || ch != chemAtomData.getC1()) continue;
                num = chemAtomData.getAtomicNumber();
                break;
            }
            return num;
        }
        if (length == 2) {
            char ch = Character.toUpperCase(symbol.charAt(0));
            char ch2 = Character.toUpperCase(symbol.charAt(1));
            if (ch == 'R' && ch2 == '#') {
                return 275;
            }
            if (ch == 'L' && ch2 == 'P') {
                return 276;
            }
            if (ch == 'H' && ch2 == '+') {
                return HPLUS;
            }
            if (ch == 'A' && ch2 == 'H') {
                return 281;
            }
            if (ch == 'Q' && ch2 == 'H') {
                return 282;
            }
            if (ch == 'X' && ch2 == 'H') {
                return 283;
            }
            if (ch == 'M' && ch2 == 'H') {
                return 284;
            }
            if (ch == '~' && ch2 == 'X') {
                return 279;
            }
            if (ch == '~' && ch2 == 'M') {
                return 280;
            }
            for (ChemAtomData chemAtomData : chemAtomDatas.values()) {
                if (chemAtomData.getNameLength() != 2 || ch != chemAtomData.getC1() || ch2 != chemAtomData.getC2()) continue;
                num = chemAtomData.getAtomicNumber();
                break;
            }
            return num;
        }
        if (length == 3) {
            char ch = Character.toUpperCase(symbol.charAt(0));
            char ch2 = Character.toUpperCase(symbol.charAt(1));
            char ch3 = Character.toUpperCase(symbol.charAt(2));
            for (ChemAtomData chemAtomData : chemAtomDatas.values()) {
                if (chemAtomData.getNameLength() != 3 || ch != chemAtomData.getC1() || ch2 != chemAtomData.getC2() || ch3 != chemAtomData.getC3()) continue;
                num = chemAtomData.getAtomicNumber();
                break;
            }
        }
        return num;
    }

    private static void initPeriodicTable() {
        ChemUtil.addChemAtomData(new ChemAtomData(1, "H"));
        ChemUtil.addChemAtomData(new ChemAtomData(2, "He"));
        ChemUtil.addChemAtomData(new ChemAtomData(3, "Li"));
        ChemUtil.addChemAtomData(new ChemAtomData(4, "Be"));
        ChemUtil.addChemAtomData(new ChemAtomData(5, "B"));
        ChemUtil.addChemAtomData(new ChemAtomData(6, "C"));
        ChemUtil.addChemAtomData(new ChemAtomData(7, "N"));
        ChemUtil.addChemAtomData(new ChemAtomData(8, "O"));
        ChemUtil.addChemAtomData(new ChemAtomData(9, "F"));
        ChemUtil.addChemAtomData(new ChemAtomData(10, "Ne"));
        ChemUtil.addChemAtomData(new ChemAtomData(11, "Na"));
        ChemUtil.addChemAtomData(new ChemAtomData(12, "Mg"));
        ChemUtil.addChemAtomData(new ChemAtomData(13, "Al"));
        ChemUtil.addChemAtomData(new ChemAtomData(14, "Si"));
        ChemUtil.addChemAtomData(new ChemAtomData(15, "P"));
        ChemUtil.addChemAtomData(new ChemAtomData(16, "S"));
        ChemUtil.addChemAtomData(new ChemAtomData(17, "Cl"));
        ChemUtil.addChemAtomData(new ChemAtomData(18, "Ar"));
        ChemUtil.addChemAtomData(new ChemAtomData(19, "K"));
        ChemUtil.addChemAtomData(new ChemAtomData(20, "Ca"));
        ChemUtil.addChemAtomData(new ChemAtomData(21, "Sc"));
        ChemUtil.addChemAtomData(new ChemAtomData(22, "Ti"));
        ChemUtil.addChemAtomData(new ChemAtomData(23, "V"));
        ChemUtil.addChemAtomData(new ChemAtomData(24, "Cr"));
        ChemUtil.addChemAtomData(new ChemAtomData(25, "Mn"));
        ChemUtil.addChemAtomData(new ChemAtomData(26, "Fe"));
        ChemUtil.addChemAtomData(new ChemAtomData(27, "Co"));
        ChemUtil.addChemAtomData(new ChemAtomData(28, "Ni"));
        ChemUtil.addChemAtomData(new ChemAtomData(29, "Cu"));
        ChemUtil.addChemAtomData(new ChemAtomData(30, "Zn"));
        ChemUtil.addChemAtomData(new ChemAtomData(31, "Ga"));
        ChemUtil.addChemAtomData(new ChemAtomData(32, "Ge"));
        ChemUtil.addChemAtomData(new ChemAtomData(33, "As"));
        ChemUtil.addChemAtomData(new ChemAtomData(34, "Se"));
        ChemUtil.addChemAtomData(new ChemAtomData(35, "Br"));
        ChemUtil.addChemAtomData(new ChemAtomData(36, "Kr"));
        ChemUtil.addChemAtomData(new ChemAtomData(37, "Rb"));
        ChemUtil.addChemAtomData(new ChemAtomData(38, "Sr"));
        ChemUtil.addChemAtomData(new ChemAtomData(39, "Y"));
        ChemUtil.addChemAtomData(new ChemAtomData(40, "Zr"));
        ChemUtil.addChemAtomData(new ChemAtomData(41, "Nb"));
        ChemUtil.addChemAtomData(new ChemAtomData(42, "Mo"));
        ChemUtil.addChemAtomData(new ChemAtomData(43, "Tc"));
        ChemUtil.addChemAtomData(new ChemAtomData(44, "Ru"));
        ChemUtil.addChemAtomData(new ChemAtomData(45, "Rh"));
        ChemUtil.addChemAtomData(new ChemAtomData(46, "Pd"));
        ChemUtil.addChemAtomData(new ChemAtomData(47, "Ag"));
        ChemUtil.addChemAtomData(new ChemAtomData(48, "Cd"));
        ChemUtil.addChemAtomData(new ChemAtomData(49, "In"));
        ChemUtil.addChemAtomData(new ChemAtomData(50, "Sn"));
        ChemUtil.addChemAtomData(new ChemAtomData(51, "Sb"));
        ChemUtil.addChemAtomData(new ChemAtomData(52, "Te"));
        ChemUtil.addChemAtomData(new ChemAtomData(53, "I"));
        ChemUtil.addChemAtomData(new ChemAtomData(54, "Xe"));
        ChemUtil.addChemAtomData(new ChemAtomData(55, "Cs"));
        ChemUtil.addChemAtomData(new ChemAtomData(56, "Ba"));
        ChemUtil.addChemAtomData(new ChemAtomData(57, "La"));
        ChemUtil.addChemAtomData(new ChemAtomData(58, "Ce"));
        ChemUtil.addChemAtomData(new ChemAtomData(59, "Pr"));
        ChemUtil.addChemAtomData(new ChemAtomData(60, "Nd"));
        ChemUtil.addChemAtomData(new ChemAtomData(61, "Pm"));
        ChemUtil.addChemAtomData(new ChemAtomData(62, "Sm"));
        ChemUtil.addChemAtomData(new ChemAtomData(63, "Eu"));
        ChemUtil.addChemAtomData(new ChemAtomData(64, "Gd"));
        ChemUtil.addChemAtomData(new ChemAtomData(65, "Tb"));
        ChemUtil.addChemAtomData(new ChemAtomData(66, "Dy"));
        ChemUtil.addChemAtomData(new ChemAtomData(67, "Ho"));
        ChemUtil.addChemAtomData(new ChemAtomData(68, "Er"));
        ChemUtil.addChemAtomData(new ChemAtomData(69, "Tm"));
        ChemUtil.addChemAtomData(new ChemAtomData(70, "Yb"));
        ChemUtil.addChemAtomData(new ChemAtomData(71, "Lu"));
        ChemUtil.addChemAtomData(new ChemAtomData(72, "Hf"));
        ChemUtil.addChemAtomData(new ChemAtomData(73, "Ta"));
        ChemUtil.addChemAtomData(new ChemAtomData(74, "W"));
        ChemUtil.addChemAtomData(new ChemAtomData(75, "Re"));
        ChemUtil.addChemAtomData(new ChemAtomData(76, "Os"));
        ChemUtil.addChemAtomData(new ChemAtomData(77, "Ir"));
        ChemUtil.addChemAtomData(new ChemAtomData(78, "Pt"));
        ChemUtil.addChemAtomData(new ChemAtomData(79, "Au"));
        ChemUtil.addChemAtomData(new ChemAtomData(80, "Hg"));
        ChemUtil.addChemAtomData(new ChemAtomData(81, "Tl"));
        ChemUtil.addChemAtomData(new ChemAtomData(82, "Pb"));
        ChemUtil.addChemAtomData(new ChemAtomData(83, "Bi"));
        ChemUtil.addChemAtomData(new ChemAtomData(84, "Po"));
        ChemUtil.addChemAtomData(new ChemAtomData(85, "At"));
        ChemUtil.addChemAtomData(new ChemAtomData(86, "Rn"));
        ChemUtil.addChemAtomData(new ChemAtomData(87, "Fr"));
        ChemUtil.addChemAtomData(new ChemAtomData(88, "Ra"));
        ChemUtil.addChemAtomData(new ChemAtomData(89, "Ac"));
        ChemUtil.addChemAtomData(new ChemAtomData(90, "Th"));
        ChemUtil.addChemAtomData(new ChemAtomData(91, "Pa"));
        ChemUtil.addChemAtomData(new ChemAtomData(92, "U"));
        ChemUtil.addChemAtomData(new ChemAtomData(93, "Np"));
        ChemUtil.addChemAtomData(new ChemAtomData(94, "Pu"));
        ChemUtil.addChemAtomData(new ChemAtomData(95, "Am"));
        ChemUtil.addChemAtomData(new ChemAtomData(96, "Cm"));
        ChemUtil.addChemAtomData(new ChemAtomData(97, "Bk"));
        ChemUtil.addChemAtomData(new ChemAtomData(98, "Cf"));
        ChemUtil.addChemAtomData(new ChemAtomData(99, "Es"));
        ChemUtil.addChemAtomData(new ChemAtomData(100, "Fm"));
        ChemUtil.addChemAtomData(new ChemAtomData(101, "Md"));
        ChemUtil.addChemAtomData(new ChemAtomData(102, "No"));
        ChemUtil.addChemAtomData(new ChemAtomData(103, "Lr"));
        ChemUtil.addChemAtomData(new ChemAtomData(104, "Db"));
        ChemUtil.addChemAtomData(new ChemAtomData(105, "Jl"));
        ChemUtil.addChemAtomData(new ChemAtomData(106, "Rf"));
        ChemUtil.addChemAtomData(new ChemAtomData(107, "Bh"));
        ChemUtil.addChemAtomData(new ChemAtomData(108, "Hn"));
        ChemUtil.addChemAtomData(new ChemAtomData(109, "Mt"));
        ChemUtil.addChemAtomData(new ChemAtomData(151, "D"));
        ChemUtil.addChemAtomData(new ChemAtomData(152, "T"));
        ChemUtil.addChemAtomData(new ChemAtomData(153, "X"));
        ChemUtil.addChemAtomData(new ChemAtomData(154, "R"));
        ChemUtil.addChemAtomData(new ChemAtomData(155, "H2"));
        ChemUtil.addChemAtomData(new ChemAtomData(156, "H+"));
        ChemUtil.addChemAtomData(new ChemAtomData(159, "Pol"));
    }

    static {
        if (chemAtomDatas.isEmpty()) {
            ChemUtil.initPeriodicTable();
        }
        skcDataArray = new int[]{122, -2, 4, 133, -2, 4, 134, -2, 4, 135, -2, 4, 123, -2, 4, 165, -2, 4, 124, -2, 4, 125, -2, 4, 150, -2, 4, 153, -2, 4, 126, -2, 4, 127, -2, 4, 172, -2, 4, 173, -2, 4, 128, -2, 4, 129, -2, 4, 130, -2, 4, 151, -2, 4, 154, -2, 4, 131, -2, 4, 166, -2, 4, 167, -2, 4, 168, -2, 4, 169, -2, 4, 170, -2, 4, 171, -2, 4, 100, -2, 4, 197, -2, 4, 199, -2, 4, 102, -2, 4, 103, -2, 4, 104, -2, 4, 105, -2, 4, 198, -2, 4, 106, -2, 4, 107, -2, 4, 108, -2, 4, 110, -2, 4, 111, -2, 4, 112, -2, 4, 113, -2, 4, 115, -2, 4, 117, -2, 4, 116, -2, 4, 118, -2, 4, 174, -2, 4, 119, -2, 4, 120, -2, 4, 121, -2, 4, 132, -2, 4, 147, -2, 4, 148, -2, 4, 149, -2, 4, 152, -2, 4, 155, -2, 4, 156, -2, 4, 157, -2, 4, 158, -2, 4, 159, -2, 4, 160, -2, 4, 161, -2, 4, 136, -2, 4, 137, -2, 4, 138, -2, 4, 142, -2, 4, 139, -2, 4, 144, -2, 4, 140, -2, 4, 145, -2, 4, 141, -2, 4, 146, -2, 4, 143, -2, 4, 175, -2, 4, 176, -2, 4, 177, -2, 4, 178, -2, 4, 179, -2, 4, 180, -2, 4, 181, -2, 4, 182, -2, 4, 183, -2, 4, 184, -2, 4, 185, -2, 4, 186, -2, 4, 187, -2, 4, 114, -2, 4, 188, -2, 4, 189, -2, 4, 190, -2, 4, 191, -2, 4, 192, -2, 4, 193, -2, 4, 194, -2, 4, 195, -2, 4, 196, -2, 4, 200, -2, 4, 201, -2, 4, 210, -2, 4, 211, -2, 4, 212, -2, 4, 213, -2, 4, 214, -2, 4, 215, -2, 4, 216, -2, 4, 217, -2, 4, 218, -2, 4, 219, -2, 4, 162, -2, 4, 163, -2, 4, 237, -2, 4, 238, -2, 4, 239, -2, 4, 240, -2, 4, 1, -1, 0, 64, -1, 0, 65, -1, 0, 2, -1, 0, 97, -1, 0, 92, -1, 0, 228, -1, 0, 3, -1, 0, 4, -1, 0, 5, -1, 0, 231, -1, 0, 6, -1, 0, 84, -1, 0, 7, -1, 0, 86, -1, 0, 88, -1, 0, 56, -1, 0, 57, -1, 0, 229, -1, 0, 220, -1, 0, 230, -1, 0, 8, -1, 0, 9, -1, 0, 10, -1, 0, 87, -1, 0, 89, -1, 0, 11, -1, 0, 12, -1, 0, 48, -1, 0, 13, -1, 0, 14, -1, 0, 15, -1, 0, 261, 2, 0, 262, 3, 0, 263, 6, 0, 16, 7, 0, 260, 7, 0, 17, -1, 0, 18, -1, 0, 205, -1, 0, 243, -1, 0, 21, -1, 0, 22, 33, 1, 78, 33, 1, 223, 33, 1, 23, 33, 1, 232, 33, 1, 24, 33, 1, 25, 33, 1, 60, 33, 1, 26, 33, 1, 96, 33, 1, 27, 33, 1, 28, 33, 1, 29, 33, 1, 30, 33, 1, 31, 33, 1, 32, 33, 1, 33, 33, 1, 34, 33, 1, 35, 33, 1, 36, 33, 1, 37, 33, 1, 38, 33, 1, 98, 33, 1, 62, 33, 1, 63, 33, 1, 79, 33, 1, 80, 33, 1, 208, 33, 1, 224, 33, 1, 225, 33, 1, 233, 33, 1, 90, 33, 1, 91, 33, 1, 235, 33, 1, 39, 32, 2, 40, 32, 2, 41, 32, 2, 82, 32, 2, 42, 32, 2, 43, 32, 2, 44, 32, 2, 45, 32, 2, 46, 32, 2, 47, 32, 2, 81, 32, 2, 207, 32, 2, 206, 32, 2, 49, 17, 0, 50, 20, 0, 51, 34, 3, 164, 34, 3, 256, 34, 3, 52, 34, 3, 54, 34, 3, 61, 34, 3, 55, 34, 3, 202, 34, 3, 226, 34, 3, 249, 34, 3, 241, 34, 3, 242, 34, 3, 244, 34, 3, 245, 34, 3, 246, 34, 3, 247, 34, 3, 248, 34, 3, 53, 33, 1, 257, 33, 1, 59, 12, 3, 58, 11, 0, 85, -1, 0, 66, 33, 1, 67, 66, 5, 68, 66, 5, 69, 66, 5, 70, 68, 5, 71, 68, 5, 72, 69, 5, 73, 70, 5, 236, 70, 5, 74, 62, 5, 75, 63, 5, 234, 63, 5, 83, 63, 5, 76, 50, 5, 227, 72, 5, 77, 71, 5, 203, 26, 0, 204, 26, 0, 250, 35, 3, 251, 35, 3, 252, 35, 3, 253, 35, 3, 254, 35, 3, 255, 35, 3, 258, -1, 0, 259, -1, 0, 19, -1, 0, 20, -1, 0, -1, -1, 0};
    }
}

