/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import java.util.ArrayList;

public class ComponentHelp {
    private DPoint3 reactionArrowStartPoint;
    private DPoint3 reactionArrowEndPoint;
    private ArrayList<MolAtom> molAtomList = new ArrayList();
    private float x;
    private float y;
    private float z;

    public ComponentHelp() {
    }

    public ArrayList<MolAtom> getAtomList() {
        return this.molAtomList;
    }

    public int getType() {
        int type = 0;
        float p = this.x / (float)this.molAtomList.size();
        if ((double)p < this.reactionArrowStartPoint.x) {
            type = 0;
        }
        if ((double)p > this.reactionArrowEndPoint.x) {
            type = 1;
        }
        if (this.reactionArrowStartPoint.x < (double)p && (double)p < this.reactionArrowEndPoint.x) {
            type = 2;
        }
        return type;
    }

    public ComponentHelp(DPoint3 reactionArrowStartPoint, DPoint3 reactionArrowEndPoint, MolAtom molAtom) {
        this.reactionArrowStartPoint = reactionArrowStartPoint;
        this.reactionArrowEndPoint = reactionArrowEndPoint;
        this.addAtom(molAtom);
    }

    public void addAtom(MolAtom molAtom) {
        this.x = (float)((double)this.x + molAtom.getX());
        this.y = (float)((double)this.y + molAtom.getY());
        this.z = (float)((double)this.z + molAtom.getZ());
        this.molAtomList.add(molAtom);
    }

    public boolean contains(MolAtom molAtom) {
        return this.molAtomList.contains(molAtom);
    }

    public String toString() {
        return this.molAtomList.toString();
    }
}

