/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.marvin.io.formats.skc.utils.SgroupInfo;
import chemaxon.struc.MolAtom;
import java.util.Hashtable;
import java.util.Map;

public class ObjectManager {
    private Hashtable<MolAtom, SgroupInfo> atomSupMap = new Hashtable();
    private Hashtable<Object, Map<String, Object>> cacheTempValueMap = new Hashtable();

    public void addKeyAndValue(Object outsideKey, String insideKey, Object insideValue) {
        if (outsideKey != null && insideKey != null && insideValue != null) {
            if (this.cacheTempValueMap.containsKey(outsideKey)) {
                Map<String, Object> insideMap = this.cacheTempValueMap.get(outsideKey);
                insideMap.put(insideKey, insideValue);
            } else {
                Hashtable<String, Object> insideMap = new Hashtable<String, Object>();
                insideMap.put(insideKey, insideValue);
                this.cacheTempValueMap.put(outsideKey, insideMap);
            }
        }
    }

    public Object getValueByKey(Object outsideKey, String insideKey) {
        Map<String, Object> insideMap;
        Object insideValue = null;
        if (outsideKey != null && insideKey != null && this.cacheTempValueMap.containsKey(outsideKey) && (insideMap = this.cacheTempValueMap.get(outsideKey)).containsKey(insideKey)) {
            insideValue = insideMap.get(insideKey);
        }
        return insideValue;
    }

    public void removeValueByOutsideKeyAndInsideKey(Object outsideKey, Object insideKey) {
        if (outsideKey != null && insideKey != null && this.cacheTempValueMap.containsKey(outsideKey)) {
            Map<String, Object> insideMap = this.cacheTempValueMap.get(outsideKey);
            insideMap.remove(insideKey);
        }
    }

    public void createRelationOfMolAtomAndSupSgroup(MolAtom molAtom, SgroupInfo sgroupInfo) {
        if (molAtom != null && sgroupInfo != null) {
            this.atomSupMap.put(molAtom, sgroupInfo);
        }
    }

    public SgroupInfo getSupSgroupByMolAtom(MolAtom molAtom) {
        SgroupInfo sgroupInfo = null;
        if (molAtom != null && this.atomSupMap.containsKey(molAtom)) {
            sgroupInfo = this.atomSupMap.get(molAtom);
        }
        return sgroupInfo;
    }
}

