/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.struc.DPoint3;

public class Point3d {
    private double x;
    private double y;
    private double z;
    private static final double ZERO_POINT = 0.0;
    private static final double CF_VALUE = 0.001;
    private static final int MF_VALUE = 2;
    private static final float FACTOR_VALUE = 129.8f;
    private static final int X_OFF_SET_FOR_SKC = 1435;
    private static final int Y_OFF_SET_FOR_SKC = 959;
    private static final int MINUS_1 = -1;

    private double getDifferenceValue(double minuend, double subtrahend) {
        return minuend - subtrahend;
    }

    private double getAndValue(double v1, double v2, double v3) {
        return v1 + v2 + v3;
    }

    private double getSquareValue(double value) {
        return value * value;
    }

    private boolean isCanProcess(double value) {
        return Math.abs(value) >= 0.001;
    }

    private double getSquareLength(Point3d point3d) {
        double x = this.getSquareValue(this.getDifferenceValue(point3d.getX(), this.x));
        double y = this.getSquareValue(this.getDifferenceValue(point3d.getY(), this.y));
        double z = this.getSquareValue(this.getDifferenceValue(point3d.getZ(), this.z));
        return this.getAndValue(x, y, z);
    }

    private double calculateAngle(double baseLength, double lengthOne, double lengthTwo) {
        double angle = 0.0;
        double dividend = this.getDifferenceValue(this.getAndValue(lengthOne, lengthTwo, 0.0), baseLength);
        double divisor = Math.sqrt(lengthOne * lengthTwo) * 2.0;
        if (this.isCanProcess(lengthOne) && this.isCanProcess(lengthTwo)) {
            angle = Math.acos(dividend / divisor);
        }
        return angle;
    }

    public Point3d() {
    }

    public Point3d(double v) {
        this.x = v;
        this.y = v;
        this.z = v;
    }

    public Point3d(Point3d point3d) {
        this.x = point3d.getX();
        this.y = point3d.getY();
        this.z = point3d.getY();
    }

    public Point3d(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = 0.0;
    }

    public Point3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3d getSkcPoint3d(double x, double y, double z) {
        x = x * (double)129.8f + 1435.0;
        y = y * (double)129.8f * -1.0 + 959.0;
        return new Point3d(x, y, z *= (double)129.8f);
    }

    public static float getXOfSkc(double x) {
        return (float)(x * (double)129.8f + 1435.0);
    }

    public static float getYOfSkc(double y) {
        return (float)(y * (double)129.8f * -1.0 + 959.0);
    }

    public static double getXOfMrv(double x) {
        return x / (double)129.8f;
    }

    public static double getYOfMrv(double y) {
        return y / (double)129.8f * -1.0;
    }

    public static double getZOfMrv(double z) {
        return z / (double)129.8f;
    }

    public DPoint3 getMrvDPoint3() {
        double x = this.getX() / (double)129.8f;
        double y = this.getY() / (double)129.8f * -1.0;
        double z = this.getZ() / (double)129.8f;
        return new DPoint3(x, y, z);
    }

    public static DPoint3 getMrvDPoint3(double x, double y, double z) {
        double _x = x / (double)129.8f;
        double _y = y / (double)129.8f * -1.0;
        double _z = z / (double)129.8f;
        return new DPoint3(_x, _y, _z);
    }

    public double getArcOrCircleAngle(Point3d basicPoint, Point3d point3d) {
        double baseLength = basicPoint.getSquareLength(point3d);
        double lengthOne = this.getSquareLength(basicPoint);
        double lengthTwo = this.getSquareLength(point3d);
        return this.calculateAngle(baseLength, lengthOne, lengthTwo);
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point3d other = (Point3d)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return "x:" + this.x + ",y:" + this.y + ",z:" + this.z;
    }
}

