/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.marvin.io.formats.skc.utils.MolBondInfo;
import chemaxon.marvin.io.formats.skc.utils.SgroupInfo;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.Sgroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Segment {
    private static int globalUniqueId = 0;
    private int segmentId = 0;
    private List<Segment> parents = null;
    private List<Segment> children = new ArrayList<Segment>();
    private List<MolAtom> molAtoms = new ArrayList<MolAtom>();
    private List<MolBond> molBonds = new ArrayList<MolBond>();
    private List<Sgroup> sgroups = new ArrayList<Sgroup>();
    private List<MolBondInfo> molBondxes = new ArrayList<MolBondInfo>();
    private List<Object> objects = new ArrayList<Object>();
    private List<SgroupInfo> sgroupInfoList = new ArrayList<SgroupInfo>();

    public Segment() {
        this.segmentId = this.getNextUniqueId();
    }

    public Segment(int segmentId) {
        this.segmentId = segmentId;
    }

    public Segment(MoleculeGraph mg) {
        this.molAtoms.addAll(Arrays.asList(mg.getAtomArray()));
        this.molBonds.addAll(Arrays.asList(mg.getBondArray()));
    }

    public void addChildSegment(Segment segment) {
        if (this.children == null) {
            this.children = new ArrayList<Segment>();
        }
        if (segment != null && !this.children.contains(segment)) {
            this.children.add(segment);
        }
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(int segmentId) {
        this.segmentId = segmentId;
    }

    public List<Segment> getParents() {
        return this.parents;
    }

    public void setParents(List<Segment> parents) {
        this.parents = parents;
    }

    public List<Segment> getChildren() {
        return this.children;
    }

    public void setChildren(List<Segment> children) {
        this.children = children;
    }

    public List<MolAtom> getMolAtoms() {
        return new ArrayList<MolAtom>(this.molAtoms);
    }

    public void setMolAtoms(List<MolAtom> molAtoms) {
        this.molAtoms = new ArrayList<MolAtom>(molAtoms);
    }

    public List<MolBondInfo> getMolBondxes() {
        return this.molBondxes;
    }

    public void setMolBondxes(List<MolBondInfo> molBondxes) {
        this.molBondxes = molBondxes;
    }

    public void addMolBondx(MolBondInfo molBondInfo) {
        if (molBondInfo != null && !this.molBondxes.contains(molBondInfo)) {
            this.molBondxes.add(molBondInfo);
        }
    }

    public void addMolAtom(MolAtom molAtom) {
        if (molAtom != null && !this.molAtoms.contains(molAtom)) {
            this.molAtoms.add(molAtom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextUniqueId() {
        Class<Segment> clazz = Segment.class;
        synchronized (Segment.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ++globalUniqueId;
        }
    }

    public List<SgroupInfo> getSgroupInfoList() {
        return this.sgroupInfoList;
    }

    public void addSgroupInfo(SgroupInfo sgroupInfo) {
        if (sgroupInfo != null && !this.sgroupInfoList.contains(sgroupInfo)) {
            this.sgroupInfoList.add(sgroupInfo);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(" ");
        sb.append("Segment ID( " + this.segmentId + " )");
        sb.append(", MolAtom  List ::" + this.getMolAtoms());
        sb.append(", MolBondx List ::" + this.getMolBondxes());
        sb.append(", Sgroup   List ::" + this.getSgroupInfoList());
        return sb.toString();
    }

    public List<MolBond> getMolBonds() {
        return new ArrayList<MolBond>(this.molBonds);
    }

    public void setMolBonds(List<MolBond> molBonds) {
        this.molBonds = new ArrayList<MolBond>(molBonds);
    }

    public List<Object> getObjects() {
        if (this.objects == null || this.objects.isEmpty()) {
            this.objects.addAll(this.molAtoms);
            this.objects.addAll(this.molBonds);
            this.objects.addAll(this.children);
            this.objects.addAll(this.sgroups);
        }
        return this.objects;
    }

    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    public void addChild(Object o) {
        if (this.objects == null) {
            this.objects = new ArrayList<Object>();
        }
        this.objects.add(o);
    }

    public void addAtom(MolAtom atom) {
        this.molAtoms.add(atom);
    }

    public void addBond(MolBond bond) {
        this.molBonds.add(bond);
    }

    public List<Sgroup> getSgoups() {
        return this.sgroups;
    }

    public void setSgoups(List<Sgroup> sgoups) {
        this.sgroups = sgoups;
    }

    public void addSgroup(Sgroup sgroup) {
        this.sgroups.add(sgroup);
    }

    public void addSegment(Segment segment) {
        this.children.add(segment);
    }
}

