/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils;

import chemaxon.struc.Sgroup;
import java.util.HashMap;
import java.util.Map;

public class SgroupUtil {
    private static Map<Integer, String> sgroupTypeMap = new HashMap<Integer, String>();

    private static void init() {
        if (sgroupTypeMap.isEmpty()) {
            sgroupTypeMap.put(0, "SUP");
            sgroupTypeMap.put(1, "MUL");
            sgroupTypeMap.put(10, "DAT");
            sgroupTypeMap.put(11, "ANY");
            sgroupTypeMap.put(5, "COP");
            sgroupTypeMap.put(7, "MOD");
            sgroupTypeMap.put(15, "GRA");
            sgroupTypeMap.put(2, "SRU");
            sgroupTypeMap.put(6, "CRO");
            sgroupTypeMap.put(9, "FOR");
            sgroupTypeMap.put(13, "COM");
            sgroupTypeMap.put(8, "MIX");
            sgroupTypeMap.put(3, "MON");
            sgroupTypeMap.put(4, "MER");
            sgroupTypeMap.put(12, "GEN");
        }
    }

    public static int getMrvExpandedState(boolean isExpanded) {
        int state = 3;
        if (isExpanded) {
            state = 1;
        }
        return state;
    }

    public static boolean isSgroupExpanded(Sgroup cg) {
        boolean expanded = true;
        if (cg.getXState() == 3 || cg.getXState() == 2) {
            expanded = false;
        }
        return expanded;
    }

    public static int getMrvSgroupSubType(String skcSgorupSubType) {
        int sType = 0;
        if (skcSgorupSubType.equals("ALT")) {
            sType = 1;
        }
        if (skcSgorupSubType.equals("BLO")) {
            sType = 3;
        }
        if (skcSgorupSubType.equals("RAN")) {
            sType = 2;
        }
        return sType;
    }

    public static String getSkcConnectivity(Sgroup sgroup) {
        String connectivity = "";
        if (sgroup.getConnectivity() == 0) {
            connectivity = "EU";
        } else if (sgroup.getConnectivity() == 1) {
            connectivity = "HH";
        } else if (sgroup.getConnectivity() == 2) {
            connectivity = "HT";
        }
        return connectivity;
    }

    public static String getSkcSgroupSubtype(Sgroup sgroup) {
        String subtype = "";
        int mrvSubtype = sgroup.getSubType();
        if (mrvSubtype == 1) {
            subtype = "ALT";
        } else if (mrvSubtype == 2) {
            subtype = "RAN";
        } else if (mrvSubtype == 3) {
            subtype = "BLO";
        }
        return subtype;
    }

    public static byte getSkcGroupType(Sgroup sgroup) {
        String type = sgroupTypeMap.get(sgroup.getType());
        String subtype = SgroupUtil.getSkcSgroupSubtype(sgroup);
        if (type.equals("LINKNODE") || type.equals("MUL")) {
            if (type.equals("LINKNODE")) {
                return 1;
            }
            return 16;
        }
        if (type.equals("SUP")) {
            return 2;
        }
        if (type.equals("SRU")) {
            return 3;
        }
        if (type.equals("MON")) {
            return 4;
        }
        if (type.equals("MER")) {
            return 5;
        }
        if (type.equals("COP")) {
            if (subtype.equals("ALT")) {
                return 7;
            }
            if (subtype.equals("RAN")) {
                return 8;
            }
            if (subtype.equals("BLO")) {
                return 9;
            }
            return 6;
        }
        if (type.equals("CRO")) {
            return 10;
        }
        if (type.equals("GRA")) {
            return 11;
        }
        if (type.equals("MOD")) {
            return 12;
        }
        if (type.equals("COM")) {
            return 13;
        }
        if (type.equals("MIX")) {
            return 14;
        }
        if (type.equals("FOR")) {
            return 15;
        }
        if (type.equals("GEN")) {
            return 17;
        }
        if (type.equals("ANY")) {
            return 18;
        }
        return 0;
    }

    static {
        SgroupUtil.init();
    }
}

