/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils.text;

import chemaxon.marvin.io.formats.skc.utils.text.TextChecker;
import chemaxon.marvin.io.formats.skc.utils.text.TextContent;
import chemaxon.marvin.io.formats.skc.utils.text.TextData;
import chemaxon.marvin.io.formats.skc.utils.text.TextUtil;
import chemaxon.marvin.io.formats.skc.utils.text.TextWrapper;
import java.util.ArrayList;

public abstract class TextBaseParser {
    protected TextData textData;
    private String textContentBody;
    private int baseLenth;
    private int cotentSize;

    public TextBaseParser(TextData context, String textContentBody) {
        this.textData = context;
        this.textContentBody = textContentBody;
        this.baseLenth = 0;
        this.cotentSize = textContentBody != null ? textContentBody.length() : 0;
    }

    protected TextBaseParser getChildTextBaseParser() {
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        if (this.baseLenth < this.cotentSize) {
            while (this.baseLenth < this.cotentSize) {
                char ch = this.textContentBody.charAt(this.baseLenth);
                if (ch != '\\') {
                    if (ch == '{') {
                        int startIndex = ++this.baseLenth;
                        int count = 1;
                        while (this.baseLenth < this.cotentSize && count > 0) {
                            switch (this.textContentBody.charAt(this.baseLenth++)) {
                                case '{': {
                                    if (this.baseLenth - 1 >= 0 && this.textContentBody.charAt(this.baseLenth - 2) != '\\') {
                                        ++count;
                                        break;
                                    }
                                }
                                case '}': {
                                    if (this.baseLenth - 2 < 0 || this.textContentBody.charAt(this.baseLenth - 2) == '\\') break;
                                    --count;
                                }
                            }
                        }
                        return new TextChecker(this.textData, this.textContentBody.substring(startIndex, this.baseLenth - 1));
                    }
                    while (this.baseLenth < this.cotentSize && this.isEnter()) {
                        ++this.baseLenth;
                    }
                    while (this.baseLenth < this.cotentSize && this.isStandText()) {
                        byteList.add((byte)this.textContentBody.charAt(this.baseLenth));
                        ++this.baseLenth;
                    }
                    continue;
                }
                if (this.baseLenth + 1 >= this.cotentSize || this.textContentBody.charAt(this.baseLenth + 1) != '\'') {
                    if (this.baseLenth + 1 >= this.cotentSize || this.textContentBody.charAt(this.baseLenth + 1) != 'u' || this.baseLenth + 2 >= this.cotentSize || !Character.isDigit(this.textContentBody.charAt(this.baseLenth + 2)) && this.textContentBody.charAt(this.baseLenth + 2) != '-') {
                        if (this.baseLenth + 1 >= this.cotentSize || this.textContentBody.charAt(this.baseLenth + 1) != '\\') {
                            if (this.textContentBody.charAt(this.baseLenth + 1) == '{') {
                                byteList.add((byte)this.textContentBody.charAt(++this.baseLenth));
                            }
                            if (byteList.size() > 0) {
                                return new TextContent(this.textData, this.convertArrayToString(byteList.toArray()));
                            }
                            int counter = ++this.baseLenth;
                            if (this.baseLenth >= this.cotentSize || this.textContentBody.charAt(this.baseLenth) != '*' || this.textContentBody.charAt(this.baseLenth + 1) != '\\') {
                                while (this.baseLenth < this.cotentSize && this.isLetter()) {
                                    ++this.baseLenth;
                                }
                                int index = this.baseLenth;
                                if (this.baseLenth < this.cotentSize && (this.isMinusSymol() || this.isDigit())) {
                                    ++this.baseLenth;
                                    while (this.baseLenth < this.cotentSize && this.isDigit()) {
                                        ++this.baseLenth;
                                    }
                                }
                                if (this.baseLenth < this.cotentSize && this.isSpaceSymol()) {
                                    ++this.baseLenth;
                                }
                                String subStr1 = this.textContentBody.substring(counter, index);
                                String subStr2 = this.textContentBody.substring(index, this.baseLenth).trim();
                                return new TextWrapper(this.textData, subStr1, subStr2);
                            }
                            return new TextWrapper(this.textData, new String(this.textContentBody.charAt(this.baseLenth++) + ""), null);
                        }
                        ++this.baseLenth;
                        byteList.add(Byte.parseByte("\\"));
                        ++this.baseLenth;
                        continue;
                    }
                    this.baseLenth += 2;
                    int length = 1;
                    while (this.baseLenth + length < this.cotentSize && Character.isDigit(this.textContentBody.charAt(this.baseLenth + length))) {
                        ++length;
                    }
                    int value = Integer.parseInt(this.textContentBody.substring(this.baseLenth, this.baseLenth + length));
                    String text = (char)value + "";
                    String newText = TextUtil.findSpecialCharacterByName(text);
                    newText = newText == null || newText.equals("") ? text : '.' + newText + '.';
                    this.baseLenth += length;
                    if (value >= 0 && value < 256) {
                        byteList.add((byte)value);
                    } else {
                        for (int j = 0; j < newText.length(); ++j) {
                            byteList.add(Byte.parseByte(newText.charAt(j) + ""));
                        }
                    }
                    ++this.baseLenth;
                    continue;
                }
                ++this.baseLenth;
                byteList.add(Byte.valueOf(this.textContentBody.substring(this.baseLenth + 1, this.baseLenth + 2 + 1), 16));
                this.baseLenth += 3;
            }
            if (byteList.size() < 1) {
                return this.getChildTextBaseParser();
            }
            return new TextContent(this.textData, this.convertArrayToString(byteList.toArray()));
        }
        return null;
    }

    boolean parse() {
        TextBaseParser part = this.getChildTextBaseParser();
        while (part != null) {
            if (!part.parse()) {
                return false;
            }
            part = this.getChildTextBaseParser();
        }
        return true;
    }

    private boolean isEnter() {
        if (this.textContentBody.charAt(this.baseLenth) != '\n') {
            return this.textContentBody.charAt(this.baseLenth) == '\r';
        }
        return true;
    }

    private boolean isSpaceSymol() {
        return this.textContentBody.charAt(this.baseLenth) == ' ';
    }

    private boolean isLetter() {
        return this.textContentBody.charAt(this.baseLenth) >= 'A' && this.textContentBody.charAt(this.baseLenth) <= 'Z' || this.textContentBody.charAt(this.baseLenth) >= 'a' && this.textContentBody.charAt(this.baseLenth) <= 'z';
    }

    private boolean isStandText() {
        return this.textContentBody.charAt(this.baseLenth) != '\\' && this.textContentBody.charAt(this.baseLenth) != '{' && !this.isEnter();
    }

    private boolean isDigit() {
        return this.textContentBody.charAt(this.baseLenth) >= '0' && this.textContentBody.charAt(this.baseLenth) <= '9';
    }

    private boolean isMinusSymol() {
        return this.textContentBody.charAt(this.baseLenth) == '-';
    }

    private String convertArrayToString(Object[] os) {
        StringBuilder sb = new StringBuilder();
        for (Object o : os) {
            sb.append((char)((Byte)o).intValue());
        }
        return sb.toString();
    }
}

