/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.skc.utils.text;

import chemaxon.marvin.io.formats.skc.utils.text.TextBaseParser;
import chemaxon.marvin.io.formats.skc.utils.text.TextContent;
import chemaxon.marvin.io.formats.skc.utils.text.TextData;
import chemaxon.marvin.io.formats.skc.utils.text.TextFont;
import chemaxon.marvin.io.formats.skc.utils.text.TextWrapper;

public class TextChecker
extends TextBaseParser {
    public TextChecker(TextData context, String body) {
        super(context, body);
    }

    @Override
    public boolean parse() {
        TextBaseParser textBaseParser = super.getChildTextBaseParser();
        if (textBaseParser instanceof TextWrapper) {
            TextWrapper textWrapper = (TextWrapper)textBaseParser;
            if (textWrapper.getSymbolName().equals("footnote") || textWrapper.getSymbolName().equals("header") || textWrapper.getSymbolName().equals("footer") || textWrapper.getSymbolName().equals("pict") || textWrapper.getSymbolName().equals("info") || textWrapper.getSymbolName().equals("stylesheet") || textWrapper.getSymbolName().equals("colortbl") || textWrapper.getSymbolName().equals("*")) {
                return true;
            }
            if (textWrapper.getSymbolName().equals("fonttbl")) {
                this.startParseTextFont();
                return true;
            }
        }
        return textBaseParser.parse() && super.parse();
    }

    private void toParseDefaultFont() {
        TextWrapper textWrapper = null;
        TextContent textContent = null;
        int c = 0;
        TextBaseParser textBaseParser = super.getChildTextBaseParser();
        while (textBaseParser != null) {
            if (textBaseParser instanceof TextWrapper) {
                TextWrapper wrapper = (TextWrapper)textBaseParser;
                if (wrapper.getSymbolName().equals("f")) {
                    textWrapper = (TextWrapper)textBaseParser;
                } else if (wrapper.getSymbolName().equals("fcharset")) {
                    c = Integer.parseInt(wrapper.getparameter());
                }
            } else if (textBaseParser instanceof TextContent) {
                textContent = (TextContent)textBaseParser;
            }
            textBaseParser = super.getChildTextBaseParser();
        }
        if (textWrapper != null && textContent != null) {
            String str = textContent.getTextContent();
            String word = textWrapper.getSymbolName();
            String param = textWrapper.getparameter();
            String key = word + param;
            this.textData.getFextFontMap().put(key, new TextFont(str.trim(), c));
            if (this.textData.getFontName() == null) {
                this.textData.setFontName(textWrapper.getSymbolName() + textWrapper.getparameter());
            }
        }
    }

    private void startParseTextFont() {
        TextBaseParser part = super.getChildTextBaseParser();
        while (part != null) {
            if (part instanceof TextChecker) {
                ((TextChecker)part).toParseDefaultFont();
            }
            part = super.getChildTextBaseParser();
        }
    }
}

